/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.ui.console;

import static net.argius.stew.Iteration.join;
import static net.argius.stew.ui.console.Resource.*;

import java.util.*;

import net.argius.logging.*;
import net.argius.stew.*;
import net.argius.stew.ui.*;

/**
 * R\[[hNB
 */
public final class ConsoleLauncher implements Launcher {

    private static final Logger log = LoggerFactory.getLogger(ConsoleLauncher.class);
    private static final boolean END = false;

    /* @see net.argius.stew.Launcher#launch(net.argius.stew.Environment) */
    public void launch(Environment env) {
        if (log.isInfoEnabled()) {
            log.info("start");
        }
        OutputProcessor out = env.getOutputProcessor();
        Prompt prompt = new Prompt(env);
        Scanner scanner = new Scanner(System.in);
        while (true) {
            out.output(prompt);
            if (!scanner.hasNextLine()) {
                break;
            }
            final String line = scanner.nextLine();
            if (log.isDebugEnabled()) {
                log.debug("input : " + line);
            }
            if (String.valueOf(line).trim().equals("--edit")) {
                ConnectorMapEditor.invoke();
                env.updateConnectorMap();
            } else if (Command.invoke(env, line) == END) {
                break;
            }
        }
        if (log.isInfoEnabled()) {
            log.info("end");
        }
    }

    /**
     * @param args
     */
    public static void main(String... args) {
        List<String> a = new ArrayList<String>(Arrays.asList(args));
        if (a.contains("-v")) {
            System.out.println("Stew " + getVersion());
            return;
        }
        Environment env = new Environment();
        try {
            env.setOutputProcessor(new ConsoleOutputProcessor());
            env.getOutputProcessor().output(getString(".about", getVersion()));
            if (!a.isEmpty() && !a.get(0).startsWith("-")) {
                Command.invoke(env, "connect " + a.remove(0));
            }
            if (!a.isEmpty()) {
                Command.invoke(env, join(a, " "));
                Command.invoke(env, "disconnect");
            } else {
                Launcher o = new ConsoleLauncher();
                o.launch(env);
            }
        } finally {
            env.release();
        }
    }

}
