/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;

public final class Logger {
    private final java.util.logging.Logger log;
    private String enteredMethodName;

    Logger(String string) {
        this.log = java.util.logging.Logger.getLogger(string);
        Logger.removeRootLoggerHandlers();
    }

    Logger(Class<?> clazz) {
        this(clazz.getName());
    }

    static void removeRootLoggerHandlers() {
        java.util.logging.Logger logger = LogManager.getLogManager().getLogger("");
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
    }

    public static Logger getLogger(Object object) {
        String string;
        if (object instanceof Class) {
            Class clazz = (Class)object;
            string = clazz.getName();
        } else {
            string = object instanceof String ? (String)object : String.valueOf(object);
        }
        return new Logger(string);
    }

    public boolean isInfoEnabled() {
        return this.log.isLoggable(Level.INFO);
    }

    public boolean isDebugEnabled() {
        return this.log.isLoggable(Level.FINE);
    }

    public boolean isTraceEnabled() {
        return this.log.isLoggable(Level.FINER);
    }

    public String getEnteredMethodName() {
        return this.enteredMethodName == null ? "" : this.enteredMethodName;
    }

    public void setEnteredMethodName(String string) {
        this.enteredMethodName = string == null ? "" : string;
    }

    public void log(Level level, Throwable throwable, String string, Object ... objectArray) {
        if (this.log.isLoggable(level)) {
            String string2;
            String string3 = this.log.getName();
            String string4 = this.enteredMethodName == null ? "(unknown method)" : this.enteredMethodName;
            String string5 = string2 = objectArray.length == 0 ? string : String.format(string, objectArray);
            if (throwable == null) {
                this.log.logp(level, string3, string4, string2);
            } else {
                this.log.logp(level, string3, string4, string2, throwable);
            }
        }
    }

    public void fatal(Throwable throwable) {
        if (this.log.isLoggable(Level.SEVERE)) {
            this.log(Level.SEVERE, throwable, "*FATAL*", new Object[0]);
        }
    }

    public void fatal(Throwable throwable, String string, Object ... objectArray) {
        if (this.log.isLoggable(Level.SEVERE)) {
            this.log(Level.SEVERE, throwable, "*FATAL* " + String.format(string, objectArray), new Object[0]);
        }
    }

    public void error(Throwable throwable) {
        if (this.log.isLoggable(Level.SEVERE)) {
            this.log(Level.SEVERE, throwable, "", new Object[0]);
        }
    }

    public void error(Throwable throwable, Object object) {
        if (this.log.isLoggable(Level.SEVERE)) {
            this.log(Level.SEVERE, throwable, String.valueOf(object), new Object[0]);
        }
    }

    public void error(Throwable throwable, String string, Object object) {
        if (this.log.isLoggable(Level.SEVERE)) {
            this.log(Level.SEVERE, throwable, string, object);
        }
    }

    public void warn(Throwable throwable) {
        if (this.log.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, throwable, "", new Object[0]);
        }
    }

    public void warn(Throwable throwable, Object object) {
        if (this.log.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, throwable, String.valueOf(object), new Object[0]);
        }
    }

    public void warn(String string, Object ... objectArray) {
        if (this.log.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, null, string, objectArray);
        }
    }

    public void info(Object object) {
        if (this.isInfoEnabled()) {
            this.log(Level.INFO, null, String.valueOf(object), new Object[0]);
        }
    }

    public void info(String string, Object object) {
        if (this.isInfoEnabled()) {
            this.log(Level.INFO, null, string, object);
        }
    }

    public void info(String string, Object object, Object object2) {
        if (this.isInfoEnabled()) {
            this.log(Level.INFO, null, string, object, object2);
        }
    }

    public void info(String string, Object ... objectArray) {
        if (this.isInfoEnabled()) {
            this.log(Level.INFO, null, string, objectArray);
        }
    }

    public void debug(Object object) {
        if (this.isDebugEnabled()) {
            this.log(Level.FINE, null, String.valueOf(object), new Object[0]);
        }
    }

    public void debug(String string, Object object) {
        if (this.isDebugEnabled()) {
            this.log(Level.FINE, null, string, object);
        }
    }

    public void debug(String string, Object object, Object object2) {
        if (this.isDebugEnabled()) {
            this.log(Level.FINE, null, string, object, object2);
        }
    }

    public void debug(String string, Object ... objectArray) {
        if (this.isDebugEnabled()) {
            this.log(Level.FINE, null, string, objectArray);
        }
    }

    public void trace(Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.log(Level.FINER, throwable, "", new Object[0]);
        }
    }

    public void trace(Object object) {
        if (this.isTraceEnabled()) {
            this.log(Level.FINER, null, String.valueOf(object), new Object[0]);
        }
    }

    public void trace(String string, Object object) {
        if (this.isTraceEnabled()) {
            this.log(Level.FINER, null, string, object);
        }
    }

    public void trace(String string, Object ... objectArray) {
        if (this.isTraceEnabled()) {
            this.log(Level.FINER, null, string, objectArray);
        }
    }

    public void atEnter(String string, Object ... objectArray) {
        this.setEnteredMethodName(string);
        this.log.entering(this.log.getName(), string, objectArray);
    }

    public void atExit(String string) {
        this.log.exiting(this.log.getName(), string);
        this.setEnteredMethodName("");
    }

    public <T> T atExit(String string, T t) {
        this.log.exiting(this.log.getName(), string, t);
        this.setEnteredMethodName("");
        return t;
    }
}

