/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import net.argius.stew.DynamicLoadingException;

public final class DynamicLoader {
    private DynamicLoader() {
    }

    public static <T> Class<T> loadClass(String string) throws DynamicLoadingException {
        return DynamicLoader.loadClass(string, ClassLoader.getSystemClassLoader());
    }

    public static <T> Class<T> loadClass(String string, ClassLoader classLoader) throws DynamicLoadingException {
        try {
            Class<?> clazz = classLoader.loadClass(string);
            return clazz;
        }
        catch (Throwable throwable) {
            throw new DynamicLoadingException("class loading error", throwable);
        }
    }

    public static <T> T newInstance(String string) throws DynamicLoadingException {
        T t = DynamicLoader.newInstance(string, DynamicLoader.class.getClassLoader());
        return t;
    }

    public static <T> T newInstance(String string, URL ... uRLArray) throws DynamicLoadingException {
        T t = DynamicLoader.newInstance(string, DynamicLoader.getClassLoader(uRLArray));
        return t;
    }

    public static <T> T newInstance(String string, ClassLoader classLoader) throws DynamicLoadingException {
        try {
            Class<T> clazz = DynamicLoader.loadClass(string, classLoader);
            return clazz.newInstance();
        }
        catch (DynamicLoadingException dynamicLoadingException) {
            throw dynamicLoadingException;
        }
        catch (Throwable throwable) {
            throw new DynamicLoadingException("load error: " + string, throwable);
        }
    }

    public static <T> T newInstance(Class<T> clazz) throws DynamicLoadingException {
        try {
            return clazz.newInstance();
        }
        catch (Throwable throwable) {
            throw new DynamicLoadingException("load error: " + clazz, throwable);
        }
    }

    public static URLClassLoader getClassLoader(URL ... uRLArray) {
        return (URLClassLoader)AccessController.doPrivileged(new GettingURLClassLoaderPrivilegedAction(uRLArray));
    }

    private static final class GettingURLClassLoaderPrivilegedAction
    implements PrivilegedAction<Object> {
        private final URL[] urls;

        GettingURLClassLoaderPrivilegedAction(URL[] uRLArray) {
            this.urls = uRLArray;
        }

        @Override
        public Object run() {
            return new URLClassLoader(this.urls, ClassLoader.getSystemClassLoader());
        }
    }
}

