/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.optimizer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.optimizer.ClassConstantsCollector;
import org.objectweb.asm.optimizer.ClassOptimizer;
import org.objectweb.asm.optimizer.Constant;
import org.objectweb.asm.optimizer.ConstantPool;
import org.objectweb.asm.optimizer.NameMapping;

public class Shrinker {
    public static void main(String[] args) throws IOException {
        NameMapping mapping = new NameMapping(args[0]);
        File f = new File(args[1]);
        File d = new File(args[2]);
        Shrinker.optimize(f, d, mapping);
        Iterator i = mapping.unused.iterator();
        while (i.hasNext()) {
            System.out.println("INFO: unused mapping " + i.next());
        }
    }

    static void optimize(File f, File d, NameMapping mapping) throws IOException {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Shrinker.optimize(files[i], d, mapping);
            }
        } else if (f.getName().endsWith(".class")) {
            ConstantPool cp = new ConstantPool();
            ClassReader cr = new ClassReader(new FileInputStream(f));
            ClassWriter cw = new ClassWriter(false);
            ClassConstantsCollector ccc = new ClassConstantsCollector(cw, cp);
            ClassOptimizer co = new ClassOptimizer(ccc, mapping);
            cr.accept(co, true);
            TreeSet constants = new TreeSet(new ConstantComparator());
            constants.addAll(cp.values());
            cr = new ClassReader(cw.toByteArray());
            cw = new ClassWriter(false);
            Iterator i = constants.iterator();
            while (i.hasNext()) {
                Constant c = (Constant)i.next();
                c.write(cw);
            }
            cr.accept(cw, true);
            String n = mapping.map(co.getClassName());
            File g = new File(d, n + ".class");
            if (!g.exists() || g.lastModified() < f.lastModified()) {
                g.getParentFile().mkdirs();
                FileOutputStream os = new FileOutputStream(g);
                ((OutputStream)os).write(cw.toByteArray());
                ((OutputStream)os).close();
            }
        }
    }

    static class ConstantComparator
    implements Comparator {
        ConstantComparator() {
        }

        public int compare(Object o1, Object o2) {
            Constant c1 = (Constant)o1;
            Constant c2 = (Constant)o2;
            int d = this.getSort(c1) - this.getSort(c2);
            if (d == 0) {
                switch (c1.type) {
                    case 'I': {
                        return new Integer(c1.intVal).compareTo(new Integer(c2.intVal));
                    }
                    case 'J': {
                        return new Long(c1.longVal).compareTo(new Long(c2.longVal));
                    }
                    case 'F': {
                        return new Float(c1.floatVal).compareTo(new Float(c2.floatVal));
                    }
                    case 'D': {
                        return new Double(c1.doubleVal).compareTo(new Double(c2.doubleVal));
                    }
                    case 'C': 
                    case 'S': 
                    case 's': {
                        return c1.strVal1.compareTo(c2.strVal1);
                    }
                    case 'T': {
                        d = c1.strVal1.compareTo(c2.strVal1);
                        if (d != 0) break;
                        d = c1.strVal2.compareTo(c2.strVal2);
                        break;
                    }
                    default: {
                        d = c1.strVal1.compareTo(c2.strVal1);
                        if (d != 0 || (d = c1.strVal2.compareTo(c2.strVal2)) != 0) break;
                        d = c1.strVal3.compareTo(c2.strVal3);
                    }
                }
            }
            return d;
        }

        private int getSort(Constant c) {
            switch (c.type) {
                case 'I': {
                    return 0;
                }
                case 'J': {
                    return 1;
                }
                case 'F': {
                    return 2;
                }
                case 'D': {
                    return 3;
                }
                case 's': {
                    return 4;
                }
                case 'S': {
                    return 5;
                }
                case 'C': {
                    return 6;
                }
                case 'T': {
                    return 7;
                }
                case 'G': {
                    return 8;
                }
                case 'M': {
                    return 9;
                }
            }
            return 10;
        }
    }
}

