/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class CompareTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 234557758658567345L;

    public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasForcus, int row, int cols) {
        Object value = table.getValueAt(row, cols);
        Component c = super.getTableCellRendererComponent(table, obj, isSelected, hasForcus, row, cols);
        if (value instanceof Double && !isSelected) {
            double d = (Double)value;
            if (Math.abs(d - 1.0) < 1.0E-8) {
                c.setBackground(Color.red);
            } else {
                c.setBackground(Color.white);
            }
            float ratio = (float)Math.round(d * 10.0) / 10.0f;
            int color = Math.round(255.0f - 200.0f * ratio);
            c.setForeground(new Color(color, color, color));
        }
        return c;
    }
}

