
# Build script for OSX using gcc v11.2.0 gnat
# Example script that avoids Xcode g++:
#
# 100% GNU (no Xcode compilers):
#

# In nov2021 my Xcode was upgraded to 10.1 but
# my MacBookPro TBD files became "out-of-sync"
# with SDK libraries. Here, I now give specific path
# to libraries & frameworks.


#!/bin/sh

# this ensures a complete recompilation:
if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi

export GROOT=/opt/gcc-11.2.0/bin
export PATH=$GROOT:$PATH



# first, create oal.o:
$GROOT/g++ \
adabindings/adaOpenAL/OalBinding/oal.cpp -c \
-Iadabindings/adaOpenAL/OalBinding \
-Iadabindings/adaOpenAL/OalBinding/incoal


#---------------------------------------------------

export SDKROOT=$(xcrun --show-sdk-path)

export FWROOT=/System/Library/Frameworks


# note that this setup requires
# -lstdc++ rather than -lc++


$GROOT/gnatmake  adagate -O3  \
-o adagate_osx_gn \
-D $PWD/obj \
-I$PWD/src \
-I$PWD/adautils \
-I$PWD/adabindings/gl \
-I$PWD/adabindings/glfwada \
-I$PWD/adabindings/AdaPngLib \
-I$PWD/adabindings/adaOpenAL \
-I$PWD/adabindings/adaOpenAL/OalBinding \
-largs \
oal.o \
$PWD/libs/osx/libglfw3.a \
\
-L$SDKROOT/usr/lib \
-lm -lz  -lstdc++ \
\
-F$FWROOT \
-framework OpenGL \
-framework ForceFeedback \
-framework CoreFoundation \
-framework Carbon \
-framework Cocoa \
-framework QuartzCore \
-framework IOKit \
-framework CoreAudio \
-framework AudioUnit \
-framework AudioToolBox \
-framework Metal \
-framework OpenAL \
-pthread 

