#version 330 core
layout(location = 0) in vec3 vertexPos;
layout(location = 1) in vec2 vertexUV;
out vec2 UV;
uniform mat4 MVP;

uniform vec3 wPos;
uniform vec3 wRad;
uniform float angl;


void main(){

	float hrad2= ( wRad.x*wRad.x + wRad.z*wRad.z );
	float hrad = sqrt( hrad2 );

	vec3 pos = vertexPos;

	pos.x *= wRad.x;
	pos.y *= wRad.y;
	pos.z *= wRad.z;
	// we assume original setup with unitary radii

	float nx = cos(angl)*pos.x - sin(angl)*pos.z;
	float nz = sin(angl)*pos.x + cos(angl)*pos.z;
	pos.x = nx;
	pos.z = nz;

	pos.x += wPos.x;
	pos.y += wPos.y;
	pos.z += wPos.z; 
	// we assume original setup @ origin



	float 
		rx=(pos.x-wPos.x), 
		ry=(pos.y-wPos.y), 
		rz=(pos.z-wPos.z);

	//spherical-quadratic decline to zero @ edge
	// rxz = 0..hrad
	//float rxz = sqrt( hrad2 - ( rx*rx+rz*rz ) ); 
	//if( ry>0 )   pos.y = rxz/hrad*ry + wPos.y;

	// good for crab, starfish:
	float rxz = rx*rx+rz*rz;
	if( ry>0 ) pos.y = wPos.y + ry*exp(-200*rxz);

	// slightly better for jar:
	//float rxz = 2*rz*rz;
	//if( ry>0 ) pos.y = wPos.y + ry*exp(-400*rxz);

	gl_Position =  MVP * vec4(pos,1.0);
	UV = vertexUV;
}


//--
//-- Copyright (C) 2016  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

