
//# -- Copyright (C) 2016  <fastrgv@gmail.com>
//# --
//# -- This program is free software: you can redistribute it and/or modify
//# -- it under the terms of the GNU General Public License as published by
//# -- the Free Software Foundation, either version 3 of the License, or
//# -- (at your option) any later version.
//# --
//# -- This program is distributed in the hope that it will be useful,
//# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
//# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//# -- GNU General Public License for more details.
//# --
//# -- You may read the full text of the GNU General Public License
//# -- at <http://www.gnu.org/licenses/>.


#include "snd4ada.hpp"

#include <SFML/Audio.hpp>
#include <SFML/System.hpp>
#include <cassert>

#include <string>
using std::string;


static int bkmus(-1);

static sf::Sound sound;

// persistent sound loops here:
static sf::Music music[6]; // 0..5
static sf::Music water, lava, hum;

// transient sounds here:
//                       6        7        8       9			10			11
static sf::SoundBuffer sbLaser, sbStone, sbXport, sbKick, sbQport, sbSplash;




//void initSnds(void)
int initSnds(void)
{
 // loops 0..5:
 //const string st0("data/beach00.wav");
 const string st0("data/beach01.wav"); // 30 sec
 const string st1("data/falls.wav");
 const string st2("data/dark-metal-electronic-loop.wav");
 const string st3("data/gothic-dutch-trance.wav");
 const string st4("data/portals-to-neptune_loop.wav");
 const string st5("data/briefChurchChoir.wav");

 // 6, 7, 8, 9, 10, 11
 const string sbl("data/laser-gun.wav");
 const string sbs("data/concrete.wav");
 const string sbx("data/sci-fi.wav");
 const string sbk("data/soccer-kick.wav");
 const string sqp("data/quick_portal.wav");
 const string sts("data/splash.wav");

 // named loops:
 //const string stw("data/lake-waves-01.wav");
 const string stw("data/lake-waves-02.wav"); // 30 sec
 //const string stl("data/lava-loop.wav");
 const string stl("data/lava-loopt.wav");  // 30 sec
 //const string sth("data/freezer-hum-1.wav");
 const string sth("data/freezer-hum.wav"); // 30 sec


	if( !music[0].openFromFile(st0) ) return 1;
	if( !music[1].openFromFile(st1) ) return 2;
	if( !music[2].openFromFile(st2) ) return 3;
	if( !music[3].openFromFile(st3) ) return 4;
	if( !music[4].openFromFile(st4) ) return 5;
	if( !music[5].openFromFile(st5) ) return 6;
	if( !water.openFromFile(stw) ) return 7;
	if( !lava.openFromFile(stl) ) return 8;
	if( !hum.openFromFile(sth) ) return 9;

	for(int i=0; i<6; i++) {
		music[i].setLoop(true);
		if( i==0 ) 
			music[i].setVolume(100);
		else
			music[i].setVolume(50);
	}
	music[3].setVolume(40); //gothicDutch

	water.setLoop(true);
	water.setVolume(60); // 16nov14 down from 100
	
	lava.setLoop(true);
	lava.setVolume(100);

	hum.setLoop(true);
	hum.setVolume(100);



// end loops, begin transients:


	if( !sbLaser.loadFromFile(sbl) ) return 10;
	if( !sbStone.loadFromFile(sbs) ) return 11;
	if( !sbXport.loadFromFile(sbx) ) return 12;
	if( !sbKick.loadFromFile(sbk) ) return 13;
	if( !sbQport.loadFromFile(sqp) ) return 14;
	if( !sbSplash.loadFromFile(sts) ) return 15;


	sound.setLoop(false);
	sound.setVolume(100);

	return 0;

} // end initSnds




void stopSnd(void) {  // stops current music loop AND named bkgd loop

	//assert( bkmus >= 0 ); // for debug only...
	// otherwise we are calling this erroneously

	if( ( bkmus >= 0 ) && ( bkmus<=5 ) )
	{
		music[bkmus].stop();
		bkmus=-1;
	}

	if( sf::Music::Playing == hum.getStatus() )       hum.stop();
	if( sf::Music::Playing == lava.getStatus() )     lava.stop();
	if( sf::Music::Playing == water.getStatus() )   water.stop();

} // end stopSnd







void stopMusik(void) {  // stops current music loop only

	if( ( bkmus >= 0 ) && ( bkmus<=5 ) )
	{
		music[bkmus].stop();
		bkmus=-1;
	}

} // end stopMusik




void playHum(void) {
	hum.play();
}

void stopHum(void) {
	if( sf::Music::Playing == hum.getStatus() )     hum.stop();
}




void playLava(void) {
	lava.play();
}

void stopLava(void) {
	if( sf::Music::Playing == lava.getStatus() )   lava.stop();
}





void playWater(void) {
	water.play();
}

void stopWater(void) {
	if( sf::Music::Playing == water.getStatus() ) water.stop();
}


static bool csplash(false);

// these next two procs wrap the sound
// of the prolog [transient] splash-loop
void playSplash(void) {
	//if( !csplash ) {
		sound.setBuffer(sbSplash);
		sound.setVolume(20);
		sound.setLoop(true);
		sound.play();
		csplash=true;
	//} // end if
}
void stopSplash(void) {
	//if (csplash) {
		sound.stop();
		sound.setLoop(false);
	//}
	csplash=false;
}







//#include <iostream>
//using std::cout;
//using std::endl;
void playSnd( int nbuf ) {

//cout<<nbuf<<endl;

	assert(nbuf>=0);
	assert(nbuf<=10);

	//if(nbuf>=6) sound.stop(); // test 21mar16

	if( nbuf<6 ) 
	{
		if( bkmus>=0 ) stopSnd();
		bkmus=nbuf;
		music[bkmus].play();
	}


	else if( nbuf==6 )
	{
		sound.setBuffer(sbLaser);
		sound.setLoop(false);
		sound.setVolume(50);
		sound.play();
	}
	else if( nbuf==7 )
	{
		sound.setBuffer(sbStone);
		sound.setLoop(false);
		sound.setVolume(100);
		sound.play();
	}

	else if( nbuf==8 )
	{
		sound.setBuffer(sbXport);
		sound.setLoop(false);
		sound.setVolume(50);
		sound.play();
	}


	else if( nbuf==9 )
	{
		sound.setBuffer(sbKick);
		sound.setLoop(false);
		sound.setVolume(100);
		sound.play();
	}


	else if( nbuf==10 )
	{
		sound.setBuffer(sbQport);
		sound.setLoop(false);
		sound.setVolume(50);
		sound.play();
	}



} // end playSnd



