#version 330 core

// vertex shader

layout(location = 0) in vec3 vertexPosition_modelspace;
layout(location = 1) in vec2 vertexUV;

out vec2 UV;

uniform mat4 MVP;
uniform float mytime;

uniform vec3 wPos;

uniform float rad; //radius of swim circle
uniform float svel; // swim-velocity (nom=1.0)
uniform float wvel; // wiggle-velocity (nom=1.0)
uniform float wamp; // wiggle-amplitude (nom=1.0)

const float onepi = 3.14159;


float dx( float ang )
{
	return rad*cos(ang);
}

float dz( float ang )
{
	return rad*sin(ang);
}


// ?early attempt at [stiff] fish movement

void main(){

	float ang = svel*0.05*mytime*onepi;
	float amp = wamp*onepi/45;
	float hfr = amp * sin( wvel*0.5*mytime*onepi );
	vec3 pos = vertexPosition_modelspace;

	// original vector of current pt from center:
	float ddx = pos.x - wPos.x;
	float ddz = pos.z - wPos.z;

	// rotated vector of pt from center:
	float ddxx = +cos(ang+hfr)*ddx - sin(ang+hfr)*ddz;
	float ddzz = +sin(ang+hfr)*ddx + cos(ang+hfr)*ddz;

	// rotate fish to swim nose forward:
	pos.x = wPos.x + ddxx;
	pos.z = wPos.z + ddzz;

	// now displace entire fish to swim in circle:
	pos.x = pos.x + dx(ang);
	pos.z = pos.z + dz(ang);

	gl_Position =  MVP * vec4(pos,1.0);
	UV = vertexUV; 
}


//--
//-- Copyright (C) 2017  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

