#version 330 core


uniform float time;
//uniform vec2 mouse;
vec2 mouse=vec2(0.5,0.5);
//uniform vec2 resolution;
uniform vec2 wPos;
uniform vec2 wRad;

in vec2 mypos;
out vec4 fragColor;

in vec4 aPos;

// halfspace discard uniforms: ////////////////////////////////////

uniform int iside=0; 
// zero=>no discard, -1=>hangbound=minimum, +1=>hangbound=maximum

uniform float hangbound; // halfspace divider angle
uniform float xme;       // halfspace angle vertex X
uniform float zme;       // halfspace angle vertex Y

// halfspace discard uniforms end /////////////////////////////////



void main(void){
	
	//vec2 p = gl_FragCoord.xy / resolution;
	vec2 p = +0.5 + 0.5*(mypos-wPos)/wRad; // 0...1
	vec2 q = p - vec2(mouse.x,mouse.y);
	
	vec3 col = mix(
		vec3(1.2*(mouse.y*2.0),0.4*(mouse.y),0.1), 
		vec3(0.9*mouse.y,0.7*mouse.y*1.5,0.2), 
		(p.y));
	
	float r = 0.0;
	r = 0.2*(mouse.y) +.1*mouse.y*cos(atan(q.x,q.y) * 10. 
		+ 20.*-q.x + 3. + time/cos(abs(mouse.x/50.)));
	
	col *= smoothstep(r,r+.01,length(q));
	r = 0.01*mouse.y;
	r += 0.001*cos(220.*q.y);
	r += exp(-100.*p.y - 0.5);
	col *= 1.0 
	- (1.0 - smoothstep(r, r+.005, abs(q.x - 0.25 
	* (mouse.x * 2.0 - 1.)*sin((cos(mouse.y) * 2.0)
	*q.y*2.0*mouse.y)) )) 
	* (1.0 - smoothstep(0.,0.01,q.y));
	
	fragColor = vec4(col,1.0);

	// fastrgv:  my halfspace-discard addendum:
	float hang=0.0;
	if( iside != 0 ) hang = atan(aPos.x-xme, aPos.z-zme);
	if     ( (iside>0) && (sin(hang-hangbound)>=0.0) ) discard;
	else if( (iside<0) && (sin(hang-hangbound)<=0.0) ) discard;


}				  

