#version 330 core

// vertex shader supporting lighting

layout(location = 0) in vec3 vertexPosition_modelspace;
layout(location = 1) in vec2 vertexUV;
layout(location = 2) in vec3 vertexNormal; // new item

uniform mat4 MVP;
uniform mat4 MV;

uniform int lightFlag = 0; // 0=>no, 1=>yes

smooth out vec2 UV;
smooth out vec3 vNormal;
smooth out vec4 vEyeSpacePos;
smooth out vec3 vWorldPos;
smooth out vec4 aPos;



void main(){ // see adagate.adb::pgmtexshadid

	aPos = vec4(vertexPosition_modelspace,1.0);
	gl_Position =  MVP * aPos;

	vEyeSpacePos = MV * aPos;

	UV = vertexUV; 


	if( lightFlag>0 )	vNormal = normalize(vertexNormal);
	else vNormal = vec3(0.0, 1.0, 0.0);


	vWorldPos = aPos.xyz;

}


//--
//-- Copyright (C) 2017  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

