#version 330 core

// fragment shader supporting lighting

smooth in vec2 UV;
smooth in vec3 vNormal;
smooth in vec4 vEyeSpacePos;
smooth in vec4 aPos;
smooth in vec3 vWorldPos;


out vec4 color;


////// begin lighting uniforms ///////////


uniform int lightFlag = 0; // 0=>no, 1=>yes

/////// begin point-light ///////
uniform vec3 vPtColor; // 254:203:33
uniform vec3 vPos1;
uniform vec3 vPos2;
uniform vec3 vPos3;
//uniform float fPtAmbient;
//uniform float fPtConstantAtt;
//uniform float fPtLinearAtt;
//uniform float fPtQuadAtt;
// note:  settings for lava room only:
const float fPtAmbient = 1.0;
const float fPtConstantAtt = 0.0;
const float fPtLinearAtt = 0.3;
const float fPtQuadAtt = 0.0;
////// end point-light //////////////////


////// begin directional-light //////
//uniform vec3 vDirColor;
//uniform vec3 vDirection;
//uniform float fDirAmbient;
//uniform float fDirStrength; // to ignore, set this to zero

const vec3 vDirColor = vec3(1.0,1.0,1.0);
const vec3 vDirection = vec3(0.0,-1.0,0.0);
const float fDirAmbient = 1.0;
const float fDirStrength = 0.0;

//////// end directional-light ////////////


////// end lighting uniforms ///////////


uniform sampler2D myTextureSampler;

uniform int level=0; //0=>noFog, 3=>purple, 2=>brown, 1=>gray

uniform int isel=0; // 0=>none, 3=>both, 1=>only 1, 2=>only 2
uniform float prad;
uniform vec3  port1;
uniform vec3  port2;

// halfspace discard uniforms: ////////////////////////////////////

uniform int iside=0; 
// zero=>no discard, -1=>hangbound=minimum, +1=>hangbound=maximum

uniform float hangbound; // halfspace divider angle
uniform float xme;       // halfspace angle vertex X
uniform float zme;       // halfspace angle vertex Y

// halfspace discard uniforms end /////////////////////////////////






//////// begin lighting ftns /////////////////////////


vec4 getPointLightColor()
{
	vec3 vPosToLight1 = vWorldPos-vPos1;
	float fDist1 = length(vPosToLight1);
	vPosToLight1 = normalize(vPosToLight1);

	vec3 vPosToLight2 = vWorldPos-vPos2;
	float fDist2 = length(vPosToLight2);
	vPosToLight2 = normalize(vPosToLight2);

	vec3 vPosToLight3 = vWorldPos-vPos3;
	float fDist3 = length(vPosToLight3);
	vPosToLight3 = normalize(vPosToLight3);

	float fDist = (fDist1+fDist2+fDist3)/3.0;

	float fDiffuse1 = max(0.0, dot(vNormal, -vPosToLight1));
	float fDiffuse2 = max(0.0, dot(vNormal, -vPosToLight2));
	float fDiffuse3 = max(0.0, dot(vNormal, -vPosToLight3));

	float fAttTotal = 
		fPtConstantAtt 
		+ fPtLinearAtt*fDist 
		+ fPtQuadAtt*fDist*fDist;

	return 
		vec4(vPtColor, 1.0)
		* (fPtAmbient+fDiffuse1+fDiffuse2+fDiffuse3)/fAttTotal;
}


vec4 getDirectionalLightColor()
{
	float fDiffuse = max(0.0, dot(vNormal, -vDirection));
	return vec4(
		vDirColor
		* (fDirAmbient+fDiffuse)
		* fDirStrength, 
		1.0);
}


//////// end lighting ftns /////////////////////////





const float onepi = 3.14159;
const float twopi=2.0*onepi;

const float fStart=0.0;
const float fEnd=30.0; // normal fog
const float sEnd=20.0; // use this for soot (lava room)

const vec4 vFogColor=vec4(0.9,0.9,0.9,1.0); //normal
const vec4 vSootColor=vec4(50.0/255,30.0/255,10.0/255,1.0); // lava room
const vec4 vMystColor=vec4(0.7,0.5,0.7,1.0); // granite room

float getFogFactor(float fFogCoord)
{
	float fResult = 0.0;

	if(level==2)
		fResult = (sEnd-fFogCoord)/(sEnd-fStart);
	else
		fResult = (fEnd-fFogCoord)/(fEnd-fStart);

	fResult = 1.0-clamp(fResult, 0.0, 1.0);
	
	return fResult;
}


const float yc=-2.85;

const float elip=0.9; //ratio

bool insideEllipse( vec3 cc, vec3 pt )
{
	float dist2 = 
		(cc.x-pt.x)*(cc.x-pt.x)/elip/elip +
		(cc.y-pt.y)*(cc.y-pt.y) +
		(cc.z-pt.z)*(cc.z-pt.z)/elip/elip;
	if( dist2<prad*prad ) return true;
	else return false;
}


void main(){  // see adagate.adb::pgmtexshadid

	color = texture( myTextureSampler, UV).rgba;


if( lightFlag > 0 ) { // use light effects

	vec4 vTexColor = color;
   vec4 vLightColor = 
		getDirectionalLightColor() +
		getPointLightColor();
		
	color = vTexColor*vLightColor;

}


	if(color.a < 0.1) discard;



	float dist = length( vEyeSpacePos.xz );
	float fFogCoord = exp(-0.4*abs(aPos.y-yc)) * dist/vEyeSpacePos.w;

	if( level==3 ) // purple
		color = mix(color, vMystColor, getFogFactor(fFogCoord));
	else if( level==2 ) // brown
		color = mix(color, vSootColor, getFogFactor(fFogCoord));
	else // gray
		color = mix(color, vFogColor, getFogFactor(fFogCoord));



	if( (isel>0) && (prad>0.1) ){
		if(

			 ( ( isel==3 ) && ( ( insideEllipse(port1,aPos.xyz) ) 
			 						|| ( insideEllipse(port2,aPos.xyz) ) ) )
			 ||

			 ( ( isel==2 ) && ( insideEllipse(port2,aPos.xyz) ) )
			 ||

			 ( ( isel==1 ) && ( insideEllipse(port1,aPos.xyz) ) )

		 ) color.a=0.0;
	}


	// fastrgv:  my halfspace-discard addendum:
	float hang=0.0;
	if( iside != 0 ) hang = atan(aPos.x-xme, aPos.z-zme);
	if     ( (iside>0) && (sin(hang-hangbound)>=0.0) ) discard;
	else if( (iside<0) && (sin(hang-hangbound)<=0.0) ) discard;



}



//--
//-- Copyright (C) 2017  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

