#version 330 core

// fragment shader
in vec2 UV;
in vec4 vEyeSpacePos;
in vec4 aPos;
out vec4 color;

uniform sampler2D myTextureSampler;
uniform int level;

uniform int isel; // 0=>none, 3=>both, 1=>only 1, 2=>only 2
uniform float prad;
uniform vec3  port1;
uniform vec3  port2;


const float fStart=0.0;
const float fEnd=30.0; // normal fog
const float sEnd=20.0; // use this for soot (lava room)

const vec4 vFogColor=vec4(0.9,0.9,0.9,1.0); //normal
const vec4 vSootColor=vec4(50.0/255,30.0/255,10.0/255,1.0); // lava room
const vec4 vMystColor=vec4(0.7,0.5,0.7,1.0); // granite room

float getFogFactor(float fFogCoord)
{
	float fResult = 0.0;

	if(level==2)
		fResult = (sEnd-fFogCoord)/(sEnd-fStart);
	else
		fResult = (fEnd-fFogCoord)/(fEnd-fStart);

	fResult = 1.0-clamp(fResult, 0.0, 1.0);
	
	return fResult;
}


const float yc=-2.85;

const float elip=0.9; //ratio

bool insideEllipse( vec3 cc, vec3 pt )
{
	float dist2 = 
		(cc.x-pt.x)*(cc.x-pt.x)/elip/elip +
		(cc.y-pt.y)*(cc.y-pt.y) +
		(cc.z-pt.z)*(cc.z-pt.z)/elip/elip;
	if( dist2<prad*prad ) return true;
	else return false;
}


void main(){
	color = texture( myTextureSampler, UV).rgba;
	if(color.a < 0.1) discard;
	float dist = length( vEyeSpacePos.xz );
	float fFogCoord = exp(-0.4*abs(aPos.y-yc)) * dist/vEyeSpacePos.w;

	if( level==3 )
		color = mix(color, vMystColor, getFogFactor(fFogCoord));
	else if( level==2 )
		color = mix(color, vSootColor, getFogFactor(fFogCoord));
	else
		color = mix(color, vFogColor, getFogFactor(fFogCoord));

	if( (isel>0) && (prad>0.1) ){
		if(

			 ( ( isel==3 ) && ( ( insideEllipse(port1,aPos.xyz) ) || ( insideEllipse(port2,aPos.xyz) ) ) )
			 ||

			 ( ( isel==2 ) && ( insideEllipse(port2,aPos.xyz) ) )
			 ||

			 ( ( isel==1 ) && ( insideEllipse(port1,aPos.xyz) ) )

		 ) color.a=0.0;
	}

}



//--
//-- Copyright (C) 2017  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

