
--
-- Copyright (C) 2018  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--

with system;
with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;


with ada.finalization;
with unchecked_deallocation;


with text_io;
with ada.numerics.generic_elementary_functions;



package body annusurfobj is
-- for annular/circular body of reflective water
-- polar gridding



	package fmath is new
			Ada.Numerics.generic_elementary_functions( float );
	use fmath;

  onepi : constant float     := 3.14159_26535_89793;
  --halfpi : constant float    := onepi/2.0;
  --fourthpi : constant float  := onepi/4.0;
  twopi : constant float     := onepi*2.0;




procedure initialize( cs: in out annusurf ) is
begin
	cs.vert := new varray;
end initialize;

procedure vfree is new unchecked_deallocation(varray,vap);

procedure finalize( cs: in out annusurf ) is
begin
	vfree( cs.vert );
end finalize;






procedure setround( cs: annusurf;  inner, outer : float ) is

	da : constant float := twopi/float(nang);
	dr : constant float := (outer-inner)/float(nrad);

	ang0, ang1, r0, r1, x00,z00, x01,z01, x10,z10, x11,z11 : float;
	fi,fj : float;

begin

	nv:=0;

	for i in 0..nang-1 loop
	fi := float(i);
	for j in 0..nrad-1 loop
	fj := float(j);

		ang0 := fi*da;
		ang1 := ang0+da;

		r0 := inner + fj*dr;
		r1 := r0 + dr;

	if r1<outer then

		x00 := r0*sin(ang0);
		z00 := r0*cos(ang0);
		x01 := r0*sin(ang1);
		z01 := r0*cos(ang1);
		x10 := r1*sin(ang0);
		z10 := r1*cos(ang0);
		x11 := r1*sin(ang1);
		z11 := r1*cos(ang1);


			cs.vert(nv+1):=x00;
			cs.vert(nv+2):=0.0;
			cs.vert(nv+3):=z00;
			nv:=nv+3;

			cs.vert(nv+1):=x10;
			cs.vert(nv+2):=0.0;
			cs.vert(nv+3):=z10;
			nv:=nv+3;

			cs.vert(nv+1):=x11;
			cs.vert(nv+2):=0.0;
			cs.vert(nv+3):=z11;
			nv:=nv+3;


			cs.vert(nv+1):=x00;
			cs.vert(nv+2):=0.0;
			cs.vert(nv+3):=z00;
			nv:=nv+3;

			cs.vert(nv+1):=x11;
			cs.vert(nv+2):=0.0;
			cs.vert(nv+3):=z11;
			nv:=nv+3;

			cs.vert(nv+1):=x01;
			cs.vert(nv+2):=0.0;
			cs.vert(nv+3):=z01;
			nv:=nv+3;

	end if; -- r0<outer

	end loop; --j
	end loop; --i

end setround;





-- note:  the shaders for these objects must have one
-- input "layout", as well as whatever uniforms are needed:
--
-- layout(location=0) in vec3 vertPosName
--
-- ...where their actual name can be whatever is convenient
--

use gl;
use glext;
use glext.binding;
procedure draw( cs: annusurf;  vertbuff : gluint ) is
begin

	glBindBuffer(gl_array_buffer, vertbuff);
	glBufferData(gl_array_buffer, glsizeiptr(4*nv), cs.vert(1)'address, gl_static_draw);
	glEnableVertexAttribArray(0);
	glVertexAttribPointer(0,3,gl_float,gl_false,0, system.null_address);

	gl.binding.glDrawArrays( gl_triangles, 0, glint(nv) );

	glDisableVertexAttribArray(0);

end draw;


end annusurfobj;

