
--
-- Copyright (C) 2016  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

use gl;




with Interfaces.C;
use  type interfaces.c.unsigned;
with text_io; use text_io;
with system; use system;

with Ada.Strings.Unbounded;  use Ada.Strings.Unbounded;


package body shader is

function read2ustring( fpath : string ) return unbounded_string is
	tfil: file_type;
	lineoftext : string(1..160);
	linelen : natural;
	outstr : unbounded_string;
begin

	text_io.open( tfil, text_io.in_file, fpath );

	while not end_of_file(tfil) loop
		text_io.get_line(tfil, lineoftext, linelen);

		append( outstr, lineoftext(1..linelen) & ascii.lf );

	end loop;
	append( outstr, character'Val(0) );

	text_io.close( tfil );

	return outstr;

end read2ustring;



use glext;
use glext.binding;
use gl.binding;


function loadshaders(vertpath,fragpath: string) return gluint is
	pid : interfaces.c.unsigned;
	vscode, fscode : unbounded_string;
	vshaderid, fshaderid	 : aliased gluint;

	vstr : string := to_string( read2ustring(vertpath) );
	avs : system.address := vstr'address;

	fstr : string := to_string( read2ustring(fragpath) );
	afs : system.address := fstr'address;

begin -- loadshaders

	vshaderid := glcreateshader(gl_vertex_shader);
	fshaderid := glcreateshader(gl_fragment_shader);

	glshadersource(vshaderid, 1, avs'address, system'to_address(0));
	glcompileshader(vshaderid);

	glshadersource(fshaderid, 1, afs'address, system'to_address(0) );
	glcompileshader(fshaderid);

	pid := glcreateprogram;
	glattachshader(pid, vshaderid);
	glattachshader(pid, fshaderid);
	gllinkprogram(pid);

	gldeleteshader(vshaderid);
	gldeleteshader(fshaderid);


	return pid;

end loadshaders;


end shader;

