   type FloatArray is array (C.size_t range <>) of aliased C.C_float;
   pragma Convention (C, FloatArray);

   type Uint8Array is array (C.size_t range <>) of aliased Uint8;
   pragma Convention (C, Uint8Array);

   type Sint8Array is array (C.size_t range <>) of aliased Sint8;
   pragma Convention (C, Sint8Array);

   type Uint16Array is array (C.size_t range <>) of aliased Uint16;
   pragma Convention (C, Uint16Array);

   type Sint16Array is array (C.size_t range <>) of aliased Sint16;
   pragma Convention (C, Sint16Array);

   type Uint32Array is array (C.size_t range <>) of aliased Uint32;
   pragma Convention (C, Uint32Array);

   type Sint32Array is array (C.size_t range <>) of aliased Sint32;
   pragma Convention (C, Sint32Array);

   type Uint64Array is array (C.size_t range <>) of aliased Uint64;
   pragma Convention (C, Uint64Array);

   type Sint64Array is array (C.size_t range <>) of aliased Sint64;
   pragma Convention (C, Sint64Array);

---------------------------------------------------------------------

   function SDL_InitSubSystem (flags : Uint32) return C.int;
   pragma Import (C, SDL_InitSubSystem, "SDL_InitSubSystem");

   procedure SDL_QuitSubSystem (flags : Uint32);
   pragma Import (C, SDL_QuitSubSystem, "SDL_QuitSubSystem");

   function SDL_WasInit (flags : Uint32) return Uint32;
   pragma Import (C, SDL_WasInit, "SDL_WasInit");


---------------------------------------------------------------------
   ----------------------------------------------------------------------------
   -- SDL_platform.h
   ----------------------------------------------------------------------------

   function SDL_GetPlatform return C.Strings.chars_ptr;
   pragma Import (C, SDL_GetPlatform, "SDL_GetPlatform");

   ----------------------------------------------------------------------------
   -- SDL_power.h
   ----------------------------------------------------------------------------

   type SDL_PowerState is
     (SDL_POWERSTATE_UNKNOWN,
      SDL_POWERSTATE_ON_BATTERY,
      SDL_POWERSTATE_NO_BATTERY,
      SDL_POWERSTATE_CHARGING,
      SDL_POWERSTATE_CHARGED);
   pragma Convention (C, SDL_PowerState);

   function SDL_GetPowerInfo
     (secs : access C.int;
      pct  : access C.int) return SDL_PowerState;
   pragma Import (C, SDL_GetPowerInfo, "SDL_GetPowerInfo");

   ----------------------------------------------------------------------------
   -- SDL_cpuinfo.h
   ----------------------------------------------------------------------------

   function SDL_GetCPUCount return C.int;
   pragma Import (C, SDL_GetCPUCount, "SDL_GetCPUCount");

   function SDL_GetCPUCacheLineSize return C.int;
   pragma Import (C, SDL_GetCPUCacheLineSize, "SDL_GetCPUCacheLineSize");

   function SDL_HasRDTSC return SDL_bool;
   pragma Import (C, SDL_HasRDTSC, "SDL_HasRDTSC");

   function SDL_HasAltiVec return SDL_bool;
   pragma Import (C, SDL_HasAltiVec, "SDL_HasAltiVec");

   function SDL_HasMMX return SDL_bool;
   pragma Import (C, SDL_HasMMX, "SDL_HasMMX");

   function SDL_Has3DNow return SDL_bool;
   pragma Import (C, SDL_Has3DNow, "SDL_Has3DNow");

   function SDL_HasSSE return SDL_bool;
   pragma Import (C, SDL_HasSSE, "SDL_HasSSE");

   function SDL_HasSSE2 return SDL_bool;
   pragma Import (C, SDL_HasSSE2, "SDL_HasSSE2");

   function SDL_HasSSE3 return SDL_bool;
   pragma Import (C, SDL_HasSSE3, "SDL_HasSSE3");

   function SDL_HasSSE41 return SDL_bool;
   pragma Import (C, SDL_HasSSE41, "SDL_HasSSE41");

   function SDL_HasSSE42 return SDL_bool;
   pragma Import (C, SDL_HasSSE42, "SDL_HasSSE42");

   function SDL_HasAVX return SDL_bool;
   pragma Import (C, SDL_HasAVX, "SDL_HasAVX");

   function SDL_GetSystemRAM return C.int;
   pragma Import (C, SDL_GetSystemRAM, "SDL_GetSystemRAM");

   ----------------------------------------------------------------------------
   -- SDL_filesystem.h
   ----------------------------------------------------------------------------

   function SDL_GetBasePath return C.Strings.chars_ptr;
   pragma Import (C, SDL_GetBasePath, "SDL_GetBasePath");

   function SDL_GetPrefPath
     (org : C.char_array;
      app : C.char_array) return C.Strings.chars_ptr;
   pragma Import (C, SDL_GetPrefPath, "SDL_GetPrefPath");



---------------------------------------------------------------------


   ----------------------------------------------------------------------------
   -- SDL_timer.h
   ----------------------------------------------------------------------------

   function SDL_TICKS_PASSED (A, B : Uint32) return SDL_bool;
   pragma Inline (SDL_TICKS_PASSED);

   function SDL_GetPerformanceCounter return Uint64;
   pragma Import (C, SDL_GetPerformanceCounter, "SDL_GetPerformanceCounter");

   function SDL_GetPerformanceFrequency return Uint64;
   pragma Import
     (C,
      SDL_GetPerformanceFrequency,
      "SDL_GetPerformanceFrequency");

   procedure SDL_Delay (ms : Uint32);
   pragma Import (C, SDL_Delay, "SDL_Delay");

   function SDL_AddTimer
     (interval : Uint32;
      callback : SDL_TimerCallback;
      param    : System.Address) return SDL_TimerID;
   pragma Import (C, SDL_AddTimer, "SDL_AddTimer");

   function SDL_RemoveTimer (id : SDL_TimerID) return SDL_bool;
   pragma Import (C, SDL_RemoveTimer, "SDL_RemoveTimer");

   ----------------------------------------------------------------------------
   -- SDL_clipboard.h
   ----------------------------------------------------------------------------

   function SDL_SetClipboardText (text : C.char_array) return C.int;
   pragma Import (C, SDL_SetClipboardText, "SDL_SetClipboardText");

   function SDL_GetClipboardText return C.Strings.chars_ptr;
   pragma Import (C, SDL_GetClipboardText, "SDL_GetClipboardText");

   function SDL_HasClipboardText return SDL_bool;
   pragma Import (C, SDL_HasClipboardText, "SDL_HasClipboardText");

   ----------------------------------------------------------------------------
   -- SDL_log.h
   ----------------------------------------------------------------------------

   SDL_MAX_LOG_MESSAGE : constant := 4096;

   type SDL_LogCategory is
     (SDL_LOG_CATEGORY_APPLICATION,
      SDL_LOG_CATEGORY_ERROR,
      SDL_LOG_CATEGORY_ASSERT,
      SDL_LOG_CATEGORY_SYSTEM,
      SDL_LOG_CATEGORY_AUDIO,
      SDL_LOG_CATEGORY_VIDEO,
      SDL_LOG_CATEGORY_RENDER,
      SDL_LOG_CATEGORY_INPUT,
      SDL_LOG_CATEGORY_TEST,
      SDL_LOG_CATEGORY_RESERVED1,
      SDL_LOG_CATEGORY_RESERVED2,
      SDL_LOG_CATEGORY_RESERVED3,
      SDL_LOG_CATEGORY_RESERVED4,
      SDL_LOG_CATEGORY_RESERVED5,
      SDL_LOG_CATEGORY_RESERVED6,
      SDL_LOG_CATEGORY_RESERVED7,
      SDL_LOG_CATEGORY_RESERVED8,
      SDL_LOG_CATEGORY_RESERVED9,
      SDL_LOG_CATEGORY_RESERVED10,
      SDL_LOG_CATEGORY_CUSTOM);
   pragma Convention (C, SDL_LogCategory);

   type SDL_LogPriority is
     (SDL_LOG_PRIORITY_VERBOSE,
      SDL_LOG_PRIORITY_DEBUG,
      SDL_LOG_PRIORITY_INFO,
      SDL_LOG_PRIORITY_WARN,
      SDL_LOG_PRIORITY_ERROR,
      SDL_LOG_PRIORITY_CRITICAL,
      SDL_NUM_LOG_PRIORITIES);
   pragma Convention (C, SDL_LogPriority);

   for SDL_LogPriority use
   (SDL_LOG_PRIORITY_VERBOSE  => 1,
    SDL_LOG_PRIORITY_DEBUG    => 2,
    SDL_LOG_PRIORITY_INFO     => 3,
    SDL_LOG_PRIORITY_WARN     => 4,
    SDL_LOG_PRIORITY_ERROR    => 5,
    SDL_LOG_PRIORITY_CRITICAL => 6,
    SDL_NUM_LOG_PRIORITIES    => 7);

   procedure SDL_LogSetAllPriority (priority : SDL_LogPriority);
   pragma Import (C, SDL_LogSetAllPriority, "SDL_LogSetAllPriority");

   procedure SDL_LogSetPriority
     (category : SDL_LogCategory;
      priority : SDL_LogPriority);
   pragma Import (C, SDL_LogSetPriority, "SDL_LogSetPriority");

   function SDL_LogGetPriority
     (category : SDL_LogCategory) return SDL_LogPriority;
   pragma Import (C, SDL_LogGetPriority, "SDL_LogGetPriority");

   procedure SDL_LogResetPriorities;
   pragma Import (C, SDL_LogResetPriorities, "SDL_LogResetPriorities");

   procedure SDL_Log (text : C.char_array);
   pragma Import (C, SDL_Log, "SDL_Log");

   procedure SDL_LogVerbose (category : SDL_LogCategory; text : C.char_array);
   pragma Import (C, SDL_LogVerbose, "SDL_LogVerbose");

   procedure SDL_LogDebug (category : SDL_LogCategory; text : C.char_array);
   pragma Import (C, SDL_LogDebug, "SDL_LogDebug");

   procedure SDL_LogInfo (category : SDL_LogCategory; text : C.char_array);
   pragma Import (C, SDL_LogInfo, "SDL_LogInfo");

   procedure SDL_LogWarn (category : SDL_LogCategory; text : C.char_array);
   pragma Import (C, SDL_LogWarn, "SDL_LogWarn");

   procedure SDL_LogError (category : SDL_LogCategory; text : C.char_array);
   pragma Import (C, SDL_LogError, "SDL_LogError");

   procedure SDL_LogCritical (category : SDL_LogCategory; text : C.char_array);
   pragma Import (C, SDL_LogCritical, "SDL_LogCritical");

   procedure SDL_LogMessage
     (category : SDL_LogCategory;
      priority : SDL_LogPriority;
      text     : C.char_array);
   pragma Import (C, SDL_LogMessage, "SDL_LogMessage");

   -- procedure SDL_LogMessageV
   --   (category : SDL_LogCategory;
   --    priority : SDL_LogPriority;
   --    fmt : C.char_array;
   --    ap : va_list ?);

   type SDL_LogOutputFunction is access procedure
     (userdata : System.Address;
      category : SDL_LogCategory;
      priority : SDL_LogPriority;
      message  : C.char_array);
   pragma Convention (C, SDL_LogOutputFunction);

   procedure SDL_LogGetOutputFunction
     (callback : access SDL_LogOutputFunction;
      userdata : System.Address);
   pragma Import (C, SDL_LogGetOutputFunction, "SDL_LogGetOutputFunction");

   procedure SDL_LogSetOutputFunction
     (callback : SDL_LogOutputFunction;
      userdata : System.Address);
   pragma Import (C, SDL_LogSetOutputFunction, "SDL_LogSetOutputFunction");

   ----------------------------------------------------------------------------
   -- SDL_loadso.h
   ----------------------------------------------------------------------------

   function SDL_LoadObject (sofile : C.char_array) return System.Address;
   pragma Import (C, SDL_LoadObject, "SDL_LoadObject");

   function SDL_LoadFunction
     (handle : System.Address;
      name   : C.char_array) return System.Address;
   pragma Import (C, SDL_LoadFunction, "SDL_LoadFunction");

   procedure SDL_UnloadObject (handle : System.Address);
   pragma Import (C, SDL_UnloadObject, "SDL_UnloadObject");



---------------------------------------------------------------------
   type SDL_HintCallback is access procedure
     (userdata : System.Address;
      name     : Interfaces.C.char_array;
      oldValue : Interfaces.C.char_array;
      newValue : Interfaces.C.char_array);
   pragma Convention (C, SDL_HintCallback);

   procedure SDL_AddHintCallback
     (name     : Interfaces.C.char_array;
      callback : SDL_HintCallback;
      userdata : System.Address);
   pragma Import (C, SDL_AddHintCallback, "SDL_AddHintCallback");

   procedure SDL_DelHintCallback
     (name     : Interfaces.C.char_array;
      callback : SDL_HintCallback;
      userdata : System.Address);
   pragma Import (C, SDL_DelHintCallback, "SDL_DelHintCallback");

   procedure SDL_ClearHints;
   pragma Import (C, SDL_ClearHints, "SDL_ClearHints");


---------------------------------------------------------------------


   ----------------------------------------------------------------------------
   -- SDL_rwops.h
   ----------------------------------------------------------------------------

   function SDL_RWFromFile
     (file : C.char_array;
      mode : C.char_array) return access SDL_RWops;
   pragma Import (C, SDL_RWFromFile, "SDL_RWFromFile");

   function SDL_RWFromFP
     (fp        : System.Address;
      autoclose : SDL_bool) return access SDL_RWops;
   pragma Import (C, SDL_RWFromFP, "SDL_RWFromFP");

   function SDL_RWFromMem
     (mem  : System.Address;
      size : C.int) return access SDL_RWops;
   pragma Import (C, SDL_RWFromMem, "SDL_RWFromMem");

   function SDL_RWFromConstMem
     (mem  : System.Address;
      size : C.int) return access SDL_RWops;
   pragma Import (C, SDL_RWFromConstMem, "SDL_RWFromConstMem");

   function SDL_AllocRW return access SDL_RWops;
   pragma Import (C, SDL_AllocRW, "SDL_AllocRW");

   procedure SDL_FreeRW (area : access SDL_RWops);
   pragma Import (C, SDL_FreeRW, "SDL_FreeRW");

   function SDL_RWsize (ctx : access SDL_RWops) return Sint64;
   pragma Inline (SDL_RWsize);

   function SDL_RWseek
     (ctx    : access SDL_RWops;
      offset : Sint64;
      whence : C.int) return Sint64;
   pragma Inline (SDL_RWseek);

   function SDL_RWtell (ctx : access SDL_RWops) return Sint64;
   pragma Inline (SDL_RWtell);

   function SDL_RWread
     (ctx  : access SDL_RWops;
      ptr  : System.Address;
      size : C.size_t;
      n    : C.size_t) return C.size_t;
   pragma Inline (SDL_RWread);

   function SDL_RWwrite
     (ctx  : access SDL_RWops;
      ptr  : System.Address;
      size : C.size_t;
      n    : C.size_t) return C.size_t;
   pragma Inline (SDL_RWwrite);

   function SDL_RWclose (ctx : access SDL_RWops) return C.int;
   pragma Inline (SDL_RWclose);

   function SDL_ReadU8 (src : access SDL_RWops) return Uint8;
   pragma Import (C, SDL_ReadU8, "SDL_ReadU8");

   function SDL_ReadLE16 (src : access SDL_RWops) return Uint16;
   pragma Import (C, SDL_ReadLE16, "SDL_ReadLE16");

   function SDL_ReadBE16 (src : access SDL_RWops) return Uint16;
   pragma Import (C, SDL_ReadBE16, "SDL_ReadBE16");

   function SDL_ReadLE32 (src : access SDL_RWops) return Uint32;
   pragma Import (C, SDL_ReadLE32, "SDL_ReadLE32");

   function SDL_ReadBE32 (src : access SDL_RWops) return Uint32;
   pragma Import (C, SDL_ReadBE32, "SDL_ReadBE32");

   function SDL_ReadLE64 (src : access SDL_RWops) return Uint64;
   pragma Import (C, SDL_ReadLE64, "SDL_ReadLE64");

   function SDL_ReadBE64 (src : access SDL_RWops) return Uint64;
   pragma Import (C, SDL_ReadBE64, "SDL_ReadBE64");

   function SDL_WriteU8
     (dst   : access SDL_RWops;
      value : Uint8) return C.size_t;
   pragma Import (C, SDL_WriteU8, "SDL_WriteU8");

   function SDL_WriteLE16
     (dst   : access SDL_RWops;
      value : Uint16) return C.size_t;
   pragma Import (C, SDL_WriteLE16, "SDL_WriteLE16");

   function SDL_WriteBE16
     (dst   : access SDL_RWops;
      value : Uint16) return C.size_t;
   pragma Import (C, SDL_WriteBE16, "SDL_WriteBE16");

   function SDL_WriteLE32
     (dst   : access SDL_RWops;
      value : Uint32) return C.size_t;
   pragma Import (C, SDL_WriteLE32, "SDL_WriteLE32");

   function SDL_WriteBE32
     (dst   : access SDL_RWops;
      value : Uint32) return C.size_t;
   pragma Import (C, SDL_WriteBE32, "SDL_WriteBE32");

   function SDL_WriteLE64
     (dst   : access SDL_RWops;
      value : Uint64) return C.size_t;
   pragma Import (C, SDL_WriteLE64, "SDL_WriteLE64");

   function SDL_WriteBE64
     (dst   : access SDL_RWops;
      value : Uint64) return C.size_t;
   pragma Import (C, SDL_WriteBE64, "SDL_WriteBE64");

---------------------------------------------------------------------



   ----------------------------------------------------------------------------
   -- SDL_pixels.h
   ----------------------------------------------------------------------------
---------------------------------------------------------------------
   
   ----------------------------------------------------------------------------
   -- SDL_surface.h
   ----------------------------------------------------------------------------

	
   function SDL_MUSTLOCK (S : access SDL_Surface) return SDL_bool;
   pragma Inline (SDL_MUSTLOCK);

   function SDL_CreateRGBSurface
     (flags  : Uint32;
      width  : C.int;
      height : C.int;
      depth  : C.int;
      Rmask  : Uint32;
      Gmask  : Uint32;
      Bmask  : Uint32;
      Amask  : Uint32) return access SDL_Surface;
   pragma Import (C, SDL_CreateRGBSurface, "SDL_CreateRGBSurface");

   function SDL_CreateRGBSurfaceFrom
     (pixels : System.Address;
      width  : C.int;
      height : C.int;
      depth  : C.int;
      pitch  : C.int;
      Rmask  : Uint32;
      Gmask  : Uint32;
      Bmask  : Uint32;
      Amask  : Uint32) return access SDL_Surface;
   pragma Import (C, SDL_CreateRGBSurfaceFrom, "SDL_CreateRGBSurfaceFrom");

   procedure SDL_FreeSurface (surface : access SDL_Surface);
   pragma Import (C, SDL_FreeSurface, "SDL_FreeSurface");

   function SDL_SetSurfacePalette
     (surface : access SDL_Surface;
      palette : access SDL_Palette) return C.int;
   pragma Import (C, SDL_SetSurfacePalette, "SDL_SetSurfacePalette");

   function SDL_LockSurface (surface : access SDL_Surface) return C.int;
   pragma Import (C, SDL_LockSurface, "SDL_LockSurface");

   procedure SDL_UnlockSurface (surface : access SDL_Surface);
   pragma Import (C, SDL_UnlockSurface, "SDL_UnlockSurface");

   function SDL_LoadBMP_RW
     (src     : access SDL_RWops;
      freesrc : C.int) return access SDL_Surface;
   pragma Import (C, SDL_LoadBMP_RW, "SDL_LoadBMP_RW");

   function SDL_LoadBMP (file : C.char_array) return access SDL_Surface;
   pragma Inline (SDL_LoadBMP);

   function SDL_SaveBMP_RW
     (surface : access SDL_Surface;
      dst     : access SDL_RWops;
      freedst : C.int) return C.int;
   pragma Import (C, SDL_SaveBMP_RW, "SDL_SaveBMP_RW");

   function SDL_SaveBMP
     (surface : access SDL_Surface;
      file    : C.char_array) return C.int;
   pragma Inline (SDL_SaveBMP);

   function SDL_SetSurfaceRLE
     (surface : access SDL_Surface;
      flag    : C.int) return C.int;
   pragma Import (C, SDL_SetSurfaceRLE, "SDL_SetSurfaceRLE");

   function SDL_SetColorKey
     (surface : access SDL_Surface;
      flag    : C.int;
      key     : Uint32) return C.int;
   pragma Import (C, SDL_SetColorKey, "SDL_SetColorKey");

   function SDL_GetColorKey
     (surface : access SDL_Surface;
      key     : access Uint32) return C.int;
   pragma Import (C, SDL_GetColorKey, "SDL_GetColorKey");

   function SDL_SetSurfaceColorMod
     (surface : access SDL_Surface;
      r       : Uint8;
      g       : Uint8;
      b       : Uint8) return C.int;
   pragma Import (C, SDL_SetSurfaceColorMod, "SDL_SetSurfaceColorMod");

   function SDL_GetSurfaceColorMod
     (surface : access SDL_Surface;
      r       : access Uint8;
      g       : access Uint8;
      b       : access Uint8) return C.int;
   pragma Import (C, SDL_GetSurfaceColorMod, "SDL_GetSurfaceColorMod");

   function SDL_SetSurfaceAlphaMod
     (surface : access SDL_Surface;
      alpha   : Uint8) return C.int;
   pragma Import (C, SDL_SetSurfaceAlphaMod, "SDL_SetSurfaceAlphaMod");

   function SDL_GetSurfaceAlphaMod
     (surface : access SDL_Surface;
      alpha   : access Uint8) return C.int;
   pragma Import (C, SDL_GetSurfaceAlphaMod, "SDL_GetSurfaceAlphaMod");

   function SDL_SetSurfaceBlendMode
     (surface   : access SDL_Surface;
      blendMode : SDL_BlendMode) return C.int;
   pragma Import (C, SDL_SetSurfaceBlendMode, "SDL_SetSurfaceBlendMode");

   function SDL_GetSurfaceBlendMode
     (surface   : access SDL_Surface;
      blendMode : access SDL_BlendMode) return C.int;
   pragma Import (C, SDL_GetSurfaceBlendMode, "SDL_GetSurfaceBlendMode");

   function SDL_SetClipRect
     (surface : access SDL_Surface;
      rect    : access SDL_Rect) return SDL_bool;
   pragma Import (C, SDL_SetClipRect, "SDL_SetClipRect");

   procedure SDL_GetClipRect
     (surface : access SDL_Surface;
      rect    : access SDL_Rect);
   pragma Import (C, SDL_GetClipRect, "SDL_GetClipRect");

   function SDL_ConvertSurface
     (src   : access SDL_Surface;
      fmt   : access SDL_PixelFormat;
      flags : Uint32) return access SDL_Surface;
   pragma Import (C, SDL_ConvertSurface, "SDL_ConvertSurface");

   function SDL_ConvertSurfaceFormat
     (src          : access SDL_Surface;
      pixel_format : Uint32;
      flags        : Uint32) return access SDL_Surface;
   pragma Import (C, SDL_ConvertSurfaceFormat, "SDL_ConvertSurfaceFormat");

   function SDL_ConvertPixels
     (width      : C.int;
      height     : C.int;
      src_format : Uint32;
      src        : System.Address;
      src_pitch  : C.int;
      dst_format : Uint32;
      dst        : System.Address;
      dst_pitch  : C.int) return C.int;
   pragma Import (C, SDL_ConvertPixels, "SDL_ConvertPixels");

   function SDL_FillRect
     (dst   : access SDL_Surface;
      rect  : access SDL_Rect;
      color : Uint32) return C.int;
   pragma Import (C, SDL_FillRect, "SDL_FillRect");

   function SDL_FillRects
     (dst   : access SDL_Surface;
      rects : access SDL_Rect;
      count : C.int;
      color : Uint32) return C.int;
   pragma Import (C, SDL_FillRects, "SDL_FillRects");

   function SDL_UpperBlit
     (src     : access SDL_Surface;
      srcrect : access SDL_Rect;
      dst     : access SDL_Surface;
      dstrect : access SDL_Rect) return C.int;
   pragma Import (C, SDL_UpperBlit, "SDL_UpperBlit");

   function SDL_BlitSurface
     (src     : access SDL_Surface;
      srcrect : access SDL_Rect;
      dst     : access SDL_Surface;
      dstrect : access SDL_Rect) return C.int renames
     SDL_UpperBlit;

   function SDL_LowerBlit
     (src     : access SDL_Surface;
      srcrect : access SDL_Rect;
      dst     : access SDL_Surface;
      dstrect : access SDL_Rect) return C.int;
   pragma Import (C, SDL_LowerBlit, "SDL_LowerBlit");

   function SDL_SoftStretch
     (src     : access SDL_Surface;
      srcrect : access SDL_Rect;
      dst     : access SDL_Surface;
      dstrect : access SDL_Rect) return C.int;
   pragma Import (C, SDL_SoftStretch, "SDL_SoftStretch");

   function SDL_UpperBlitScaled
     (src     : access SDL_Surface;
      srcrect : access SDL_Rect;
      dst     : access SDL_Surface;
      dstrect : access SDL_Rect) return C.int;
   pragma Import (C, SDL_UpperBlitScaled, "SDL_UpperBlitScaled");

   function SDL_BlitScaled
     (src     : access SDL_Surface;
      srcrect : access SDL_Rect;
      dst     : access SDL_Surface;
      dstrect : access SDL_Rect) return C.int renames
     SDL_UpperBlitScaled;

   function SDL_LowerBlitScaled
     (src     : access SDL_Surface;
      srcrect : access SDL_Rect;
      dst     : access SDL_Surface;
      dstrect : access SDL_Rect) return C.int;
   pragma Import (C, SDL_LowerBlitScaled, "SDL_LowerBlitScaled");

   ----------------------------------------------------------------------------
   -- SDL_audio.h
   ----------------------------------------------------------------------------

   subtype SDL_AudioFormat is Uint16;
   subtype SDL_AudioDeviceID is Uint32;

   SDL_AUDIO_MASK_BITSIZE  : constant := (16#FF#);
   SDL_AUDIO_MASK_DATATYPE : constant := (2**8);
   SDL_AUDIO_MASK_ENDIAN   : constant := (2**12);
   SDL_AUDIO_MASK_SIGNED   : constant := (2**15);

   function SDL_AUDIO_BITSIZE (x : SDL_AudioFormat) return C.int;
   pragma Inline (SDL_AUDIO_BITSIZE);

   function SDL_AUDIO_ISFLOAT (x : SDL_AudioFormat) return SDL_bool;
   pragma Inline (SDL_AUDIO_ISFLOAT);

   function SDL_AUDIO_ISBIGENDIAN (x : SDL_AudioFormat) return SDL_bool;
   pragma Inline (SDL_AUDIO_ISBIGENDIAN);

   function SDL_AUDIO_ISSIGNED (x : SDL_AudioFormat) return SDL_bool;
   pragma Inline (SDL_AUDIO_ISSIGNED);

   function SDL_AUDIO_ISINT (x : SDL_AudioFormat) return SDL_bool;
   pragma Inline (SDL_AUDIO_ISINT);

   function SDL_AUDIO_ISLITTLEENDIAN (x : SDL_AudioFormat) return SDL_bool;
   pragma Inline (SDL_AUDIO_ISLITTLEENDIAN);

   function SDL_AUDIO_ISUNSIGNED (x : SDL_AudioFormat) return SDL_bool;
   pragma Inline (SDL_AUDIO_ISUNSIGNED);

   AUDIO_U8     : constant := 16#0008#;
   AUDIO_S8     : constant := 16#8008#;
   AUDIO_U16LSB : constant := 16#0010#;
   AUDIO_S16LSB : constant := 16#8010#;
   AUDIO_U16MSB : constant := 16#1010#;
   AUDIO_S16MSB : constant := 16#9010#;
   AUDIO_U16    : constant := AUDIO_U16LSB;
   AUDIO_S16    : constant := AUDIO_S16LSB;

   AUDIO_S32LSB : constant := 16#8020#;
   AUDIO_S32MSB : constant := 16#9020#;
   AUDIO_S32    : constant := AUDIO_S32LSB;

   AUDIO_F32LSB : constant := 16#8120#;
   AUDIO_F32MSB : constant := 16#9120#;
   AUDIO_F32    : constant := AUDIO_F32LSB;

   -- AUDIO_U16SYS : constant SDL_AudioFormat;
   -- AUDIO_S16SYS : constant SDL_AudioFormat;
   -- AUDIO_S32SYS : constant SDL_AudioFormat;
   -- AUDIO_F32SYS : constant SDL_AudioFormat;

   SDL_AUDIO_ALLOW_FREQUENCY_CHANGE : constant := 16#00000001#;
   SDL_AUDIO_ALLOW_FORMAT_CHANGE    : constant := 16#00000002#;
   SDL_AUDIO_ALLOW_CHANNELS_CHANGE  : constant := 16#00000004#;
   SDL_AUDIO_ALLOW_ANY_CHANGE       : constant :=
     (Uint32 (SDL_AUDIO_ALLOW_FREQUENCY_CHANGE) or
      Uint32 (SDL_AUDIO_ALLOW_FORMAT_CHANGE) or
      Uint32 (SDL_AUDIO_ALLOW_CHANNELS_CHANGE));

   type SDL_AudioCallback is access procedure
     (userdata : System.Address;
      stream   : access Uint8;
      len      : C.int);
   pragma Convention (C, SDL_AudioCallback);

   type SDL_AudioSpec is record
      freq     : aliased C.int;
      format   : aliased SDL_AudioFormat;
      channels : aliased Uint8;
      silence  : aliased Uint8;
      samples  : aliased Uint16;
      padding  : aliased Uint16;
      size     : aliased Uint32;
      callback : SDL_AudioCallback;
      userdata : System.Address;
   end record;
   pragma Convention (C_Pass_By_Copy, SDL_AudioSpec);

   type SDL_AudioCVT;
   type SDL_AudioFilter is access procedure
     (cvt    : access SDL_AudioCVT;
      format : SDL_AudioFormat);
   pragma Convention (C, SDL_AudioFilter);

   type SDL_AudioCVT_filters_array is array (0 .. 9) of SDL_AudioFilter;
   type SDL_AudioCVT is record
      needed       : aliased C.int;
      src_format   : aliased SDL_AudioFormat;
      dst_format   : aliased SDL_AudioFormat;
      rate_incr    : aliased C.double;
      buf          : access Uint8;
      len          : aliased C.int;
      len_cvt      : aliased C.int;
      len_mult     : aliased C.int;
      len_ratio    : aliased C.double;
      filters      : aliased SDL_AudioCVT_filters_array;
      filter_index : aliased C.int;
   end record;
   pragma Convention (C_Pass_By_Copy, SDL_AudioCVT);

   function SDL_GetNumAudioDrivers return C.int;
   pragma Import (C, SDL_GetNumAudioDrivers, "SDL_GetNumAudioDrivers");

   function SDL_GetAudioDriver (index : C.int) return C.Strings.chars_ptr;
   pragma Import (C, SDL_GetAudioDriver, "SDL_GetAudioDriver");

   function SDL_AudioInit (driver_name : C.char_array) return C.int;
   pragma Import (C, SDL_AudioInit, "SDL_AudioInit");

   procedure SDL_AudioQuit;
   pragma Import (C, SDL_AudioQuit, "SDL_AudioQuit");

   function SDL_GetCurrentAudioDriver return C.Strings.chars_ptr;
   pragma Import (C, SDL_GetCurrentAudioDriver, "SDL_GetCurrentAudioDriver");

   function SDL_OpenAudio
     (desired  : access SDL_AudioSpec;
      obtained : access SDL_AudioSpec) return C.int;
   pragma Import (C, SDL_OpenAudio, "SDL_OpenAudio");

   function SDL_GetNumAudioDevices (iscapture : C.int) return C.int;
   pragma Import (C, SDL_GetNumAudioDevices, "SDL_GetNumAudioDevices");

   function SDL_GetAudioDeviceName
     (index     : C.int;
      iscapture : C.int) return C.Strings.chars_ptr;
   pragma Import (C, SDL_GetAudioDeviceName, "SDL_GetAudioDeviceName");

   function SDL_OpenAudioDevice
     (device          : C.char_array;
      iscapture       : C.int;
      desired         : access SDL_AudioSpec;
      obtained        : access SDL_AudioSpec;
      allowed_changes : C.int) return SDL_AudioDeviceID;
   pragma Import (C, SDL_OpenAudioDevice, "SDL_OpenAudioDevice");

   type SDL_AudioStatus is
     (SDL_AUDIO_STOPPED, SDL_AUDIO_PLAYING, SDL_AUDIO_PAUSED);
   pragma Convention (C, SDL_AudioStatus);

   function SDL_GetAudioStatus return SDL_AudioStatus;
   pragma Import (C, SDL_GetAudioStatus, "SDL_GetAudioStatus");

   function SDL_GetAudioDeviceStatus
     (dev : SDL_AudioDeviceID) return SDL_AudioStatus;
   pragma Import (C, SDL_GetAudioDeviceStatus, "SDL_GetAudioDeviceStatus");

   procedure SDL_PauseAudio (pause_on : C.int);
   pragma Import (C, SDL_PauseAudio, "SDL_PauseAudio");

   procedure SDL_PauseAudioDevice (dev : SDL_AudioDeviceID; pause_on : C.int);
   pragma Import (C, SDL_PauseAudioDevice, "SDL_PauseAudioDevice");

   function SDL_LoadWAV_RW
     (src       : access SDL_RWops;
      freesrc   : C.int;
      spec      : access SDL_AudioSpec;
      audio_buf : System.Address;
      audio_len : access Uint32) return access SDL_AudioSpec;
   pragma Import (C, SDL_LoadWAV_RW, "SDL_LoadWAV_RW");

   function SDL_LoadWAV
     (file      : C.char_array;
      spec      : access SDL_AudioSpec;
      audio_buf : System.Address;
      audio_len : access Uint32) return access SDL_AudioSpec;
   pragma Inline (SDL_LoadWAV);

   procedure SDL_FreeWAV (audio_buf : access Uint8);
   pragma Import (C, SDL_FreeWAV, "SDL_FreeWAV");

   function SDL_BuildAudioCVT
     (cvt          : access SDL_AudioCVT;
      src_format   : SDL_AudioFormat;
      src_channels : Uint8;
      src_rate     : C.int;
      dst_format   : SDL_AudioFormat;
      dst_channels : Uint8;
      dst_rate     : C.int) return C.int;
   pragma Import (C, SDL_BuildAudioCVT, "SDL_BuildAudioCVT");

   function SDL_ConvertAudio (cvt : access SDL_AudioCVT) return C.int;
   pragma Import (C, SDL_ConvertAudio, "SDL_ConvertAudio");

   SDL_MIX_MAXVOLUME : constant := 128;

   procedure SDL_MixAudio
     (dst    : access Uint8;
      src    : access Uint8;
      len    : Uint32;
      volume : C.int);
   pragma Import (C, SDL_MixAudio, "SDL_MixAudio");

   procedure SDL_MixAudioFormat
     (dst    : access Uint8;
      src    : access Uint8;
      format : SDL_AudioFormat;
      len    : Uint32;
      volume : C.int);
   pragma Import (C, SDL_MixAudioFormat, "SDL_MixAudioFormat");

   procedure SDL_LockAudio;
   pragma Import (C, SDL_LockAudio, "SDL_LockAudio");

   procedure SDL_LockAudioDevice (dev : SDL_AudioDeviceID);
   pragma Import (C, SDL_LockAudioDevice, "SDL_LockAudioDevice");

   procedure SDL_UnlockAudio;
   pragma Import (C, SDL_UnlockAudio, "SDL_UnlockAudio");

   procedure SDL_UnlockAudioDevice (dev : SDL_AudioDeviceID);
   pragma Import (C, SDL_UnlockAudioDevice, "SDL_UnlockAudioDevice");

   procedure SDL_CloseAudio;
   pragma Import (C, SDL_CloseAudio, "SDL_CloseAudio");

   procedure SDL_CloseAudioDevice (dev : SDL_AudioDeviceID);
   pragma Import (C, SDL_CloseAudioDevice, "SDL_CloseAudioDevice");



   ----------------------------------------------------------------------------
   -- SDL_pixels.h
   ----------------------------------------------------------------------------



	---skip stuff here

   function SDL_DEFINE_PIXELFORMAT
     (typ    : C.int;
      order  : C.int;
      layout : C.int;
      bits   : C.int;
      bytes  : C.int) return Uint32;
   pragma Inline (SDL_DEFINE_PIXELFORMAT);


   function SDL_PIXELFLAG (X : Uint32) return C.int;
   pragma Inline (SDL_PIXELFLAG);

   function SDL_PIXELTYPE (X : Uint32) return C.int;
   pragma Inline (SDL_PIXELTYPE);

   function SDL_PIXELORDER (X : Uint32) return C.int;
   pragma Inline (SDL_PIXELORDER);

   function SDL_PIXELLAYOUT (X : Uint32) return C.int;
   pragma Inline (SDL_PIXELLAYOUT);

   function SDL_BITSPERPIXEL (X : Uint32) return C.int;
   pragma Inline (SDL_BITSPERPIXEL);

   function SDL_BYTESPERPIXEL (X : Uint32) return C.int;
   pragma Inline (SDL_BYTESPERPIXEL);

   function SDL_ISPIXELFORMAT_FOURCC (format : Uint32) return SDL_bool;
   pragma Inline (SDL_ISPIXELFORMAT_FOURCC);

   function SDL_ISPIXELFORMAT_INDEXED (format : Uint32) return SDL_bool;
   pragma Inline (SDL_ISPIXELFORMAT_INDEXED);

   function SDL_ISPIXELFORMAT_ALPHA (format : Uint32) return SDL_bool;
   pragma Inline (SDL_ISPIXELFORMAT_ALPHA);

	---skip stuff here


   function SDL_GetPixelFormatName
     (format : Uint32) return C.Strings.chars_ptr;
   pragma Import (C, SDL_GetPixelFormatName, "SDL_GetPixelFormatName");

   function SDL_PixelFormatEnumToMasks
     (format : Uint32;
      bpp    : access C.int;
      Rmask  : access Uint32;
      Gmask  : access Uint32;
      Bmask  : access Uint32;
      Amask  : access Uint32) return SDL_bool;
   pragma Import (C, SDL_PixelFormatEnumToMasks, "SDL_PixelFormatEnumToMasks");

   function SDL_MasksToPixelFormatEnum
     (bpp   : C.int;
      Rmask : Uint32;
      Gmask : Uint32;
      Bmask : Uint32;
      Amask : Uint32) return Uint32;
   pragma Import (C, SDL_MasksToPixelFormatEnum, "SDL_MasksToPixelFormatEnum");

   function SDL_AllocFormat
     (pixel_format : Uint32) return access SDL_PixelFormat;
   pragma Import (C, SDL_AllocFormat, "SDL_AllocFormat");

   procedure SDL_FreeFormat (format : access SDL_PixelFormat);
   pragma Import (C, SDL_FreeFormat, "SDL_FreeFormat");

   function SDL_AllocPalette (ncolors : C.int) return access SDL_Palette;
   pragma Import (C, SDL_AllocPalette, "SDL_AllocPalette");

   function SDL_SetPixelFormatPalette
     (format  : access SDL_PixelFormat;
      palette : access SDL_Palette) return C.int;
   pragma Import (C, SDL_SetPixelFormatPalette, "SDL_SetPixelFormatPalette");

   function SDL_SetPaletteColors
     (palette    : access SDL_Palette;
      colors     : access SDL_Color;
      firstcolor : C.int;
      ncolors    : C.int) return C.int;
   pragma Import (C, SDL_SetPaletteColors, "SDL_SetPaletteColors");

   procedure SDL_FreePalette (palette : access SDL_Palette);
   pragma Import (C, SDL_FreePalette, "SDL_FreePalette");

   function SDL_MapRGB
     (format : access SDL_PixelFormat;
      r      : Uint8;
      g      : Uint8;
      b      : Uint8) return Uint32;
   pragma Import (C, SDL_MapRGB, "SDL_MapRGB");

   function SDL_MapRGBA
     (format : access SDL_PixelFormat;
      r      : Uint8;
      g      : Uint8;
      b      : Uint8;
      a      : Uint8) return Uint32;
   pragma Import (C, SDL_MapRGBA, "SDL_MapRGBA");

   procedure SDL_GetRGB
     (pixel  : Uint32;
      format : access SDL_PixelFormat;
      r      : access Uint8;
      g      : access Uint8;
      b      : access Uint8);
   pragma Import (C, SDL_GetRGB, "SDL_GetRGB");

   procedure SDL_GetRGBA
     (pixel  : Uint32;
      format : access SDL_PixelFormat;
      r      : access Uint8;
      g      : access Uint8;
      b      : access Uint8;
      a      : access Uint8);
   pragma Import (C, SDL_GetRGBA, "SDL_GetRGBA");

   procedure SDL_CalculateGammaRamp (gamma : C.C_float; ramp : access Uint16);
   pragma Import (C, SDL_CalculateGammaRamp, "SDL_CalculateGammaRamp");





   ----------------------------------------------------------------------------
   -- SDL_rect.h
   ----------------------------------------------------------------------------

   function SDL_RectEmpty (rect : access SDL_Rect) return SDL_bool;
   pragma Import (C, SDL_RectEmpty, "SDL_RectEmpty");

   function SDL_RectEquals
     (a : access SDL_Rect;
      b : access SDL_Rect) return SDL_bool;
   pragma Import (C, SDL_RectEquals, "SDL_RectEquals");

   function SDL_HasIntersection
     (A : access SDL_Rect;
      B : access SDL_Rect) return SDL_bool;
   pragma Import (C, SDL_HasIntersection, "SDL_HasIntersection");

   function SDL_IntersectRect
     (A      : access SDL_Rect;
      B      : access SDL_Rect;
      result : access SDL_Rect) return SDL_bool;
   pragma Import (C, SDL_IntersectRect, "SDL_IntersectRect");

   procedure SDL_UnionRect
     (A      : access SDL_Rect;
      B      : access SDL_Rect;
      result : access SDL_Rect);
   pragma Import (C, SDL_UnionRect, "SDL_UnionRect");

   function SDL_EnclosePoints
     (points : access SDL_Point;
      count  : C.int;
      clip   : access SDL_Rect;
      result : access SDL_Rect) return SDL_bool;
   pragma Import (C, SDL_EnclosePoints, "SDL_EnclosePoints");

   function SDL_IntersectRectAndLine
     (r  : access SDL_Rect;
      X1 : access C.int;
      Y1 : access C.int;
      X2 : access C.int;
      Y2 : access C.int) return SDL_bool;
   pragma Import (C, SDL_IntersectRectAndLine, "SDL_IntersectRectAndLine");



   ----------------------------------------------------------------------------
   -- SDL_touch.h
   ----------------------------------------------------------------------------

   subtype SDL_TouchID is Sint64;
   subtype SDL_FingerID is Sint64;

   type SDL_Finger is record
      id       : aliased SDL_FingerID;
      x        : aliased C.C_float;
      y        : aliased C.C_float;
      pressure : aliased C.C_float;
   end record;
   pragma Convention (C_Pass_By_Copy, SDL_Finger);

   function SDL_GetNumTouchDevices return C.int;
   pragma Import (C, SDL_GetNumTouchDevices, "SDL_GetNumTouchDevices");

   function SDL_GetTouchDevice (index : C.int) return SDL_TouchID;
   pragma Import (C, SDL_GetTouchDevice, "SDL_GetTouchDevice");

   function SDL_GetNumTouchFingers (touchID : SDL_TouchID) return C.int;
   pragma Import (C, SDL_GetNumTouchFingers, "SDL_GetNumTouchFingers");

   function SDL_GetTouchFinger
     (touchID : SDL_TouchID;
      index   : C.int) return access SDL_Finger;
   pragma Import (C, SDL_GetTouchFinger, "SDL_GetTouchFinger");


   ----------------------------------------------------------------------------
   -- SDL_gesture.h
   ----------------------------------------------------------------------------

   subtype SDL_GestureID is Sint64;

   function SDL_RecordGesture (touchId : SDL_TouchID) return C.int;
   pragma Import (C, SDL_RecordGesture, "SDL_RecordGesture");

   function SDL_SaveAllDollarTemplates (dst : access SDL_RWops) return C.int;
   pragma Import (C, SDL_SaveAllDollarTemplates, "SDL_SaveAllDollarTemplates");

   function SDL_SaveDollarTemplate
     (gestureId : SDL_GestureID;
      dst       : access SDL_RWops) return C.int;
   pragma Import (C, SDL_SaveDollarTemplate, "SDL_SaveDollarTemplate");

   function SDL_LoadDollarTemplates
     (touchId : SDL_TouchID;
      src     : access SDL_RWops) return C.int;
   pragma Import (C, SDL_LoadDollarTemplates, "SDL_LoadDollarTemplates");



   ----------------------------------------------------------------------------
   -- SDL_haptic.h
   ----------------------------------------------------------------------------

   subtype SDL_Haptic is System.Address;

   SDL_HAPTIC_CONSTANT     : constant := (2**0);
   SDL_HAPTIC_SINE         : constant := (2**1);
   SDL_HAPTIC_LEFTRIGHT    : constant := (2**2);
   SDL_HAPTIC_TRIANGLE     : constant := (2**3);
   SDL_HAPTIC_SAWTOOTHUP   : constant := (2**4);
   SDL_HAPTIC_SAWTOOTHDOWN : constant := (2**5);
   SDL_HAPTIC_RAMP         : constant := (2**6);
   SDL_HAPTIC_SPRING       : constant := (2**7);
   SDL_HAPTIC_DAMPER       : constant := (2**8);
   SDL_HAPTIC_INERTIA      : constant := (2**9);
   SDL_HAPTIC_FRICTION     : constant := (2**10);
   SDL_HAPTIC_CUSTOM       : constant := (2**11);
   SDL_HAPTIC_GAIN         : constant := (2**12);
   SDL_HAPTIC_AUTOCENTER   : constant := (2**13);
   SDL_HAPTIC_STATUS       : constant := (2**14);
   SDL_HAPTIC_PAUSE        : constant := (2**15);
   SDL_HAPTIC_POLAR        : constant := 0;
   SDL_HAPTIC_CARTESIAN    : constant := 1;
   SDL_HAPTIC_SPHERICAL    : constant := 2;
   SDL_HAPTIC_INFINITY     : constant := 4294967295;

   type SDL_HapticDirection_dir_array is array (0 .. 2) of aliased Sint32;
   type SDL_HapticDirection is record
      kind : aliased Uint8;
      dir  : aliased SDL_HapticDirection_dir_array;
   end record;
   pragma Convention (C_Pass_By_Copy, SDL_HapticDirection);

   type SDL_HapticConstant is record
      kind          : aliased Uint16;
      direction     : aliased SDL_HapticDirection;
      length        : aliased Uint32;
      c_delay       : aliased Uint16;
      button        : aliased Uint16;
      interval      : aliased Uint16;
      level         : aliased Sint16;
      attack_length : aliased Uint16;
      attack_level  : aliased Uint16;
      fade_length   : aliased Uint16;
      fade_level    : aliased Uint16;
   end record;
   pragma Convention (C_Pass_By_Copy, SDL_HapticConstant);

   type SDL_HapticPeriodic is record
      kind          : aliased Uint16;
      direction     : aliased SDL_HapticDirection;
      length        : aliased Uint32;
      c_delay       : aliased Uint16;
      button        : aliased Uint16;
      interval      : aliased Uint16;
      period        : aliased Uint16;
      magnitude     : aliased Sint16;
      offset        : aliased Sint16;
      phase         : aliased Uint16;
      attack_length : aliased Uint16;
      attack_level  : aliased Uint16;
      fade_length   : aliased Uint16;
      fade_level    : aliased Uint16;
   end record;
   pragma Convention (C_Pass_By_Copy, SDL_HapticPeriodic);

   type SDL_HapticCondition_right_sat_array is
     array (0 .. 2) of aliased Uint16;
   type SDL_HapticCondition_left_sat_array is array (0 .. 2) of aliased Uint16;
   type SDL_HapticCondition_right_coeff_array is
     array (0 .. 2) of aliased Sint16;
   type SDL_HapticCondition_left_coeff_array is
     array (0 .. 2) of aliased Sint16;
   type SDL_HapticCondition_deadband_array is array (0 .. 2) of aliased Uint16;
   type SDL_HapticCondition_center_array is array (0 .. 2) of aliased Sint16;

   type SDL_HapticCondition is record
      kind        : aliased Uint16;
      direction   : aliased SDL_HapticDirection;
      length      : aliased Uint32;
      c_delay     : aliased Uint16;
      button      : aliased Uint16;
      interval    : aliased Uint16;
      right_sat   : aliased SDL_HapticCondition_right_sat_array;
      left_sat    : aliased SDL_HapticCondition_left_sat_array;
      right_coeff : aliased SDL_HapticCondition_right_coeff_array;
      left_coeff  : aliased SDL_HapticCondition_left_coeff_array;
      deadband    : aliased SDL_HapticCondition_deadband_array;
      center      : aliased SDL_HapticCondition_center_array;
   end record;
   pragma Convention (C_Pass_By_Copy, SDL_HapticCondition);

   type SDL_HapticRamp is record
      kind          : aliased Uint16;
      direction     : aliased SDL_HapticDirection;
      length        : aliased Uint32;
      c_delay       : aliased Uint16;
      button        : aliased Uint16;
      interval      : aliased Uint16;
      start         : aliased Sint16;
      c_end         : aliased Sint16;
      attack_length : aliased Uint16;
      attack_level  : aliased Uint16;
      fade_length   : aliased Uint16;
      fade_level    : aliased Uint16;
   end record;
   pragma Convention (C_Pass_By_Copy, SDL_HapticRamp);

   type SDL_HapticLeftRight is record
      kind            : aliased Uint16;
      length          : aliased Uint32;
      large_magnitude : aliased Uint16;
      small_magnitude : aliased Uint16;
   end record;
   pragma Convention (C_Pass_By_Copy, SDL_HapticLeftRight);

   type SDL_HapticCustom is record
      kind          : aliased Uint16;
      direction     : aliased SDL_HapticDirection;
      length        : aliased Uint32;
      c_delay       : aliased Uint16;
      button        : aliased Uint16;
      interval      : aliased Uint16;
      channels      : aliased Uint8;
      period        : aliased Uint16;
      samples       : aliased Uint16;
      data          : access Uint16;
      attack_length : aliased Uint16;
      attack_level  : aliased Uint16;
      fade_length   : aliased Uint16;
      fade_level    : aliased Uint16;
   end record;
   pragma Convention (C_Pass_By_Copy, SDL_HapticCustom);

   type SDL_HapticEffect (discr : C.unsigned := 0) is record
      case discr is
         when 0 =>
            kind : aliased Uint16;
         when 1 =>
            c_constant : aliased SDL_HapticConstant;
         when 2 =>
            periodic : aliased SDL_HapticPeriodic;
         when 3 =>
            condition : aliased SDL_HapticCondition;
         when 4 =>
            ramp : aliased SDL_HapticRamp;
         when 5 =>
            leftright : aliased SDL_HapticLeftRight;
         when others =>
            custom : aliased SDL_HapticCustom;
      end case;
   end record;
   pragma Convention (C_Pass_By_Copy, SDL_HapticEffect);
   pragma Unchecked_Union (SDL_HapticEffect);

   function SDL_NumHaptics return C.int;
   pragma Import (C, SDL_NumHaptics, "SDL_NumHaptics");

   function SDL_HapticName (device_index : C.int) return C.Strings.chars_ptr;
   pragma Import (C, SDL_HapticName, "SDL_HapticName");

   function SDL_HapticOpen (device_index : C.int) return access SDL_Haptic;
   pragma Import (C, SDL_HapticOpen, "SDL_HapticOpen");

   function SDL_HapticOpened (device_index : C.int) return C.int;
   pragma Import (C, SDL_HapticOpened, "SDL_HapticOpened");

   function SDL_HapticIndex (haptic : access SDL_Haptic) return C.int;
   pragma Import (C, SDL_HapticIndex, "SDL_HapticIndex");

   function SDL_MouseIsHaptic return C.int;
   pragma Import (C, SDL_MouseIsHaptic, "SDL_MouseIsHaptic");

   function SDL_HapticOpenFromMouse return access SDL_Haptic;
   pragma Import (C, SDL_HapticOpenFromMouse, "SDL_HapticOpenFromMouse");

   function SDL_JoystickIsHaptic (joystick : access SDL_Joystick) return C.int;
   pragma Import (C, SDL_JoystickIsHaptic, "SDL_JoystickIsHaptic");

   function SDL_HapticOpenFromJoystick
     (joystick : access SDL_Joystick) return access SDL_Haptic;
   pragma Import (C, SDL_HapticOpenFromJoystick, "SDL_HapticOpenFromJoystick");

   procedure SDL_HapticClose (haptic : access SDL_Haptic);
   pragma Import (C, SDL_HapticClose, "SDL_HapticClose");

   function SDL_HapticNumEffects (haptic : access SDL_Haptic) return C.int;
   pragma Import (C, SDL_HapticNumEffects, "SDL_HapticNumEffects");

   function SDL_HapticNumEffectsPlaying
     (haptic : access SDL_Haptic) return C.int;
   pragma Import
     (C,
      SDL_HapticNumEffectsPlaying,
      "SDL_HapticNumEffectsPlaying");

   function SDL_HapticQuery (haptic : access SDL_Haptic) return C.unsigned;
   pragma Import (C, SDL_HapticQuery, "SDL_HapticQuery");

   function SDL_HapticNumAxes (haptic : access SDL_Haptic) return C.int;
   pragma Import (C, SDL_HapticNumAxes, "SDL_HapticNumAxes");

   function SDL_HapticEffectSupported
     (haptic : access SDL_Haptic;
      effect : access SDL_HapticEffect) return C.int;
   pragma Import (C, SDL_HapticEffectSupported, "SDL_HapticEffectSupported");

   function SDL_HapticNewEffect
     (haptic : access SDL_Haptic;
      effect : access SDL_HapticEffect) return C.int;
   pragma Import (C, SDL_HapticNewEffect, "SDL_HapticNewEffect");

   function SDL_HapticUpdateEffect
     (haptic : access SDL_Haptic;
      effect : C.int;
      data   : access SDL_HapticEffect) return C.int;
   pragma Import (C, SDL_HapticUpdateEffect, "SDL_HapticUpdateEffect");

   function SDL_HapticRunEffect
     (haptic     : access SDL_Haptic;
      effect     : C.int;
      iterations : Uint32) return C.int;
   pragma Import (C, SDL_HapticRunEffect, "SDL_HapticRunEffect");

   function SDL_HapticStopEffect
     (haptic : access SDL_Haptic;
      effect : C.int) return C.int;
   pragma Import (C, SDL_HapticStopEffect, "SDL_HapticStopEffect");

   procedure SDL_HapticDestroyEffect
     (haptic : access SDL_Haptic;
      effect : C.int);
   pragma Import (C, SDL_HapticDestroyEffect, "SDL_HapticDestroyEffect");

   function SDL_HapticGetEffectStatus
     (haptic : access SDL_Haptic;
      effect : C.int) return C.int;
   pragma Import (C, SDL_HapticGetEffectStatus, "SDL_HapticGetEffectStatus");

   function SDL_HapticSetGain
     (haptic : access SDL_Haptic;
      gain   : C.int) return C.int;
   pragma Import (C, SDL_HapticSetGain, "SDL_HapticSetGain");

   function SDL_HapticSetAutocenter
     (haptic     : access SDL_Haptic;
      autocenter : C.int) return C.int;
   pragma Import (C, SDL_HapticSetAutocenter, "SDL_HapticSetAutocenter");

   function SDL_HapticPause (haptic : access SDL_Haptic) return C.int;
   pragma Import (C, SDL_HapticPause, "SDL_HapticPause");

   function SDL_HapticUnpause (haptic : access SDL_Haptic) return C.int;
   pragma Import (C, SDL_HapticUnpause, "SDL_HapticUnpause");

   function SDL_HapticStopAll (haptic : access SDL_Haptic) return C.int;
   pragma Import (C, SDL_HapticStopAll, "SDL_HapticStopAll");

   function SDL_HapticRumbleSupported
     (haptic : access SDL_Haptic) return C.int;
   pragma Import (C, SDL_HapticRumbleSupported, "SDL_HapticRumbleSupported");

   function SDL_HapticRumbleInit (haptic : access SDL_Haptic) return C.int;
   pragma Import (C, SDL_HapticRumbleInit, "SDL_HapticRumbleInit");

   function SDL_HapticRumblePlay
     (haptic   : access SDL_Haptic;
      strength : C.C_float;
      length   : Uint32) return C.int;
   pragma Import (C, SDL_HapticRumblePlay, "SDL_HapticRumblePlay");

   function SDL_HapticRumbleStop (haptic : access SDL_Haptic) return C.int;
   pragma Import (C, SDL_HapticRumbleStop, "SDL_HapticRumbleStop");






   ----------------------------------------------------------------------------
   -- SDL_render.h
   ----------------------------------------------------------------------------

	--- lots of stuf here




   function SDL_GetNumRenderDrivers return C.int;
   pragma Import (C, SDL_GetNumRenderDrivers, "SDL_GetNumRenderDrivers");

   function SDL_GetRenderDriverInfo
     (index : C.int;
      info  : access SDL_RendererInfo) return C.int;
   pragma Import (C, SDL_GetRenderDriverInfo, "SDL_GetRenderDriverInfo");

   function SDL_CreateWindowAndRenderer
     (width        : C.int;
      height       : C.int;
      window_flags : Uint32;
      window       : System.Address;
      renderer     : System.Address) return C.int;
   pragma Import
     (C,
      SDL_CreateWindowAndRenderer,
      "SDL_CreateWindowAndRenderer");

   function SDL_CreateRenderer
     (window : access SDL_Window;
      index  : C.int;
      flags  : Uint32) return access SDL_Renderer;
   pragma Import (C, SDL_CreateRenderer, "SDL_CreateRenderer");

   function SDL_CreateSoftwareRenderer
     (surface : access SDL_Surface) return access SDL_Renderer;
   pragma Import (C, SDL_CreateSoftwareRenderer, "SDL_CreateSoftwareRenderer");

   function SDL_GetRenderer
     (window : access SDL_Window) return access SDL_Renderer;
   pragma Import (C, SDL_GetRenderer, "SDL_GetRenderer");

   function SDL_GetRendererInfo
     (renderer : access SDL_Renderer;
      info     : access SDL_RendererInfo) return C.int;
   pragma Import (C, SDL_GetRendererInfo, "SDL_GetRendererInfo");

   function SDL_GetRendererOutputSize
     (renderer : access SDL_Renderer;
      w        : access C.int;
      h        : access C.int) return C.int;
   pragma Import (C, SDL_GetRendererOutputSize, "SDL_GetRendererOutputSize");



	--if fail, try this:
   --function SDL_CreateTexture
     --(renderer    : system.address;
      --format      : Uint32;
      --access_type : C.int;
      --w           : C.int;
      --h           : C.int) return system.address;
   function SDL_CreateTexture
     (renderer    : access SDL_Renderer;
      format      : Uint32;
      access_type : C.int;
      w           : C.int;
      h           : C.int) return access SDL_Texture;
   pragma Import (C, SDL_CreateTexture, "SDL_CreateTexture");

   function SDL_CreateTextureFromSurface
     (renderer : access SDL_Renderer;
      surface  : access SDL_Surface) return access SDL_Texture;
   pragma Import
     (C,
      SDL_CreateTextureFromSurface,
      "SDL_CreateTextureFromSurface");

   function SDL_QueryTexture
     (texture  : access SDL_Texture;
      format   : access Uint32;
      c_access : access C.int;
      w        : access C.int;
      h        : access C.int) return C.int;
   pragma Import (C, SDL_QueryTexture, "SDL_QueryTexture");

   function SDL_SetTextureColorMod
     (texture : access SDL_Texture;
      r       : Uint8;
      g       : Uint8;
      b       : Uint8) return C.int;
   pragma Import (C, SDL_SetTextureColorMod, "SDL_SetTextureColorMod");

   function SDL_GetTextureColorMod
     (texture : access SDL_Texture;
      r       : access Uint8;
      g       : access Uint8;
      b       : access Uint8) return C.int;
   pragma Import (C, SDL_GetTextureColorMod, "SDL_GetTextureColorMod");

   function SDL_SetTextureAlphaMod
     (texture : access SDL_Texture;
      alpha   : Uint8) return C.int;
   pragma Import (C, SDL_SetTextureAlphaMod, "SDL_SetTextureAlphaMod");

   function SDL_GetTextureAlphaMod
     (texture : access SDL_Texture;
      alpha   : access Uint8) return C.int;
   pragma Import (C, SDL_GetTextureAlphaMod, "SDL_GetTextureAlphaMod");

   function SDL_SetTextureBlendMode
     (texture   : access SDL_Texture;
      blendMode : SDL_BlendMode) return C.int;
   pragma Import (C, SDL_SetTextureBlendMode, "SDL_SetTextureBlendMode");

   function SDL_GetTextureBlendMode
     (texture   : access SDL_Texture;
      blendMode : access SDL_BlendMode) return C.int;
   pragma Import (C, SDL_GetTextureBlendMode, "SDL_GetTextureBlendMode");

   function SDL_UpdateTexture
     (texture : access SDL_Texture;
      rect    : access SDL_Rect;
      pixels  : System.Address;
      pitch   : C.int) return C.int;
   pragma Import (C, SDL_UpdateTexture, "SDL_UpdateTexture");

   function SDL_UpdateYUVTexture
     (texture : access SDL_Texture;
      rect    : access SDL_Rect;
      Yplane  : access Uint8;
      Ypitch  : C.int;
      Uplane  : access Uint8;
      Upitch  : C.int;
      Vplane  : access Uint8;
      Vpitch  : C.int) return C.int;
   pragma Import (C, SDL_UpdateYUVTexture, "SDL_UpdateYUVTexture");

   function SDL_LockTexture
     (texture : access SDL_Texture;
      rect    : access SDL_Rect;
      pixels  : System.Address;
      pitch   : access C.int) return C.int;
   pragma Import (C, SDL_LockTexture, "SDL_LockTexture");

   procedure SDL_UnlockTexture (texture : access SDL_Texture);
   pragma Import (C, SDL_UnlockTexture, "SDL_UnlockTexture");

   function SDL_RenderTargetSupported
     (renderer : access SDL_Renderer) return SDL_bool;
   pragma Import (C, SDL_RenderTargetSupported, "SDL_RenderTargetSupported");

   function SDL_SetRenderTarget
     (renderer : access SDL_Renderer;
      texture  : access SDL_Texture) return C.int;
   pragma Import (C, SDL_SetRenderTarget, "SDL_SetRenderTarget");

   function SDL_GetRenderTarget
     (renderer : access SDL_Renderer) return access SDL_Texture;
   pragma Import (C, SDL_GetRenderTarget, "SDL_GetRenderTarget");

   function SDL_RenderSetLogicalSize
     (renderer : access SDL_Renderer;
      w        : C.int;
      h        : C.int) return C.int;
   pragma Import (C, SDL_RenderSetLogicalSize, "SDL_RenderSetLogicalSize");

   procedure SDL_RenderGetLogicalSize
     (renderer : access SDL_Renderer;
      w        : access C.int;
      h        : access C.int);
   pragma Import (C, SDL_RenderGetLogicalSize, "SDL_RenderGetLogicalSize");

   function SDL_RenderSetViewport
     (renderer : access SDL_Renderer;
      rect     : access SDL_Rect) return C.int;
   pragma Import (C, SDL_RenderSetViewport, "SDL_RenderSetViewport");

   procedure SDL_RenderGetViewport
     (renderer : access SDL_Renderer;
      rect     : access SDL_Rect);
   pragma Import (C, SDL_RenderGetViewport, "SDL_RenderGetViewport");

   function SDL_RenderSetClipRect
     (renderer : access SDL_Renderer;
      rect     : access SDL_Rect) return C.int;
   pragma Import (C, SDL_RenderSetClipRect, "SDL_RenderSetClipRect");

   procedure SDL_RenderGetClipRect
     (renderer : access SDL_Renderer;
      rect     : access SDL_Rect);
   pragma Import (C, SDL_RenderGetClipRect, "SDL_RenderGetClipRect");

   function SDL_RenderSetScale
     (renderer : access SDL_Renderer;
      scaleX   : C.C_float;
      scaleY   : C.C_float) return C.int;
   pragma Import (C, SDL_RenderSetScale, "SDL_RenderSetScale");

   procedure SDL_RenderGetScale
     (renderer : access SDL_Renderer;
      scaleX   : access C.C_float;
      scaleY   : access C.C_float);
   pragma Import (C, SDL_RenderGetScale, "SDL_RenderGetScale");

   function SDL_SetRenderDrawColor
     (renderer : access SDL_Renderer;
      r        : Uint8;
      g        : Uint8;
      b        : Uint8;
      a        : Uint8) return C.int;
   pragma Import (C, SDL_SetRenderDrawColor, "SDL_SetRenderDrawColor");

   function SDL_GetRenderDrawColor
     (renderer : access SDL_Renderer;
      r        : access Uint8;
      g        : access Uint8;
      b        : access Uint8;
      a        : access Uint8) return C.int;
   pragma Import (C, SDL_GetRenderDrawColor, "SDL_GetRenderDrawColor");

   function SDL_SetRenderDrawBlendMode
     (renderer  : access SDL_Renderer;
      blendMode : SDL_BlendMode) return C.int;
   pragma Import (C, SDL_SetRenderDrawBlendMode, "SDL_SetRenderDrawBlendMode");

   function SDL_GetRenderDrawBlendMode
     (renderer  : access SDL_Renderer;
      blendMode : access SDL_BlendMode) return C.int;
   pragma Import (C, SDL_GetRenderDrawBlendMode, "SDL_GetRenderDrawBlendMode");

   function SDL_RenderClear (renderer : access SDL_Renderer) return C.int;
   pragma Import (C, SDL_RenderClear, "SDL_RenderClear");

   function SDL_RenderDrawPoint
     (renderer : access SDL_Renderer;
      x        : C.int;
      y        : C.int) return C.int;
   pragma Import (C, SDL_RenderDrawPoint, "SDL_RenderDrawPoint");

   function SDL_RenderDrawPoints
     (renderer : access SDL_Renderer;
      points   : access SDL_Point;
      count    : C.int) return C.int;
   pragma Import (C, SDL_RenderDrawPoints, "SDL_RenderDrawPoints");

   function SDL_RenderDrawLine
     (renderer : access SDL_Renderer;
      x1       : C.int;
      y1       : C.int;
      x2       : C.int;
      y2       : C.int) return C.int;
   pragma Import (C, SDL_RenderDrawLine, "SDL_RenderDrawLine");

   function SDL_RenderDrawLines
     (renderer : access SDL_Renderer;
      points   : access SDL_Point;
      count    : C.int) return C.int;
   pragma Import (C, SDL_RenderDrawLines, "SDL_RenderDrawLines");

   function SDL_RenderDrawRect
     (renderer : access SDL_Renderer;
      rect     : access SDL_Rect) return C.int;
   pragma Import (C, SDL_RenderDrawRect, "SDL_RenderDrawRect");

   function SDL_RenderDrawRects
     (renderer : access SDL_Renderer;
      rects    : access SDL_Rect;
      count    : C.int) return C.int;
   pragma Import (C, SDL_RenderDrawRects, "SDL_RenderDrawRects");

   function SDL_RenderFillRect
     (renderer : access SDL_Renderer;
      rect     : access SDL_Rect) return C.int;
   pragma Import (C, SDL_RenderFillRect, "SDL_RenderFillRect");

   function SDL_RenderFillRects
     (renderer : access SDL_Renderer;
      rects    : access SDL_Rect;
      count    : C.int) return C.int;
   pragma Import (C, SDL_RenderFillRects, "SDL_RenderFillRects");

   function SDL_RenderCopy
     (renderer : access SDL_Renderer;
      texture  : access SDL_Texture;
      srcrect  : access SDL_Rect;
      dstrect  : access SDL_Rect) return C.int;
   pragma Import (C, SDL_RenderCopy, "SDL_RenderCopy");

   function SDL_RenderCopyEx
     (renderer : access SDL_Renderer;
      texture  : access SDL_Texture;
      srcrect  : access SDL_Rect;
      dstrect  : access SDL_Rect;
      angle    : C.double;
      center   : access SDL_Point;
      flip     : SDL_RendererFlip) return C.int;
   pragma Import (C, SDL_RenderCopyEx, "SDL_RenderCopyEx");

   function SDL_RenderReadPixels
     (renderer : access SDL_Renderer;
      rect     : access SDL_Rect;
      format   : Uint32;
      pixels   : System.Address;
      pitch    : C.int) return C.int;
   pragma Import (C, SDL_RenderReadPixels, "SDL_RenderReadPixels");

   procedure SDL_RenderPresent (renderer : access SDL_Renderer);
   pragma Import (C, SDL_RenderPresent, "SDL_RenderPresent");

   procedure SDL_DestroyTexture (texture : access SDL_Texture);
   pragma Import (C, SDL_DestroyTexture, "SDL_DestroyTexture");

   procedure SDL_DestroyRenderer (renderer : access SDL_Renderer);
   pragma Import (C, SDL_DestroyRenderer, "SDL_DestroyRenderer");


	--if fail, try this:
   --function SDL_GL_BindTexture
     --(texture : system.address;

   function SDL_GL_BindTexture
     (texture : access SDL_Texture;
      texw    : access C.C_float;
      texh    : access C.C_float) return C.int;
   pragma Import (C, SDL_GL_BindTexture, "SDL_GL_BindTexture");

   function SDL_GL_UnbindTexture (texture : access SDL_Texture) return C.int;
   pragma Import (C, SDL_GL_UnbindTexture, "SDL_GL_UnbindTexture");









   ----------------------------------------------------------------------------
   -- SDL_messagebox.h
   ----------------------------------------------------------------------------

   subtype SDL_MessageBoxFlags is Uint32;
   SDL_MESSAGEBOX_ERROR       : constant SDL_MessageBoxFlags := 16;
   SDL_MESSAGEBOX_WARNING     : constant SDL_MessageBoxFlags := 32;
   SDL_MESSAGEBOX_INFORMATION : constant SDL_MessageBoxFlags := 64;

   subtype SDL_MessageBoxButtonFlags is Uint32;
   SDL_MESSAGEBOX_BUTTON_RETURNKEY_DEFAULT : constant SDL_MessageBoxButtonFlags :=
     1;
   SDL_MESSAGEBOX_BUTTON_ESCAPEKEY_DEFAULT : constant SDL_MessageBoxButtonFlags :=
     2;

   type SDL_MessageBoxButtonData is record
      flags    : aliased Uint32;
      buttonid : aliased C.int;
      text     : aliased Interfaces.C.Strings.chars_ptr;
   end record;
   pragma Convention (C, SDL_MessageBoxButtonData);

   type SDL_MessageBoxColor is record
      r : aliased Uint8;
      g : aliased Uint8;
      b : aliased Uint8;
   end record;
   pragma Convention (C_Pass_By_Copy, SDL_MessageBoxColor);

   type SDL_MessageBoxColorType is
     (SDL_MESSAGEBOX_COLOR_BACKGROUND,
      SDL_MESSAGEBOX_COLOR_TEXT,
      SDL_MESSAGEBOX_COLOR_BUTTON_BORDER,
      SDL_MESSAGEBOX_COLOR_BUTTON_BACKGROUND,
      SDL_MESSAGEBOX_COLOR_BUTTON_SELECTED,
      SDL_MESSAGEBOX_COLOR_MAX);
   pragma Convention (C, SDL_MessageBoxColorType);

   type SDL_MessageBoxColorScheme_colors_array is
     array (0 .. 4) of aliased SDL_MessageBoxColor;
   type SDL_MessageBoxColorScheme is record
      colors : aliased SDL_MessageBoxColorScheme_colors_array;
   end record;
   pragma Convention (C, SDL_MessageBoxColorScheme);

   type SDL_MessageBoxData is record
      flags       : aliased Uint32;
      window      : access SDL_Window;
      title       : aliased Interfaces.C.Strings.chars_ptr;
      message     : aliased Interfaces.C.Strings.chars_ptr;
      numbuttons  : aliased C.int;
      buttons     : SDL_MessageBoxButtonData;
      colorScheme : SDL_MessageBoxColorScheme;
   end record;
   pragma Convention (C_Pass_By_Copy, SDL_MessageBoxData);

   function SDL_ShowMessageBox
     (messageboxdata : SDL_MessageBoxData;
      buttonid       : access C.int) return C.int;
   pragma Import (C, SDL_ShowMessageBox, "SDL_ShowMessageBox");

   function SDL_ShowSimpleMessageBox
     (flags   : Uint32;
      title   : C.char_array;
      message : C.char_array;
      window  : access SDL_Window) return C.int;
   pragma Import (C, SDL_ShowSimpleMessageBox, "SDL_ShowSimpleMessageBox");




   ----------------------------------------------------------------------------
   -- SDL_shape.h
   ----------------------------------------------------------------------------

   SDL_NONSHAPEABLE_WINDOW    : constant := -1;
   SDL_INVALID_SHAPE_ARGUMENT : constant := -2;
   SDL_WINDOW_LACKS_SHAPE     : constant := -3;

   function SDL_CreateShapedWindow
     (title : C.char_array;
      x     : C.unsigned;
      y     : C.unsigned;
      w     : C.unsigned;
      h     : C.unsigned;
      flags : Uint32) return access SDL_Window;
   pragma Import (C, SDL_CreateShapedWindow, "SDL_CreateShapedWindow");

   function SDL_IsShapedWindow (window : access SDL_Window) return SDL_bool;
   pragma Import (C, SDL_IsShapedWindow, "SDL_IsShapedWindow");

   type WindowShapeMode is
     (ShapeModeDefault,
      ShapeModeBinarizeAlpha,
      ShapeModeReverseBinarizeAlpha,
      ShapeModeColorKey);
   pragma Convention (C, WindowShapeMode);

   function SDL_SHAPEMODEALPHA (mode : WindowShapeMode) return SDL_bool;
   pragma Inline (SDL_SHAPEMODEALPHA);

   type SDL_WindowShapeParams (discr : C.unsigned := 0) is record
      case discr is
         when 0 =>
            binarizationCutoff : aliased Uint8;
         when others =>
            colorKey : aliased SDL_Color;
      end case;
   end record;
   pragma Convention (C_Pass_By_Copy, SDL_WindowShapeParams);
   pragma Unchecked_Union (SDL_WindowShapeParams);

   type SDL_WindowShapeMode is record
      mode       : aliased WindowShapeMode;
      parameters : aliased SDL_WindowShapeParams;
   end record;
   pragma Convention (C_Pass_By_Copy, SDL_WindowShapeMode);

   function SDL_SetWindowShape
     (window     : access SDL_Window;
      shape      : access SDL_Surface;
      shape_mode : access SDL_WindowShapeMode) return C.int;
   pragma Import (C, SDL_SetWindowShape, "SDL_SetWindowShape");

   function SDL_GetShapedWindowMode
     (window     : access SDL_Window;
      shape_mode : access SDL_WindowShapeMode) return C.int;
   pragma Import (C, SDL_GetShapedWindowMode, "SDL_GetShapedWindowMode");










---------------------------------------------------------------------
-- sdl.adb removals below here
---------------------------------------------------------------------
   ----------------------------------------------------------------------------
   -- SDL_audio.h
   ----------------------------------------------------------------------------

   function SDL_AUDIO_BITSIZE (x : SDL_AudioFormat) return C.int is
   begin
      return C.int (x and SDL_AUDIO_MASK_BITSIZE);
   end SDL_AUDIO_BITSIZE;

   function SDL_AUDIO_ISFLOAT (x : SDL_AudioFormat) return SDL_bool is
   begin
      if (x and SDL_AUDIO_MASK_DATATYPE) /= 0 then
         return SDL_TRUE;
      else
         return SDL_FALSE;
      end if;
   end SDL_AUDIO_ISFLOAT;

   function SDL_AUDIO_ISBIGENDIAN (x : SDL_AudioFormat) return SDL_bool is
   begin
      if (x and SDL_AUDIO_MASK_ENDIAN) /= 0 then
         return SDL_TRUE;
      else
         return SDL_FALSE;
      end if;
   end SDL_AUDIO_ISBIGENDIAN;

   function SDL_AUDIO_ISSIGNED (x : SDL_AudioFormat) return SDL_bool is
   begin
      if (x and SDL_AUDIO_MASK_SIGNED) /= 0 then
         return SDL_TRUE;
      else
         return SDL_FALSE;
      end if;
   end SDL_AUDIO_ISSIGNED;

   function SDL_AUDIO_ISINT (x : SDL_AudioFormat) return SDL_bool is
   begin
      if SDL_AUDIO_ISFLOAT (x) = SDL_FALSE then
         return SDL_TRUE;
      else
         return SDL_FALSE;
      end if;
   end SDL_AUDIO_ISINT;

   function SDL_AUDIO_ISLITTLEENDIAN (x : SDL_AudioFormat) return SDL_bool is
   begin
      if SDL_AUDIO_ISBIGENDIAN (x) = SDL_FALSE then
         return SDL_TRUE;
      else
         return SDL_FALSE;
      end if;
   end SDL_AUDIO_ISLITTLEENDIAN;

   function SDL_AUDIO_ISUNSIGNED (x : SDL_AudioFormat) return SDL_bool is
   begin
      if SDL_AUDIO_ISSIGNED (x) = SDL_FALSE then
         return SDL_TRUE;
      else
         return SDL_FALSE;
      end if;
   end SDL_AUDIO_ISUNSIGNED;

   function SDL_LoadWAV
     (file      : C.char_array;
      spec      : access SDL_AudioSpec;
      audio_buf : System.Address;
      audio_len : access Uint32) return access SDL_AudioSpec
   is
   begin
      return SDL_LoadWAV_RW
          (SDL_RWFromFile (file, C.To_C ("rb")),
           1,
           spec,
           audio_buf,
           audio_len);
   end SDL_LoadWAV;




   ----------------------------------------------------------------------------
   -- SDL_pixels.h
   ----------------------------------------------------------------------------


   function SDL_DEFINE_PIXELFORMAT
     (typ    : C.int;
      order  : C.int;
      layout : C.int;
      bits   : C.int;
      bytes  : C.int) return Uint32
   is
   begin
      return
        ((ShiftLeft (1, 28)) or
         (ShiftLeft (Uint32 (typ), 24)) or
         (ShiftLeft (Uint32 (order), 20)) or
         (ShiftLeft (Uint32 (layout), 16)) or
         (ShiftLeft (Uint32 (bits), 8)) or
         (ShiftLeft (Uint32 (bytes), 0)));
   end SDL_DEFINE_PIXELFORMAT;

   function SDL_PIXELFLAG (X : Uint32) return C.int is
   begin
      return C.int (ShiftRight (X, 28) and 16#0F#);
   end SDL_PIXELFLAG;

   function SDL_PIXELTYPE (X : Uint32) return C.int is
   begin
      return C.int (ShiftRight (X, 24) and 16#0F#);
   end SDL_PIXELTYPE;

   function SDL_PIXELORDER (X : Uint32) return C.int is
   begin
      return C.int (ShiftRight (X, 20) and 16#0F#);
   end SDL_PIXELORDER;

   function SDL_PIXELLAYOUT (X : Uint32) return C.int is
   begin
      return C.int (ShiftRight (X, 16) and 16#0F#);
   end SDL_PIXELLAYOUT;

   function SDL_BITSPERPIXEL (X : Uint32) return C.int is
   begin
      return C.int (ShiftRight (X, 8) and 16#FF#);
   end SDL_BITSPERPIXEL;

   function SDL_BYTESPERPIXEL (X : Uint32) return C.int is
   begin
      if (SDL_ISPIXELFORMAT_FOURCC (X) = SDL_TRUE) then
         if
           ((X = SDL_PIXELFORMAT_YUY2)
            or else (X = SDL_PIXELFORMAT_UYVY)
            or else (X = SDL_PIXELFORMAT_YVYU))
         then
            return 2;
         else
            return 1;
         end if;
      else
         return C.int (ShiftRight (X, 0) and 16#FF#);
      end if;
   end SDL_BYTESPERPIXEL;

   function SDL_ISPIXELFORMAT_FOURCC (format : Uint32) return SDL_bool is
   begin
      if (format /= 0) and then (SDL_PIXELFLAG (format) /= 1) then
         return SDL_TRUE;
      else
         return SDL_FALSE;
      end if;
   end SDL_ISPIXELFORMAT_FOURCC;

   function SDL_ISPIXELFORMAT_INDEXED (format : Uint32) return SDL_bool is
   begin
      if
        ((SDL_ISPIXELFORMAT_FOURCC (format) = SDL_FALSE)
         and then
         ((SDL_PIXELTYPE (format) = SDL_PIXELTYPE_INDEX1)
          or else (SDL_PIXELTYPE (format) = SDL_PIXELTYPE_INDEX4)
          or else (SDL_PIXELTYPE (format) = SDL_PIXELTYPE_INDEX8)))
      then
         return SDL_TRUE;
      else
         return SDL_FALSE;
      end if;
   end SDL_ISPIXELFORMAT_INDEXED;

   function SDL_ISPIXELFORMAT_ALPHA (format : Uint32) return SDL_bool is
   begin
      if
        ((SDL_ISPIXELFORMAT_FOURCC (format) = SDL_FALSE)
         and then
         ((SDL_PIXELORDER (format) = SDL_PACKEDORDER_ARGB)
          or else (SDL_PIXELORDER (format) = SDL_PACKEDORDER_RGBA)
          or else (SDL_PIXELORDER (format) = SDL_PACKEDORDER_ABGR)
          or else (SDL_PIXELORDER (format) = SDL_PACKEDORDER_BGRA)))
      then
         return SDL_TRUE;
      else
         return SDL_FALSE;
      end if;
   end SDL_ISPIXELFORMAT_ALPHA;







   ----------------------------------------------------------------------------
   -- SDL_shape.h
   ----------------------------------------------------------------------------

   function SDL_SHAPEMODEALPHA (mode : WindowShapeMode) return SDL_bool is
   begin
      if
        ((mode = ShapeModeDefault)
         or else (mode = ShapeModeBinarizeAlpha)
         or else (mode = ShapeModeReverseBinarizeAlpha))
      then
         return SDL_TRUE;
      else
         return SDL_FALSE;
      end if;
   end SDL_SHAPEMODEALPHA;


