pragma Style_Checks (Off);

with Interfaces.C; use Interfaces.C;
with Interfaces.C.Extensions;
with System;
with Interfaces.C.Strings;
with global_h;
with stddef_h;
with unistd_h;
with sys_types_h;

package pcm_h is

  -- Data structure describing a polling request.   
  -- File descriptor to poll.   
   type pollfd is record
      fd : aliased int;  -- /usr/include/sys/poll.h:41
      events : aliased short;  -- /usr/include/sys/poll.h:42
      revents : aliased short;  -- /usr/include/sys/poll.h:43
   end record;
   pragma Convention (C_Pass_By_Copy, pollfd);  -- /usr/include/sys/poll.h:39


   --  unsupported macro: SND_PCM_DLSYM_VERSION _dlsym_pcm_001
   --  unsupported macro: SND_PCM_NONBLOCK 0x00000001
   --  unsupported macro: SND_PCM_ASYNC 0x00000002
   --  unsupported macro: SND_PCM_ABORT 0x00008000
   --  unsupported macro: SND_PCM_NO_AUTO_RESAMPLE 0x00010000
   --  unsupported macro: SND_PCM_NO_AUTO_CHANNELS 0x00020000
   --  unsupported macro: SND_PCM_NO_AUTO_FORMAT 0x00040000
   --  unsupported macro: SND_PCM_NO_SOFTVOL 0x00080000
   --  unsupported macro: SND_CHMAP_API_VERSION ((1 << 16) | (0 << 8) | 1)
   --  unsupported macro: SND_CHMAP_POSITION_MASK 0xffff
   --  unsupported macro: SND_CHMAP_PHASE_INVERSE (0x01 << 16)
   --  unsupported macro: SND_CHMAP_DRIVER_SPEC (0x02 << 16)
   --  arg-macro: procedure snd_pcm_info_alloca (ptr)
   --    __snd_alloca(ptr, snd_pcm_info)
   --  arg-macro: procedure snd_pcm_hw_params_alloca (ptr)
   --    __snd_alloca(ptr, snd_pcm_hw_params)
   --  arg-macro: procedure snd_pcm_sw_params_alloca (ptr)
   --    __snd_alloca(ptr, snd_pcm_sw_params)
   --  arg-macro: procedure snd_pcm_access_mask_alloca (ptr)
   --    __snd_alloca(ptr, snd_pcm_access_mask)
   --  arg-macro: procedure snd_pcm_format_mask_alloca (ptr)
   --    __snd_alloca(ptr, snd_pcm_format_mask)
   --  arg-macro: procedure snd_pcm_subformat_mask_alloca (ptr)
   --    __snd_alloca(ptr, snd_pcm_subformat_mask)
   --  arg-macro: procedure snd_pcm_status_alloca (ptr)
   --    __snd_alloca(ptr, snd_pcm_status)
  --*
  -- * \file include/pcm.h
  -- * \brief Application interface library for the ALSA driver
  -- * \author Jaroslav Kysela <perex@perex.cz>
  -- * \author Abramo Bagnara <abramo@alsa-project.org>
  -- * \author Takashi Iwai <tiwai@suse.de>
  -- * \date 1998-2001
  -- *
  -- * Application interface library for the ALSA driver.
  -- * See the \ref pcm page for more details.
  --  

  -- *   This library is free software; you can redistribute it and/or modify
  -- *   it under the terms of the GNU Lesser General Public License as
  -- *   published by the Free Software Foundation; either version 2.1 of
  -- *   the License, or (at your option) any later version.
  -- *
  -- *   This program is distributed in the hope that it will be useful,
  -- *   but WITHOUT ANY WARRANTY; without even the implied warranty of
  -- *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  -- *   GNU Lesser General Public License for more details.
  -- *
  -- *   You should have received a copy of the GNU Lesser General Public
  -- *   License along with this library; if not, write to the Free Software
  -- *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
  -- *
  --  

  --*
  -- *  \defgroup PCM PCM Interface
  -- *  See the \ref pcm page for more details.
  -- *  \{
  --  

  --* dlsym version for interface entry callback  
  --* PCM generic info container  
   --  skipped empty struct u_snd_pcm_info

   --  skipped empty struct snd_pcm_info_t

  --* PCM hardware configuration space container
  -- *
  -- *  snd_pcm_hw_params_t is an opaque structure which contains a set of possible
  -- *  PCM hardware configurations. For example, a given instance might include a
  -- *  range of buffer sizes, a range of period sizes, and a set of several sample
  -- *  formats. Some subset of all possible combinations these sets may be valid,
  -- *  but not necessarily any combination will be valid.
  -- *
  -- *  When a parameter is set or restricted using a snd_pcm_hw_params_set*
  -- *  function, all of the other ranges will be updated to exclude as many
  -- *  impossible configurations as possible. Attempting to set a parameter
  -- *  outside of its acceptable range will result in the function failing
  -- *  and an error code being returned.
  --  

   type u_snd_pcm_hw_params is null record;   -- incomplete struct
	--for u_snd_pcm_hw_params'size use 1_000_000; --fastrgv

   subtype snd_pcm_hw_params_t is u_snd_pcm_hw_params;  -- /usr/include/alsa/pcm.h:62

  --* PCM software configuration container  
   --  skipped empty struct u_snd_pcm_sw_params

   --  skipped empty struct snd_pcm_sw_params_t

  --* PCM status container  
   --  skipped empty struct u_snd_pcm_status

   --  skipped empty struct snd_pcm_status_t

  --* PCM access types mask  
   --  skipped empty struct u_snd_pcm_access_mask

   --  skipped empty struct snd_pcm_access_mask_t

  --* PCM formats mask  
   --  skipped empty struct u_snd_pcm_format_mask

   --  skipped empty struct snd_pcm_format_mask_t

  --* PCM subformats mask  
   --  skipped empty struct u_snd_pcm_subformat_mask

   --  skipped empty struct snd_pcm_subformat_mask_t

  --* PCM class  
   subtype u_snd_pcm_class is unsigned;
   SND_PCM_CLASS_GENERIC : constant u_snd_pcm_class := 0;
   SND_PCM_CLASS_MULTI : constant u_snd_pcm_class := 1;
   SND_PCM_CLASS_MODEM : constant u_snd_pcm_class := 2;
   SND_PCM_CLASS_DIGITIZER : constant u_snd_pcm_class := 3;
   SND_PCM_CLASS_LAST : constant u_snd_pcm_class := 3;  -- ./alsa/pcm.h:76

  --* standard device  
  --* multichannel device  
  --* software modem device  
  --* digitizer device  
   subtype snd_pcm_class_t is u_snd_pcm_class;

  --* PCM subclass  
   subtype u_snd_pcm_subclass is unsigned;
   SND_PCM_SUBCLASS_GENERIC_MIX : constant u_snd_pcm_subclass := 0;
   SND_PCM_SUBCLASS_MULTI_MIX : constant u_snd_pcm_subclass := 1;
   SND_PCM_SUBCLASS_LAST : constant u_snd_pcm_subclass := 1;  -- ./alsa/pcm.h:90

  --* subdevices are mixed together  
  --* multichannel subdevices are mixed together  
   subtype snd_pcm_subclass_t is u_snd_pcm_subclass;

  --* PCM stream (direction)  
   subtype u_snd_pcm_stream is unsigned;
   SND_PCM_STREAM_PLAYBACK : constant u_snd_pcm_stream := 0;
   SND_PCM_STREAM_CAPTURE : constant u_snd_pcm_stream := 1;
   SND_PCM_STREAM_LAST : constant u_snd_pcm_stream := 1;  -- ./alsa/pcm.h:99

  --* Playback stream  
  --* Capture stream  
   subtype snd_pcm_stream_t is u_snd_pcm_stream;

  --* PCM access type  
   subtype u_snd_pcm_access is unsigned;
   SND_PCM_ACCESS_MMAP_INTERLEAVED : constant u_snd_pcm_access := 0;
   SND_PCM_ACCESS_MMAP_NONINTERLEAVED : constant u_snd_pcm_access := 1;
   SND_PCM_ACCESS_MMAP_COMPLEX : constant u_snd_pcm_access := 2;
   SND_PCM_ACCESS_RW_INTERLEAVED : constant u_snd_pcm_access := 3;
   SND_PCM_ACCESS_RW_NONINTERLEAVED : constant u_snd_pcm_access := 4;
   SND_PCM_ACCESS_LAST : constant u_snd_pcm_access := 4;  -- ./alsa/pcm.h:108

  --* mmap access with simple interleaved channels  
  --* mmap access with simple non interleaved channels  
  --* mmap access with complex placement  
  --* snd_pcm_readi/snd_pcm_writei access  
  --* snd_pcm_readn/snd_pcm_writen access  
   subtype snd_pcm_access_t is u_snd_pcm_access;

  --* PCM sample format  
   subtype u_snd_pcm_format is unsigned;
   SND_PCM_FORMAT_UNKNOWN : constant u_snd_pcm_format := -1;
   SND_PCM_FORMAT_S8 : constant u_snd_pcm_format := 0;
   SND_PCM_FORMAT_U8 : constant u_snd_pcm_format := 1;
   SND_PCM_FORMAT_S16_LE : constant u_snd_pcm_format := 2;
   SND_PCM_FORMAT_S16_BE : constant u_snd_pcm_format := 3;
   SND_PCM_FORMAT_U16_LE : constant u_snd_pcm_format := 4;
   SND_PCM_FORMAT_U16_BE : constant u_snd_pcm_format := 5;
   SND_PCM_FORMAT_S24_LE : constant u_snd_pcm_format := 6;
   SND_PCM_FORMAT_S24_BE : constant u_snd_pcm_format := 7;
   SND_PCM_FORMAT_U24_LE : constant u_snd_pcm_format := 8;
   SND_PCM_FORMAT_U24_BE : constant u_snd_pcm_format := 9;
   SND_PCM_FORMAT_S32_LE : constant u_snd_pcm_format := 10;
   SND_PCM_FORMAT_S32_BE : constant u_snd_pcm_format := 11;
   SND_PCM_FORMAT_U32_LE : constant u_snd_pcm_format := 12;
   SND_PCM_FORMAT_U32_BE : constant u_snd_pcm_format := 13;
   SND_PCM_FORMAT_FLOAT_LE : constant u_snd_pcm_format := 14;
   SND_PCM_FORMAT_FLOAT_BE : constant u_snd_pcm_format := 15;
   SND_PCM_FORMAT_FLOAT64_LE : constant u_snd_pcm_format := 16;
   SND_PCM_FORMAT_FLOAT64_BE : constant u_snd_pcm_format := 17;
   SND_PCM_FORMAT_IEC958_SUBFRAME_LE : constant u_snd_pcm_format := 18;
   SND_PCM_FORMAT_IEC958_SUBFRAME_BE : constant u_snd_pcm_format := 19;
   SND_PCM_FORMAT_MU_LAW : constant u_snd_pcm_format := 20;
   SND_PCM_FORMAT_A_LAW : constant u_snd_pcm_format := 21;
   SND_PCM_FORMAT_IMA_ADPCM : constant u_snd_pcm_format := 22;
   SND_PCM_FORMAT_MPEG : constant u_snd_pcm_format := 23;
   SND_PCM_FORMAT_GSM : constant u_snd_pcm_format := 24;
   SND_PCM_FORMAT_SPECIAL : constant u_snd_pcm_format := 31;
   SND_PCM_FORMAT_S24_3LE : constant u_snd_pcm_format := 32;
   SND_PCM_FORMAT_S24_3BE : constant u_snd_pcm_format := 33;
   SND_PCM_FORMAT_U24_3LE : constant u_snd_pcm_format := 34;
   SND_PCM_FORMAT_U24_3BE : constant u_snd_pcm_format := 35;
   SND_PCM_FORMAT_S20_3LE : constant u_snd_pcm_format := 36;
   SND_PCM_FORMAT_S20_3BE : constant u_snd_pcm_format := 37;
   SND_PCM_FORMAT_U20_3LE : constant u_snd_pcm_format := 38;
   SND_PCM_FORMAT_U20_3BE : constant u_snd_pcm_format := 39;
   SND_PCM_FORMAT_S18_3LE : constant u_snd_pcm_format := 40;
   SND_PCM_FORMAT_S18_3BE : constant u_snd_pcm_format := 41;
   SND_PCM_FORMAT_U18_3LE : constant u_snd_pcm_format := 42;
   SND_PCM_FORMAT_U18_3BE : constant u_snd_pcm_format := 43;
   SND_PCM_FORMAT_G723_24 : constant u_snd_pcm_format := 44;
   SND_PCM_FORMAT_G723_24_1B : constant u_snd_pcm_format := 45;
   SND_PCM_FORMAT_G723_40 : constant u_snd_pcm_format := 46;
   SND_PCM_FORMAT_G723_40_1B : constant u_snd_pcm_format := 47;
   SND_PCM_FORMAT_DSD_U8 : constant u_snd_pcm_format := 48;
   SND_PCM_FORMAT_DSD_U16_LE : constant u_snd_pcm_format := 49;
   SND_PCM_FORMAT_DSD_U32_LE : constant u_snd_pcm_format := 50;
   SND_PCM_FORMAT_DSD_U16_BE : constant u_snd_pcm_format := 51;
   SND_PCM_FORMAT_DSD_U32_BE : constant u_snd_pcm_format := 52;
   SND_PCM_FORMAT_LAST : constant u_snd_pcm_format := 52;
   SND_PCM_FORMAT_S16 : constant u_snd_pcm_format := 2;
   SND_PCM_FORMAT_U16 : constant u_snd_pcm_format := 4;
   SND_PCM_FORMAT_S24 : constant u_snd_pcm_format := 6;
   SND_PCM_FORMAT_U24 : constant u_snd_pcm_format := 8;
   SND_PCM_FORMAT_S32 : constant u_snd_pcm_format := 10;
   SND_PCM_FORMAT_U32 : constant u_snd_pcm_format := 12;
   CSND_PCM_FORMAT_FLOAT : constant u_snd_pcm_format := 14;
   SND_PCM_FORMAT_FLOAT64 : constant u_snd_pcm_format := 16;
   SND_PCM_FORMAT_IEC958_SUBFRAME : constant u_snd_pcm_format := 18;  -- ./alsa/pcm.h:123

  --* Unknown  
  --* Signed 8 bit  
  --* Unsigned 8 bit  
  --* Signed 16 bit Little Endian  
  --* Signed 16 bit Big Endian  
  --* Unsigned 16 bit Little Endian  
  --* Unsigned 16 bit Big Endian  
  --* Signed 24 bit Little Endian using low three bytes in 32-bit word  
  --* Signed 24 bit Big Endian using low three bytes in 32-bit word  
  --* Unsigned 24 bit Little Endian using low three bytes in 32-bit word  
  --* Unsigned 24 bit Big Endian using low three bytes in 32-bit word  
  --* Signed 32 bit Little Endian  
  --* Signed 32 bit Big Endian  
  --* Unsigned 32 bit Little Endian  
  --* Unsigned 32 bit Big Endian  
  --* Float 32 bit Little Endian, Range -1.0 to 1.0  
  --* Float 32 bit Big Endian, Range -1.0 to 1.0  
  --* Float 64 bit Little Endian, Range -1.0 to 1.0  
  --* Float 64 bit Big Endian, Range -1.0 to 1.0  
  --* IEC-958 Little Endian  
  --* IEC-958 Big Endian  
  --* Mu-Law  
  --* A-Law  
  --* Ima-ADPCM  
  --* MPEG  
  --* GSM  
  --* Special  
  --* Signed 24bit Little Endian in 3bytes format  
  --* Signed 24bit Big Endian in 3bytes format  
  --* Unsigned 24bit Little Endian in 3bytes format  
  --* Unsigned 24bit Big Endian in 3bytes format  
  --* Signed 20bit Little Endian in 3bytes format  
  --* Signed 20bit Big Endian in 3bytes format  
  --* Unsigned 20bit Little Endian in 3bytes format  
  --* Unsigned 20bit Big Endian in 3bytes format  
  --* Signed 18bit Little Endian in 3bytes format  
  --* Signed 18bit Big Endian in 3bytes format  
  --* Unsigned 18bit Little Endian in 3bytes format  
  --* Unsigned 18bit Big Endian in 3bytes format  
  -- G.723 (ADPCM) 24 kbit/s, 8 samples in 3 bytes  
  -- G.723 (ADPCM) 24 kbit/s, 1 sample in 1 byte  
  -- G.723 (ADPCM) 40 kbit/s, 8 samples in 3 bytes  
  -- G.723 (ADPCM) 40 kbit/s, 1 sample in 1 byte  
  -- Direct Stream Digital (DSD) in 1-byte samples (x8)  
  -- Direct Stream Digital (DSD) in 2-byte samples (x16)  
  -- Direct Stream Digital (DSD) in 4-byte samples (x32)  
  -- Direct Stream Digital (DSD) in 2-byte samples (x16)  
  -- Direct Stream Digital (DSD) in 4-byte samples (x32)  
  --* Signed 16 bit CPU endian  
  --* Unsigned 16 bit CPU endian  
  --* Signed 24 bit CPU endian  
  --* Unsigned 24 bit CPU endian  
  --* Signed 32 bit CPU endian  
  --* Unsigned 32 bit CPU endian  
  --* Float 32 bit CPU endian  
  --* Float 64 bit CPU endian  
  --* IEC-958 CPU Endian  
  --* Signed 16 bit CPU endian  
  --* Unsigned 16 bit CPU endian  
  --* Signed 24 bit CPU endian  
  --* Unsigned 24 bit CPU endian  
  --* Signed 32 bit CPU endian  
  --* Unsigned 32 bit CPU endian  
  --* Float 32 bit CPU endian  
  --* Float 64 bit CPU endian  
  --* IEC-958 CPU Endian  
   subtype snd_pcm_format_t is u_snd_pcm_format;

  --* PCM sample subformat  
   subtype u_snd_pcm_subformat is unsigned;
   SND_PCM_SUBFORMAT_STD : constant u_snd_pcm_subformat := 0;
   SND_PCM_SUBFORMAT_LAST : constant u_snd_pcm_subformat := 0;  -- ./alsa/pcm.h:266

  --* Standard  
   subtype snd_pcm_subformat_t is u_snd_pcm_subformat;

  --* PCM state  
   subtype u_snd_pcm_state is unsigned;
   SND_PCM_STATE_OPEN : constant u_snd_pcm_state := 0;
   SND_PCM_STATE_SETUP : constant u_snd_pcm_state := 1;
   SND_PCM_STATE_PREPARED : constant u_snd_pcm_state := 2;
   SND_PCM_STATE_RUNNING : constant u_snd_pcm_state := 3;
   SND_PCM_STATE_XRUN : constant u_snd_pcm_state := 4;
   SND_PCM_STATE_DRAINING : constant u_snd_pcm_state := 5;
   SND_PCM_STATE_PAUSED : constant u_snd_pcm_state := 6;
   SND_PCM_STATE_SUSPENDED : constant u_snd_pcm_state := 7;
   SND_PCM_STATE_DISCONNECTED : constant u_snd_pcm_state := 8;
   SND_PCM_STATE_LAST : constant u_snd_pcm_state := 8;  -- ./alsa/pcm.h:273

  --* Open  
  --* Setup installed  
  --* Ready to start  
  --* Running  
  --* Stopped: underrun (playback) or overrun (capture) detected  
  --* Draining: running (playback) or stopped (capture)  
  --* Paused  
  --* Hardware is suspended  
  --* Hardware is disconnected  
   subtype snd_pcm_state_t is u_snd_pcm_state;

  --* PCM start mode  
   subtype u_snd_pcm_start is unsigned;
   SND_PCM_START_DATA : constant u_snd_pcm_start := 0;
   SND_PCM_START_EXPLICIT : constant u_snd_pcm_start := 1;
   SND_PCM_START_LAST : constant u_snd_pcm_start := 1;  -- ./alsa/pcm.h:296

  --* Automatic start on data read/write  
  --* Explicit start  
   subtype snd_pcm_start_t is u_snd_pcm_start;

  --* PCM xrun mode  
   subtype u_snd_pcm_xrun is unsigned;
   SND_PCM_XRUN_NONE : constant u_snd_pcm_xrun := 0;
   SND_PCM_XRUN_STOP : constant u_snd_pcm_xrun := 1;
   SND_PCM_XRUN_LAST : constant u_snd_pcm_xrun := 1;  -- ./alsa/pcm.h:305

  --* Xrun detection disabled  
  --* Stop on xrun detection  
   subtype snd_pcm_xrun_t is u_snd_pcm_xrun;

  --* PCM timestamp mode  
   subtype u_snd_pcm_tstamp is unsigned;
   SND_PCM_TSTAMP_NONE : constant u_snd_pcm_tstamp := 0;
   SND_PCM_TSTAMP_ENABLE : constant u_snd_pcm_tstamp := 1;
   SND_PCM_TSTAMP_MMAP : constant u_snd_pcm_tstamp := 1;
   SND_PCM_TSTAMP_LAST : constant u_snd_pcm_tstamp := 1;  -- ./alsa/pcm.h:314

  --* No timestamp  
  --* Update timestamp at every hardware position update  
  --* Equivalent with #SND_PCM_TSTAMP_ENABLE,
  --	 * just for compatibility with older versions
  --	  

   subtype snd_pcm_tstamp_t is u_snd_pcm_tstamp;

   subtype u_snd_pcm_tstamp_type is unsigned;
   SND_PCM_TSTAMP_TYPE_GETTIMEOFDAY : constant u_snd_pcm_tstamp_type := 0;
   SND_PCM_TSTAMP_TYPE_MONOTONIC : constant u_snd_pcm_tstamp_type := 1;
   SND_PCM_TSTAMP_TYPE_MONOTONIC_RAW : constant u_snd_pcm_tstamp_type := 2;
   SND_PCM_TSTAMP_TYPE_LAST : constant u_snd_pcm_tstamp_type := 2;  -- ./alsa/pcm.h:326

  --*< gettimeofday equivalent  
  --*< posix_clock_monotonic equivalent  
  --*< monotonic_raw (no NTP)  
   subtype snd_pcm_tstamp_type_t is u_snd_pcm_tstamp_type;

  -- 5 of max 16 bits used  
   type u_snd_pcm_audio_tstamp_config is record
      type_requested : Extensions.Unsigned_4;  -- ./alsa/pcm.h:335
      report_delay : Extensions.Unsigned_1;  -- ./alsa/pcm.h:336
   end record;
   pragma Convention (C_Pass_By_Copy, u_snd_pcm_audio_tstamp_config);
   pragma Pack (u_snd_pcm_audio_tstamp_config);  -- ./alsa/pcm.h:333

  -- add total delay to A/D or D/A  
   subtype snd_pcm_audio_tstamp_config_t is u_snd_pcm_audio_tstamp_config;

  -- 6 of max 16 bits used for bit-fields  
  -- for backwards compatibility  
   type u_snd_pcm_audio_tstamp_report is record
      valid : Extensions.Unsigned_1;  -- ./alsa/pcm.h:343
      actual_type : Extensions.Unsigned_4;  -- ./alsa/pcm.h:346
      accuracy_report : Extensions.Unsigned_1;  -- ./alsa/pcm.h:349
      accuracy : aliased unsigned;  -- ./alsa/pcm.h:350
   end record;
   pragma Convention (C_Pass_By_Copy, u_snd_pcm_audio_tstamp_report);
   pragma Pack (u_snd_pcm_audio_tstamp_report);  -- ./alsa/pcm.h:339

  -- actual type if hardware could not support requested timestamp  
  -- accuracy represented in ns units  
  -- 0 if accuracy unknown, 1 if accuracy field is valid  
  -- up to 4.29s, will be packed in separate field   
   subtype snd_pcm_audio_tstamp_report_t is u_snd_pcm_audio_tstamp_report;

  --* Unsigned frames quantity  
   subtype snd_pcm_uframes_t is unsigned_long;  -- ./alsa/pcm.h:354

  --* Signed frames quantity  
   subtype snd_pcm_sframes_t is long;  -- ./alsa/pcm.h:356

  --* Non blocking mode (flag for open mode) \hideinitializer  
  --* Async notification (flag for open mode) \hideinitializer  
  --* In an abort state (internal, not allowed for open)  
  --* Disable automatic (but not forced!) rate resamplinig  
  --* Disable automatic (but not forced!) channel conversion  
  --* Disable automatic (but not forced!) format conversion  
  --* Disable soft volume control  
  --* PCM handle  

   type u_snd_pcm is null record;   -- incomplete struct
	--for u_snd_pcm'size use 1_000_000; --fastrgv

   subtype snd_pcm_t is u_snd_pcm;  -- /usr/include/alsa/pcm.h:374

  --* PCM type  
   subtype u_snd_pcm_type is unsigned;
   SND_PCM_TYPE_HW : constant u_snd_pcm_type := 0;
   SND_PCM_TYPE_HOOKS : constant u_snd_pcm_type := 1;
   SND_PCM_TYPE_MULTI : constant u_snd_pcm_type := 2;
   SND_PCM_TYPE_FILE : constant u_snd_pcm_type := 3;
   SND_PCM_TYPE_NULL : constant u_snd_pcm_type := 4;
   SND_PCM_TYPE_SHM : constant u_snd_pcm_type := 5;
   SND_PCM_TYPE_INET : constant u_snd_pcm_type := 6;
   SND_PCM_TYPE_COPY : constant u_snd_pcm_type := 7;
   SND_PCM_TYPE_LINEAR : constant u_snd_pcm_type := 8;
   SND_PCM_TYPE_ALAW : constant u_snd_pcm_type := 9;
   SND_PCM_TYPE_MULAW : constant u_snd_pcm_type := 10;
   SND_PCM_TYPE_ADPCM : constant u_snd_pcm_type := 11;
   SND_PCM_TYPE_RATE : constant u_snd_pcm_type := 12;
   SND_PCM_TYPE_ROUTE : constant u_snd_pcm_type := 13;
   SND_PCM_TYPE_PLUG : constant u_snd_pcm_type := 14;
   SND_PCM_TYPE_SHARE : constant u_snd_pcm_type := 15;
   SND_PCM_TYPE_METER : constant u_snd_pcm_type := 16;
   SND_PCM_TYPE_MIX : constant u_snd_pcm_type := 17;
   SND_PCM_TYPE_DROUTE : constant u_snd_pcm_type := 18;
   SND_PCM_TYPE_LBSERVER : constant u_snd_pcm_type := 19;
   SND_PCM_TYPE_LINEAR_FLOAT : constant u_snd_pcm_type := 20;
   SND_PCM_TYPE_LADSPA : constant u_snd_pcm_type := 21;
   SND_PCM_TYPE_DMIX : constant u_snd_pcm_type := 22;
   SND_PCM_TYPE_JACK : constant u_snd_pcm_type := 23;
   SND_PCM_TYPE_DSNOOP : constant u_snd_pcm_type := 24;
   SND_PCM_TYPE_DSHARE : constant u_snd_pcm_type := 25;
   SND_PCM_TYPE_IEC958 : constant u_snd_pcm_type := 26;
   SND_PCM_TYPE_SOFTVOL : constant u_snd_pcm_type := 27;
   SND_PCM_TYPE_IOPLUG : constant u_snd_pcm_type := 28;
   SND_PCM_TYPE_EXTPLUG : constant u_snd_pcm_type := 29;
   SND_PCM_TYPE_MMAP_EMUL : constant u_snd_pcm_type := 30;
   SND_PCM_TYPE_LAST : constant u_snd_pcm_type := 30;  -- ./alsa/pcm.h:377

  --* Kernel level PCM  
  --* Hooked PCM  
  --* One or more linked PCM with exclusive access to selected
  --	    channels  

  --* File writing plugin  
  --* Null endpoint PCM  
  --* Shared memory client PCM  
  --* INET client PCM (not yet implemented)  
  --* Copying plugin  
  --* Linear format conversion PCM  
  --* A-Law format conversion PCM  
  --* Mu-Law format conversion PCM  
  --* IMA-ADPCM format conversion PCM  
  --* Rate conversion PCM  
  --* Attenuated static route PCM  
  --* Format adjusted PCM  
  --* Sharing PCM  
  --* Meter plugin  
  --* Mixing PCM  
  --* Attenuated dynamic route PCM (not yet implemented)  
  --* Loopback server plugin (not yet implemented)  
  --* Linear Integer <-> Linear Float format conversion PCM  
  --* LADSPA integration plugin  
  --* Direct Mixing plugin  
  --* Jack Audio Connection Kit plugin  
  --* Direct Snooping plugin  
  --* Direct Sharing plugin  
  --* IEC958 subframe plugin  
  --* Soft volume plugin  
  --* External I/O plugin  
  --* External filter plugin  
  --* Mmap-emulation plugin  
  --* PCM type  
   subtype snd_pcm_type_t is u_snd_pcm_type;

  --* PCM area specification  
  --* base address of channel samples  
   type u_snd_pcm_channel_area is record
      addr : System.Address;  -- ./alsa/pcm.h:450
      first : aliased unsigned;  -- ./alsa/pcm.h:452
      step : aliased unsigned;  -- ./alsa/pcm.h:454
   end record;
   pragma Convention (C_Pass_By_Copy, u_snd_pcm_channel_area);  -- ./alsa/pcm.h:448

  --* offset to first sample in bits  
  --* samples distance in bits  
   subtype snd_pcm_channel_area_t is u_snd_pcm_channel_area;

  --* PCM synchronization ID  
  --* 8-bit ID  
   type u_snd_pcm_sync_id_id_array is array (0 .. 15) of aliased unsigned_char;
   type u_snd_pcm_sync_id_id16_array is array (0 .. 7) of aliased unsigned_short;
   type u_snd_pcm_sync_id_id32_array is array (0 .. 3) of aliased unsigned;
   type u_snd_pcm_sync_id (discr : unsigned := 0) is record
      case discr is
         when 0 =>
            id : aliased u_snd_pcm_sync_id_id_array;  -- ./alsa/pcm.h:460
         when 1 =>
            id16 : aliased u_snd_pcm_sync_id_id16_array;  -- ./alsa/pcm.h:462
         when others =>
            id32 : aliased u_snd_pcm_sync_id_id32_array;  -- ./alsa/pcm.h:464
      end case;
   end record;
   pragma Convention (C_Pass_By_Copy, u_snd_pcm_sync_id);
   pragma Unchecked_Union (u_snd_pcm_sync_id);  -- ./alsa/pcm.h:458

  --* 16-bit ID  
  --* 32-bit ID  
   subtype snd_pcm_sync_id_t is u_snd_pcm_sync_id;

  --* #SND_PCM_TYPE_METER scope handle  
   --  skipped empty struct u_snd_pcm_scope

   --  skipped empty struct snd_pcm_scope_t

   function snd_pcm_open
     (pcm : System.Address;
      name : Interfaces.C.Strings.chars_ptr;
      stream : snd_pcm_stream_t;
      mode : int) return int;  -- ./alsa/pcm.h:470
   pragma Import (C, snd_pcm_open, "snd_pcm_open");

   function snd_pcm_open_lconf
     (pcm : System.Address;
      name : Interfaces.C.Strings.chars_ptr;
      stream : snd_pcm_stream_t;
      mode : int;
      lconf : System.Address) return int;  -- ./alsa/pcm.h:472
   pragma Import (C, snd_pcm_open_lconf, "snd_pcm_open_lconf");

   function snd_pcm_open_fallback
     (pcm : System.Address;
      root : System.Address;
      name : Interfaces.C.Strings.chars_ptr;
      orig_name : Interfaces.C.Strings.chars_ptr;
      stream : snd_pcm_stream_t;
      mode : int) return int;  -- ./alsa/pcm.h:475
   pragma Import (C, snd_pcm_open_fallback, "snd_pcm_open_fallback");

   function snd_pcm_close (pcm : System.Address) return int;  -- ./alsa/pcm.h:479
   pragma Import (C, snd_pcm_close, "snd_pcm_close");

   function snd_pcm_name (pcm : System.Address) return Interfaces.C.Strings.chars_ptr;  -- ./alsa/pcm.h:480
   pragma Import (C, snd_pcm_name, "snd_pcm_name");

   function snd_pcm_type (pcm : System.Address) return snd_pcm_type_t;  -- ./alsa/pcm.h:481
   pragma Import (C, snd_pcm_type, "snd_pcm_type");

   function snd_pcm_stream (pcm : System.Address) return snd_pcm_stream_t;  -- ./alsa/pcm.h:482
   pragma Import (C, snd_pcm_stream, "snd_pcm_stream");

   function snd_pcm_poll_descriptors_count (pcm : System.Address) return int;  -- ./alsa/pcm.h:483
   pragma Import (C, snd_pcm_poll_descriptors_count, "snd_pcm_poll_descriptors_count");

   function snd_pcm_poll_descriptors
     (pcm : System.Address;
      --pfds : access sys_poll_h.pollfd;
      pfds : access pollfd;
      space : unsigned) return int;  -- ./alsa/pcm.h:484
   pragma Import (C, snd_pcm_poll_descriptors, "snd_pcm_poll_descriptors");

   function snd_pcm_poll_descriptors_revents
     (pcm : System.Address;
      --pfds : access sys_poll_h.pollfd;
      pfds : access pollfd;
      nfds : unsigned;
      revents : access unsigned_short) return int;  -- ./alsa/pcm.h:485
   pragma Import (C, snd_pcm_poll_descriptors_revents, "snd_pcm_poll_descriptors_revents");

   function snd_pcm_nonblock (pcm : System.Address; nonblock : int) return int;  -- ./alsa/pcm.h:486
   pragma Import (C, snd_pcm_nonblock, "snd_pcm_nonblock");

   function snd_pcm_abort (pcm : System.Address) return int;  -- ./alsa/pcm.h:487
   pragma Import (C, snd_pcm_abort, "snd_pcm_abort");

   function snd_async_add_pcm_handler
     (handler : System.Address;
      pcm : System.Address;
      callback : global_h.snd_async_callback_t;
      private_data : System.Address) return int;  -- ./alsa/pcm.h:488
   pragma Import (C, snd_async_add_pcm_handler, "snd_async_add_pcm_handler");

   function snd_async_handler_get_pcm (handler : System.Address) return System.Address;  -- ./alsa/pcm.h:490
   pragma Import (C, snd_async_handler_get_pcm, "snd_async_handler_get_pcm");

   function snd_pcm_info (pcm : System.Address; info : System.Address) return int;  -- ./alsa/pcm.h:491
   pragma Import (C, snd_pcm_info, "snd_pcm_info");

   function snd_pcm_hw_params_current (pcm : System.Address; params : System.Address) return int;  -- ./alsa/pcm.h:492
   pragma Import (C, snd_pcm_hw_params_current, "snd_pcm_hw_params_current");

   function snd_pcm_hw_params (pcm : System.Address; params : System.Address) return int;  -- ./alsa/pcm.h:493
   pragma Import (C, snd_pcm_hw_params, "snd_pcm_hw_params");

   function snd_pcm_hw_free (pcm : System.Address) return int;  -- ./alsa/pcm.h:494
   pragma Import (C, snd_pcm_hw_free, "snd_pcm_hw_free");

   function snd_pcm_sw_params_current (pcm : System.Address; params : System.Address) return int;  -- ./alsa/pcm.h:495
   pragma Import (C, snd_pcm_sw_params_current, "snd_pcm_sw_params_current");

   function snd_pcm_sw_params (pcm : System.Address; params : System.Address) return int;  -- ./alsa/pcm.h:496
   pragma Import (C, snd_pcm_sw_params, "snd_pcm_sw_params");

   function snd_pcm_prepare (pcm : System.Address) return int;  -- ./alsa/pcm.h:497
   pragma Import (C, snd_pcm_prepare, "snd_pcm_prepare");

   function snd_pcm_reset (pcm : System.Address) return int;  -- ./alsa/pcm.h:498
   pragma Import (C, snd_pcm_reset, "snd_pcm_reset");

   function snd_pcm_status (pcm : System.Address; status : System.Address) return int;  -- ./alsa/pcm.h:499
   pragma Import (C, snd_pcm_status, "snd_pcm_status");

   function snd_pcm_start (pcm : System.Address) return int;  -- ./alsa/pcm.h:500
   pragma Import (C, snd_pcm_start, "snd_pcm_start");

   function snd_pcm_drop (pcm : System.Address) return int;  -- ./alsa/pcm.h:501
   pragma Import (C, snd_pcm_drop, "snd_pcm_drop");

   function snd_pcm_drain (pcm : System.Address) return int;  -- ./alsa/pcm.h:502
   pragma Import (C, snd_pcm_drain, "snd_pcm_drain");

   function snd_pcm_pause (pcm : System.Address; enable : int) return int;  -- ./alsa/pcm.h:503
   pragma Import (C, snd_pcm_pause, "snd_pcm_pause");

   function snd_pcm_state (pcm : System.Address) return snd_pcm_state_t;  -- ./alsa/pcm.h:504
   pragma Import (C, snd_pcm_state, "snd_pcm_state");

   function snd_pcm_hwsync (pcm : System.Address) return int;  -- ./alsa/pcm.h:505
   pragma Import (C, snd_pcm_hwsync, "snd_pcm_hwsync");

   function snd_pcm_delay (pcm : System.Address; delayp : access snd_pcm_sframes_t) return int;  -- ./alsa/pcm.h:506
   pragma Import (C, snd_pcm_delay, "snd_pcm_delay");

   function snd_pcm_resume (pcm : System.Address) return int;  -- ./alsa/pcm.h:507
   pragma Import (C, snd_pcm_resume, "snd_pcm_resume");

   function snd_pcm_htimestamp
     (pcm : System.Address;
      avail : access snd_pcm_uframes_t;
      tstamp : access global_h.snd_htimestamp_t) return int;  -- ./alsa/pcm.h:508
   pragma Import (C, snd_pcm_htimestamp, "snd_pcm_htimestamp");

   function snd_pcm_avail (pcm : System.Address) return snd_pcm_sframes_t;  -- ./alsa/pcm.h:509
   pragma Import (C, snd_pcm_avail, "snd_pcm_avail");

   function snd_pcm_avail_update (pcm : System.Address) return snd_pcm_sframes_t;  -- ./alsa/pcm.h:510
   pragma Import (C, snd_pcm_avail_update, "snd_pcm_avail_update");

   function snd_pcm_avail_delay
     (pcm : System.Address;
      availp : access snd_pcm_sframes_t;
      delayp : access snd_pcm_sframes_t) return int;  -- ./alsa/pcm.h:511
   pragma Import (C, snd_pcm_avail_delay, "snd_pcm_avail_delay");

   function snd_pcm_rewindable (pcm : System.Address) return snd_pcm_sframes_t;  -- ./alsa/pcm.h:512
   pragma Import (C, snd_pcm_rewindable, "snd_pcm_rewindable");

   function snd_pcm_rewind (pcm : System.Address; frames : snd_pcm_uframes_t) return snd_pcm_sframes_t;  -- ./alsa/pcm.h:513
   pragma Import (C, snd_pcm_rewind, "snd_pcm_rewind");

   function snd_pcm_forwardable (pcm : System.Address) return snd_pcm_sframes_t;  -- ./alsa/pcm.h:514
   pragma Import (C, snd_pcm_forwardable, "snd_pcm_forwardable");

   function snd_pcm_forward (pcm : System.Address; frames : snd_pcm_uframes_t) return snd_pcm_sframes_t;  -- ./alsa/pcm.h:515
   pragma Import (C, snd_pcm_forward, "snd_pcm_forward");

   function snd_pcm_writei
     (pcm : System.Address;
      buffer : System.Address;
      size : snd_pcm_uframes_t) return snd_pcm_sframes_t;  -- ./alsa/pcm.h:516
   pragma Import (C, snd_pcm_writei, "snd_pcm_writei");

   function snd_pcm_readi
     (pcm : System.Address;
      buffer : System.Address;
      size : snd_pcm_uframes_t) return snd_pcm_sframes_t;  -- ./alsa/pcm.h:517
   pragma Import (C, snd_pcm_readi, "snd_pcm_readi");

   function snd_pcm_writen
     (pcm : System.Address;
      bufs : System.Address;
      size : snd_pcm_uframes_t) return snd_pcm_sframes_t;  -- ./alsa/pcm.h:518
   pragma Import (C, snd_pcm_writen, "snd_pcm_writen");

   function snd_pcm_readn
     (pcm : System.Address;
      bufs : System.Address;
      size : snd_pcm_uframes_t) return snd_pcm_sframes_t;  -- ./alsa/pcm.h:519
   pragma Import (C, snd_pcm_readn, "snd_pcm_readn");

   function snd_pcm_wait (pcm : System.Address; timeout : int) return int;  -- ./alsa/pcm.h:520
   pragma Import (C, snd_pcm_wait, "snd_pcm_wait");

   function snd_pcm_link (pcm1 : System.Address; pcm2 : System.Address) return int;  -- ./alsa/pcm.h:522
   pragma Import (C, snd_pcm_link, "snd_pcm_link");

   function snd_pcm_unlink (pcm : System.Address) return int;  -- ./alsa/pcm.h:523
   pragma Import (C, snd_pcm_unlink, "snd_pcm_unlink");

  --* channel mapping API version number  
  --* channel map list type  
   subtype snd_pcm_chmap_type is unsigned;
   SND_CHMAP_TYPE_NONE : constant snd_pcm_chmap_type := 0;
   SND_CHMAP_TYPE_FIXED : constant snd_pcm_chmap_type := 1;
   SND_CHMAP_TYPE_VAR : constant snd_pcm_chmap_type := 2;
   SND_CHMAP_TYPE_PAIRED : constant snd_pcm_chmap_type := 3;
   SND_CHMAP_TYPE_LAST : constant snd_pcm_chmap_type := 3;  -- ./alsa/pcm.h:529

  --*< unspecified channel position  
  --*< fixed channel position  
  --*< freely swappable channel position  
  --*< pair-wise swappable channel position  
  --*< last entry  
  --* channel positions  
   subtype snd_pcm_chmap_position is unsigned;
   SND_CHMAP_UNKNOWN : constant snd_pcm_chmap_position := 0;
   SND_CHMAP_NA : constant snd_pcm_chmap_position := 1;
   SND_CHMAP_MONO : constant snd_pcm_chmap_position := 2;
   SND_CHMAP_FL : constant snd_pcm_chmap_position := 3;
   SND_CHMAP_FR : constant snd_pcm_chmap_position := 4;
   SND_CHMAP_RL : constant snd_pcm_chmap_position := 5;
   SND_CHMAP_RR : constant snd_pcm_chmap_position := 6;
   SND_CHMAP_FC : constant snd_pcm_chmap_position := 7;
   SND_CHMAP_LFE : constant snd_pcm_chmap_position := 8;
   SND_CHMAP_SL : constant snd_pcm_chmap_position := 9;
   SND_CHMAP_SR : constant snd_pcm_chmap_position := 10;
   SND_CHMAP_RC : constant snd_pcm_chmap_position := 11;
   SND_CHMAP_FLC : constant snd_pcm_chmap_position := 12;
   SND_CHMAP_FRC : constant snd_pcm_chmap_position := 13;
   SND_CHMAP_RLC : constant snd_pcm_chmap_position := 14;
   SND_CHMAP_RRC : constant snd_pcm_chmap_position := 15;
   SND_CHMAP_FLW : constant snd_pcm_chmap_position := 16;
   SND_CHMAP_FRW : constant snd_pcm_chmap_position := 17;
   SND_CHMAP_FLH : constant snd_pcm_chmap_position := 18;
   SND_CHMAP_FCH : constant snd_pcm_chmap_position := 19;
   SND_CHMAP_FRH : constant snd_pcm_chmap_position := 20;
   SND_CHMAP_TC : constant snd_pcm_chmap_position := 21;
   SND_CHMAP_TFL : constant snd_pcm_chmap_position := 22;
   SND_CHMAP_TFR : constant snd_pcm_chmap_position := 23;
   SND_CHMAP_TFC : constant snd_pcm_chmap_position := 24;
   SND_CHMAP_TRL : constant snd_pcm_chmap_position := 25;
   SND_CHMAP_TRR : constant snd_pcm_chmap_position := 26;
   SND_CHMAP_TRC : constant snd_pcm_chmap_position := 27;
   SND_CHMAP_TFLC : constant snd_pcm_chmap_position := 28;
   SND_CHMAP_TFRC : constant snd_pcm_chmap_position := 29;
   SND_CHMAP_TSL : constant snd_pcm_chmap_position := 30;
   SND_CHMAP_TSR : constant snd_pcm_chmap_position := 31;
   SND_CHMAP_LLFE : constant snd_pcm_chmap_position := 32;
   SND_CHMAP_RLFE : constant snd_pcm_chmap_position := 33;
   SND_CHMAP_BC : constant snd_pcm_chmap_position := 34;
   SND_CHMAP_BLC : constant snd_pcm_chmap_position := 35;
   SND_CHMAP_BRC : constant snd_pcm_chmap_position := 36;
   SND_CHMAP_LAST : constant snd_pcm_chmap_position := 36;  -- ./alsa/pcm.h:538

  --*< unspecified  
  --*< N/A, silent  
  --*< mono stream  
  --*< front left  
  --*< front right  
  --*< rear left  
  --*< rear right  
  --*< front center  
  --*< LFE  
  --*< side left  
  --*< side right  
  --*< rear center  
  --*< front left center  
  --*< front right center  
  --*< rear left center  
  --*< rear right center  
  --*< front left wide  
  --*< front right wide  
  --*< front left high  
  --*< front center high  
  --*< front right high  
  --*< top center  
  --*< top front left  
  --*< top front right  
  --*< top front center  
  --*< top rear left  
  --*< top rear right  
  --*< top rear center  
  --*< top front left center  
  --*< top front right center  
  --*< top side left  
  --*< top side right  
  --*< left LFE  
  --*< right LFE  
  --*< bottom center  
  --*< bottom left center  
  --*< bottom right center  
  --* bitmask for channel position  
  --* bit flag indicating the channel is phase inverted  
  --* bit flag indicating the non-standard channel value  
  --* the channel map header  
  --*< number of channels  
   type snd_pcm_chmap_pos_array is array (0 .. -1) of aliased unsigned;
   type snd_pcm_chmap is record
      channels : aliased unsigned;  -- ./alsa/pcm.h:589
      pos : aliased snd_pcm_chmap_pos_array;  -- ./alsa/pcm.h:590
   end record;
   pragma Convention (C_Pass_By_Copy, snd_pcm_chmap);  -- ./alsa/pcm.h:588

  --*< channel position array  
   subtype snd_pcm_chmap_t is snd_pcm_chmap;

  --* the header of array items returned from snd_pcm_query_chmaps()  
  --*< channel map type  
   type snd_pcm_chmap_query is record
      c_type : aliased snd_pcm_chmap_type;  -- ./alsa/pcm.h:595
      map : aliased snd_pcm_chmap_t;  -- ./alsa/pcm.h:596
   end record;
   pragma Convention (C_Pass_By_Copy, snd_pcm_chmap_query);  -- ./alsa/pcm.h:594

  --*< available channel map  
   subtype snd_pcm_chmap_query_t is snd_pcm_chmap_query;

   function snd_pcm_query_chmaps (pcm : System.Address) return System.Address;  -- ./alsa/pcm.h:600
   pragma Import (C, snd_pcm_query_chmaps, "snd_pcm_query_chmaps");

   function snd_pcm_query_chmaps_from_hw
     (card : int;
      dev : int;
      subdev : int;
      stream : snd_pcm_stream_t) return System.Address;  -- ./alsa/pcm.h:601
   pragma Import (C, snd_pcm_query_chmaps_from_hw, "snd_pcm_query_chmaps_from_hw");

   procedure snd_pcm_free_chmaps (maps : System.Address);  -- ./alsa/pcm.h:604
   pragma Import (C, snd_pcm_free_chmaps, "snd_pcm_free_chmaps");

   function snd_pcm_get_chmap (pcm : System.Address) return access snd_pcm_chmap_t;  -- ./alsa/pcm.h:605
   pragma Import (C, snd_pcm_get_chmap, "snd_pcm_get_chmap");

   function snd_pcm_set_chmap (pcm : System.Address; map : System.Address) return int;  -- ./alsa/pcm.h:606
   pragma Import (C, snd_pcm_set_chmap, "snd_pcm_set_chmap");

   function snd_pcm_chmap_type_name (val : snd_pcm_chmap_type) return Interfaces.C.Strings.chars_ptr;  -- ./alsa/pcm.h:608
   pragma Import (C, snd_pcm_chmap_type_name, "snd_pcm_chmap_type_name");

   function snd_pcm_chmap_name (val : snd_pcm_chmap_position) return Interfaces.C.Strings.chars_ptr;  -- ./alsa/pcm.h:609
   pragma Import (C, snd_pcm_chmap_name, "snd_pcm_chmap_name");

   function snd_pcm_chmap_long_name (val : snd_pcm_chmap_position) return Interfaces.C.Strings.chars_ptr;  -- ./alsa/pcm.h:610
   pragma Import (C, snd_pcm_chmap_long_name, "snd_pcm_chmap_long_name");

   function snd_pcm_chmap_print
     (map : System.Address;
      maxlen : stddef_h.size_t;
      buf : Interfaces.C.Strings.chars_ptr) return int;  -- ./alsa/pcm.h:611
   pragma Import (C, snd_pcm_chmap_print, "snd_pcm_chmap_print");

   function snd_pcm_chmap_from_string (str : Interfaces.C.Strings.chars_ptr) return unsigned;  -- ./alsa/pcm.h:612
   pragma Import (C, snd_pcm_chmap_from_string, "snd_pcm_chmap_from_string");

   function snd_pcm_chmap_parse_string (str : Interfaces.C.Strings.chars_ptr) return access snd_pcm_chmap_t;  -- ./alsa/pcm.h:613
   pragma Import (C, snd_pcm_chmap_parse_string, "snd_pcm_chmap_parse_string");

  --int snd_pcm_mixer_element(snd_pcm_t *pcm, snd_mixer_t *mixer, snd_mixer_elem_t **elem);
  -- * application helpers - these functions are implemented on top
  -- * of the basic API
  --  

   function snd_pcm_recover
     (pcm : System.Address;
      err : int;
      silent : int) return int;  -- ./alsa/pcm.h:622
   pragma Import (C, snd_pcm_recover, "snd_pcm_recover");

   function snd_pcm_set_params
     (pcm : System.Address;
      format : snd_pcm_format_t;
      c_access : snd_pcm_access_t;
      channels : unsigned;
      rate : unsigned;
      soft_resample : int;
      latency : unsigned) return int;  -- ./alsa/pcm.h:623
   pragma Import (C, snd_pcm_set_params, "snd_pcm_set_params");

   function snd_pcm_get_params
     (pcm : System.Address;
      buffer_size : access snd_pcm_uframes_t;
      period_size : access snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:630
   pragma Import (C, snd_pcm_get_params, "snd_pcm_get_params");

  --* \}  
  --*
  -- * \defgroup PCM_Info Stream Information
  -- * \ingroup PCM
  -- * See the \ref pcm page for more details.
  -- * \{
  --  

   function snd_pcm_info_sizeof return stddef_h.size_t;  -- ./alsa/pcm.h:643
   pragma Import (C, snd_pcm_info_sizeof, "snd_pcm_info_sizeof");

  --* \hideinitializer
  -- * \brief allocate an invalid #snd_pcm_info_t using standard alloca
  -- * \param ptr returned pointer
  --  

   function snd_pcm_info_malloc (ptr : System.Address) return int;  -- ./alsa/pcm.h:649
   pragma Import (C, snd_pcm_info_malloc, "snd_pcm_info_malloc");

   procedure snd_pcm_info_free (obj : System.Address);  -- ./alsa/pcm.h:650
   pragma Import (C, snd_pcm_info_free, "snd_pcm_info_free");

   procedure snd_pcm_info_copy (dst : System.Address; src : System.Address);  -- ./alsa/pcm.h:651
   pragma Import (C, snd_pcm_info_copy, "snd_pcm_info_copy");

   function snd_pcm_info_get_device (obj : System.Address) return unsigned;  -- ./alsa/pcm.h:652
   pragma Import (C, snd_pcm_info_get_device, "snd_pcm_info_get_device");

   function snd_pcm_info_get_subdevice (obj : System.Address) return unsigned;  -- ./alsa/pcm.h:653
   pragma Import (C, snd_pcm_info_get_subdevice, "snd_pcm_info_get_subdevice");

   function snd_pcm_info_get_stream (obj : System.Address) return snd_pcm_stream_t;  -- ./alsa/pcm.h:654
   pragma Import (C, snd_pcm_info_get_stream, "snd_pcm_info_get_stream");

   function snd_pcm_info_get_card (obj : System.Address) return int;  -- ./alsa/pcm.h:655
   pragma Import (C, snd_pcm_info_get_card, "snd_pcm_info_get_card");

   function snd_pcm_info_get_id (obj : System.Address) return Interfaces.C.Strings.chars_ptr;  -- ./alsa/pcm.h:656
   pragma Import (C, snd_pcm_info_get_id, "snd_pcm_info_get_id");

   function snd_pcm_info_get_name (obj : System.Address) return Interfaces.C.Strings.chars_ptr;  -- ./alsa/pcm.h:657
   pragma Import (C, snd_pcm_info_get_name, "snd_pcm_info_get_name");

   function snd_pcm_info_get_subdevice_name (obj : System.Address) return Interfaces.C.Strings.chars_ptr;  -- ./alsa/pcm.h:658
   pragma Import (C, snd_pcm_info_get_subdevice_name, "snd_pcm_info_get_subdevice_name");

   function snd_pcm_info_get_class (obj : System.Address) return snd_pcm_class_t;  -- ./alsa/pcm.h:659
   pragma Import (C, snd_pcm_info_get_class, "snd_pcm_info_get_class");

   function snd_pcm_info_get_subclass (obj : System.Address) return snd_pcm_subclass_t;  -- ./alsa/pcm.h:660
   pragma Import (C, snd_pcm_info_get_subclass, "snd_pcm_info_get_subclass");

   function snd_pcm_info_get_subdevices_count (obj : System.Address) return unsigned;  -- ./alsa/pcm.h:661
   pragma Import (C, snd_pcm_info_get_subdevices_count, "snd_pcm_info_get_subdevices_count");

   function snd_pcm_info_get_subdevices_avail (obj : System.Address) return unsigned;  -- ./alsa/pcm.h:662
   pragma Import (C, snd_pcm_info_get_subdevices_avail, "snd_pcm_info_get_subdevices_avail");

   function snd_pcm_info_get_sync (obj : System.Address) return snd_pcm_sync_id_t;  -- ./alsa/pcm.h:663
   pragma Import (C, snd_pcm_info_get_sync, "snd_pcm_info_get_sync");

   procedure snd_pcm_info_set_device (obj : System.Address; val : unsigned);  -- ./alsa/pcm.h:664
   pragma Import (C, snd_pcm_info_set_device, "snd_pcm_info_set_device");

   procedure snd_pcm_info_set_subdevice (obj : System.Address; val : unsigned);  -- ./alsa/pcm.h:665
   pragma Import (C, snd_pcm_info_set_subdevice, "snd_pcm_info_set_subdevice");

   procedure snd_pcm_info_set_stream (obj : System.Address; val : snd_pcm_stream_t);  -- ./alsa/pcm.h:666
   pragma Import (C, snd_pcm_info_set_stream, "snd_pcm_info_set_stream");

  --* \}  
  --*
  -- * \defgroup PCM_HW_Params Hardware Parameters
  -- * \ingroup PCM
  -- * See the \ref pcm page for more details.
  -- * \{
  --  

   function snd_pcm_hw_params_any (pcm : System.Address; params : System.Address) return int;  -- ./alsa/pcm.h:677
   pragma Import (C, snd_pcm_hw_params_any, "snd_pcm_hw_params_any");

   function snd_pcm_hw_params_can_mmap_sample_resolution (params : System.Address) return int;  -- ./alsa/pcm.h:679
   pragma Import (C, snd_pcm_hw_params_can_mmap_sample_resolution, "snd_pcm_hw_params_can_mmap_sample_resolution");

   function snd_pcm_hw_params_is_double (params : System.Address) return int;  -- ./alsa/pcm.h:680
   pragma Import (C, snd_pcm_hw_params_is_double, "snd_pcm_hw_params_is_double");

   function snd_pcm_hw_params_is_batch (params : System.Address) return int;  -- ./alsa/pcm.h:681
   pragma Import (C, snd_pcm_hw_params_is_batch, "snd_pcm_hw_params_is_batch");

   function snd_pcm_hw_params_is_block_transfer (params : System.Address) return int;  -- ./alsa/pcm.h:682
   pragma Import (C, snd_pcm_hw_params_is_block_transfer, "snd_pcm_hw_params_is_block_transfer");

   function snd_pcm_hw_params_is_monotonic (params : System.Address) return int;  -- ./alsa/pcm.h:683
   pragma Import (C, snd_pcm_hw_params_is_monotonic, "snd_pcm_hw_params_is_monotonic");

   function snd_pcm_hw_params_can_overrange (params : System.Address) return int;  -- ./alsa/pcm.h:684
   pragma Import (C, snd_pcm_hw_params_can_overrange, "snd_pcm_hw_params_can_overrange");

   function snd_pcm_hw_params_can_pause (params : System.Address) return int;  -- ./alsa/pcm.h:685
   pragma Import (C, snd_pcm_hw_params_can_pause, "snd_pcm_hw_params_can_pause");

   function snd_pcm_hw_params_can_resume (params : System.Address) return int;  -- ./alsa/pcm.h:686
   pragma Import (C, snd_pcm_hw_params_can_resume, "snd_pcm_hw_params_can_resume");

   function snd_pcm_hw_params_is_half_duplex (params : System.Address) return int;  -- ./alsa/pcm.h:687
   pragma Import (C, snd_pcm_hw_params_is_half_duplex, "snd_pcm_hw_params_is_half_duplex");

   function snd_pcm_hw_params_is_joint_duplex (params : System.Address) return int;  -- ./alsa/pcm.h:688
   pragma Import (C, snd_pcm_hw_params_is_joint_duplex, "snd_pcm_hw_params_is_joint_duplex");

   function snd_pcm_hw_params_can_sync_start (params : System.Address) return int;  -- ./alsa/pcm.h:689
   pragma Import (C, snd_pcm_hw_params_can_sync_start, "snd_pcm_hw_params_can_sync_start");

   function snd_pcm_hw_params_can_disable_period_wakeup (params : System.Address) return int;  -- ./alsa/pcm.h:690
   pragma Import (C, snd_pcm_hw_params_can_disable_period_wakeup, "snd_pcm_hw_params_can_disable_period_wakeup");

  -- deprecated, use audio_ts_type  
   function snd_pcm_hw_params_supports_audio_wallclock_ts (params : System.Address) return int;  -- ./alsa/pcm.h:691
   pragma Import (C, snd_pcm_hw_params_supports_audio_wallclock_ts, "snd_pcm_hw_params_supports_audio_wallclock_ts");

   function snd_pcm_hw_params_supports_audio_ts_type (params : System.Address; c_type : int) return int;  -- ./alsa/pcm.h:692
   pragma Import (C, snd_pcm_hw_params_supports_audio_ts_type, "snd_pcm_hw_params_supports_audio_ts_type");

   function snd_pcm_hw_params_get_rate_numden
     (params : System.Address;
      rate_num : access unsigned;
      rate_den : access unsigned) return int;  -- ./alsa/pcm.h:693
   pragma Import (C, snd_pcm_hw_params_get_rate_numden, "snd_pcm_hw_params_get_rate_numden");

   function snd_pcm_hw_params_get_sbits (params : System.Address) return int;  -- ./alsa/pcm.h:696
   pragma Import (C, snd_pcm_hw_params_get_sbits, "snd_pcm_hw_params_get_sbits");

   function snd_pcm_hw_params_get_fifo_size (params : System.Address) return int;  -- ./alsa/pcm.h:697
   pragma Import (C, snd_pcm_hw_params_get_fifo_size, "snd_pcm_hw_params_get_fifo_size");

  -- choices need to be sorted on ascending badness  
   function snd_pcm_hw_params_sizeof return stddef_h.size_t;  -- ./alsa/pcm.h:725
   pragma Import (C, snd_pcm_hw_params_sizeof, "snd_pcm_hw_params_sizeof");

  --* \hideinitializer
  -- * \brief allocate an invalid #snd_pcm_hw_params_t using standard alloca
  -- * \param ptr returned pointer
  --  

   function snd_pcm_hw_params_malloc (ptr : System.Address) return int;  -- ./alsa/pcm.h:731
   pragma Import (C, snd_pcm_hw_params_malloc, "snd_pcm_hw_params_malloc");

   procedure snd_pcm_hw_params_free (obj : System.Address);  -- ./alsa/pcm.h:732
   pragma Import (C, snd_pcm_hw_params_free, "snd_pcm_hw_params_free");

   procedure snd_pcm_hw_params_copy (dst : System.Address; src : System.Address);  -- ./alsa/pcm.h:733
   pragma Import (C, snd_pcm_hw_params_copy, "snd_pcm_hw_params_copy");

   function snd_pcm_hw_params_get_access (params : System.Address; u_access : access snd_pcm_access_t) return int;  -- ./alsa/pcm.h:737
   pragma Import (C, snd_pcm_hw_params_get_access, "snd_pcm_hw_params_get_access");

   function snd_pcm_hw_params_test_access
     (pcm : System.Address;
      params : System.Address;
      u_access : snd_pcm_access_t) return int;  -- ./alsa/pcm.h:738
   pragma Import (C, snd_pcm_hw_params_test_access, "snd_pcm_hw_params_test_access");

   function snd_pcm_hw_params_set_access
     (pcm : System.Address;
      params : System.Address;
      u_access : snd_pcm_access_t) return int;  -- ./alsa/pcm.h:739
   pragma Import (C, snd_pcm_hw_params_set_access, "snd_pcm_hw_params_set_access");

   function snd_pcm_hw_params_set_access_first
     (pcm : System.Address;
      params : System.Address;
      u_access : access snd_pcm_access_t) return int;  -- ./alsa/pcm.h:740
   pragma Import (C, snd_pcm_hw_params_set_access_first, "snd_pcm_hw_params_set_access_first");

   function snd_pcm_hw_params_set_access_last
     (pcm : System.Address;
      params : System.Address;
      u_access : access snd_pcm_access_t) return int;  -- ./alsa/pcm.h:741
   pragma Import (C, snd_pcm_hw_params_set_access_last, "snd_pcm_hw_params_set_access_last");

   function snd_pcm_hw_params_set_access_mask
     (pcm : System.Address;
      params : System.Address;
      mask : System.Address) return int;  -- ./alsa/pcm.h:742
   pragma Import (C, snd_pcm_hw_params_set_access_mask, "snd_pcm_hw_params_set_access_mask");

   function snd_pcm_hw_params_get_access_mask (params : System.Address; mask : System.Address) return int;  -- ./alsa/pcm.h:743
   pragma Import (C, snd_pcm_hw_params_get_access_mask, "snd_pcm_hw_params_get_access_mask");

   function snd_pcm_hw_params_get_format (params : System.Address; val : access snd_pcm_format_t) return int;  -- ./alsa/pcm.h:745
   pragma Import (C, snd_pcm_hw_params_get_format, "snd_pcm_hw_params_get_format");

   function snd_pcm_hw_params_test_format
     (pcm : System.Address;
      params : System.Address;
      val : snd_pcm_format_t) return int;  -- ./alsa/pcm.h:746
   pragma Import (C, snd_pcm_hw_params_test_format, "snd_pcm_hw_params_test_format");

   function snd_pcm_hw_params_set_format
     (pcm : System.Address;
      params : System.Address;
      val : snd_pcm_format_t) return int;  -- ./alsa/pcm.h:747
   pragma Import (C, snd_pcm_hw_params_set_format, "snd_pcm_hw_params_set_format");

   function snd_pcm_hw_params_set_format_first
     (pcm : System.Address;
      params : System.Address;
      format : access snd_pcm_format_t) return int;  -- ./alsa/pcm.h:748
   pragma Import (C, snd_pcm_hw_params_set_format_first, "snd_pcm_hw_params_set_format_first");

   function snd_pcm_hw_params_set_format_last
     (pcm : System.Address;
      params : System.Address;
      format : access snd_pcm_format_t) return int;  -- ./alsa/pcm.h:749
   pragma Import (C, snd_pcm_hw_params_set_format_last, "snd_pcm_hw_params_set_format_last");

   function snd_pcm_hw_params_set_format_mask
     (pcm : System.Address;
      params : System.Address;
      mask : System.Address) return int;  -- ./alsa/pcm.h:750
   pragma Import (C, snd_pcm_hw_params_set_format_mask, "snd_pcm_hw_params_set_format_mask");

   procedure snd_pcm_hw_params_get_format_mask (params : System.Address; mask : System.Address);  -- ./alsa/pcm.h:751
   pragma Import (C, snd_pcm_hw_params_get_format_mask, "snd_pcm_hw_params_get_format_mask");

   function snd_pcm_hw_params_get_subformat (params : System.Address; subformat : access snd_pcm_subformat_t) return int;  -- ./alsa/pcm.h:753
   pragma Import (C, snd_pcm_hw_params_get_subformat, "snd_pcm_hw_params_get_subformat");

   function snd_pcm_hw_params_test_subformat
     (pcm : System.Address;
      params : System.Address;
      subformat : snd_pcm_subformat_t) return int;  -- ./alsa/pcm.h:754
   pragma Import (C, snd_pcm_hw_params_test_subformat, "snd_pcm_hw_params_test_subformat");

   function snd_pcm_hw_params_set_subformat
     (pcm : System.Address;
      params : System.Address;
      subformat : snd_pcm_subformat_t) return int;  -- ./alsa/pcm.h:755
   pragma Import (C, snd_pcm_hw_params_set_subformat, "snd_pcm_hw_params_set_subformat");

   function snd_pcm_hw_params_set_subformat_first
     (pcm : System.Address;
      params : System.Address;
      subformat : access snd_pcm_subformat_t) return int;  -- ./alsa/pcm.h:756
   pragma Import (C, snd_pcm_hw_params_set_subformat_first, "snd_pcm_hw_params_set_subformat_first");

   function snd_pcm_hw_params_set_subformat_last
     (pcm : System.Address;
      params : System.Address;
      subformat : access snd_pcm_subformat_t) return int;  -- ./alsa/pcm.h:757
   pragma Import (C, snd_pcm_hw_params_set_subformat_last, "snd_pcm_hw_params_set_subformat_last");

   function snd_pcm_hw_params_set_subformat_mask
     (pcm : System.Address;
      params : System.Address;
      mask : System.Address) return int;  -- ./alsa/pcm.h:758
   pragma Import (C, snd_pcm_hw_params_set_subformat_mask, "snd_pcm_hw_params_set_subformat_mask");

   procedure snd_pcm_hw_params_get_subformat_mask (params : System.Address; mask : System.Address);  -- ./alsa/pcm.h:759
   pragma Import (C, snd_pcm_hw_params_get_subformat_mask, "snd_pcm_hw_params_get_subformat_mask");

   function snd_pcm_hw_params_get_channels (params : System.Address; val : access unsigned) return int;  -- ./alsa/pcm.h:761
   pragma Import (C, snd_pcm_hw_params_get_channels, "snd_pcm_hw_params_get_channels");

   function snd_pcm_hw_params_get_channels_min (params : System.Address; val : access unsigned) return int;  -- ./alsa/pcm.h:762
   pragma Import (C, snd_pcm_hw_params_get_channels_min, "snd_pcm_hw_params_get_channels_min");

   function snd_pcm_hw_params_get_channels_max (params : System.Address; val : access unsigned) return int;  -- ./alsa/pcm.h:763
   pragma Import (C, snd_pcm_hw_params_get_channels_max, "snd_pcm_hw_params_get_channels_max");

   function snd_pcm_hw_params_test_channels
     (pcm : System.Address;
      params : System.Address;
      val : unsigned) return int;  -- ./alsa/pcm.h:764
   pragma Import (C, snd_pcm_hw_params_test_channels, "snd_pcm_hw_params_test_channels");

   function snd_pcm_hw_params_set_channels
     (pcm : System.Address;
      params : System.Address;
      val : unsigned) return int;  -- ./alsa/pcm.h:765
   pragma Import (C, snd_pcm_hw_params_set_channels, "snd_pcm_hw_params_set_channels");

   function snd_pcm_hw_params_set_channels_min
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned) return int;  -- ./alsa/pcm.h:766
   pragma Import (C, snd_pcm_hw_params_set_channels_min, "snd_pcm_hw_params_set_channels_min");

   function snd_pcm_hw_params_set_channels_max
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned) return int;  -- ./alsa/pcm.h:767
   pragma Import (C, snd_pcm_hw_params_set_channels_max, "snd_pcm_hw_params_set_channels_max");

   function snd_pcm_hw_params_set_channels_minmax
     (pcm : System.Address;
      params : System.Address;
      min : access unsigned;
      max : access unsigned) return int;  -- ./alsa/pcm.h:768
   pragma Import (C, snd_pcm_hw_params_set_channels_minmax, "snd_pcm_hw_params_set_channels_minmax");

   function snd_pcm_hw_params_set_channels_near
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned) return int;  -- ./alsa/pcm.h:769
   pragma Import (C, snd_pcm_hw_params_set_channels_near, "snd_pcm_hw_params_set_channels_near");

   function snd_pcm_hw_params_set_channels_first
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned) return int;  -- ./alsa/pcm.h:770
   pragma Import (C, snd_pcm_hw_params_set_channels_first, "snd_pcm_hw_params_set_channels_first");

   function snd_pcm_hw_params_set_channels_last
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned) return int;  -- ./alsa/pcm.h:771
   pragma Import (C, snd_pcm_hw_params_set_channels_last, "snd_pcm_hw_params_set_channels_last");

   function snd_pcm_hw_params_get_rate
     (params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:773
   pragma Import (C, snd_pcm_hw_params_get_rate, "snd_pcm_hw_params_get_rate");

   function snd_pcm_hw_params_get_rate_min
     (params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:774
   pragma Import (C, snd_pcm_hw_params_get_rate_min, "snd_pcm_hw_params_get_rate_min");

   function snd_pcm_hw_params_get_rate_max
     (params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:775
   pragma Import (C, snd_pcm_hw_params_get_rate_max, "snd_pcm_hw_params_get_rate_max");

   function snd_pcm_hw_params_test_rate
     (pcm : System.Address;
      params : System.Address;
      val : unsigned;
      dir : int) return int;  -- ./alsa/pcm.h:776
   pragma Import (C, snd_pcm_hw_params_test_rate, "snd_pcm_hw_params_test_rate");

   function snd_pcm_hw_params_set_rate
     (pcm : System.Address;
      params : System.Address;
      val : unsigned;
      dir : int) return int;  -- ./alsa/pcm.h:777
   pragma Import (C, snd_pcm_hw_params_set_rate, "snd_pcm_hw_params_set_rate");

   function snd_pcm_hw_params_set_rate_min
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:778
   pragma Import (C, snd_pcm_hw_params_set_rate_min, "snd_pcm_hw_params_set_rate_min");

   function snd_pcm_hw_params_set_rate_max
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:779
   pragma Import (C, snd_pcm_hw_params_set_rate_max, "snd_pcm_hw_params_set_rate_max");

   function snd_pcm_hw_params_set_rate_minmax
     (pcm : System.Address;
      params : System.Address;
      min : access unsigned;
      mindir : access int;
      max : access unsigned;
      maxdir : access int) return int;  -- ./alsa/pcm.h:780
   pragma Import (C, snd_pcm_hw_params_set_rate_minmax, "snd_pcm_hw_params_set_rate_minmax");

   function snd_pcm_hw_params_set_rate_near
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:781
   pragma Import (C, snd_pcm_hw_params_set_rate_near, "snd_pcm_hw_params_set_rate_near");

   function snd_pcm_hw_params_set_rate_first
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:782
   pragma Import (C, snd_pcm_hw_params_set_rate_first, "snd_pcm_hw_params_set_rate_first");

   function snd_pcm_hw_params_set_rate_last
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:783
   pragma Import (C, snd_pcm_hw_params_set_rate_last, "snd_pcm_hw_params_set_rate_last");

   function snd_pcm_hw_params_set_rate_resample
     (pcm : System.Address;
      params : System.Address;
      val : unsigned) return int;  -- ./alsa/pcm.h:784
   pragma Import (C, snd_pcm_hw_params_set_rate_resample, "snd_pcm_hw_params_set_rate_resample");

   function snd_pcm_hw_params_get_rate_resample
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned) return int;  -- ./alsa/pcm.h:785
   pragma Import (C, snd_pcm_hw_params_get_rate_resample, "snd_pcm_hw_params_get_rate_resample");

   function snd_pcm_hw_params_set_export_buffer
     (pcm : System.Address;
      params : System.Address;
      val : unsigned) return int;  -- ./alsa/pcm.h:786
   pragma Import (C, snd_pcm_hw_params_set_export_buffer, "snd_pcm_hw_params_set_export_buffer");

   function snd_pcm_hw_params_get_export_buffer
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned) return int;  -- ./alsa/pcm.h:787
   pragma Import (C, snd_pcm_hw_params_get_export_buffer, "snd_pcm_hw_params_get_export_buffer");

   function snd_pcm_hw_params_set_period_wakeup
     (pcm : System.Address;
      params : System.Address;
      val : unsigned) return int;  -- ./alsa/pcm.h:788
   pragma Import (C, snd_pcm_hw_params_set_period_wakeup, "snd_pcm_hw_params_set_period_wakeup");

   function snd_pcm_hw_params_get_period_wakeup
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned) return int;  -- ./alsa/pcm.h:789
   pragma Import (C, snd_pcm_hw_params_get_period_wakeup, "snd_pcm_hw_params_get_period_wakeup");

   function snd_pcm_hw_params_get_period_time
     (params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:791
   pragma Import (C, snd_pcm_hw_params_get_period_time, "snd_pcm_hw_params_get_period_time");

   function snd_pcm_hw_params_get_period_time_min
     (params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:792
   pragma Import (C, snd_pcm_hw_params_get_period_time_min, "snd_pcm_hw_params_get_period_time_min");

   function snd_pcm_hw_params_get_period_time_max
     (params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:793
   pragma Import (C, snd_pcm_hw_params_get_period_time_max, "snd_pcm_hw_params_get_period_time_max");

   function snd_pcm_hw_params_test_period_time
     (pcm : System.Address;
      params : System.Address;
      val : unsigned;
      dir : int) return int;  -- ./alsa/pcm.h:794
   pragma Import (C, snd_pcm_hw_params_test_period_time, "snd_pcm_hw_params_test_period_time");

   function snd_pcm_hw_params_set_period_time
     (pcm : System.Address;
      params : System.Address;
      val : unsigned;
      dir : int) return int;  -- ./alsa/pcm.h:795
   pragma Import (C, snd_pcm_hw_params_set_period_time, "snd_pcm_hw_params_set_period_time");

   function snd_pcm_hw_params_set_period_time_min
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:796
   pragma Import (C, snd_pcm_hw_params_set_period_time_min, "snd_pcm_hw_params_set_period_time_min");

   function snd_pcm_hw_params_set_period_time_max
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:797
   pragma Import (C, snd_pcm_hw_params_set_period_time_max, "snd_pcm_hw_params_set_period_time_max");

   function snd_pcm_hw_params_set_period_time_minmax
     (pcm : System.Address;
      params : System.Address;
      min : access unsigned;
      mindir : access int;
      max : access unsigned;
      maxdir : access int) return int;  -- ./alsa/pcm.h:798
   pragma Import (C, snd_pcm_hw_params_set_period_time_minmax, "snd_pcm_hw_params_set_period_time_minmax");

   function snd_pcm_hw_params_set_period_time_near
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:799
   pragma Import (C, snd_pcm_hw_params_set_period_time_near, "snd_pcm_hw_params_set_period_time_near");

   function snd_pcm_hw_params_set_period_time_first
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:800
   pragma Import (C, snd_pcm_hw_params_set_period_time_first, "snd_pcm_hw_params_set_period_time_first");

   function snd_pcm_hw_params_set_period_time_last
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:801
   pragma Import (C, snd_pcm_hw_params_set_period_time_last, "snd_pcm_hw_params_set_period_time_last");

   function snd_pcm_hw_params_get_period_size
     (params : System.Address;
      frames : access snd_pcm_uframes_t;
      dir : access int) return int;  -- ./alsa/pcm.h:803
   pragma Import (C, snd_pcm_hw_params_get_period_size, "snd_pcm_hw_params_get_period_size");

   function snd_pcm_hw_params_get_period_size_min
     (params : System.Address;
      frames : access snd_pcm_uframes_t;
      dir : access int) return int;  -- ./alsa/pcm.h:804
   pragma Import (C, snd_pcm_hw_params_get_period_size_min, "snd_pcm_hw_params_get_period_size_min");

   function snd_pcm_hw_params_get_period_size_max
     (params : System.Address;
      frames : access snd_pcm_uframes_t;
      dir : access int) return int;  -- ./alsa/pcm.h:805
   pragma Import (C, snd_pcm_hw_params_get_period_size_max, "snd_pcm_hw_params_get_period_size_max");

   function snd_pcm_hw_params_test_period_size
     (pcm : System.Address;
      params : System.Address;
      val : snd_pcm_uframes_t;
      dir : int) return int;  -- ./alsa/pcm.h:806
   pragma Import (C, snd_pcm_hw_params_test_period_size, "snd_pcm_hw_params_test_period_size");

   function snd_pcm_hw_params_set_period_size
     (pcm : System.Address;
      params : System.Address;
      val : snd_pcm_uframes_t;
      dir : int) return int;  -- ./alsa/pcm.h:807
   pragma Import (C, snd_pcm_hw_params_set_period_size, "snd_pcm_hw_params_set_period_size");

   function snd_pcm_hw_params_set_period_size_min
     (pcm : System.Address;
      params : System.Address;
      val : access snd_pcm_uframes_t;
      dir : access int) return int;  -- ./alsa/pcm.h:808
   pragma Import (C, snd_pcm_hw_params_set_period_size_min, "snd_pcm_hw_params_set_period_size_min");

   function snd_pcm_hw_params_set_period_size_max
     (pcm : System.Address;
      params : System.Address;
      val : access snd_pcm_uframes_t;
      dir : access int) return int;  -- ./alsa/pcm.h:809
   pragma Import (C, snd_pcm_hw_params_set_period_size_max, "snd_pcm_hw_params_set_period_size_max");

   function snd_pcm_hw_params_set_period_size_minmax
     (pcm : System.Address;
      params : System.Address;
      min : access snd_pcm_uframes_t;
      mindir : access int;
      max : access snd_pcm_uframes_t;
      maxdir : access int) return int;  -- ./alsa/pcm.h:810
   pragma Import (C, snd_pcm_hw_params_set_period_size_minmax, "snd_pcm_hw_params_set_period_size_minmax");

   function snd_pcm_hw_params_set_period_size_near
     (pcm : System.Address;
      params : System.Address;
      val : access snd_pcm_uframes_t;
      dir : access int) return int;  -- ./alsa/pcm.h:811
   pragma Import (C, snd_pcm_hw_params_set_period_size_near, "snd_pcm_hw_params_set_period_size_near");

   function snd_pcm_hw_params_set_period_size_first
     (pcm : System.Address;
      params : System.Address;
      val : access snd_pcm_uframes_t;
      dir : access int) return int;  -- ./alsa/pcm.h:812
   pragma Import (C, snd_pcm_hw_params_set_period_size_first, "snd_pcm_hw_params_set_period_size_first");

   function snd_pcm_hw_params_set_period_size_last
     (pcm : System.Address;
      params : System.Address;
      val : access snd_pcm_uframes_t;
      dir : access int) return int;  -- ./alsa/pcm.h:813
   pragma Import (C, snd_pcm_hw_params_set_period_size_last, "snd_pcm_hw_params_set_period_size_last");

   function snd_pcm_hw_params_set_period_size_integer (pcm : System.Address; params : System.Address) return int;  -- ./alsa/pcm.h:814
   pragma Import (C, snd_pcm_hw_params_set_period_size_integer, "snd_pcm_hw_params_set_period_size_integer");

   function snd_pcm_hw_params_get_periods
     (params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:816
   pragma Import (C, snd_pcm_hw_params_get_periods, "snd_pcm_hw_params_get_periods");

   function snd_pcm_hw_params_get_periods_min
     (params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:817
   pragma Import (C, snd_pcm_hw_params_get_periods_min, "snd_pcm_hw_params_get_periods_min");

   function snd_pcm_hw_params_get_periods_max
     (params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:818
   pragma Import (C, snd_pcm_hw_params_get_periods_max, "snd_pcm_hw_params_get_periods_max");

   function snd_pcm_hw_params_test_periods
     (pcm : System.Address;
      params : System.Address;
      val : unsigned;
      dir : int) return int;  -- ./alsa/pcm.h:819
   pragma Import (C, snd_pcm_hw_params_test_periods, "snd_pcm_hw_params_test_periods");

   function snd_pcm_hw_params_set_periods
     (pcm : System.Address;
      params : System.Address;
      val : unsigned;
      dir : int) return int;  -- ./alsa/pcm.h:820
   pragma Import (C, snd_pcm_hw_params_set_periods, "snd_pcm_hw_params_set_periods");

   function snd_pcm_hw_params_set_periods_min
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:821
   pragma Import (C, snd_pcm_hw_params_set_periods_min, "snd_pcm_hw_params_set_periods_min");

   function snd_pcm_hw_params_set_periods_max
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:822
   pragma Import (C, snd_pcm_hw_params_set_periods_max, "snd_pcm_hw_params_set_periods_max");

   function snd_pcm_hw_params_set_periods_minmax
     (pcm : System.Address;
      params : System.Address;
      min : access unsigned;
      mindir : access int;
      max : access unsigned;
      maxdir : access int) return int;  -- ./alsa/pcm.h:823
   pragma Import (C, snd_pcm_hw_params_set_periods_minmax, "snd_pcm_hw_params_set_periods_minmax");

   function snd_pcm_hw_params_set_periods_near
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:824
   pragma Import (C, snd_pcm_hw_params_set_periods_near, "snd_pcm_hw_params_set_periods_near");

   function snd_pcm_hw_params_set_periods_first
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:825
   pragma Import (C, snd_pcm_hw_params_set_periods_first, "snd_pcm_hw_params_set_periods_first");

   function snd_pcm_hw_params_set_periods_last
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:826
   pragma Import (C, snd_pcm_hw_params_set_periods_last, "snd_pcm_hw_params_set_periods_last");

   function snd_pcm_hw_params_set_periods_integer (pcm : System.Address; params : System.Address) return int;  -- ./alsa/pcm.h:827
   pragma Import (C, snd_pcm_hw_params_set_periods_integer, "snd_pcm_hw_params_set_periods_integer");

   function snd_pcm_hw_params_get_buffer_time
     (params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:829
   pragma Import (C, snd_pcm_hw_params_get_buffer_time, "snd_pcm_hw_params_get_buffer_time");

   function snd_pcm_hw_params_get_buffer_time_min
     (params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:830
   pragma Import (C, snd_pcm_hw_params_get_buffer_time_min, "snd_pcm_hw_params_get_buffer_time_min");

   function snd_pcm_hw_params_get_buffer_time_max
     (params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:831
   pragma Import (C, snd_pcm_hw_params_get_buffer_time_max, "snd_pcm_hw_params_get_buffer_time_max");

   function snd_pcm_hw_params_test_buffer_time
     (pcm : System.Address;
      params : System.Address;
      val : unsigned;
      dir : int) return int;  -- ./alsa/pcm.h:832
   pragma Import (C, snd_pcm_hw_params_test_buffer_time, "snd_pcm_hw_params_test_buffer_time");

   function snd_pcm_hw_params_set_buffer_time
     (pcm : System.Address;
      params : System.Address;
      val : unsigned;
      dir : int) return int;  -- ./alsa/pcm.h:833
   pragma Import (C, snd_pcm_hw_params_set_buffer_time, "snd_pcm_hw_params_set_buffer_time");

   function snd_pcm_hw_params_set_buffer_time_min
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:834
   pragma Import (C, snd_pcm_hw_params_set_buffer_time_min, "snd_pcm_hw_params_set_buffer_time_min");

   function snd_pcm_hw_params_set_buffer_time_max
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:835
   pragma Import (C, snd_pcm_hw_params_set_buffer_time_max, "snd_pcm_hw_params_set_buffer_time_max");

   function snd_pcm_hw_params_set_buffer_time_minmax
     (pcm : System.Address;
      params : System.Address;
      min : access unsigned;
      mindir : access int;
      max : access unsigned;
      maxdir : access int) return int;  -- ./alsa/pcm.h:836
   pragma Import (C, snd_pcm_hw_params_set_buffer_time_minmax, "snd_pcm_hw_params_set_buffer_time_minmax");

   function snd_pcm_hw_params_set_buffer_time_near
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:837
   pragma Import (C, snd_pcm_hw_params_set_buffer_time_near, "snd_pcm_hw_params_set_buffer_time_near");

   function snd_pcm_hw_params_set_buffer_time_first
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:838
   pragma Import (C, snd_pcm_hw_params_set_buffer_time_first, "snd_pcm_hw_params_set_buffer_time_first");

   function snd_pcm_hw_params_set_buffer_time_last
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:839
   pragma Import (C, snd_pcm_hw_params_set_buffer_time_last, "snd_pcm_hw_params_set_buffer_time_last");

   function snd_pcm_hw_params_get_buffer_size (params : System.Address; val : access snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:841
   pragma Import (C, snd_pcm_hw_params_get_buffer_size, "snd_pcm_hw_params_get_buffer_size");

   function snd_pcm_hw_params_get_buffer_size_min (params : System.Address; val : access snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:842
   pragma Import (C, snd_pcm_hw_params_get_buffer_size_min, "snd_pcm_hw_params_get_buffer_size_min");

   function snd_pcm_hw_params_get_buffer_size_max (params : System.Address; val : access snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:843
   pragma Import (C, snd_pcm_hw_params_get_buffer_size_max, "snd_pcm_hw_params_get_buffer_size_max");

   function snd_pcm_hw_params_test_buffer_size
     (pcm : System.Address;
      params : System.Address;
      val : snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:844
   pragma Import (C, snd_pcm_hw_params_test_buffer_size, "snd_pcm_hw_params_test_buffer_size");

   function snd_pcm_hw_params_set_buffer_size
     (pcm : System.Address;
      params : System.Address;
      val : snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:845
   pragma Import (C, snd_pcm_hw_params_set_buffer_size, "snd_pcm_hw_params_set_buffer_size");

   function snd_pcm_hw_params_set_buffer_size_min
     (pcm : System.Address;
      params : System.Address;
      val : access snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:846
   pragma Import (C, snd_pcm_hw_params_set_buffer_size_min, "snd_pcm_hw_params_set_buffer_size_min");

   function snd_pcm_hw_params_set_buffer_size_max
     (pcm : System.Address;
      params : System.Address;
      val : access snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:847
   pragma Import (C, snd_pcm_hw_params_set_buffer_size_max, "snd_pcm_hw_params_set_buffer_size_max");

   function snd_pcm_hw_params_set_buffer_size_minmax
     (pcm : System.Address;
      params : System.Address;
      min : access snd_pcm_uframes_t;
      max : access snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:848
   pragma Import (C, snd_pcm_hw_params_set_buffer_size_minmax, "snd_pcm_hw_params_set_buffer_size_minmax");

   function snd_pcm_hw_params_set_buffer_size_near
     (pcm : System.Address;
      params : System.Address;
      val : access snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:849
   pragma Import (C, snd_pcm_hw_params_set_buffer_size_near, "snd_pcm_hw_params_set_buffer_size_near");

   function snd_pcm_hw_params_set_buffer_size_first
     (pcm : System.Address;
      params : System.Address;
      val : access snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:850
   pragma Import (C, snd_pcm_hw_params_set_buffer_size_first, "snd_pcm_hw_params_set_buffer_size_first");

   function snd_pcm_hw_params_set_buffer_size_last
     (pcm : System.Address;
      params : System.Address;
      val : access snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:851
   pragma Import (C, snd_pcm_hw_params_set_buffer_size_last, "snd_pcm_hw_params_set_buffer_size_last");

   function snd_pcm_hw_params_get_min_align (params : System.Address; val : access snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:855
   pragma Import (C, snd_pcm_hw_params_get_min_align, "snd_pcm_hw_params_get_min_align");

  --* \}  
  --*
  -- * \defgroup PCM_SW_Params Software Parameters
  -- * \ingroup PCM
  -- * See the \ref pcm page for more details.
  -- * \{
  --  

   function snd_pcm_sw_params_sizeof return stddef_h.size_t;  -- ./alsa/pcm.h:866
   pragma Import (C, snd_pcm_sw_params_sizeof, "snd_pcm_sw_params_sizeof");

  --* \hideinitializer
  -- * \brief allocate an invalid #snd_pcm_sw_params_t using standard alloca
  -- * \param ptr returned pointer
  --  

   function snd_pcm_sw_params_malloc (ptr : System.Address) return int;  -- ./alsa/pcm.h:872
   pragma Import (C, snd_pcm_sw_params_malloc, "snd_pcm_sw_params_malloc");

   procedure snd_pcm_sw_params_free (obj : System.Address);  -- ./alsa/pcm.h:873
   pragma Import (C, snd_pcm_sw_params_free, "snd_pcm_sw_params_free");

   procedure snd_pcm_sw_params_copy (dst : System.Address; src : System.Address);  -- ./alsa/pcm.h:874
   pragma Import (C, snd_pcm_sw_params_copy, "snd_pcm_sw_params_copy");

   function snd_pcm_sw_params_get_boundary (params : System.Address; val : access snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:875
   pragma Import (C, snd_pcm_sw_params_get_boundary, "snd_pcm_sw_params_get_boundary");

   function snd_pcm_sw_params_set_tstamp_mode
     (pcm : System.Address;
      params : System.Address;
      val : snd_pcm_tstamp_t) return int;  -- ./alsa/pcm.h:879
   pragma Import (C, snd_pcm_sw_params_set_tstamp_mode, "snd_pcm_sw_params_set_tstamp_mode");

   function snd_pcm_sw_params_get_tstamp_mode (params : System.Address; val : access snd_pcm_tstamp_t) return int;  -- ./alsa/pcm.h:880
   pragma Import (C, snd_pcm_sw_params_get_tstamp_mode, "snd_pcm_sw_params_get_tstamp_mode");

   function snd_pcm_sw_params_set_tstamp_type
     (pcm : System.Address;
      params : System.Address;
      val : snd_pcm_tstamp_type_t) return int;  -- ./alsa/pcm.h:881
   pragma Import (C, snd_pcm_sw_params_set_tstamp_type, "snd_pcm_sw_params_set_tstamp_type");

   function snd_pcm_sw_params_get_tstamp_type (params : System.Address; val : access snd_pcm_tstamp_type_t) return int;  -- ./alsa/pcm.h:882
   pragma Import (C, snd_pcm_sw_params_get_tstamp_type, "snd_pcm_sw_params_get_tstamp_type");

   function snd_pcm_sw_params_set_avail_min
     (pcm : System.Address;
      params : System.Address;
      val : snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:883
   pragma Import (C, snd_pcm_sw_params_set_avail_min, "snd_pcm_sw_params_set_avail_min");

   function snd_pcm_sw_params_get_avail_min (params : System.Address; val : access snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:884
   pragma Import (C, snd_pcm_sw_params_get_avail_min, "snd_pcm_sw_params_get_avail_min");

   function snd_pcm_sw_params_set_period_event
     (pcm : System.Address;
      params : System.Address;
      val : int) return int;  -- ./alsa/pcm.h:885
   pragma Import (C, snd_pcm_sw_params_set_period_event, "snd_pcm_sw_params_set_period_event");

   function snd_pcm_sw_params_get_period_event (params : System.Address; val : access int) return int;  -- ./alsa/pcm.h:886
   pragma Import (C, snd_pcm_sw_params_get_period_event, "snd_pcm_sw_params_get_period_event");

   function snd_pcm_sw_params_set_start_threshold
     (pcm : System.Address;
      params : System.Address;
      val : snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:887
   pragma Import (C, snd_pcm_sw_params_set_start_threshold, "snd_pcm_sw_params_set_start_threshold");

   function snd_pcm_sw_params_get_start_threshold (paramsm : System.Address; val : access snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:888
   pragma Import (C, snd_pcm_sw_params_get_start_threshold, "snd_pcm_sw_params_get_start_threshold");

   function snd_pcm_sw_params_set_stop_threshold
     (pcm : System.Address;
      params : System.Address;
      val : snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:889
   pragma Import (C, snd_pcm_sw_params_set_stop_threshold, "snd_pcm_sw_params_set_stop_threshold");

   function snd_pcm_sw_params_get_stop_threshold (params : System.Address; val : access snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:890
   pragma Import (C, snd_pcm_sw_params_get_stop_threshold, "snd_pcm_sw_params_get_stop_threshold");

   function snd_pcm_sw_params_set_silence_threshold
     (pcm : System.Address;
      params : System.Address;
      val : snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:891
   pragma Import (C, snd_pcm_sw_params_set_silence_threshold, "snd_pcm_sw_params_set_silence_threshold");

   function snd_pcm_sw_params_get_silence_threshold (params : System.Address; val : access snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:892
   pragma Import (C, snd_pcm_sw_params_get_silence_threshold, "snd_pcm_sw_params_get_silence_threshold");

   function snd_pcm_sw_params_set_silence_size
     (pcm : System.Address;
      params : System.Address;
      val : snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:893
   pragma Import (C, snd_pcm_sw_params_set_silence_size, "snd_pcm_sw_params_set_silence_size");

   function snd_pcm_sw_params_get_silence_size (params : System.Address; val : access snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:894
   pragma Import (C, snd_pcm_sw_params_get_silence_size, "snd_pcm_sw_params_get_silence_size");

  --* \}  
  -- include old API  
  --*
  -- * \defgroup PCM_Access Access Mask Functions
  -- * \ingroup PCM
  -- * See the \ref pcm page for more details.
  -- * \{
  --  

   function snd_pcm_access_mask_sizeof return stddef_h.size_t;  -- ./alsa/pcm.h:914
   pragma Import (C, snd_pcm_access_mask_sizeof, "snd_pcm_access_mask_sizeof");

  --* \hideinitializer
  -- * \brief allocate an empty #snd_pcm_access_mask_t using standard alloca
  -- * \param ptr returned pointer
  --  

   function snd_pcm_access_mask_malloc (ptr : System.Address) return int;  -- ./alsa/pcm.h:920
   pragma Import (C, snd_pcm_access_mask_malloc, "snd_pcm_access_mask_malloc");

   procedure snd_pcm_access_mask_free (obj : System.Address);  -- ./alsa/pcm.h:921
   pragma Import (C, snd_pcm_access_mask_free, "snd_pcm_access_mask_free");

   procedure snd_pcm_access_mask_copy (dst : System.Address; src : System.Address);  -- ./alsa/pcm.h:922
   pragma Import (C, snd_pcm_access_mask_copy, "snd_pcm_access_mask_copy");

   procedure snd_pcm_access_mask_none (mask : System.Address);  -- ./alsa/pcm.h:923
   pragma Import (C, snd_pcm_access_mask_none, "snd_pcm_access_mask_none");

   procedure snd_pcm_access_mask_any (mask : System.Address);  -- ./alsa/pcm.h:924
   pragma Import (C, snd_pcm_access_mask_any, "snd_pcm_access_mask_any");

   function snd_pcm_access_mask_test (mask : System.Address; val : snd_pcm_access_t) return int;  -- ./alsa/pcm.h:925
   pragma Import (C, snd_pcm_access_mask_test, "snd_pcm_access_mask_test");

   function snd_pcm_access_mask_empty (mask : System.Address) return int;  -- ./alsa/pcm.h:926
   pragma Import (C, snd_pcm_access_mask_empty, "snd_pcm_access_mask_empty");

   procedure snd_pcm_access_mask_set (mask : System.Address; val : snd_pcm_access_t);  -- ./alsa/pcm.h:927
   pragma Import (C, snd_pcm_access_mask_set, "snd_pcm_access_mask_set");

   procedure snd_pcm_access_mask_reset (mask : System.Address; val : snd_pcm_access_t);  -- ./alsa/pcm.h:928
   pragma Import (C, snd_pcm_access_mask_reset, "snd_pcm_access_mask_reset");

  --* \}  
  --*
  -- * \defgroup PCM_Format Format Mask Functions
  -- * \ingroup PCM
  -- * See the \ref pcm page for more details.
  -- * \{
  --  

   function snd_pcm_format_mask_sizeof return stddef_h.size_t;  -- ./alsa/pcm.h:939
   pragma Import (C, snd_pcm_format_mask_sizeof, "snd_pcm_format_mask_sizeof");

  --* \hideinitializer
  -- * \brief allocate an empty #snd_pcm_format_mask_t using standard alloca
  -- * \param ptr returned pointer
  --  

   function snd_pcm_format_mask_malloc (ptr : System.Address) return int;  -- ./alsa/pcm.h:945
   pragma Import (C, snd_pcm_format_mask_malloc, "snd_pcm_format_mask_malloc");

   procedure snd_pcm_format_mask_free (obj : System.Address);  -- ./alsa/pcm.h:946
   pragma Import (C, snd_pcm_format_mask_free, "snd_pcm_format_mask_free");

   procedure snd_pcm_format_mask_copy (dst : System.Address; src : System.Address);  -- ./alsa/pcm.h:947
   pragma Import (C, snd_pcm_format_mask_copy, "snd_pcm_format_mask_copy");

   procedure snd_pcm_format_mask_none (mask : System.Address);  -- ./alsa/pcm.h:948
   pragma Import (C, snd_pcm_format_mask_none, "snd_pcm_format_mask_none");

   procedure snd_pcm_format_mask_any (mask : System.Address);  -- ./alsa/pcm.h:949
   pragma Import (C, snd_pcm_format_mask_any, "snd_pcm_format_mask_any");

   function snd_pcm_format_mask_test (mask : System.Address; val : snd_pcm_format_t) return int;  -- ./alsa/pcm.h:950
   pragma Import (C, snd_pcm_format_mask_test, "snd_pcm_format_mask_test");

   function snd_pcm_format_mask_empty (mask : System.Address) return int;  -- ./alsa/pcm.h:951
   pragma Import (C, snd_pcm_format_mask_empty, "snd_pcm_format_mask_empty");

   procedure snd_pcm_format_mask_set (mask : System.Address; val : snd_pcm_format_t);  -- ./alsa/pcm.h:952
   pragma Import (C, snd_pcm_format_mask_set, "snd_pcm_format_mask_set");

   procedure snd_pcm_format_mask_reset (mask : System.Address; val : snd_pcm_format_t);  -- ./alsa/pcm.h:953
   pragma Import (C, snd_pcm_format_mask_reset, "snd_pcm_format_mask_reset");

  --* \}  
  --*
  -- * \defgroup PCM_SubFormat Subformat Mask Functions
  -- * \ingroup PCM
  -- * See the \ref pcm page for more details.
  -- * \{
  --  

   function snd_pcm_subformat_mask_sizeof return stddef_h.size_t;  -- ./alsa/pcm.h:964
   pragma Import (C, snd_pcm_subformat_mask_sizeof, "snd_pcm_subformat_mask_sizeof");

  --* \hideinitializer
  -- * \brief allocate an empty #snd_pcm_subformat_mask_t using standard alloca
  -- * \param ptr returned pointer
  --  

   function snd_pcm_subformat_mask_malloc (ptr : System.Address) return int;  -- ./alsa/pcm.h:970
   pragma Import (C, snd_pcm_subformat_mask_malloc, "snd_pcm_subformat_mask_malloc");

   procedure snd_pcm_subformat_mask_free (obj : System.Address);  -- ./alsa/pcm.h:971
   pragma Import (C, snd_pcm_subformat_mask_free, "snd_pcm_subformat_mask_free");

   procedure snd_pcm_subformat_mask_copy (dst : System.Address; src : System.Address);  -- ./alsa/pcm.h:972
   pragma Import (C, snd_pcm_subformat_mask_copy, "snd_pcm_subformat_mask_copy");

   procedure snd_pcm_subformat_mask_none (mask : System.Address);  -- ./alsa/pcm.h:973
   pragma Import (C, snd_pcm_subformat_mask_none, "snd_pcm_subformat_mask_none");

   procedure snd_pcm_subformat_mask_any (mask : System.Address);  -- ./alsa/pcm.h:974
   pragma Import (C, snd_pcm_subformat_mask_any, "snd_pcm_subformat_mask_any");

   function snd_pcm_subformat_mask_test (mask : System.Address; val : snd_pcm_subformat_t) return int;  -- ./alsa/pcm.h:975
   pragma Import (C, snd_pcm_subformat_mask_test, "snd_pcm_subformat_mask_test");

   function snd_pcm_subformat_mask_empty (mask : System.Address) return int;  -- ./alsa/pcm.h:976
   pragma Import (C, snd_pcm_subformat_mask_empty, "snd_pcm_subformat_mask_empty");

   procedure snd_pcm_subformat_mask_set (mask : System.Address; val : snd_pcm_subformat_t);  -- ./alsa/pcm.h:977
   pragma Import (C, snd_pcm_subformat_mask_set, "snd_pcm_subformat_mask_set");

   procedure snd_pcm_subformat_mask_reset (mask : System.Address; val : snd_pcm_subformat_t);  -- ./alsa/pcm.h:978
   pragma Import (C, snd_pcm_subformat_mask_reset, "snd_pcm_subformat_mask_reset");

  --* \}  
  --*
  -- * \defgroup PCM_Status Status Functions
  -- * \ingroup PCM
  -- * See the \ref pcm page for more details.
  -- * \{
  --  

   function snd_pcm_status_sizeof return stddef_h.size_t;  -- ./alsa/pcm.h:989
   pragma Import (C, snd_pcm_status_sizeof, "snd_pcm_status_sizeof");

  --* \hideinitializer
  -- * \brief allocate an invalid #snd_pcm_status_t using standard alloca
  -- * \param ptr returned pointer
  --  

   function snd_pcm_status_malloc (ptr : System.Address) return int;  -- ./alsa/pcm.h:995
   pragma Import (C, snd_pcm_status_malloc, "snd_pcm_status_malloc");

   procedure snd_pcm_status_free (obj : System.Address);  -- ./alsa/pcm.h:996
   pragma Import (C, snd_pcm_status_free, "snd_pcm_status_free");

   procedure snd_pcm_status_copy (dst : System.Address; src : System.Address);  -- ./alsa/pcm.h:997
   pragma Import (C, snd_pcm_status_copy, "snd_pcm_status_copy");

   function snd_pcm_status_get_state (obj : System.Address) return snd_pcm_state_t;  -- ./alsa/pcm.h:998
   pragma Import (C, snd_pcm_status_get_state, "snd_pcm_status_get_state");

   procedure snd_pcm_status_get_trigger_tstamp (obj : System.Address; ptr : access global_h.snd_timestamp_t);  -- ./alsa/pcm.h:999
   pragma Import (C, snd_pcm_status_get_trigger_tstamp, "snd_pcm_status_get_trigger_tstamp");

   procedure snd_pcm_status_get_trigger_htstamp (obj : System.Address; ptr : access global_h.snd_htimestamp_t);  -- ./alsa/pcm.h:1000
   pragma Import (C, snd_pcm_status_get_trigger_htstamp, "snd_pcm_status_get_trigger_htstamp");

   procedure snd_pcm_status_get_tstamp (obj : System.Address; ptr : access global_h.snd_timestamp_t);  -- ./alsa/pcm.h:1001
   pragma Import (C, snd_pcm_status_get_tstamp, "snd_pcm_status_get_tstamp");

   procedure snd_pcm_status_get_htstamp (obj : System.Address; ptr : access global_h.snd_htimestamp_t);  -- ./alsa/pcm.h:1002
   pragma Import (C, snd_pcm_status_get_htstamp, "snd_pcm_status_get_htstamp");

   procedure snd_pcm_status_get_audio_htstamp (obj : System.Address; ptr : access global_h.snd_htimestamp_t);  -- ./alsa/pcm.h:1003
   pragma Import (C, snd_pcm_status_get_audio_htstamp, "snd_pcm_status_get_audio_htstamp");

   procedure snd_pcm_status_get_driver_htstamp (obj : System.Address; ptr : access global_h.snd_htimestamp_t);  -- ./alsa/pcm.h:1004
   pragma Import (C, snd_pcm_status_get_driver_htstamp, "snd_pcm_status_get_driver_htstamp");

   procedure snd_pcm_status_get_audio_htstamp_report (obj : System.Address; audio_tstamp_report : access snd_pcm_audio_tstamp_report_t);  -- ./alsa/pcm.h:1005
   pragma Import (C, snd_pcm_status_get_audio_htstamp_report, "snd_pcm_status_get_audio_htstamp_report");

   procedure snd_pcm_status_set_audio_htstamp_config (obj : System.Address; audio_tstamp_config : access snd_pcm_audio_tstamp_config_t);  -- ./alsa/pcm.h:1007
   pragma Import (C, snd_pcm_status_set_audio_htstamp_config, "snd_pcm_status_set_audio_htstamp_config");

   procedure snd_pcm_pack_audio_tstamp_config (data : access unsigned; config : access snd_pcm_audio_tstamp_config_t);  -- ./alsa/pcm.h:1010
   pragma Import (C, snd_pcm_pack_audio_tstamp_config, "snd_pcm_pack_audio_tstamp_config");

   procedure snd_pcm_unpack_audio_tstamp_report
     (data : unsigned;
      accuracy : unsigned;
      report : access snd_pcm_audio_tstamp_report_t);  -- ./alsa/pcm.h:1018
   pragma Import (C, snd_pcm_unpack_audio_tstamp_report, "snd_pcm_unpack_audio_tstamp_report");

   function snd_pcm_status_get_delay (obj : System.Address) return snd_pcm_sframes_t;  -- ./alsa/pcm.h:1028
   pragma Import (C, snd_pcm_status_get_delay, "snd_pcm_status_get_delay");

   function snd_pcm_status_get_avail (obj : System.Address) return snd_pcm_uframes_t;  -- ./alsa/pcm.h:1029
   pragma Import (C, snd_pcm_status_get_avail, "snd_pcm_status_get_avail");

   function snd_pcm_status_get_avail_max (obj : System.Address) return snd_pcm_uframes_t;  -- ./alsa/pcm.h:1030
   pragma Import (C, snd_pcm_status_get_avail_max, "snd_pcm_status_get_avail_max");

   function snd_pcm_status_get_overrange (obj : System.Address) return snd_pcm_uframes_t;  -- ./alsa/pcm.h:1031
   pragma Import (C, snd_pcm_status_get_overrange, "snd_pcm_status_get_overrange");

  --* \}  
  --*
  -- * \defgroup PCM_Description Description Functions
  -- * \ingroup PCM
  -- * See the \ref pcm page for more details.
  -- * \{
  --  

   function snd_pcm_type_name (c_type : snd_pcm_type_t) return Interfaces.C.Strings.chars_ptr;  -- ./alsa/pcm.h:1042
   pragma Import (C, snd_pcm_type_name, "snd_pcm_type_name");

   function snd_pcm_stream_name (stream : snd_pcm_stream_t) return Interfaces.C.Strings.chars_ptr;  -- ./alsa/pcm.h:1043
   pragma Import (C, snd_pcm_stream_name, "snd_pcm_stream_name");

   function snd_pcm_access_name (u_access : snd_pcm_access_t) return Interfaces.C.Strings.chars_ptr;  -- ./alsa/pcm.h:1044
   pragma Import (C, snd_pcm_access_name, "snd_pcm_access_name");

   function snd_pcm_format_name (format : snd_pcm_format_t) return Interfaces.C.Strings.chars_ptr;  -- ./alsa/pcm.h:1045
   pragma Import (C, snd_pcm_format_name, "snd_pcm_format_name");

   function snd_pcm_format_description (format : snd_pcm_format_t) return Interfaces.C.Strings.chars_ptr;  -- ./alsa/pcm.h:1046
   pragma Import (C, snd_pcm_format_description, "snd_pcm_format_description");

   function snd_pcm_subformat_name (subformat : snd_pcm_subformat_t) return Interfaces.C.Strings.chars_ptr;  -- ./alsa/pcm.h:1047
   pragma Import (C, snd_pcm_subformat_name, "snd_pcm_subformat_name");

   function snd_pcm_subformat_description (subformat : snd_pcm_subformat_t) return Interfaces.C.Strings.chars_ptr;  -- ./alsa/pcm.h:1048
   pragma Import (C, snd_pcm_subformat_description, "snd_pcm_subformat_description");

   function snd_pcm_format_value (name : Interfaces.C.Strings.chars_ptr) return snd_pcm_format_t;  -- ./alsa/pcm.h:1049
   pragma Import (C, snd_pcm_format_value, "snd_pcm_format_value");

   function snd_pcm_tstamp_mode_name (mode : snd_pcm_tstamp_t) return Interfaces.C.Strings.chars_ptr;  -- ./alsa/pcm.h:1050
   pragma Import (C, snd_pcm_tstamp_mode_name, "snd_pcm_tstamp_mode_name");

   function snd_pcm_state_name (state : snd_pcm_state_t) return Interfaces.C.Strings.chars_ptr;  -- ./alsa/pcm.h:1051
   pragma Import (C, snd_pcm_state_name, "snd_pcm_state_name");

  --* \}  
  --*
  -- * \defgroup PCM_Dump Debug Functions
  -- * \ingroup PCM
  -- * See the \ref pcm page for more details.
  -- * \{
  --  

   function snd_pcm_dump (pcm : System.Address; c_out : System.Address) return int;  -- ./alsa/pcm.h:1062
   pragma Import (C, snd_pcm_dump, "snd_pcm_dump");

   function snd_pcm_dump_hw_setup (pcm : System.Address; c_out : System.Address) return int;  -- ./alsa/pcm.h:1063
   pragma Import (C, snd_pcm_dump_hw_setup, "snd_pcm_dump_hw_setup");

   function snd_pcm_dump_sw_setup (pcm : System.Address; c_out : System.Address) return int;  -- ./alsa/pcm.h:1064
   pragma Import (C, snd_pcm_dump_sw_setup, "snd_pcm_dump_sw_setup");

   function snd_pcm_dump_setup (pcm : System.Address; c_out : System.Address) return int;  -- ./alsa/pcm.h:1065
   pragma Import (C, snd_pcm_dump_setup, "snd_pcm_dump_setup");

   function snd_pcm_hw_params_dump (params : System.Address; c_out : System.Address) return int;  -- ./alsa/pcm.h:1066
   pragma Import (C, snd_pcm_hw_params_dump, "snd_pcm_hw_params_dump");

   function snd_pcm_sw_params_dump (params : System.Address; c_out : System.Address) return int;  -- ./alsa/pcm.h:1067
   pragma Import (C, snd_pcm_sw_params_dump, "snd_pcm_sw_params_dump");

   function snd_pcm_status_dump (status : System.Address; c_out : System.Address) return int;  -- ./alsa/pcm.h:1068
   pragma Import (C, snd_pcm_status_dump, "snd_pcm_status_dump");

  --* \}  
  --*
  -- * \defgroup PCM_Direct Direct Access (MMAP) Functions
  -- * \ingroup PCM
  -- * See the \ref pcm page for more details.
  -- * \{
  --  

   function snd_pcm_mmap_begin
     (pcm : System.Address;
      areas : System.Address;
      offset : access snd_pcm_uframes_t;
      frames : access snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:1079
   pragma Import (C, snd_pcm_mmap_begin, "snd_pcm_mmap_begin");

   function snd_pcm_mmap_commit
     (pcm : System.Address;
      offset : snd_pcm_uframes_t;
      frames : snd_pcm_uframes_t) return snd_pcm_sframes_t;  -- ./alsa/pcm.h:1083
   pragma Import (C, snd_pcm_mmap_commit, "snd_pcm_mmap_commit");

   function snd_pcm_mmap_writei
     (pcm : System.Address;
      buffer : System.Address;
      size : snd_pcm_uframes_t) return snd_pcm_sframes_t;  -- ./alsa/pcm.h:1086
   pragma Import (C, snd_pcm_mmap_writei, "snd_pcm_mmap_writei");

   function snd_pcm_mmap_readi
     (pcm : System.Address;
      buffer : System.Address;
      size : snd_pcm_uframes_t) return snd_pcm_sframes_t;  -- ./alsa/pcm.h:1087
   pragma Import (C, snd_pcm_mmap_readi, "snd_pcm_mmap_readi");

   function snd_pcm_mmap_writen
     (pcm : System.Address;
      bufs : System.Address;
      size : snd_pcm_uframes_t) return snd_pcm_sframes_t;  -- ./alsa/pcm.h:1088
   pragma Import (C, snd_pcm_mmap_writen, "snd_pcm_mmap_writen");

   function snd_pcm_mmap_readn
     (pcm : System.Address;
      bufs : System.Address;
      size : snd_pcm_uframes_t) return snd_pcm_sframes_t;  -- ./alsa/pcm.h:1089
   pragma Import (C, snd_pcm_mmap_readn, "snd_pcm_mmap_readn");

  --* \}  
  --*
  -- * \defgroup PCM_Helpers Helper Functions
  -- * \ingroup PCM
  -- * See the \ref pcm page for more details.
  -- * \{
  --  

   function snd_pcm_format_signed (format : snd_pcm_format_t) return int;  -- ./alsa/pcm.h:1100
   pragma Import (C, snd_pcm_format_signed, "snd_pcm_format_signed");

   function snd_pcm_format_unsigned (format : snd_pcm_format_t) return int;  -- ./alsa/pcm.h:1101
   pragma Import (C, snd_pcm_format_unsigned, "snd_pcm_format_unsigned");

   function snd_pcm_format_linear (format : snd_pcm_format_t) return int;  -- ./alsa/pcm.h:1102
   pragma Import (C, snd_pcm_format_linear, "snd_pcm_format_linear");

   function snd_pcm_format_float (format : snd_pcm_format_t) return int;  -- ./alsa/pcm.h:1103
   pragma Import (C, snd_pcm_format_float, "snd_pcm_format_float");

   function snd_pcm_format_little_endian (format : snd_pcm_format_t) return int;  -- ./alsa/pcm.h:1104
   pragma Import (C, snd_pcm_format_little_endian, "snd_pcm_format_little_endian");

   function snd_pcm_format_big_endian (format : snd_pcm_format_t) return int;  -- ./alsa/pcm.h:1105
   pragma Import (C, snd_pcm_format_big_endian, "snd_pcm_format_big_endian");

   function snd_pcm_format_cpu_endian (format : snd_pcm_format_t) return int;  -- ./alsa/pcm.h:1106
   pragma Import (C, snd_pcm_format_cpu_endian, "snd_pcm_format_cpu_endian");

  -- in bits  
   function snd_pcm_format_width (format : snd_pcm_format_t) return int;  -- ./alsa/pcm.h:1107
   pragma Import (C, snd_pcm_format_width, "snd_pcm_format_width");

  -- in bits  
   function snd_pcm_format_physical_width (format : snd_pcm_format_t) return int;  -- ./alsa/pcm.h:1108
   pragma Import (C, snd_pcm_format_physical_width, "snd_pcm_format_physical_width");

   function snd_pcm_build_linear_format
     (width : int;
      pwidth : int;
      unsignd : int;
      big_endian : int) return snd_pcm_format_t;  -- ./alsa/pcm.h:1109
   pragma Import (C, snd_pcm_build_linear_format, "snd_pcm_build_linear_format");

   function snd_pcm_format_size (format : snd_pcm_format_t; samples : stddef_h.size_t) return unistd_h.ssize_t;  -- ./alsa/pcm.h:1110
   pragma Import (C, snd_pcm_format_size, "snd_pcm_format_size");

   function snd_pcm_format_silence (format : snd_pcm_format_t) return sys_types_h.u_int8_t;  -- ./alsa/pcm.h:1111
   pragma Import (C, snd_pcm_format_silence, "snd_pcm_format_silence");

   function snd_pcm_format_silence_16 (format : snd_pcm_format_t) return sys_types_h.u_int16_t;  -- ./alsa/pcm.h:1112
   pragma Import (C, snd_pcm_format_silence_16, "snd_pcm_format_silence_16");

   function snd_pcm_format_silence_32 (format : snd_pcm_format_t) return sys_types_h.u_int32_t;  -- ./alsa/pcm.h:1113
   pragma Import (C, snd_pcm_format_silence_32, "snd_pcm_format_silence_32");

   function snd_pcm_format_silence_64 (format : snd_pcm_format_t) return sys_types_h.u_int64_t;  -- ./alsa/pcm.h:1114
   pragma Import (C, snd_pcm_format_silence_64, "snd_pcm_format_silence_64");

   function snd_pcm_format_set_silence
     (format : snd_pcm_format_t;
      buf : System.Address;
      samples : unsigned) return int;  -- ./alsa/pcm.h:1115
   pragma Import (C, snd_pcm_format_set_silence, "snd_pcm_format_set_silence");

   function snd_pcm_bytes_to_frames (pcm : System.Address; bytes : unistd_h.ssize_t) return snd_pcm_sframes_t;  -- ./alsa/pcm.h:1117
   pragma Import (C, snd_pcm_bytes_to_frames, "snd_pcm_bytes_to_frames");

   function snd_pcm_frames_to_bytes (pcm : System.Address; frames : snd_pcm_sframes_t) return unistd_h.ssize_t;  -- ./alsa/pcm.h:1118
   pragma Import (C, snd_pcm_frames_to_bytes, "snd_pcm_frames_to_bytes");

   function snd_pcm_bytes_to_samples (pcm : System.Address; bytes : unistd_h.ssize_t) return long;  -- ./alsa/pcm.h:1119
   pragma Import (C, snd_pcm_bytes_to_samples, "snd_pcm_bytes_to_samples");

   function snd_pcm_samples_to_bytes (pcm : System.Address; samples : long) return unistd_h.ssize_t;  -- ./alsa/pcm.h:1120
   pragma Import (C, snd_pcm_samples_to_bytes, "snd_pcm_samples_to_bytes");

   function snd_pcm_area_silence
     (dst_channel : System.Address;
      dst_offset : snd_pcm_uframes_t;
      samples : unsigned;
      format : snd_pcm_format_t) return int;  -- ./alsa/pcm.h:1122
   pragma Import (C, snd_pcm_area_silence, "snd_pcm_area_silence");

   function snd_pcm_areas_silence
     (dst_channels : System.Address;
      dst_offset : snd_pcm_uframes_t;
      channels : unsigned;
      frames : snd_pcm_uframes_t;
      format : snd_pcm_format_t) return int;  -- ./alsa/pcm.h:1124
   pragma Import (C, snd_pcm_areas_silence, "snd_pcm_areas_silence");

   function snd_pcm_area_copy
     (dst_channel : System.Address;
      dst_offset : snd_pcm_uframes_t;
      src_channel : System.Address;
      src_offset : snd_pcm_uframes_t;
      samples : unsigned;
      format : snd_pcm_format_t) return int;  -- ./alsa/pcm.h:1126
   pragma Import (C, snd_pcm_area_copy, "snd_pcm_area_copy");

   function snd_pcm_areas_copy
     (dst_channels : System.Address;
      dst_offset : snd_pcm_uframes_t;
      src_channels : System.Address;
      src_offset : snd_pcm_uframes_t;
      channels : unsigned;
      frames : snd_pcm_uframes_t;
      format : snd_pcm_format_t) return int;  -- ./alsa/pcm.h:1129
   pragma Import (C, snd_pcm_areas_copy, "snd_pcm_areas_copy");

  --* \}  
  --*
  -- * \defgroup PCM_Hook Hook Extension
  -- * \ingroup PCM
  -- * See the \ref pcm page for more details.
  -- * \{
  --  

  --* type of pcm hook  
   subtype u_snd_pcm_hook_type is unsigned;
   SND_PCM_HOOK_TYPE_HW_PARAMS : constant u_snd_pcm_hook_type := 0;
   SND_PCM_HOOK_TYPE_HW_FREE : constant u_snd_pcm_hook_type := 1;
   SND_PCM_HOOK_TYPE_CLOSE : constant u_snd_pcm_hook_type := 2;
   SND_PCM_HOOK_TYPE_LAST : constant u_snd_pcm_hook_type := 2;  -- ./alsa/pcm.h:1143

   subtype snd_pcm_hook_type_t is u_snd_pcm_hook_type;

  --* PCM hook container  
   --  skipped empty struct u_snd_pcm_hook

   --  skipped empty struct snd_pcm_hook_t

  --* PCM hook callback function  
   type snd_pcm_hook_func_t is access function (arg1 : System.Address) return int;
   pragma Convention (C, snd_pcm_hook_func_t);  -- ./alsa/pcm.h:1153

   function snd_pcm_hook_get_pcm (hook : System.Address) return System.Address;  -- ./alsa/pcm.h:1154
   pragma Import (C, snd_pcm_hook_get_pcm, "snd_pcm_hook_get_pcm");

   function snd_pcm_hook_get_private (hook : System.Address) return System.Address;  -- ./alsa/pcm.h:1155
   pragma Import (C, snd_pcm_hook_get_private, "snd_pcm_hook_get_private");

   procedure snd_pcm_hook_set_private (hook : System.Address; private_data : System.Address);  -- ./alsa/pcm.h:1156
   pragma Import (C, snd_pcm_hook_set_private, "snd_pcm_hook_set_private");

   function snd_pcm_hook_add
     (hookp : System.Address;
      pcm : System.Address;
      c_type : snd_pcm_hook_type_t;
      func : snd_pcm_hook_func_t;
      private_data : System.Address) return int;  -- ./alsa/pcm.h:1157
   pragma Import (C, snd_pcm_hook_add, "snd_pcm_hook_add");

   function snd_pcm_hook_remove (hook : System.Address) return int;  -- ./alsa/pcm.h:1160
   pragma Import (C, snd_pcm_hook_remove, "snd_pcm_hook_remove");

  --* \}  
  --*
  -- * \defgroup PCM_Scope Scope Plugin Extension
  -- * \ingroup PCM
  -- * See the \ref pcm page for more details.
  -- * \{
  --  

  --* #SND_PCM_TYPE_METER scope functions  
  --* \brief Enable and prepare it using current params
  --	 * \param scope scope handle
  --	  

   type u_snd_pcm_scope_ops is record
      enable : access function (arg1 : System.Address) return int;  -- ./alsa/pcm.h:1176
      disable : access procedure (arg1 : System.Address);  -- ./alsa/pcm.h:1180
      start : access procedure (arg1 : System.Address);  -- ./alsa/pcm.h:1184
      stop : access procedure (arg1 : System.Address);  -- ./alsa/pcm.h:1188
      update : access procedure (arg1 : System.Address);  -- ./alsa/pcm.h:1192
      reset : access procedure (arg1 : System.Address);  -- ./alsa/pcm.h:1196
      close : access procedure (arg1 : System.Address);  -- ./alsa/pcm.h:1200
   end record;
   pragma Convention (C_Pass_By_Copy, u_snd_pcm_scope_ops);  -- ./alsa/pcm.h:1172

  --* \brief Disable
  --	 * \param scope scope handle
  --	  

  --* \brief PCM has been started
  --	 * \param scope scope handle
  --	  

  --* \brief PCM has been stopped
  --	 * \param scope scope handle
  --	  

  --* \brief New frames are present
  --	 * \param scope scope handle
  --	  

  --* \brief Reset status
  --	 * \param scope scope handle
  --	  

  --* \brief PCM is closing
  --	 * \param scope scope handle
  --	  

   subtype snd_pcm_scope_ops_t is u_snd_pcm_scope_ops;

   function snd_pcm_meter_get_bufsize (pcm : System.Address) return snd_pcm_uframes_t;  -- ./alsa/pcm.h:1203
   pragma Import (C, snd_pcm_meter_get_bufsize, "snd_pcm_meter_get_bufsize");

   function snd_pcm_meter_get_channels (pcm : System.Address) return unsigned;  -- ./alsa/pcm.h:1204
   pragma Import (C, snd_pcm_meter_get_channels, "snd_pcm_meter_get_channels");

   function snd_pcm_meter_get_rate (pcm : System.Address) return unsigned;  -- ./alsa/pcm.h:1205
   pragma Import (C, snd_pcm_meter_get_rate, "snd_pcm_meter_get_rate");

   function snd_pcm_meter_get_now (pcm : System.Address) return snd_pcm_uframes_t;  -- ./alsa/pcm.h:1206
   pragma Import (C, snd_pcm_meter_get_now, "snd_pcm_meter_get_now");

   function snd_pcm_meter_get_boundary (pcm : System.Address) return snd_pcm_uframes_t;  -- ./alsa/pcm.h:1207
   pragma Import (C, snd_pcm_meter_get_boundary, "snd_pcm_meter_get_boundary");

   function snd_pcm_meter_add_scope (pcm : System.Address; scope : System.Address) return int;  -- ./alsa/pcm.h:1208
   pragma Import (C, snd_pcm_meter_add_scope, "snd_pcm_meter_add_scope");

   function snd_pcm_meter_search_scope (pcm : System.Address; name : Interfaces.C.Strings.chars_ptr) return System.Address;  -- ./alsa/pcm.h:1209
   pragma Import (C, snd_pcm_meter_search_scope, "snd_pcm_meter_search_scope");

   function snd_pcm_scope_malloc (ptr : System.Address) return int;  -- ./alsa/pcm.h:1210
   pragma Import (C, snd_pcm_scope_malloc, "snd_pcm_scope_malloc");

   procedure snd_pcm_scope_set_ops (scope : System.Address; val : System.Address);  -- ./alsa/pcm.h:1211
   pragma Import (C, snd_pcm_scope_set_ops, "snd_pcm_scope_set_ops");

   procedure snd_pcm_scope_set_name (scope : System.Address; val : Interfaces.C.Strings.chars_ptr);  -- ./alsa/pcm.h:1213
   pragma Import (C, snd_pcm_scope_set_name, "snd_pcm_scope_set_name");

   function snd_pcm_scope_get_name (scope : System.Address) return Interfaces.C.Strings.chars_ptr;  -- ./alsa/pcm.h:1214
   pragma Import (C, snd_pcm_scope_get_name, "snd_pcm_scope_get_name");

   function snd_pcm_scope_get_callback_private (scope : System.Address) return System.Address;  -- ./alsa/pcm.h:1215
   pragma Import (C, snd_pcm_scope_get_callback_private, "snd_pcm_scope_get_callback_private");

   procedure snd_pcm_scope_set_callback_private (scope : System.Address; val : System.Address);  -- ./alsa/pcm.h:1216
   pragma Import (C, snd_pcm_scope_set_callback_private, "snd_pcm_scope_set_callback_private");

   function snd_pcm_scope_s16_open
     (pcm : System.Address;
      name : Interfaces.C.Strings.chars_ptr;
      scopep : System.Address) return int;  -- ./alsa/pcm.h:1217
   pragma Import (C, snd_pcm_scope_s16_open, "snd_pcm_scope_s16_open");

   function snd_pcm_scope_s16_get_channel_buffer (scope : System.Address; channel : unsigned) return access sys_types_h.int16_t;  -- ./alsa/pcm.h:1219
   pragma Import (C, snd_pcm_scope_s16_get_channel_buffer, "snd_pcm_scope_s16_get_channel_buffer");

  --* \}  
  --*
  -- * \defgroup PCM_Simple Simple setup functions
  -- * \ingroup PCM
  -- * See the \ref pcm page for more details.
  -- * \{
  --  

  --* Simple PCM latency type  
   type u_snd_spcm_latency is 
     (SND_SPCM_LATENCY_STANDARD,
      SND_SPCM_LATENCY_MEDIUM,
      SND_SPCM_LATENCY_REALTIME);
   pragma Convention (C, u_snd_spcm_latency);  -- ./alsa/pcm.h:1232

  --* standard latency - for standard playback or capture
  --            (estimated latency in one direction 350ms)  

  --* medium latency - software phones etc.
  --	    (estimated latency in one direction maximally 25ms  

  --* realtime latency - realtime applications (effect processors etc.)
  --	    (estimated latency in one direction 5ms and better)  

   subtype snd_spcm_latency_t is u_snd_spcm_latency;

  --* Simple PCM xrun type  
   type u_snd_spcm_xrun_type is 
     (SND_SPCM_XRUN_IGNORE,
      SND_SPCM_XRUN_STOP);
   pragma Convention (C, u_snd_spcm_xrun_type);  -- ./alsa/pcm.h:1245

  --* driver / library will ignore all xruns, the stream runs forever  
  --* driver / library stops the stream when an xrun occurs  
   subtype snd_spcm_xrun_type_t is u_snd_spcm_xrun_type;

  --* Simple PCM duplex type  
   type u_snd_spcm_duplex_type is 
     (SND_SPCM_DUPLEX_LIBERAL,
      SND_SPCM_DUPLEX_PEDANTIC);
   pragma Convention (C, u_snd_spcm_duplex_type);  -- ./alsa/pcm.h:1253

  --* liberal duplex - the buffer and period sizes might not match  
  --* pedantic duplex - the buffer and period sizes MUST match  
   subtype snd_spcm_duplex_type_t is u_snd_spcm_duplex_type;

   function snd_spcm_init
     (pcm : System.Address;
      rate : unsigned;
      channels : unsigned;
      format : snd_pcm_format_t;
      subformat : snd_pcm_subformat_t;
      latency : snd_spcm_latency_t;
      u_access : snd_pcm_access_t;
      xrun_type : snd_spcm_xrun_type_t) return int;  -- ./alsa/pcm.h:1260
   pragma Import (C, snd_spcm_init, "snd_spcm_init");

   function snd_spcm_init_duplex
     (playback_pcm : System.Address;
      capture_pcm : System.Address;
      rate : unsigned;
      channels : unsigned;
      format : snd_pcm_format_t;
      subformat : snd_pcm_subformat_t;
      latency : snd_spcm_latency_t;
      u_access : snd_pcm_access_t;
      xrun_type : snd_spcm_xrun_type_t;
      duplex_type : snd_spcm_duplex_type_t) return int;  -- ./alsa/pcm.h:1269
   pragma Import (C, snd_spcm_init_duplex, "snd_spcm_init_duplex");

   function snd_spcm_init_get_params
     (pcm : System.Address;
      rate : access unsigned;
      buffer_size : access snd_pcm_uframes_t;
      period_size : access snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:1280
   pragma Import (C, snd_spcm_init_get_params, "snd_spcm_init_get_params");

  --* \}  
  --*
  -- * \defgroup PCM_Deprecated Deprecated Functions
  -- * \ingroup PCM
  -- * See the \ref pcm page for more details.
  -- * \{
  --  

  -- Deprecated functions, for compatibility  
   function snd_pcm_start_mode_name (mode : snd_pcm_start_t) return Interfaces.C.Strings.chars_ptr;  -- ./alsa/pcm.h:1295
   pragma Import (C, snd_pcm_start_mode_name, "snd_pcm_start_mode_name");

   function snd_pcm_xrun_mode_name (mode : snd_pcm_xrun_t) return Interfaces.C.Strings.chars_ptr;  -- ./alsa/pcm.h:1296
   pragma Import (C, snd_pcm_xrun_mode_name, "snd_pcm_xrun_mode_name");

   function snd_pcm_sw_params_set_start_mode
     (pcm : System.Address;
      params : System.Address;
      val : snd_pcm_start_t) return int;  -- ./alsa/pcm.h:1297
   pragma Import (C, snd_pcm_sw_params_set_start_mode, "snd_pcm_sw_params_set_start_mode");

   function snd_pcm_sw_params_get_start_mode (params : System.Address) return snd_pcm_start_t;  -- ./alsa/pcm.h:1298
   pragma Import (C, snd_pcm_sw_params_get_start_mode, "snd_pcm_sw_params_get_start_mode");

   function snd_pcm_sw_params_set_xrun_mode
     (pcm : System.Address;
      params : System.Address;
      val : snd_pcm_xrun_t) return int;  -- ./alsa/pcm.h:1299
   pragma Import (C, snd_pcm_sw_params_set_xrun_mode, "snd_pcm_sw_params_set_xrun_mode");

   function snd_pcm_sw_params_get_xrun_mode (params : System.Address) return snd_pcm_xrun_t;  -- ./alsa/pcm.h:1300
   pragma Import (C, snd_pcm_sw_params_get_xrun_mode, "snd_pcm_sw_params_get_xrun_mode");

   function snd_pcm_sw_params_set_xfer_align
     (pcm : System.Address;
      params : System.Address;
      val : snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:1302
   pragma Import (C, snd_pcm_sw_params_set_xfer_align, "snd_pcm_sw_params_set_xfer_align");

   function snd_pcm_sw_params_get_xfer_align (params : System.Address; val : access snd_pcm_uframes_t) return int;  -- ./alsa/pcm.h:1303
   pragma Import (C, snd_pcm_sw_params_get_xfer_align, "snd_pcm_sw_params_get_xfer_align");

   function snd_pcm_sw_params_set_sleep_min
     (pcm : System.Address;
      params : System.Address;
      val : unsigned) return int;  -- ./alsa/pcm.h:1304
   pragma Import (C, snd_pcm_sw_params_set_sleep_min, "snd_pcm_sw_params_set_sleep_min");

   function snd_pcm_sw_params_get_sleep_min (params : System.Address; val : access unsigned) return int;  -- ./alsa/pcm.h:1305
   pragma Import (C, snd_pcm_sw_params_get_sleep_min, "snd_pcm_sw_params_get_sleep_min");

   function snd_pcm_hw_params_get_tick_time
     (params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:1308
   pragma Import (C, snd_pcm_hw_params_get_tick_time, "snd_pcm_hw_params_get_tick_time");

   function snd_pcm_hw_params_get_tick_time_min
     (params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:1309
   pragma Import (C, snd_pcm_hw_params_get_tick_time_min, "snd_pcm_hw_params_get_tick_time_min");

   function snd_pcm_hw_params_get_tick_time_max
     (params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:1310
   pragma Import (C, snd_pcm_hw_params_get_tick_time_max, "snd_pcm_hw_params_get_tick_time_max");

   function snd_pcm_hw_params_test_tick_time
     (pcm : System.Address;
      params : System.Address;
      val : unsigned;
      dir : int) return int;  -- ./alsa/pcm.h:1311
   pragma Import (C, snd_pcm_hw_params_test_tick_time, "snd_pcm_hw_params_test_tick_time");

   function snd_pcm_hw_params_set_tick_time
     (pcm : System.Address;
      params : System.Address;
      val : unsigned;
      dir : int) return int;  -- ./alsa/pcm.h:1312
   pragma Import (C, snd_pcm_hw_params_set_tick_time, "snd_pcm_hw_params_set_tick_time");

   function snd_pcm_hw_params_set_tick_time_min
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:1313
   pragma Import (C, snd_pcm_hw_params_set_tick_time_min, "snd_pcm_hw_params_set_tick_time_min");

   function snd_pcm_hw_params_set_tick_time_max
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:1314
   pragma Import (C, snd_pcm_hw_params_set_tick_time_max, "snd_pcm_hw_params_set_tick_time_max");

   function snd_pcm_hw_params_set_tick_time_minmax
     (pcm : System.Address;
      params : System.Address;
      min : access unsigned;
      mindir : access int;
      max : access unsigned;
      maxdir : access int) return int;  -- ./alsa/pcm.h:1315
   pragma Import (C, snd_pcm_hw_params_set_tick_time_minmax, "snd_pcm_hw_params_set_tick_time_minmax");

   function snd_pcm_hw_params_set_tick_time_near
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:1316
   pragma Import (C, snd_pcm_hw_params_set_tick_time_near, "snd_pcm_hw_params_set_tick_time_near");

   function snd_pcm_hw_params_set_tick_time_first
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:1317
   pragma Import (C, snd_pcm_hw_params_set_tick_time_first, "snd_pcm_hw_params_set_tick_time_first");

   function snd_pcm_hw_params_set_tick_time_last
     (pcm : System.Address;
      params : System.Address;
      val : access unsigned;
      dir : access int) return int;  -- ./alsa/pcm.h:1318
   pragma Import (C, snd_pcm_hw_params_set_tick_time_last, "snd_pcm_hw_params_set_tick_time_last");

  --* \}  
end pcm_h;
