# Linux
# main gnu compile script for adagate
# using shared glfw libs
#
# uses rpath to tell runtime linker to look also in
# ./libs/gnu/ for any needed *.so files 
# not found elsewhere

#########################################################

# use this to ensure a complete recompilation:
if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi



# this is newest compiler from AdaCore:
export PATH=$HOME/opt/GNAT/2021/bin:$PATH


# first, create oal.o:
g++ src/adabindings/adaOpenAL/OalBinding/oal.cpp -c \
-Isrc/adabindings/adaOpenAL/OalBinding \
-Isrc/adabindings/adaOpenAL/OalBinding/incoal




gnatmake adagate -o adagate_gnu \
-O3 -gnat12 \
-D $PWD/obj \
-I$PWD/src \
-I$PWD/src/adautils \
-I$PWD/src/adabindings/gl \
-I$PWD/src/adabindings/glfwada \
-I$PWD/src/adabindings/AdaPngLib \
-I$PWD/src/adabindings/adaOpenAL \
-I$PWD/src/adabindings/adaOpenAL/OalBinding \
-largs \
oal.o \
-lGL  -lpthread -lstdc++ -lz -lm -lX11 \
-lopenal \
-L$PWD/libs/gnu \
-lglfw335







# -- Copyright (C) 2020  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.



