--                                                                    --
--  package                         Copyright (c)  Dmitry A. Kazakov  --
--     Strings_Edit.UTF8.Categorization            Luebeck            --
--  Implementation                                 Spring, 2008       --
--                                                                    --
--                                Last revision :  21:03 21 Apr 2009  --
--                                                                    --
--  This  library  is  free software; you can redistribute it and/or  --
--  modify it under the terms of the GNU General Public  License  as  --
--  published by the Free Software Foundation; either version  2  of  --
--  the License, or (at your option) any later version. This library  --
--  is distributed in the hope that it will be useful,  but  WITHOUT  --
--  ANY   WARRANTY;   without   even   the   implied   warranty   of  --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  --
--  General  Public  License  for  more  details.  You  should  have  --
--  received  a  copy  of  the GNU General Public License along with  --
--  this library; if not, write to  the  Free  Software  Foundation,  --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.    --
--                                                                    --
--  As a special exception, if other files instantiate generics from  --
--  this unit, or you link this unit with other files to produce  an  --
--  executable, this unit does not by  itself  cause  the  resulting  --
--  executable to be covered by the GNU General Public License. This  --
--  exception  does not however invalidate any other reasons why the  --
--  executable file might be covered by the GNU Public License.       --
--____________________________________________________________________--

package body Strings_Edit.UTF8.Categorization is

   type Points_Range is record
      From     : UTF8_Code_Point;
      To       : UTF8_Code_Point;
      Category : General_Category;
   end record;
   type Range_Index is range 1..2077;
   type Range_Array is array (Range_Index) of Points_Range;

   Mapping : constant Range_Array :=
   (
      (16#0#,16#1F#,CC),(16#20#,16#20#,ZS),(16#21#,16#23#,PO),
      (16#24#,16#24#,SC),(16#25#,16#27#,PO),(16#28#,16#28#,PS),
      (16#29#,16#29#,PE),(16#2A#,16#2A#,PO),(16#2B#,16#2B#,SM),
      (16#2C#,16#2C#,PO),(16#2D#,16#2D#,PD),(16#2E#,16#2F#,PO),
      (16#30#,16#39#,ND),(16#3A#,16#3B#,PO),(16#3C#,16#3E#,SM),
      (16#3F#,16#40#,PO),(16#41#,16#5A#,LU),(16#5B#,16#5B#,PS),
      (16#5C#,16#5C#,PO),(16#5D#,16#5D#,PE),(16#5E#,16#5E#,SK),
      (16#5F#,16#5F#,PC),(16#60#,16#60#,SK),(16#61#,16#7A#,LL),
      (16#7B#,16#7B#,PS),(16#7C#,16#7C#,SM),(16#7D#,16#7D#,PE),
      (16#7E#,16#7E#,SM),(16#7F#,16#9F#,CC),(16#A0#,16#A0#,ZS),
      (16#A1#,16#A1#,PO),(16#A2#,16#A5#,SC),(16#A6#,16#A7#,SO),
      (16#A8#,16#A8#,SK),(16#A9#,16#A9#,SO),(16#AA#,16#AA#,LL),
      (16#AB#,16#AB#,PI),(16#AC#,16#AC#,SM),(16#AD#,16#AD#,CF),
      (16#AE#,16#AE#,SO),(16#AF#,16#AF#,SK),(16#B0#,16#B0#,SO),
      (16#B1#,16#B1#,SM),(16#B2#,16#B3#,NO),(16#B4#,16#B4#,SK),
      (16#B5#,16#B5#,LL),(16#B6#,16#B6#,SO),(16#B7#,16#B7#,PO),
      (16#B8#,16#B8#,SK),(16#B9#,16#B9#,NO),(16#BA#,16#BA#,LL),
      (16#BB#,16#BB#,PF),(16#BC#,16#BE#,NO),(16#BF#,16#BF#,PO),
      (16#C0#,16#D6#,LU),(16#D7#,16#D7#,SM),(16#D8#,16#DE#,LU),
      (16#DF#,16#F6#,LL),(16#F7#,16#F7#,SM),(16#F8#,16#FF#,LL),
      (16#100#,16#100#,LU),(16#101#,16#101#,LL),(16#102#,16#102#,LU),
      (16#103#,16#103#,LL),(16#104#,16#104#,LU),(16#105#,16#105#,LL),
      (16#106#,16#106#,LU),(16#107#,16#107#,LL),(16#108#,16#108#,LU),
      (16#109#,16#109#,LL),(16#10A#,16#10A#,LU),(16#10B#,16#10B#,LL),
      (16#10C#,16#10C#,LU),(16#10D#,16#10D#,LL),(16#10E#,16#10E#,LU),
      (16#10F#,16#10F#,LL),(16#110#,16#110#,LU),(16#111#,16#111#,LL),
      (16#112#,16#112#,LU),(16#113#,16#113#,LL),(16#114#,16#114#,LU),
      (16#115#,16#115#,LL),(16#116#,16#116#,LU),(16#117#,16#117#,LL),
      (16#118#,16#118#,LU),(16#119#,16#119#,LL),(16#11A#,16#11A#,LU),
      (16#11B#,16#11B#,LL),(16#11C#,16#11C#,LU),(16#11D#,16#11D#,LL),
      (16#11E#,16#11E#,LU),(16#11F#,16#11F#,LL),(16#120#,16#120#,LU),
      (16#121#,16#121#,LL),(16#122#,16#122#,LU),(16#123#,16#123#,LL),
      (16#124#,16#124#,LU),(16#125#,16#125#,LL),(16#126#,16#126#,LU),
      (16#127#,16#127#,LL),(16#128#,16#128#,LU),(16#129#,16#129#,LL),
      (16#12A#,16#12A#,LU),(16#12B#,16#12B#,LL),(16#12C#,16#12C#,LU),
      (16#12D#,16#12D#,LL),(16#12E#,16#12E#,LU),(16#12F#,16#12F#,LL),
      (16#130#,16#130#,LU),(16#131#,16#131#,LL),(16#132#,16#132#,LU),
      (16#133#,16#133#,LL),(16#134#,16#134#,LU),(16#135#,16#135#,LL),
      (16#136#,16#136#,LU),(16#137#,16#138#,LL),(16#139#,16#139#,LU),
      (16#13A#,16#13A#,LL),(16#13B#,16#13B#,LU),(16#13C#,16#13C#,LL),
      (16#13D#,16#13D#,LU),(16#13E#,16#13E#,LL),(16#13F#,16#13F#,LU),
      (16#140#,16#140#,LL),(16#141#,16#141#,LU),(16#142#,16#142#,LL),
      (16#143#,16#143#,LU),(16#144#,16#144#,LL),(16#145#,16#145#,LU),
      (16#146#,16#146#,LL),(16#147#,16#147#,LU),(16#148#,16#149#,LL),
      (16#14A#,16#14A#,LU),(16#14B#,16#14B#,LL),(16#14C#,16#14C#,LU),
      (16#14D#,16#14D#,LL),(16#14E#,16#14E#,LU),(16#14F#,16#14F#,LL),
      (16#150#,16#150#,LU),(16#151#,16#151#,LL),(16#152#,16#152#,LU),
      (16#153#,16#153#,LL),(16#154#,16#154#,LU),(16#155#,16#155#,LL),
      (16#156#,16#156#,LU),(16#157#,16#157#,LL),(16#158#,16#158#,LU),
      (16#159#,16#159#,LL),(16#15A#,16#15A#,LU),(16#15B#,16#15B#,LL),
      (16#15C#,16#15C#,LU),(16#15D#,16#15D#,LL),(16#15E#,16#15E#,LU),
      (16#15F#,16#15F#,LL),(16#160#,16#160#,LU),(16#161#,16#161#,LL),
      (16#162#,16#162#,LU),(16#163#,16#163#,LL),(16#164#,16#164#,LU),
      (16#165#,16#165#,LL),(16#166#,16#166#,LU),(16#167#,16#167#,LL),
      (16#168#,16#168#,LU),(16#169#,16#169#,LL),(16#16A#,16#16A#,LU),
      (16#16B#,16#16B#,LL),(16#16C#,16#16C#,LU),(16#16D#,16#16D#,LL),
      (16#16E#,16#16E#,LU),(16#16F#,16#16F#,LL),(16#170#,16#170#,LU),
      (16#171#,16#171#,LL),(16#172#,16#172#,LU),(16#173#,16#173#,LL),
      (16#174#,16#174#,LU),(16#175#,16#175#,LL),(16#176#,16#176#,LU),
      (16#177#,16#177#,LL),(16#178#,16#179#,LU),(16#17A#,16#17A#,LL),
      (16#17B#,16#17B#,LU),(16#17C#,16#17C#,LL),(16#17D#,16#17D#,LU),
      (16#17E#,16#180#,LL),(16#181#,16#182#,LU),(16#183#,16#183#,LL),
      (16#184#,16#184#,LU),(16#185#,16#185#,LL),(16#186#,16#187#,LU),
      (16#188#,16#188#,LL),(16#189#,16#18B#,LU),(16#18C#,16#18D#,LL),
      (16#18E#,16#191#,LU),(16#192#,16#192#,LL),(16#193#,16#194#,LU),
      (16#195#,16#195#,LL),(16#196#,16#198#,LU),(16#199#,16#19B#,LL),
      (16#19C#,16#19D#,LU),(16#19E#,16#19E#,LL),(16#19F#,16#1A0#,LU),
      (16#1A1#,16#1A1#,LL),(16#1A2#,16#1A2#,LU),(16#1A3#,16#1A3#,LL),
      (16#1A4#,16#1A4#,LU),(16#1A5#,16#1A5#,LL),(16#1A6#,16#1A7#,LU),
      (16#1A8#,16#1A8#,LL),(16#1A9#,16#1A9#,LU),(16#1AA#,16#1AB#,LL),
      (16#1AC#,16#1AC#,LU),(16#1AD#,16#1AD#,LL),(16#1AE#,16#1AF#,LU),
      (16#1B0#,16#1B0#,LL),(16#1B1#,16#1B3#,LU),(16#1B4#,16#1B4#,LL),
      (16#1B5#,16#1B5#,LU),(16#1B6#,16#1B6#,LL),(16#1B7#,16#1B8#,LU),
      (16#1B9#,16#1BA#,LL),(16#1BB#,16#1BB#,LO),(16#1BC#,16#1BC#,LU),
      (16#1BD#,16#1BF#,LL),(16#1C0#,16#1C3#,LO),(16#1C4#,16#1C4#,LU),
      (16#1C5#,16#1C5#,LT),(16#1C6#,16#1C6#,LL),(16#1C7#,16#1C7#,LU),
      (16#1C8#,16#1C8#,LT),(16#1C9#,16#1C9#,LL),(16#1CA#,16#1CA#,LU),
      (16#1CB#,16#1CB#,LT),(16#1CC#,16#1CC#,LL),(16#1CD#,16#1CD#,LU),
      (16#1CE#,16#1CE#,LL),(16#1CF#,16#1CF#,LU),(16#1D0#,16#1D0#,LL),
      (16#1D1#,16#1D1#,LU),(16#1D2#,16#1D2#,LL),(16#1D3#,16#1D3#,LU),
      (16#1D4#,16#1D4#,LL),(16#1D5#,16#1D5#,LU),(16#1D6#,16#1D6#,LL),
      (16#1D7#,16#1D7#,LU),(16#1D8#,16#1D8#,LL),(16#1D9#,16#1D9#,LU),
      (16#1DA#,16#1DA#,LL),(16#1DB#,16#1DB#,LU),(16#1DC#,16#1DD#,LL),
      (16#1DE#,16#1DE#,LU),(16#1DF#,16#1DF#,LL),(16#1E0#,16#1E0#,LU),
      (16#1E1#,16#1E1#,LL),(16#1E2#,16#1E2#,LU),(16#1E3#,16#1E3#,LL),
      (16#1E4#,16#1E4#,LU),(16#1E5#,16#1E5#,LL),(16#1E6#,16#1E6#,LU),
      (16#1E7#,16#1E7#,LL),(16#1E8#,16#1E8#,LU),(16#1E9#,16#1E9#,LL),
      (16#1EA#,16#1EA#,LU),(16#1EB#,16#1EB#,LL),(16#1EC#,16#1EC#,LU),
      (16#1ED#,16#1ED#,LL),(16#1EE#,16#1EE#,LU),(16#1EF#,16#1F0#,LL),
      (16#1F1#,16#1F1#,LU),(16#1F2#,16#1F2#,LT),(16#1F3#,16#1F3#,LL),
      (16#1F4#,16#1F4#,LU),(16#1F5#,16#1F5#,LL),(16#1F6#,16#1F8#,LU),
      (16#1F9#,16#1F9#,LL),(16#1FA#,16#1FA#,LU),(16#1FB#,16#1FB#,LL),
      (16#1FC#,16#1FC#,LU),(16#1FD#,16#1FD#,LL),(16#1FE#,16#1FE#,LU),
      (16#1FF#,16#1FF#,LL),(16#200#,16#200#,LU),(16#201#,16#201#,LL),
      (16#202#,16#202#,LU),(16#203#,16#203#,LL),(16#204#,16#204#,LU),
      (16#205#,16#205#,LL),(16#206#,16#206#,LU),(16#207#,16#207#,LL),
      (16#208#,16#208#,LU),(16#209#,16#209#,LL),(16#20A#,16#20A#,LU),
      (16#20B#,16#20B#,LL),(16#20C#,16#20C#,LU),(16#20D#,16#20D#,LL),
      (16#20E#,16#20E#,LU),(16#20F#,16#20F#,LL),(16#210#,16#210#,LU),
      (16#211#,16#211#,LL),(16#212#,16#212#,LU),(16#213#,16#213#,LL),
      (16#214#,16#214#,LU),(16#215#,16#215#,LL),(16#216#,16#216#,LU),
      (16#217#,16#217#,LL),(16#218#,16#218#,LU),(16#219#,16#219#,LL),
      (16#21A#,16#21A#,LU),(16#21B#,16#21B#,LL),(16#21C#,16#21C#,LU),
      (16#21D#,16#21D#,LL),(16#21E#,16#21E#,LU),(16#21F#,16#21F#,LL),
      (16#220#,16#220#,LU),(16#221#,16#221#,LL),(16#222#,16#222#,LU),
      (16#223#,16#223#,LL),(16#224#,16#224#,LU),(16#225#,16#225#,LL),
      (16#226#,16#226#,LU),(16#227#,16#227#,LL),(16#228#,16#228#,LU),
      (16#229#,16#229#,LL),(16#22A#,16#22A#,LU),(16#22B#,16#22B#,LL),
      (16#22C#,16#22C#,LU),(16#22D#,16#22D#,LL),(16#22E#,16#22E#,LU),
      (16#22F#,16#22F#,LL),(16#230#,16#230#,LU),(16#231#,16#231#,LL),
      (16#232#,16#232#,LU),(16#233#,16#239#,LL),(16#23A#,16#23B#,LU),
      (16#23C#,16#23C#,LL),(16#23D#,16#23E#,LU),(16#23F#,16#240#,LL),
      (16#241#,16#241#,LU),(16#242#,16#242#,LL),(16#243#,16#246#,LU),
      (16#247#,16#247#,LL),(16#248#,16#248#,LU),(16#249#,16#249#,LL),
      (16#24A#,16#24A#,LU),(16#24B#,16#24B#,LL),(16#24C#,16#24C#,LU),
      (16#24D#,16#24D#,LL),(16#24E#,16#24E#,LU),(16#24F#,16#293#,LL),
      (16#294#,16#294#,LO),(16#295#,16#2AF#,LL),(16#2B0#,16#2C1#,LM),
      (16#2C2#,16#2C5#,SK),(16#2C6#,16#2D1#,LM),(16#2D2#,16#2DF#,SK),
      (16#2E0#,16#2E4#,LM),(16#2E5#,16#2ED#,SK),(16#2EE#,16#2EE#,LM),
      (16#2EF#,16#2FF#,SK),(16#300#,16#36F#,MN),(16#374#,16#375#,SK),
      (16#37A#,16#37A#,LM),(16#37B#,16#37D#,LL),(16#37E#,16#37E#,PO),
      (16#384#,16#385#,SK),(16#386#,16#386#,LU),(16#387#,16#387#,PO),
      (16#388#,16#38A#,LU),(16#38C#,16#38C#,LU),(16#38E#,16#38F#,LU),
      (16#390#,16#390#,LL),(16#391#,16#3A1#,LU),(16#3A3#,16#3AB#,LU),
      (16#3AC#,16#3CE#,LL),(16#3D0#,16#3D1#,LL),(16#3D2#,16#3D4#,LU),
      (16#3D5#,16#3D7#,LL),(16#3D8#,16#3D8#,LU),(16#3D9#,16#3D9#,LL),
      (16#3DA#,16#3DA#,LU),(16#3DB#,16#3DB#,LL),(16#3DC#,16#3DC#,LU),
      (16#3DD#,16#3DD#,LL),(16#3DE#,16#3DE#,LU),(16#3DF#,16#3DF#,LL),
      (16#3E0#,16#3E0#,LU),(16#3E1#,16#3E1#,LL),(16#3E2#,16#3E2#,LU),
      (16#3E3#,16#3E3#,LL),(16#3E4#,16#3E4#,LU),(16#3E5#,16#3E5#,LL),
      (16#3E6#,16#3E6#,LU),(16#3E7#,16#3E7#,LL),(16#3E8#,16#3E8#,LU),
      (16#3E9#,16#3E9#,LL),(16#3EA#,16#3EA#,LU),(16#3EB#,16#3EB#,LL),
      (16#3EC#,16#3EC#,LU),(16#3ED#,16#3ED#,LL),(16#3EE#,16#3EE#,LU),
      (16#3EF#,16#3F3#,LL),(16#3F4#,16#3F4#,LU),(16#3F5#,16#3F5#,LL),
      (16#3F6#,16#3F6#,SM),(16#3F7#,16#3F7#,LU),(16#3F8#,16#3F8#,LL),
      (16#3F9#,16#3FA#,LU),(16#3FB#,16#3FC#,LL),(16#3FD#,16#42F#,LU),
      (16#430#,16#45F#,LL),(16#460#,16#460#,LU),(16#461#,16#461#,LL),
      (16#462#,16#462#,LU),(16#463#,16#463#,LL),(16#464#,16#464#,LU),
      (16#465#,16#465#,LL),(16#466#,16#466#,LU),(16#467#,16#467#,LL),
      (16#468#,16#468#,LU),(16#469#,16#469#,LL),(16#46A#,16#46A#,LU),
      (16#46B#,16#46B#,LL),(16#46C#,16#46C#,LU),(16#46D#,16#46D#,LL),
      (16#46E#,16#46E#,LU),(16#46F#,16#46F#,LL),(16#470#,16#470#,LU),
      (16#471#,16#471#,LL),(16#472#,16#472#,LU),(16#473#,16#473#,LL),
      (16#474#,16#474#,LU),(16#475#,16#475#,LL),(16#476#,16#476#,LU),
      (16#477#,16#477#,LL),(16#478#,16#478#,LU),(16#479#,16#479#,LL),
      (16#47A#,16#47A#,LU),(16#47B#,16#47B#,LL),(16#47C#,16#47C#,LU),
      (16#47D#,16#47D#,LL),(16#47E#,16#47E#,LU),(16#47F#,16#47F#,LL),
      (16#480#,16#480#,LU),(16#481#,16#481#,LL),(16#482#,16#482#,SO),
      (16#483#,16#486#,MN),(16#488#,16#489#,ME),(16#48A#,16#48A#,LU),
      (16#48B#,16#48B#,LL),(16#48C#,16#48C#,LU),(16#48D#,16#48D#,LL),
      (16#48E#,16#48E#,LU),(16#48F#,16#48F#,LL),(16#490#,16#490#,LU),
      (16#491#,16#491#,LL),(16#492#,16#492#,LU),(16#493#,16#493#,LL),
      (16#494#,16#494#,LU),(16#495#,16#495#,LL),(16#496#,16#496#,LU),
      (16#497#,16#497#,LL),(16#498#,16#498#,LU),(16#499#,16#499#,LL),
      (16#49A#,16#49A#,LU),(16#49B#,16#49B#,LL),(16#49C#,16#49C#,LU),
      (16#49D#,16#49D#,LL),(16#49E#,16#49E#,LU),(16#49F#,16#49F#,LL),
      (16#4A0#,16#4A0#,LU),(16#4A1#,16#4A1#,LL),(16#4A2#,16#4A2#,LU),
      (16#4A3#,16#4A3#,LL),(16#4A4#,16#4A4#,LU),(16#4A5#,16#4A5#,LL),
      (16#4A6#,16#4A6#,LU),(16#4A7#,16#4A7#,LL),(16#4A8#,16#4A8#,LU),
      (16#4A9#,16#4A9#,LL),(16#4AA#,16#4AA#,LU),(16#4AB#,16#4AB#,LL),
      (16#4AC#,16#4AC#,LU),(16#4AD#,16#4AD#,LL),(16#4AE#,16#4AE#,LU),
      (16#4AF#,16#4AF#,LL),(16#4B0#,16#4B0#,LU),(16#4B1#,16#4B1#,LL),
      (16#4B2#,16#4B2#,LU),(16#4B3#,16#4B3#,LL),(16#4B4#,16#4B4#,LU),
      (16#4B5#,16#4B5#,LL),(16#4B6#,16#4B6#,LU),(16#4B7#,16#4B7#,LL),
      (16#4B8#,16#4B8#,LU),(16#4B9#,16#4B9#,LL),(16#4BA#,16#4BA#,LU),
      (16#4BB#,16#4BB#,LL),(16#4BC#,16#4BC#,LU),(16#4BD#,16#4BD#,LL),
      (16#4BE#,16#4BE#,LU),(16#4BF#,16#4BF#,LL),(16#4C0#,16#4C1#,LU),
      (16#4C2#,16#4C2#,LL),(16#4C3#,16#4C3#,LU),(16#4C4#,16#4C4#,LL),
      (16#4C5#,16#4C5#,LU),(16#4C6#,16#4C6#,LL),(16#4C7#,16#4C7#,LU),
      (16#4C8#,16#4C8#,LL),(16#4C9#,16#4C9#,LU),(16#4CA#,16#4CA#,LL),
      (16#4CB#,16#4CB#,LU),(16#4CC#,16#4CC#,LL),(16#4CD#,16#4CD#,LU),
      (16#4CE#,16#4CF#,LL),(16#4D0#,16#4D0#,LU),(16#4D1#,16#4D1#,LL),
      (16#4D2#,16#4D2#,LU),(16#4D3#,16#4D3#,LL),(16#4D4#,16#4D4#,LU),
      (16#4D5#,16#4D5#,LL),(16#4D6#,16#4D6#,LU),(16#4D7#,16#4D7#,LL),
      (16#4D8#,16#4D8#,LU),(16#4D9#,16#4D9#,LL),(16#4DA#,16#4DA#,LU),
      (16#4DB#,16#4DB#,LL),(16#4DC#,16#4DC#,LU),(16#4DD#,16#4DD#,LL),
      (16#4DE#,16#4DE#,LU),(16#4DF#,16#4DF#,LL),(16#4E0#,16#4E0#,LU),
      (16#4E1#,16#4E1#,LL),(16#4E2#,16#4E2#,LU),(16#4E3#,16#4E3#,LL),
      (16#4E4#,16#4E4#,LU),(16#4E5#,16#4E5#,LL),(16#4E6#,16#4E6#,LU),
      (16#4E7#,16#4E7#,LL),(16#4E8#,16#4E8#,LU),(16#4E9#,16#4E9#,LL),
      (16#4EA#,16#4EA#,LU),(16#4EB#,16#4EB#,LL),(16#4EC#,16#4EC#,LU),
      (16#4ED#,16#4ED#,LL),(16#4EE#,16#4EE#,LU),(16#4EF#,16#4EF#,LL),
      (16#4F0#,16#4F0#,LU),(16#4F1#,16#4F1#,LL),(16#4F2#,16#4F2#,LU),
      (16#4F3#,16#4F3#,LL),(16#4F4#,16#4F4#,LU),(16#4F5#,16#4F5#,LL),
      (16#4F6#,16#4F6#,LU),(16#4F7#,16#4F7#,LL),(16#4F8#,16#4F8#,LU),
      (16#4F9#,16#4F9#,LL),(16#4FA#,16#4FA#,LU),(16#4FB#,16#4FB#,LL),
      (16#4FC#,16#4FC#,LU),(16#4FD#,16#4FD#,LL),(16#4FE#,16#4FE#,LU),
      (16#4FF#,16#4FF#,LL),(16#500#,16#500#,LU),(16#501#,16#501#,LL),
      (16#502#,16#502#,LU),(16#503#,16#503#,LL),(16#504#,16#504#,LU),
      (16#505#,16#505#,LL),(16#506#,16#506#,LU),(16#507#,16#507#,LL),
      (16#508#,16#508#,LU),(16#509#,16#509#,LL),(16#50A#,16#50A#,LU),
      (16#50B#,16#50B#,LL),(16#50C#,16#50C#,LU),(16#50D#,16#50D#,LL),
      (16#50E#,16#50E#,LU),(16#50F#,16#50F#,LL),(16#510#,16#510#,LU),
      (16#511#,16#511#,LL),(16#512#,16#512#,LU),(16#513#,16#513#,LL),
      (16#531#,16#556#,LU),(16#559#,16#559#,LM),(16#55A#,16#55F#,PO),
      (16#561#,16#587#,LL),(16#589#,16#589#,PO),(16#58A#,16#58A#,PD),
      (16#591#,16#5BD#,MN),(16#5BE#,16#5BE#,PO),(16#5BF#,16#5BF#,MN),
      (16#5C0#,16#5C0#,PO),(16#5C1#,16#5C2#,MN),(16#5C3#,16#5C3#,PO),
      (16#5C4#,16#5C5#,MN),(16#5C6#,16#5C6#,PO),(16#5C7#,16#5C7#,MN),
      (16#5D0#,16#5EA#,LO),(16#5F0#,16#5F2#,LO),(16#5F3#,16#5F4#,PO),
      (16#600#,16#603#,CF),(16#60B#,16#60B#,SC),(16#60C#,16#60D#,PO),
      (16#60E#,16#60F#,SO),(16#610#,16#615#,MN),(16#61B#,16#61B#,PO),
      (16#61E#,16#61F#,PO),(16#621#,16#63A#,LO),(16#640#,16#640#,LM),
      (16#641#,16#64A#,LO),(16#64B#,16#65E#,MN),(16#660#,16#669#,ND),
      (16#66A#,16#66D#,PO),(16#66E#,16#66F#,LO),(16#670#,16#670#,MN),
      (16#671#,16#6D3#,LO),(16#6D4#,16#6D4#,PO),(16#6D5#,16#6D5#,LO),
      (16#6D6#,16#6DC#,MN),(16#6DD#,16#6DD#,CF),(16#6DE#,16#6DE#,ME),
      (16#6DF#,16#6E4#,MN),(16#6E5#,16#6E6#,LM),(16#6E7#,16#6E8#,MN),
      (16#6E9#,16#6E9#,SO),(16#6EA#,16#6ED#,MN),(16#6EE#,16#6EF#,LO),
      (16#6F0#,16#6F9#,ND),(16#6FA#,16#6FC#,LO),(16#6FD#,16#6FE#,SO),
      (16#6FF#,16#6FF#,LO),(16#700#,16#70D#,PO),(16#70F#,16#70F#,CF),
      (16#710#,16#710#,LO),(16#711#,16#711#,MN),(16#712#,16#72F#,LO),
      (16#730#,16#74A#,MN),(16#74D#,16#76D#,LO),(16#780#,16#7A5#,LO),
      (16#7A6#,16#7B0#,MN),(16#7B1#,16#7B1#,LO),(16#7C0#,16#7C9#,ND),
      (16#7CA#,16#7EA#,LO),(16#7EB#,16#7F3#,MN),(16#7F4#,16#7F5#,LM),
      (16#7F6#,16#7F6#,SO),(16#7F7#,16#7F9#,PO),(16#7FA#,16#7FA#,LM),
      (16#901#,16#902#,MN),(16#903#,16#903#,MC),(16#904#,16#939#,LO),
      (16#93C#,16#93C#,MN),(16#93D#,16#93D#,LO),(16#93E#,16#940#,MC),
      (16#941#,16#948#,MN),(16#949#,16#94C#,MC),(16#94D#,16#94D#,MN),
      (16#950#,16#950#,LO),(16#951#,16#954#,MN),(16#958#,16#961#,LO),
      (16#962#,16#963#,MN),(16#964#,16#965#,PO),(16#966#,16#96F#,ND),
      (16#970#,16#970#,PO),(16#97B#,16#97F#,LO),(16#981#,16#981#,MN),
      (16#982#,16#983#,MC),(16#985#,16#98C#,LO),(16#98F#,16#990#,LO),
      (16#993#,16#9A8#,LO),(16#9AA#,16#9B0#,LO),(16#9B2#,16#9B2#,LO),
      (16#9B6#,16#9B9#,LO),(16#9BC#,16#9BC#,MN),(16#9BD#,16#9BD#,LO),
      (16#9BE#,16#9C0#,MC),(16#9C1#,16#9C4#,MN),(16#9C7#,16#9C8#,MC),
      (16#9CB#,16#9CC#,MC),(16#9CD#,16#9CD#,MN),(16#9CE#,16#9CE#,LO),
      (16#9D7#,16#9D7#,MC),(16#9DC#,16#9DD#,LO),(16#9DF#,16#9E1#,LO),
      (16#9E2#,16#9E3#,MN),(16#9E6#,16#9EF#,ND),(16#9F0#,16#9F1#,LO),
      (16#9F2#,16#9F3#,SC),(16#9F4#,16#9F9#,NO),(16#9FA#,16#9FA#,SO),
      (16#A01#,16#A02#,MN),(16#A03#,16#A03#,MC),(16#A05#,16#A0A#,LO),
      (16#A0F#,16#A10#,LO),(16#A13#,16#A28#,LO),(16#A2A#,16#A30#,LO),
      (16#A32#,16#A33#,LO),(16#A35#,16#A36#,LO),(16#A38#,16#A39#,LO),
      (16#A3C#,16#A3C#,MN),(16#A3E#,16#A40#,MC),(16#A41#,16#A42#,MN),
      (16#A47#,16#A48#,MN),(16#A4B#,16#A4D#,MN),(16#A59#,16#A5C#,LO),
      (16#A5E#,16#A5E#,LO),(16#A66#,16#A6F#,ND),(16#A70#,16#A71#,MN),
      (16#A72#,16#A74#,LO),(16#A81#,16#A82#,MN),(16#A83#,16#A83#,MC),
      (16#A85#,16#A8D#,LO),(16#A8F#,16#A91#,LO),(16#A93#,16#AA8#,LO),
      (16#AAA#,16#AB0#,LO),(16#AB2#,16#AB3#,LO),(16#AB5#,16#AB9#,LO),
      (16#ABC#,16#ABC#,MN),(16#ABD#,16#ABD#,LO),(16#ABE#,16#AC0#,MC),
      (16#AC1#,16#AC5#,MN),(16#AC7#,16#AC8#,MN),(16#AC9#,16#AC9#,MC),
      (16#ACB#,16#ACC#,MC),(16#ACD#,16#ACD#,MN),(16#AD0#,16#AD0#,LO),
      (16#AE0#,16#AE1#,LO),(16#AE2#,16#AE3#,MN),(16#AE6#,16#AEF#,ND),
      (16#AF1#,16#AF1#,SC),(16#B01#,16#B01#,MN),(16#B02#,16#B03#,MC),
      (16#B05#,16#B0C#,LO),(16#B0F#,16#B10#,LO),(16#B13#,16#B28#,LO),
      (16#B2A#,16#B30#,LO),(16#B32#,16#B33#,LO),(16#B35#,16#B39#,LO),
      (16#B3C#,16#B3C#,MN),(16#B3D#,16#B3D#,LO),(16#B3E#,16#B3E#,MC),
      (16#B3F#,16#B3F#,MN),(16#B40#,16#B40#,MC),(16#B41#,16#B43#,MN),
      (16#B47#,16#B48#,MC),(16#B4B#,16#B4C#,MC),(16#B4D#,16#B4D#,MN),
      (16#B56#,16#B56#,MN),(16#B57#,16#B57#,MC),(16#B5C#,16#B5D#,LO),
      (16#B5F#,16#B61#,LO),(16#B66#,16#B6F#,ND),(16#B70#,16#B70#,SO),
      (16#B71#,16#B71#,LO),(16#B82#,16#B82#,MN),(16#B83#,16#B83#,LO),
      (16#B85#,16#B8A#,LO),(16#B8E#,16#B90#,LO),(16#B92#,16#B95#,LO),
      (16#B99#,16#B9A#,LO),(16#B9C#,16#B9C#,LO),(16#B9E#,16#B9F#,LO),
      (16#BA3#,16#BA4#,LO),(16#BA8#,16#BAA#,LO),(16#BAE#,16#BB9#,LO),
      (16#BBE#,16#BBF#,MC),(16#BC0#,16#BC0#,MN),(16#BC1#,16#BC2#,MC),
      (16#BC6#,16#BC8#,MC),(16#BCA#,16#BCC#,MC),(16#BCD#,16#BCD#,MN),
      (16#BD7#,16#BD7#,MC),(16#BE6#,16#BEF#,ND),(16#BF0#,16#BF2#,NO),
      (16#BF3#,16#BF8#,SO),(16#BF9#,16#BF9#,SC),(16#BFA#,16#BFA#,SO),
      (16#C01#,16#C03#,MC),(16#C05#,16#C0C#,LO),(16#C0E#,16#C10#,LO),
      (16#C12#,16#C28#,LO),(16#C2A#,16#C33#,LO),(16#C35#,16#C39#,LO),
      (16#C3E#,16#C40#,MN),(16#C41#,16#C44#,MC),(16#C46#,16#C48#,MN),
      (16#C4A#,16#C4D#,MN),(16#C55#,16#C56#,MN),(16#C60#,16#C61#,LO),
      (16#C66#,16#C6F#,ND),(16#C82#,16#C83#,MC),(16#C85#,16#C8C#,LO),
      (16#C8E#,16#C90#,LO),(16#C92#,16#CA8#,LO),(16#CAA#,16#CB3#,LO),
      (16#CB5#,16#CB9#,LO),(16#CBC#,16#CBC#,MN),(16#CBD#,16#CBD#,LO),
      (16#CBE#,16#CBE#,MC),(16#CBF#,16#CBF#,MN),(16#CC0#,16#CC4#,MC),
      (16#CC6#,16#CC6#,MN),(16#CC7#,16#CC8#,MC),(16#CCA#,16#CCB#,MC),
      (16#CCC#,16#CCD#,MN),(16#CD5#,16#CD6#,MC),(16#CDE#,16#CDE#,LO),
      (16#CE0#,16#CE1#,LO),(16#CE2#,16#CE3#,MN),(16#CE6#,16#CEF#,ND),
      (16#CF1#,16#CF2#,SO),(16#D02#,16#D03#,MC),(16#D05#,16#D0C#,LO),
      (16#D0E#,16#D10#,LO),(16#D12#,16#D28#,LO),(16#D2A#,16#D39#,LO),
      (16#D3E#,16#D40#,MC),(16#D41#,16#D43#,MN),(16#D46#,16#D48#,MC),
      (16#D4A#,16#D4C#,MC),(16#D4D#,16#D4D#,MN),(16#D57#,16#D57#,MC),
      (16#D60#,16#D61#,LO),(16#D66#,16#D6F#,ND),(16#D82#,16#D83#,MC),
      (16#D85#,16#D96#,LO),(16#D9A#,16#DB1#,LO),(16#DB3#,16#DBB#,LO),
      (16#DBD#,16#DBD#,LO),(16#DC0#,16#DC6#,LO),(16#DCA#,16#DCA#,MN),
      (16#DCF#,16#DD1#,MC),(16#DD2#,16#DD4#,MN),(16#DD6#,16#DD6#,MN),
      (16#DD8#,16#DDF#,MC),(16#DF2#,16#DF3#,MC),(16#DF4#,16#DF4#,PO),
      (16#E01#,16#E30#,LO),(16#E31#,16#E31#,MN),(16#E32#,16#E33#,LO),
      (16#E34#,16#E3A#,MN),(16#E3F#,16#E3F#,SC),(16#E40#,16#E45#,LO),
      (16#E46#,16#E46#,LM),(16#E47#,16#E4E#,MN),(16#E4F#,16#E4F#,PO),
      (16#E50#,16#E59#,ND),(16#E5A#,16#E5B#,PO),(16#E81#,16#E82#,LO),
      (16#E84#,16#E84#,LO),(16#E87#,16#E88#,LO),(16#E8A#,16#E8A#,LO),
      (16#E8D#,16#E8D#,LO),(16#E94#,16#E97#,LO),(16#E99#,16#E9F#,LO),
      (16#EA1#,16#EA3#,LO),(16#EA5#,16#EA5#,LO),(16#EA7#,16#EA7#,LO),
      (16#EAA#,16#EAB#,LO),(16#EAD#,16#EB0#,LO),(16#EB1#,16#EB1#,MN),
      (16#EB2#,16#EB3#,LO),(16#EB4#,16#EB9#,MN),(16#EBB#,16#EBC#,MN),
      (16#EBD#,16#EBD#,LO),(16#EC0#,16#EC4#,LO),(16#EC6#,16#EC6#,LM),
      (16#EC8#,16#ECD#,MN),(16#ED0#,16#ED9#,ND),(16#EDC#,16#EDD#,LO),
      (16#F00#,16#F00#,LO),(16#F01#,16#F03#,SO),(16#F04#,16#F12#,PO),
      (16#F13#,16#F17#,SO),(16#F18#,16#F19#,MN),(16#F1A#,16#F1F#,SO),
      (16#F20#,16#F29#,ND),(16#F2A#,16#F33#,NO),(16#F34#,16#F34#,SO),
      (16#F35#,16#F35#,MN),(16#F36#,16#F36#,SO),(16#F37#,16#F37#,MN),
      (16#F38#,16#F38#,SO),(16#F39#,16#F39#,MN),(16#F3A#,16#F3A#,PS),
      (16#F3B#,16#F3B#,PE),(16#F3C#,16#F3C#,PS),(16#F3D#,16#F3D#,PE),
      (16#F3E#,16#F3F#,MC),(16#F40#,16#F47#,LO),(16#F49#,16#F6A#,LO),
      (16#F71#,16#F7E#,MN),(16#F7F#,16#F7F#,MC),(16#F80#,16#F84#,MN),
      (16#F85#,16#F85#,PO),(16#F86#,16#F87#,MN),(16#F88#,16#F8B#,LO),
      (16#F90#,16#F97#,MN),(16#F99#,16#FBC#,MN),(16#FBE#,16#FC5#,SO),
      (16#FC6#,16#FC6#,MN),(16#FC7#,16#FCC#,SO),(16#FCF#,16#FCF#,SO),
      (16#FD0#,16#FD1#,PO),(16#1000#,16#1021#,LO),(16#1023#,16#1027#,LO),
      (16#1029#,16#102A#,LO),(16#102C#,16#102C#,MC),(16#102D#,16#1030#,MN),
      (16#1031#,16#1031#,MC),(16#1032#,16#1032#,MN),(16#1036#,16#1037#,MN),
      (16#1038#,16#1038#,MC),(16#1039#,16#1039#,MN),(16#1040#,16#1049#,ND),
      (16#104A#,16#104F#,PO),(16#1050#,16#1055#,LO),(16#1056#,16#1057#,MC),
      (16#1058#,16#1059#,MN),(16#10A0#,16#10C5#,LU),(16#10D0#,16#10FA#,LO),
      (16#10FB#,16#10FB#,PO),(16#10FC#,16#10FC#,LM),(16#1100#,16#1159#,LO),
      (16#115F#,16#11A2#,LO),(16#11A8#,16#11F9#,LO),(16#1200#,16#1248#,LO),
      (16#124A#,16#124D#,LO),(16#1250#,16#1256#,LO),(16#1258#,16#1258#,LO),
      (16#125A#,16#125D#,LO),(16#1260#,16#1288#,LO),(16#128A#,16#128D#,LO),
      (16#1290#,16#12B0#,LO),(16#12B2#,16#12B5#,LO),(16#12B8#,16#12BE#,LO),
      (16#12C0#,16#12C0#,LO),(16#12C2#,16#12C5#,LO),(16#12C8#,16#12D6#,LO),
      (16#12D8#,16#1310#,LO),(16#1312#,16#1315#,LO),(16#1318#,16#135A#,LO),
      (16#135F#,16#135F#,MN),(16#1360#,16#1360#,SO),(16#1361#,16#1368#,PO),
      (16#1369#,16#137C#,NO),(16#1380#,16#138F#,LO),(16#1390#,16#1399#,SO),
      (16#13A0#,16#13F4#,LO),(16#1401#,16#166C#,LO),(16#166D#,16#166E#,PO),
      (16#166F#,16#1676#,LO),(16#1680#,16#1680#,ZS),(16#1681#,16#169A#,LO),
      (16#169B#,16#169B#,PS),(16#169C#,16#169C#,PE),(16#16A0#,16#16EA#,LO),
      (16#16EB#,16#16ED#,PO),(16#16EE#,16#16F0#,NL),(16#1700#,16#170C#,LO),
      (16#170E#,16#1711#,LO),(16#1712#,16#1714#,MN),(16#1720#,16#1731#,LO),
      (16#1732#,16#1734#,MN),(16#1735#,16#1736#,PO),(16#1740#,16#1751#,LO),
      (16#1752#,16#1753#,MN),(16#1760#,16#176C#,LO),(16#176E#,16#1770#,LO),
      (16#1772#,16#1773#,MN),(16#1780#,16#17B3#,LO),(16#17B4#,16#17B5#,CF),
      (16#17B6#,16#17B6#,MC),(16#17B7#,16#17BD#,MN),(16#17BE#,16#17C5#,MC),
      (16#17C6#,16#17C6#,MN),(16#17C7#,16#17C8#,MC),(16#17C9#,16#17D3#,MN),
      (16#17D4#,16#17D6#,PO),(16#17D7#,16#17D7#,LM),(16#17D8#,16#17DA#,PO),
      (16#17DB#,16#17DB#,SC),(16#17DC#,16#17DC#,LO),(16#17DD#,16#17DD#,MN),
      (16#17E0#,16#17E9#,ND),(16#17F0#,16#17F9#,NO),(16#1800#,16#1805#,PO),
      (16#1806#,16#1806#,PD),(16#1807#,16#180A#,PO),(16#180B#,16#180D#,MN),
      (16#180E#,16#180E#,ZS),(16#1810#,16#1819#,ND),(16#1820#,16#1842#,LO),
      (16#1843#,16#1843#,LM),(16#1844#,16#1877#,LO),(16#1880#,16#18A8#,LO),
      (16#18A9#,16#18A9#,MN),(16#1900#,16#191C#,LO),(16#1920#,16#1922#,MN),
      (16#1923#,16#1926#,MC),(16#1927#,16#1928#,MN),(16#1929#,16#192B#,MC),
      (16#1930#,16#1931#,MC),(16#1932#,16#1932#,MN),(16#1933#,16#1938#,MC),
      (16#1939#,16#193B#,MN),(16#1940#,16#1940#,SO),(16#1944#,16#1945#,PO),
      (16#1946#,16#194F#,ND),(16#1950#,16#196D#,LO),(16#1970#,16#1974#,LO),
      (16#1980#,16#19A9#,LO),(16#19B0#,16#19C0#,MC),(16#19C1#,16#19C7#,LO),
      (16#19C8#,16#19C9#,MC),(16#19D0#,16#19D9#,ND),(16#19DE#,16#19DF#,PO),
      (16#19E0#,16#19FF#,SO),(16#1A00#,16#1A16#,LO),(16#1A17#,16#1A18#,MN),
      (16#1A19#,16#1A1B#,MC),(16#1A1E#,16#1A1F#,PO),(16#1B00#,16#1B03#,MN),
      (16#1B04#,16#1B04#,MC),(16#1B05#,16#1B33#,LO),(16#1B34#,16#1B34#,MN),
      (16#1B35#,16#1B35#,MC),(16#1B36#,16#1B3A#,MN),(16#1B3B#,16#1B3B#,MC),
      (16#1B3C#,16#1B3C#,MN),(16#1B3D#,16#1B41#,MC),(16#1B42#,16#1B42#,MN),
      (16#1B43#,16#1B44#,MC),(16#1B45#,16#1B4B#,LO),(16#1B50#,16#1B59#,ND),
      (16#1B5A#,16#1B60#,PO),(16#1B61#,16#1B6A#,SO),(16#1B6B#,16#1B73#,MN),
      (16#1B74#,16#1B7C#,SO),(16#1D00#,16#1D2B#,LL),(16#1D2C#,16#1D61#,LM),
      (16#1D62#,16#1D77#,LL),(16#1D78#,16#1D78#,LM),(16#1D79#,16#1D9A#,LL),
      (16#1D9B#,16#1DBF#,LM),(16#1DC0#,16#1DCA#,MN),(16#1DFE#,16#1DFF#,MN),
      (16#1E00#,16#1E00#,LU),(16#1E01#,16#1E01#,LL),(16#1E02#,16#1E02#,LU),
      (16#1E03#,16#1E03#,LL),(16#1E04#,16#1E04#,LU),(16#1E05#,16#1E05#,LL),
      (16#1E06#,16#1E06#,LU),(16#1E07#,16#1E07#,LL),(16#1E08#,16#1E08#,LU),
      (16#1E09#,16#1E09#,LL),(16#1E0A#,16#1E0A#,LU),(16#1E0B#,16#1E0B#,LL),
      (16#1E0C#,16#1E0C#,LU),(16#1E0D#,16#1E0D#,LL),(16#1E0E#,16#1E0E#,LU),
      (16#1E0F#,16#1E0F#,LL),(16#1E10#,16#1E10#,LU),(16#1E11#,16#1E11#,LL),
      (16#1E12#,16#1E12#,LU),(16#1E13#,16#1E13#,LL),(16#1E14#,16#1E14#,LU),
      (16#1E15#,16#1E15#,LL),(16#1E16#,16#1E16#,LU),(16#1E17#,16#1E17#,LL),
      (16#1E18#,16#1E18#,LU),(16#1E19#,16#1E19#,LL),(16#1E1A#,16#1E1A#,LU),
      (16#1E1B#,16#1E1B#,LL),(16#1E1C#,16#1E1C#,LU),(16#1E1D#,16#1E1D#,LL),
      (16#1E1E#,16#1E1E#,LU),(16#1E1F#,16#1E1F#,LL),(16#1E20#,16#1E20#,LU),
      (16#1E21#,16#1E21#,LL),(16#1E22#,16#1E22#,LU),(16#1E23#,16#1E23#,LL),
      (16#1E24#,16#1E24#,LU),(16#1E25#,16#1E25#,LL),(16#1E26#,16#1E26#,LU),
      (16#1E27#,16#1E27#,LL),(16#1E28#,16#1E28#,LU),(16#1E29#,16#1E29#,LL),
      (16#1E2A#,16#1E2A#,LU),(16#1E2B#,16#1E2B#,LL),(16#1E2C#,16#1E2C#,LU),
      (16#1E2D#,16#1E2D#,LL),(16#1E2E#,16#1E2E#,LU),(16#1E2F#,16#1E2F#,LL),
      (16#1E30#,16#1E30#,LU),(16#1E31#,16#1E31#,LL),(16#1E32#,16#1E32#,LU),
      (16#1E33#,16#1E33#,LL),(16#1E34#,16#1E34#,LU),(16#1E35#,16#1E35#,LL),
      (16#1E36#,16#1E36#,LU),(16#1E37#,16#1E37#,LL),(16#1E38#,16#1E38#,LU),
      (16#1E39#,16#1E39#,LL),(16#1E3A#,16#1E3A#,LU),(16#1E3B#,16#1E3B#,LL),
      (16#1E3C#,16#1E3C#,LU),(16#1E3D#,16#1E3D#,LL),(16#1E3E#,16#1E3E#,LU),
      (16#1E3F#,16#1E3F#,LL),(16#1E40#,16#1E40#,LU),(16#1E41#,16#1E41#,LL),
      (16#1E42#,16#1E42#,LU),(16#1E43#,16#1E43#,LL),(16#1E44#,16#1E44#,LU),
      (16#1E45#,16#1E45#,LL),(16#1E46#,16#1E46#,LU),(16#1E47#,16#1E47#,LL),
      (16#1E48#,16#1E48#,LU),(16#1E49#,16#1E49#,LL),(16#1E4A#,16#1E4A#,LU),
      (16#1E4B#,16#1E4B#,LL),(16#1E4C#,16#1E4C#,LU),(16#1E4D#,16#1E4D#,LL),
      (16#1E4E#,16#1E4E#,LU),(16#1E4F#,16#1E4F#,LL),(16#1E50#,16#1E50#,LU),
      (16#1E51#,16#1E51#,LL),(16#1E52#,16#1E52#,LU),(16#1E53#,16#1E53#,LL),
      (16#1E54#,16#1E54#,LU),(16#1E55#,16#1E55#,LL),(16#1E56#,16#1E56#,LU),
      (16#1E57#,16#1E57#,LL),(16#1E58#,16#1E58#,LU),(16#1E59#,16#1E59#,LL),
      (16#1E5A#,16#1E5A#,LU),(16#1E5B#,16#1E5B#,LL),(16#1E5C#,16#1E5C#,LU),
      (16#1E5D#,16#1E5D#,LL),(16#1E5E#,16#1E5E#,LU),(16#1E5F#,16#1E5F#,LL),
      (16#1E60#,16#1E60#,LU),(16#1E61#,16#1E61#,LL),(16#1E62#,16#1E62#,LU),
      (16#1E63#,16#1E63#,LL),(16#1E64#,16#1E64#,LU),(16#1E65#,16#1E65#,LL),
      (16#1E66#,16#1E66#,LU),(16#1E67#,16#1E67#,LL),(16#1E68#,16#1E68#,LU),
      (16#1E69#,16#1E69#,LL),(16#1E6A#,16#1E6A#,LU),(16#1E6B#,16#1E6B#,LL),
      (16#1E6C#,16#1E6C#,LU),(16#1E6D#,16#1E6D#,LL),(16#1E6E#,16#1E6E#,LU),
      (16#1E6F#,16#1E6F#,LL),(16#1E70#,16#1E70#,LU),(16#1E71#,16#1E71#,LL),
      (16#1E72#,16#1E72#,LU),(16#1E73#,16#1E73#,LL),(16#1E74#,16#1E74#,LU),
      (16#1E75#,16#1E75#,LL),(16#1E76#,16#1E76#,LU),(16#1E77#,16#1E77#,LL),
      (16#1E78#,16#1E78#,LU),(16#1E79#,16#1E79#,LL),(16#1E7A#,16#1E7A#,LU),
      (16#1E7B#,16#1E7B#,LL),(16#1E7C#,16#1E7C#,LU),(16#1E7D#,16#1E7D#,LL),
      (16#1E7E#,16#1E7E#,LU),(16#1E7F#,16#1E7F#,LL),(16#1E80#,16#1E80#,LU),
      (16#1E81#,16#1E81#,LL),(16#1E82#,16#1E82#,LU),(16#1E83#,16#1E83#,LL),
      (16#1E84#,16#1E84#,LU),(16#1E85#,16#1E85#,LL),(16#1E86#,16#1E86#,LU),
      (16#1E87#,16#1E87#,LL),(16#1E88#,16#1E88#,LU),(16#1E89#,16#1E89#,LL),
      (16#1E8A#,16#1E8A#,LU),(16#1E8B#,16#1E8B#,LL),(16#1E8C#,16#1E8C#,LU),
      (16#1E8D#,16#1E8D#,LL),(16#1E8E#,16#1E8E#,LU),(16#1E8F#,16#1E8F#,LL),
      (16#1E90#,16#1E90#,LU),(16#1E91#,16#1E91#,LL),(16#1E92#,16#1E92#,LU),
      (16#1E93#,16#1E93#,LL),(16#1E94#,16#1E94#,LU),(16#1E95#,16#1E9B#,LL),
      (16#1EA0#,16#1EA0#,LU),(16#1EA1#,16#1EA1#,LL),(16#1EA2#,16#1EA2#,LU),
      (16#1EA3#,16#1EA3#,LL),(16#1EA4#,16#1EA4#,LU),(16#1EA5#,16#1EA5#,LL),
      (16#1EA6#,16#1EA6#,LU),(16#1EA7#,16#1EA7#,LL),(16#1EA8#,16#1EA8#,LU),
      (16#1EA9#,16#1EA9#,LL),(16#1EAA#,16#1EAA#,LU),(16#1EAB#,16#1EAB#,LL),
      (16#1EAC#,16#1EAC#,LU),(16#1EAD#,16#1EAD#,LL),(16#1EAE#,16#1EAE#,LU),
      (16#1EAF#,16#1EAF#,LL),(16#1EB0#,16#1EB0#,LU),(16#1EB1#,16#1EB1#,LL),
      (16#1EB2#,16#1EB2#,LU),(16#1EB3#,16#1EB3#,LL),(16#1EB4#,16#1EB4#,LU),
      (16#1EB5#,16#1EB5#,LL),(16#1EB6#,16#1EB6#,LU),(16#1EB7#,16#1EB7#,LL),
      (16#1EB8#,16#1EB8#,LU),(16#1EB9#,16#1EB9#,LL),(16#1EBA#,16#1EBA#,LU),
      (16#1EBB#,16#1EBB#,LL),(16#1EBC#,16#1EBC#,LU),(16#1EBD#,16#1EBD#,LL),
      (16#1EBE#,16#1EBE#,LU),(16#1EBF#,16#1EBF#,LL),(16#1EC0#,16#1EC0#,LU),
      (16#1EC1#,16#1EC1#,LL),(16#1EC2#,16#1EC2#,LU),(16#1EC3#,16#1EC3#,LL),
      (16#1EC4#,16#1EC4#,LU),(16#1EC5#,16#1EC5#,LL),(16#1EC6#,16#1EC6#,LU),
      (16#1EC7#,16#1EC7#,LL),(16#1EC8#,16#1EC8#,LU),(16#1EC9#,16#1EC9#,LL),
      (16#1ECA#,16#1ECA#,LU),(16#1ECB#,16#1ECB#,LL),(16#1ECC#,16#1ECC#,LU),
      (16#1ECD#,16#1ECD#,LL),(16#1ECE#,16#1ECE#,LU),(16#1ECF#,16#1ECF#,LL),
      (16#1ED0#,16#1ED0#,LU),(16#1ED1#,16#1ED1#,LL),(16#1ED2#,16#1ED2#,LU),
      (16#1ED3#,16#1ED3#,LL),(16#1ED4#,16#1ED4#,LU),(16#1ED5#,16#1ED5#,LL),
      (16#1ED6#,16#1ED6#,LU),(16#1ED7#,16#1ED7#,LL),(16#1ED8#,16#1ED8#,LU),
      (16#1ED9#,16#1ED9#,LL),(16#1EDA#,16#1EDA#,LU),(16#1EDB#,16#1EDB#,LL),
      (16#1EDC#,16#1EDC#,LU),(16#1EDD#,16#1EDD#,LL),(16#1EDE#,16#1EDE#,LU),
      (16#1EDF#,16#1EDF#,LL),(16#1EE0#,16#1EE0#,LU),(16#1EE1#,16#1EE1#,LL),
      (16#1EE2#,16#1EE2#,LU),(16#1EE3#,16#1EE3#,LL),(16#1EE4#,16#1EE4#,LU),
      (16#1EE5#,16#1EE5#,LL),(16#1EE6#,16#1EE6#,LU),(16#1EE7#,16#1EE7#,LL),
      (16#1EE8#,16#1EE8#,LU),(16#1EE9#,16#1EE9#,LL),(16#1EEA#,16#1EEA#,LU),
      (16#1EEB#,16#1EEB#,LL),(16#1EEC#,16#1EEC#,LU),(16#1EED#,16#1EED#,LL),
      (16#1EEE#,16#1EEE#,LU),(16#1EEF#,16#1EEF#,LL),(16#1EF0#,16#1EF0#,LU),
      (16#1EF1#,16#1EF1#,LL),(16#1EF2#,16#1EF2#,LU),(16#1EF3#,16#1EF3#,LL),
      (16#1EF4#,16#1EF4#,LU),(16#1EF5#,16#1EF5#,LL),(16#1EF6#,16#1EF6#,LU),
      (16#1EF7#,16#1EF7#,LL),(16#1EF8#,16#1EF8#,LU),(16#1EF9#,16#1EF9#,LL),
      (16#1F00#,16#1F07#,LL),(16#1F08#,16#1F0F#,LU),(16#1F10#,16#1F15#,LL),
      (16#1F18#,16#1F1D#,LU),(16#1F20#,16#1F27#,LL),(16#1F28#,16#1F2F#,LU),
      (16#1F30#,16#1F37#,LL),(16#1F38#,16#1F3F#,LU),(16#1F40#,16#1F45#,LL),
      (16#1F48#,16#1F4D#,LU),(16#1F50#,16#1F57#,LL),(16#1F59#,16#1F59#,LU),
      (16#1F5B#,16#1F5B#,LU),(16#1F5D#,16#1F5D#,LU),(16#1F5F#,16#1F5F#,LU),
      (16#1F60#,16#1F67#,LL),(16#1F68#,16#1F6F#,LU),(16#1F70#,16#1F7D#,LL),
      (16#1F80#,16#1F87#,LL),(16#1F88#,16#1F8F#,LT),(16#1F90#,16#1F97#,LL),
      (16#1F98#,16#1F9F#,LT),(16#1FA0#,16#1FA7#,LL),(16#1FA8#,16#1FAF#,LT),
      (16#1FB0#,16#1FB4#,LL),(16#1FB6#,16#1FB7#,LL),(16#1FB8#,16#1FBB#,LU),
      (16#1FBC#,16#1FBC#,LT),(16#1FBD#,16#1FBD#,SK),(16#1FBE#,16#1FBE#,LL),
      (16#1FBF#,16#1FC1#,SK),(16#1FC2#,16#1FC4#,LL),(16#1FC6#,16#1FC7#,LL),
      (16#1FC8#,16#1FCB#,LU),(16#1FCC#,16#1FCC#,LT),(16#1FCD#,16#1FCF#,SK),
      (16#1FD0#,16#1FD3#,LL),(16#1FD6#,16#1FD7#,LL),(16#1FD8#,16#1FDB#,LU),
      (16#1FDD#,16#1FDF#,SK),(16#1FE0#,16#1FE7#,LL),(16#1FE8#,16#1FEC#,LU),
      (16#1FED#,16#1FEF#,SK),(16#1FF2#,16#1FF4#,LL),(16#1FF6#,16#1FF7#,LL),
      (16#1FF8#,16#1FFB#,LU),(16#1FFC#,16#1FFC#,LT),(16#1FFD#,16#1FFE#,SK),
      (16#2000#,16#200A#,ZS),(16#200B#,16#200F#,CF),(16#2010#,16#2015#,PD),
      (16#2016#,16#2017#,PO),(16#2018#,16#2018#,PI),(16#2019#,16#2019#,PF),
      (16#201A#,16#201A#,PS),(16#201B#,16#201C#,PI),(16#201D#,16#201D#,PF),
      (16#201E#,16#201E#,PS),(16#201F#,16#201F#,PI),(16#2020#,16#2027#,PO),
      (16#2028#,16#2028#,ZL),(16#2029#,16#2029#,ZP),(16#202A#,16#202E#,CF),
      (16#202F#,16#202F#,ZS),(16#2030#,16#2038#,PO),(16#2039#,16#2039#,PI),
      (16#203A#,16#203A#,PF),(16#203B#,16#203E#,PO),(16#203F#,16#2040#,PC),
      (16#2041#,16#2043#,PO),(16#2044#,16#2044#,SM),(16#2045#,16#2045#,PS),
      (16#2046#,16#2046#,PE),(16#2047#,16#2051#,PO),(16#2052#,16#2052#,SM),
      (16#2053#,16#2053#,PO),(16#2054#,16#2054#,PC),(16#2055#,16#205E#,PO),
      (16#205F#,16#205F#,ZS),(16#2060#,16#2063#,CF),(16#206A#,16#206F#,CF),
      (16#2070#,16#2070#,NO),(16#2071#,16#2071#,LL),(16#2074#,16#2079#,NO),
      (16#207A#,16#207C#,SM),(16#207D#,16#207D#,PS),(16#207E#,16#207E#,PE),
      (16#207F#,16#207F#,LL),(16#2080#,16#2089#,NO),(16#208A#,16#208C#,SM),
      (16#208D#,16#208D#,PS),(16#208E#,16#208E#,PE),(16#2090#,16#2094#,LM),
      (16#20A0#,16#20B5#,SC),(16#20D0#,16#20DC#,MN),(16#20DD#,16#20E0#,ME),
      (16#20E1#,16#20E1#,MN),(16#20E2#,16#20E4#,ME),(16#20E5#,16#20EF#,MN),
      (16#2100#,16#2101#,SO),(16#2102#,16#2102#,LU),(16#2103#,16#2106#,SO),
      (16#2107#,16#2107#,LU),(16#2108#,16#2109#,SO),(16#210A#,16#210A#,LL),
      (16#210B#,16#210D#,LU),(16#210E#,16#210F#,LL),(16#2110#,16#2112#,LU),
      (16#2113#,16#2113#,LL),(16#2114#,16#2114#,SO),(16#2115#,16#2115#,LU),
      (16#2116#,16#2118#,SO),(16#2119#,16#211D#,LU),(16#211E#,16#2123#,SO),
      (16#2124#,16#2124#,LU),(16#2125#,16#2125#,SO),(16#2126#,16#2126#,LU),
      (16#2127#,16#2127#,SO),(16#2128#,16#2128#,LU),(16#2129#,16#2129#,SO),
      (16#212A#,16#212D#,LU),(16#212E#,16#212E#,SO),(16#212F#,16#212F#,LL),
      (16#2130#,16#2133#,LU),(16#2134#,16#2134#,LL),(16#2135#,16#2138#,LO),
      (16#2139#,16#2139#,LL),(16#213A#,16#213B#,SO),(16#213C#,16#213D#,LL),
      (16#213E#,16#213F#,LU),(16#2140#,16#2144#,SM),(16#2145#,16#2145#,LU),
      (16#2146#,16#2149#,LL),(16#214A#,16#214A#,SO),(16#214B#,16#214B#,SM),
      (16#214C#,16#214D#,SO),(16#214E#,16#214E#,LL),(16#2153#,16#215F#,NO),
      (16#2160#,16#2182#,NL),(16#2183#,16#2183#,LU),(16#2184#,16#2184#,LL),
      (16#2190#,16#2194#,SM),(16#2195#,16#2199#,SO),(16#219A#,16#219B#,SM),
      (16#219C#,16#219F#,SO),(16#21A0#,16#21A0#,SM),(16#21A1#,16#21A2#,SO),
      (16#21A3#,16#21A3#,SM),(16#21A4#,16#21A5#,SO),(16#21A6#,16#21A6#,SM),
      (16#21A7#,16#21AD#,SO),(16#21AE#,16#21AE#,SM),(16#21AF#,16#21CD#,SO),
      (16#21CE#,16#21CF#,SM),(16#21D0#,16#21D1#,SO),(16#21D2#,16#21D2#,SM),
      (16#21D3#,16#21D3#,SO),(16#21D4#,16#21D4#,SM),(16#21D5#,16#21F3#,SO),
      (16#21F4#,16#22FF#,SM),(16#2300#,16#2307#,SO),(16#2308#,16#230B#,SM),
      (16#230C#,16#231F#,SO),(16#2320#,16#2321#,SM),(16#2322#,16#2328#,SO),
      (16#2329#,16#2329#,PS),(16#232A#,16#232A#,PE),(16#232B#,16#237B#,SO),
      (16#237C#,16#237C#,SM),(16#237D#,16#239A#,SO),(16#239B#,16#23B3#,SM),
      (16#23B4#,16#23DB#,SO),(16#23DC#,16#23E1#,SM),(16#23E2#,16#23E7#,SO),
      (16#2400#,16#2426#,SO),(16#2440#,16#244A#,SO),(16#2460#,16#249B#,NO),
      (16#249C#,16#24E9#,SO),(16#24EA#,16#24FF#,NO),(16#2500#,16#25B6#,SO),
      (16#25B7#,16#25B7#,SM),(16#25B8#,16#25C0#,SO),(16#25C1#,16#25C1#,SM),
      (16#25C2#,16#25F7#,SO),(16#25F8#,16#25FF#,SM),(16#2600#,16#266E#,SO),
      (16#266F#,16#266F#,SM),(16#2670#,16#269C#,SO),(16#26A0#,16#26B2#,SO),
      (16#2701#,16#2704#,SO),(16#2706#,16#2709#,SO),(16#270C#,16#2727#,SO),
      (16#2729#,16#274B#,SO),(16#274D#,16#274D#,SO),(16#274F#,16#2752#,SO),
      (16#2756#,16#2756#,SO),(16#2758#,16#275E#,SO),(16#2761#,16#2767#,SO),
      (16#2768#,16#2768#,PS),(16#2769#,16#2769#,PE),(16#276A#,16#276A#,PS),
      (16#276B#,16#276B#,PE),(16#276C#,16#276C#,PS),(16#276D#,16#276D#,PE),
      (16#276E#,16#276E#,PS),(16#276F#,16#276F#,PE),(16#2770#,16#2770#,PS),
      (16#2771#,16#2771#,PE),(16#2772#,16#2772#,PS),(16#2773#,16#2773#,PE),
      (16#2774#,16#2774#,PS),(16#2775#,16#2775#,PE),(16#2776#,16#2793#,NO),
      (16#2794#,16#2794#,SO),(16#2798#,16#27AF#,SO),(16#27B1#,16#27BE#,SO),
      (16#27C0#,16#27C4#,SM),(16#27C5#,16#27C5#,PS),(16#27C6#,16#27C6#,PE),
      (16#27C7#,16#27CA#,SM),(16#27D0#,16#27E5#,SM),(16#27E6#,16#27E6#,PS),
      (16#27E7#,16#27E7#,PE),(16#27E8#,16#27E8#,PS),(16#27E9#,16#27E9#,PE),
      (16#27EA#,16#27EA#,PS),(16#27EB#,16#27EB#,PE),(16#27F0#,16#27FF#,SM),
      (16#2800#,16#28FF#,SO),(16#2900#,16#2982#,SM),(16#2983#,16#2983#,PS),
      (16#2984#,16#2984#,PE),(16#2985#,16#2985#,PS),(16#2986#,16#2986#,PE),
      (16#2987#,16#2987#,PS),(16#2988#,16#2988#,PE),(16#2989#,16#2989#,PS),
      (16#298A#,16#298A#,PE),(16#298B#,16#298B#,PS),(16#298C#,16#298C#,PE),
      (16#298D#,16#298D#,PS),(16#298E#,16#298E#,PE),(16#298F#,16#298F#,PS),
      (16#2990#,16#2990#,PE),(16#2991#,16#2991#,PS),(16#2992#,16#2992#,PE),
      (16#2993#,16#2993#,PS),(16#2994#,16#2994#,PE),(16#2995#,16#2995#,PS),
      (16#2996#,16#2996#,PE),(16#2997#,16#2997#,PS),(16#2998#,16#2998#,PE),
      (16#2999#,16#29D7#,SM),(16#29D8#,16#29D8#,PS),(16#29D9#,16#29D9#,PE),
      (16#29DA#,16#29DA#,PS),(16#29DB#,16#29DB#,PE),(16#29DC#,16#29FB#,SM),
      (16#29FC#,16#29FC#,PS),(16#29FD#,16#29FD#,PE),(16#29FE#,16#2AFF#,SM),
      (16#2B00#,16#2B1A#,SO),(16#2B20#,16#2B23#,SO),(16#2C00#,16#2C2E#,LU),
      (16#2C30#,16#2C5E#,LL),(16#2C60#,16#2C60#,LU),(16#2C61#,16#2C61#,LL),
      (16#2C62#,16#2C64#,LU),(16#2C65#,16#2C66#,LL),(16#2C67#,16#2C67#,LU),
      (16#2C68#,16#2C68#,LL),(16#2C69#,16#2C69#,LU),(16#2C6A#,16#2C6A#,LL),
      (16#2C6B#,16#2C6B#,LU),(16#2C6C#,16#2C6C#,LL),(16#2C74#,16#2C74#,LL),
      (16#2C75#,16#2C75#,LU),(16#2C76#,16#2C77#,LL),(16#2C80#,16#2C80#,LU),
      (16#2C81#,16#2C81#,LL),(16#2C82#,16#2C82#,LU),(16#2C83#,16#2C83#,LL),
      (16#2C84#,16#2C84#,LU),(16#2C85#,16#2C85#,LL),(16#2C86#,16#2C86#,LU),
      (16#2C87#,16#2C87#,LL),(16#2C88#,16#2C88#,LU),(16#2C89#,16#2C89#,LL),
      (16#2C8A#,16#2C8A#,LU),(16#2C8B#,16#2C8B#,LL),(16#2C8C#,16#2C8C#,LU),
      (16#2C8D#,16#2C8D#,LL),(16#2C8E#,16#2C8E#,LU),(16#2C8F#,16#2C8F#,LL),
      (16#2C90#,16#2C90#,LU),(16#2C91#,16#2C91#,LL),(16#2C92#,16#2C92#,LU),
      (16#2C93#,16#2C93#,LL),(16#2C94#,16#2C94#,LU),(16#2C95#,16#2C95#,LL),
      (16#2C96#,16#2C96#,LU),(16#2C97#,16#2C97#,LL),(16#2C98#,16#2C98#,LU),
      (16#2C99#,16#2C99#,LL),(16#2C9A#,16#2C9A#,LU),(16#2C9B#,16#2C9B#,LL),
      (16#2C9C#,16#2C9C#,LU),(16#2C9D#,16#2C9D#,LL),(16#2C9E#,16#2C9E#,LU),
      (16#2C9F#,16#2C9F#,LL),(16#2CA0#,16#2CA0#,LU),(16#2CA1#,16#2CA1#,LL),
      (16#2CA2#,16#2CA2#,LU),(16#2CA3#,16#2CA3#,LL),(16#2CA4#,16#2CA4#,LU),
      (16#2CA5#,16#2CA5#,LL),(16#2CA6#,16#2CA6#,LU),(16#2CA7#,16#2CA7#,LL),
      (16#2CA8#,16#2CA8#,LU),(16#2CA9#,16#2CA9#,LL),(16#2CAA#,16#2CAA#,LU),
      (16#2CAB#,16#2CAB#,LL),(16#2CAC#,16#2CAC#,LU),(16#2CAD#,16#2CAD#,LL),
      (16#2CAE#,16#2CAE#,LU),(16#2CAF#,16#2CAF#,LL),(16#2CB0#,16#2CB0#,LU),
      (16#2CB1#,16#2CB1#,LL),(16#2CB2#,16#2CB2#,LU),(16#2CB3#,16#2CB3#,LL),
      (16#2CB4#,16#2CB4#,LU),(16#2CB5#,16#2CB5#,LL),(16#2CB6#,16#2CB6#,LU),
      (16#2CB7#,16#2CB7#,LL),(16#2CB8#,16#2CB8#,LU),(16#2CB9#,16#2CB9#,LL),
      (16#2CBA#,16#2CBA#,LU),(16#2CBB#,16#2CBB#,LL),(16#2CBC#,16#2CBC#,LU),
      (16#2CBD#,16#2CBD#,LL),(16#2CBE#,16#2CBE#,LU),(16#2CBF#,16#2CBF#,LL),
      (16#2CC0#,16#2CC0#,LU),(16#2CC1#,16#2CC1#,LL),(16#2CC2#,16#2CC2#,LU),
      (16#2CC3#,16#2CC3#,LL),(16#2CC4#,16#2CC4#,LU),(16#2CC5#,16#2CC5#,LL),
      (16#2CC6#,16#2CC6#,LU),(16#2CC7#,16#2CC7#,LL),(16#2CC8#,16#2CC8#,LU),
      (16#2CC9#,16#2CC9#,LL),(16#2CCA#,16#2CCA#,LU),(16#2CCB#,16#2CCB#,LL),
      (16#2CCC#,16#2CCC#,LU),(16#2CCD#,16#2CCD#,LL),(16#2CCE#,16#2CCE#,LU),
      (16#2CCF#,16#2CCF#,LL),(16#2CD0#,16#2CD0#,LU),(16#2CD1#,16#2CD1#,LL),
      (16#2CD2#,16#2CD2#,LU),(16#2CD3#,16#2CD3#,LL),(16#2CD4#,16#2CD4#,LU),
      (16#2CD5#,16#2CD5#,LL),(16#2CD6#,16#2CD6#,LU),(16#2CD7#,16#2CD7#,LL),
      (16#2CD8#,16#2CD8#,LU),(16#2CD9#,16#2CD9#,LL),(16#2CDA#,16#2CDA#,LU),
      (16#2CDB#,16#2CDB#,LL),(16#2CDC#,16#2CDC#,LU),(16#2CDD#,16#2CDD#,LL),
      (16#2CDE#,16#2CDE#,LU),(16#2CDF#,16#2CDF#,LL),(16#2CE0#,16#2CE0#,LU),
      (16#2CE1#,16#2CE1#,LL),(16#2CE2#,16#2CE2#,LU),(16#2CE3#,16#2CE4#,LL),
      (16#2CE5#,16#2CEA#,SO),(16#2CF9#,16#2CFC#,PO),(16#2CFD#,16#2CFD#,NO),
      (16#2CFE#,16#2CFF#,PO),(16#2D00#,16#2D25#,LL),(16#2D30#,16#2D65#,LO),
      (16#2D6F#,16#2D6F#,LM),(16#2D80#,16#2D96#,LO),(16#2DA0#,16#2DA6#,LO),
      (16#2DA8#,16#2DAE#,LO),(16#2DB0#,16#2DB6#,LO),(16#2DB8#,16#2DBE#,LO),
      (16#2DC0#,16#2DC6#,LO),(16#2DC8#,16#2DCE#,LO),(16#2DD0#,16#2DD6#,LO),
      (16#2DD8#,16#2DDE#,LO),(16#2E00#,16#2E01#,PO),(16#2E02#,16#2E02#,PI),
      (16#2E03#,16#2E03#,PF),(16#2E04#,16#2E04#,PI),(16#2E05#,16#2E05#,PF),
      (16#2E06#,16#2E08#,PO),(16#2E09#,16#2E09#,PI),(16#2E0A#,16#2E0A#,PF),
      (16#2E0B#,16#2E0B#,PO),(16#2E0C#,16#2E0C#,PI),(16#2E0D#,16#2E0D#,PF),
      (16#2E0E#,16#2E16#,PO),(16#2E17#,16#2E17#,PD),(16#2E1C#,16#2E1C#,PI),
      (16#2E1D#,16#2E1D#,PF),(16#2E80#,16#2E99#,SO),(16#2E9B#,16#2EF3#,SO),
      (16#2F00#,16#2FD5#,SO),(16#2FF0#,16#2FFB#,SO),(16#3000#,16#3000#,ZS),
      (16#3001#,16#3003#,PO),(16#3004#,16#3004#,SO),(16#3005#,16#3005#,LM),
      (16#3006#,16#3006#,LO),(16#3007#,16#3007#,NL),(16#3008#,16#3008#,PS),
      (16#3009#,16#3009#,PE),(16#300A#,16#300A#,PS),(16#300B#,16#300B#,PE),
      (16#300C#,16#300C#,PS),(16#300D#,16#300D#,PE),(16#300E#,16#300E#,PS),
      (16#300F#,16#300F#,PE),(16#3010#,16#3010#,PS),(16#3011#,16#3011#,PE),
      (16#3012#,16#3013#,SO),(16#3014#,16#3014#,PS),(16#3015#,16#3015#,PE),
      (16#3016#,16#3016#,PS),(16#3017#,16#3017#,PE),(16#3018#,16#3018#,PS),
      (16#3019#,16#3019#,PE),(16#301A#,16#301A#,PS),(16#301B#,16#301B#,PE),
      (16#301C#,16#301C#,PD),(16#301D#,16#301D#,PS),(16#301E#,16#301F#,PE),
      (16#3020#,16#3020#,SO),(16#3021#,16#3029#,NL),(16#302A#,16#302F#,MN),
      (16#3030#,16#3030#,PD),(16#3031#,16#3035#,LM),(16#3036#,16#3037#,SO),
      (16#3038#,16#303A#,NL),(16#303B#,16#303B#,LM),(16#303C#,16#303C#,LO),
      (16#303D#,16#303D#,PO),(16#303E#,16#303F#,SO),(16#3041#,16#3096#,LO),
      (16#3099#,16#309A#,MN),(16#309B#,16#309C#,SK),(16#309D#,16#309E#,LM),
      (16#309F#,16#309F#,LO),(16#30A0#,16#30A0#,PD),(16#30A1#,16#30FA#,LO),
      (16#30FB#,16#30FB#,PO),(16#30FC#,16#30FE#,LM),(16#30FF#,16#30FF#,LO),
      (16#3105#,16#312C#,LO),(16#3131#,16#318E#,LO),(16#3190#,16#3191#,SO),
      (16#3192#,16#3195#,NO),(16#3196#,16#319F#,SO),(16#31A0#,16#31B7#,LO),
      (16#31C0#,16#31CF#,SO),(16#31F0#,16#31FF#,LO),(16#3200#,16#321E#,SO),
      (16#3220#,16#3229#,NO),(16#322A#,16#3243#,SO),(16#3250#,16#3250#,SO),
      (16#3251#,16#325F#,NO),(16#3260#,16#327F#,SO),(16#3280#,16#3289#,NO),
      (16#328A#,16#32B0#,SO),(16#32B1#,16#32BF#,NO),(16#32C0#,16#32FE#,SO),
      (16#3300#,16#33FF#,SO),(16#3400#,16#3400#,LO),(16#4DB5#,16#4DB5#,LO),
      (16#4DC0#,16#4DFF#,SO),(16#4E00#,16#4E00#,LO),(16#9FBB#,16#9FBB#,LO),
      (16#A000#,16#A014#,LO),(16#A015#,16#A015#,LM),(16#A016#,16#A48C#,LO),
      (16#A490#,16#A4C6#,SO),(16#A700#,16#A716#,SK),(16#A717#,16#A71A#,LM),
      (16#A720#,16#A721#,SK),(16#A800#,16#A801#,LO),(16#A802#,16#A802#,MC),
      (16#A803#,16#A805#,LO),(16#A806#,16#A806#,MN),(16#A807#,16#A80A#,LO),
      (16#A80B#,16#A80B#,MN),(16#A80C#,16#A822#,LO),(16#A823#,16#A824#,MC),
      (16#A825#,16#A826#,MN),(16#A827#,16#A827#,MC),(16#A828#,16#A82B#,SO),
      (16#A840#,16#A873#,LO),(16#A874#,16#A877#,PO),(16#AC00#,16#AC00#,LO),
      (16#D7A3#,16#D7A3#,LO),(16#D800#,16#D800#,CS),(16#DB7F#,16#DB80#,CS),
      (16#DBFF#,16#DC00#,CS),(16#DFFF#,16#DFFF#,CS),(16#E000#,16#E000#,CO),
      (16#F8FF#,16#F8FF#,CO),(16#F900#,16#FA2D#,LO),(16#FA30#,16#FA6A#,LO),
      (16#FA70#,16#FAD9#,LO),(16#FB00#,16#FB06#,LL),(16#FB13#,16#FB17#,LL),
      (16#FB1D#,16#FB1D#,LO),(16#FB1E#,16#FB1E#,MN),(16#FB1F#,16#FB28#,LO),
      (16#FB29#,16#FB29#,SM),(16#FB2A#,16#FB36#,LO),(16#FB38#,16#FB3C#,LO),
      (16#FB3E#,16#FB3E#,LO),(16#FB40#,16#FB41#,LO),(16#FB43#,16#FB44#,LO),
      (16#FB46#,16#FBB1#,LO),(16#FBD3#,16#FD3D#,LO),(16#FD3E#,16#FD3E#,PS),
      (16#FD3F#,16#FD3F#,PE),(16#FD50#,16#FD8F#,LO),(16#FD92#,16#FDC7#,LO),
      (16#FDF0#,16#FDFB#,LO),(16#FDFC#,16#FDFC#,SC),(16#FDFD#,16#FDFD#,SO),
      (16#FE00#,16#FE0F#,MN),(16#FE10#,16#FE16#,PO),(16#FE17#,16#FE17#,PS),
      (16#FE18#,16#FE18#,PE),(16#FE19#,16#FE19#,PO),(16#FE20#,16#FE23#,MN),
      (16#FE30#,16#FE30#,PO),(16#FE31#,16#FE32#,PD),(16#FE33#,16#FE34#,PC),
      (16#FE35#,16#FE35#,PS),(16#FE36#,16#FE36#,PE),(16#FE37#,16#FE37#,PS),
      (16#FE38#,16#FE38#,PE),(16#FE39#,16#FE39#,PS),(16#FE3A#,16#FE3A#,PE),
      (16#FE3B#,16#FE3B#,PS),(16#FE3C#,16#FE3C#,PE),(16#FE3D#,16#FE3D#,PS),
      (16#FE3E#,16#FE3E#,PE),(16#FE3F#,16#FE3F#,PS),(16#FE40#,16#FE40#,PE),
      (16#FE41#,16#FE41#,PS),(16#FE42#,16#FE42#,PE),(16#FE43#,16#FE43#,PS),
      (16#FE44#,16#FE44#,PE),(16#FE45#,16#FE46#,PO),(16#FE47#,16#FE47#,PS),
      (16#FE48#,16#FE48#,PE),(16#FE49#,16#FE4C#,PO),(16#FE4D#,16#FE4F#,PC),
      (16#FE50#,16#FE52#,PO),(16#FE54#,16#FE57#,PO),(16#FE58#,16#FE58#,PD),
      (16#FE59#,16#FE59#,PS),(16#FE5A#,16#FE5A#,PE),(16#FE5B#,16#FE5B#,PS),
      (16#FE5C#,16#FE5C#,PE),(16#FE5D#,16#FE5D#,PS),(16#FE5E#,16#FE5E#,PE),
      (16#FE5F#,16#FE61#,PO),(16#FE62#,16#FE62#,SM),(16#FE63#,16#FE63#,PD),
      (16#FE64#,16#FE66#,SM),(16#FE68#,16#FE68#,PO),(16#FE69#,16#FE69#,SC),
      (16#FE6A#,16#FE6B#,PO),(16#FE70#,16#FE74#,LO),(16#FE76#,16#FEFC#,LO),
      (16#FEFF#,16#FEFF#,CF),(16#FF01#,16#FF03#,PO),(16#FF04#,16#FF04#,SC),
      (16#FF05#,16#FF07#,PO),(16#FF08#,16#FF08#,PS),(16#FF09#,16#FF09#,PE),
      (16#FF0A#,16#FF0A#,PO),(16#FF0B#,16#FF0B#,SM),(16#FF0C#,16#FF0C#,PO),
      (16#FF0D#,16#FF0D#,PD),(16#FF0E#,16#FF0F#,PO),(16#FF10#,16#FF19#,ND),
      (16#FF1A#,16#FF1B#,PO),(16#FF1C#,16#FF1E#,SM),(16#FF1F#,16#FF20#,PO),
      (16#FF21#,16#FF3A#,LU),(16#FF3B#,16#FF3B#,PS),(16#FF3C#,16#FF3C#,PO),
      (16#FF3D#,16#FF3D#,PE),(16#FF3E#,16#FF3E#,SK),(16#FF3F#,16#FF3F#,PC),
      (16#FF40#,16#FF40#,SK),(16#FF41#,16#FF5A#,LL),(16#FF5B#,16#FF5B#,PS),
      (16#FF5C#,16#FF5C#,SM),(16#FF5D#,16#FF5D#,PE),(16#FF5E#,16#FF5E#,SM),
      (16#FF5F#,16#FF5F#,PS),(16#FF60#,16#FF60#,PE),(16#FF61#,16#FF61#,PO),
      (16#FF62#,16#FF62#,PS),(16#FF63#,16#FF63#,PE),(16#FF64#,16#FF65#,PO),
      (16#FF66#,16#FF6F#,LO),(16#FF70#,16#FF70#,LM),(16#FF71#,16#FF9D#,LO),
      (16#FF9E#,16#FF9F#,LM),(16#FFA0#,16#FFBE#,LO),(16#FFC2#,16#FFC7#,LO),
      (16#FFCA#,16#FFCF#,LO),(16#FFD2#,16#FFD7#,LO),(16#FFDA#,16#FFDC#,LO),
      (16#FFE0#,16#FFE1#,SC),(16#FFE2#,16#FFE2#,SM),(16#FFE3#,16#FFE3#,SK),
      (16#FFE4#,16#FFE4#,SO),(16#FFE5#,16#FFE6#,SC),(16#FFE8#,16#FFE8#,SO),
      (16#FFE9#,16#FFEC#,SM),(16#FFED#,16#FFEE#,SO),(16#FFF9#,16#FFFB#,CF),
      (16#FFFC#,16#FFFD#,SO),(16#10000#,16#1000B#,LO),(16#1000D#,16#10026#,LO),
      (16#10028#,16#1003A#,LO),(16#1003C#,16#1003D#,LO),(16#1003F#,16#1004D#,LO),
      (16#10050#,16#1005D#,LO),(16#10080#,16#100FA#,LO),(16#10100#,16#10101#,PO),
      (16#10102#,16#10102#,SO),(16#10107#,16#10133#,NO),(16#10137#,16#1013F#,SO),
      (16#10140#,16#10174#,NL),(16#10175#,16#10178#,NO),(16#10179#,16#10189#,SO),
      (16#1018A#,16#1018A#,NO),(16#10300#,16#1031E#,LO),(16#10320#,16#10323#,NO),
      (16#10330#,16#10340#,LO),(16#10341#,16#10341#,NL),(16#10342#,16#10349#,LO),
      (16#1034A#,16#1034A#,NL),(16#10380#,16#1039D#,LO),(16#1039F#,16#1039F#,PO),
      (16#103A0#,16#103C3#,LO),(16#103C8#,16#103CF#,LO),(16#103D0#,16#103D0#,PO),
      (16#103D1#,16#103D5#,NL),(16#10400#,16#10427#,LU),(16#10428#,16#1044F#,LL),
      (16#10450#,16#1049D#,LO),(16#104A0#,16#104A9#,ND),(16#10800#,16#10805#,LO),
      (16#10808#,16#10808#,LO),(16#1080A#,16#10835#,LO),(16#10837#,16#10838#,LO),
      (16#1083C#,16#1083C#,LO),(16#1083F#,16#1083F#,LO),(16#10900#,16#10915#,LO),
      (16#10916#,16#10919#,NO),(16#1091F#,16#1091F#,PO),(16#10A00#,16#10A00#,LO),
      (16#10A01#,16#10A03#,MN),(16#10A05#,16#10A06#,MN),(16#10A0C#,16#10A0F#,MN),
      (16#10A10#,16#10A13#,LO),(16#10A15#,16#10A17#,LO),(16#10A19#,16#10A33#,LO),
      (16#10A38#,16#10A3A#,MN),(16#10A3F#,16#10A3F#,MN),(16#10A40#,16#10A47#,NO),
      (16#10A50#,16#10A58#,PO),(16#12000#,16#1236E#,LO),(16#12400#,16#12462#,NL),
      (16#12470#,16#12473#,PO),(16#1D000#,16#1D0F5#,SO),(16#1D100#,16#1D126#,SO),
      (16#1D12A#,16#1D164#,SO),(16#1D165#,16#1D166#,MC),(16#1D167#,16#1D169#,MN),
      (16#1D16A#,16#1D16C#,SO),(16#1D16D#,16#1D172#,MC),(16#1D173#,16#1D17A#,CF),
      (16#1D17B#,16#1D182#,MN),(16#1D183#,16#1D184#,SO),(16#1D185#,16#1D18B#,MN),
      (16#1D18C#,16#1D1A9#,SO),(16#1D1AA#,16#1D1AD#,MN),(16#1D1AE#,16#1D1DD#,SO),
      (16#1D200#,16#1D241#,SO),(16#1D242#,16#1D244#,MN),(16#1D245#,16#1D245#,SO),
      (16#1D300#,16#1D356#,SO),(16#1D360#,16#1D371#,NO),(16#1D400#,16#1D419#,LU),
      (16#1D41A#,16#1D433#,LL),(16#1D434#,16#1D44D#,LU),(16#1D44E#,16#1D454#,LL),
      (16#1D456#,16#1D467#,LL),(16#1D468#,16#1D481#,LU),(16#1D482#,16#1D49B#,LL),
      (16#1D49C#,16#1D49C#,LU),(16#1D49E#,16#1D49F#,LU),(16#1D4A2#,16#1D4A2#,LU),
      (16#1D4A5#,16#1D4A6#,LU),(16#1D4A9#,16#1D4AC#,LU),(16#1D4AE#,16#1D4B5#,LU),
      (16#1D4B6#,16#1D4B9#,LL),(16#1D4BB#,16#1D4BB#,LL),(16#1D4BD#,16#1D4C3#,LL),
      (16#1D4C5#,16#1D4CF#,LL),(16#1D4D0#,16#1D4E9#,LU),(16#1D4EA#,16#1D503#,LL),
      (16#1D504#,16#1D505#,LU),(16#1D507#,16#1D50A#,LU),(16#1D50D#,16#1D514#,LU),
      (16#1D516#,16#1D51C#,LU),(16#1D51E#,16#1D537#,LL),(16#1D538#,16#1D539#,LU),
      (16#1D53B#,16#1D53E#,LU),(16#1D540#,16#1D544#,LU),(16#1D546#,16#1D546#,LU),
      (16#1D54A#,16#1D550#,LU),(16#1D552#,16#1D56B#,LL),(16#1D56C#,16#1D585#,LU),
      (16#1D586#,16#1D59F#,LL),(16#1D5A0#,16#1D5B9#,LU),(16#1D5BA#,16#1D5D3#,LL),
      (16#1D5D4#,16#1D5ED#,LU),(16#1D5EE#,16#1D607#,LL),(16#1D608#,16#1D621#,LU),
      (16#1D622#,16#1D63B#,LL),(16#1D63C#,16#1D655#,LU),(16#1D656#,16#1D66F#,LL),
      (16#1D670#,16#1D689#,LU),(16#1D68A#,16#1D6A5#,LL),(16#1D6A8#,16#1D6C0#,LU),
      (16#1D6C1#,16#1D6C1#,SM),(16#1D6C2#,16#1D6DA#,LL),(16#1D6DB#,16#1D6DB#,SM),
      (16#1D6DC#,16#1D6E1#,LL),(16#1D6E2#,16#1D6FA#,LU),(16#1D6FB#,16#1D6FB#,SM),
      (16#1D6FC#,16#1D714#,LL),(16#1D715#,16#1D715#,SM),(16#1D716#,16#1D71B#,LL),
      (16#1D71C#,16#1D734#,LU),(16#1D735#,16#1D735#,SM),(16#1D736#,16#1D74E#,LL),
      (16#1D74F#,16#1D74F#,SM),(16#1D750#,16#1D755#,LL),(16#1D756#,16#1D76E#,LU),
      (16#1D76F#,16#1D76F#,SM),(16#1D770#,16#1D788#,LL),(16#1D789#,16#1D789#,SM),
      (16#1D78A#,16#1D78F#,LL),(16#1D790#,16#1D7A8#,LU),(16#1D7A9#,16#1D7A9#,SM),
      (16#1D7AA#,16#1D7C2#,LL),(16#1D7C3#,16#1D7C3#,SM),(16#1D7C4#,16#1D7C9#,LL),
      (16#1D7CA#,16#1D7CA#,LU),(16#1D7CB#,16#1D7CB#,LL),(16#1D7CE#,16#1D7FF#,ND),
      (16#20000#,16#20000#,LO),(16#2A6D6#,16#2A6D6#,LO),(16#2F800#,16#2FA1D#,LO),
      (16#E0001#,16#E0001#,CF),(16#E0020#,16#E007F#,CF),(16#E0100#,16#E01EF#,MN),
      (16#F0000#,16#F0000#,CO),(16#FFFFD#,16#FFFFD#,CO),(16#100000#,16#100000#,CO),
      (16#10FFFD#,16#10FFFD#,CO)
   );

   function Category (Value : UTF8_Code_Point)
      return General_Category is
      From : Range_Index := Mapping'First;
      To   : Range_Index := Mapping'Last;
      This : Range_Index;
      Current : Points_Range;
   begin
      loop
         This := (From + To) / 2;
         Current := Mapping (This);
         if Current.From > Value then
            exit when This = From;
            To := This - 1;
         elsif Current.To < Value then
            exit when This = To;
            From := This + 1;
         else
            return Current.Category;
         end if;
      end loop;
      return Co;
   end Category;

   function Is_Alphanumeric (Value : in UTF8_Code_Point)
      return Boolean is
   begin
      case Category (Value) is
         when Letter | Nd =>
            return True;
         when others =>
            return False;
      end case;
   end Is_Alphanumeric;

   function Is_Control (Value : in UTF8_Code_Point) return Boolean is
   begin
      return Category (Value) = Cc;
   end Is_Control;

   function Is_Identifier_Extend (Value : in UTF8_Code_Point)
      return Boolean is
   begin
      case Category (Value) is
         when Mn | Mc | Nd | Pc | Cf =>
            return True;
         when others =>
            return False;
      end case;
   end Is_Identifier_Extend;

   function Is_Identifier_Start (Value : in UTF8_Code_Point)
      return Boolean is
   begin
      case Category (Value) is
         when Letter | Nl =>
            return True;
         when others =>
            return False;
      end case;
   end Is_Identifier_Start;

   function Is_ISO_646 (Value : in UTF8_Code_Point) return Boolean is
   begin
      return Value <= 16#7F#;
   end Is_ISO_646;

   function Is_Letter (Value : in UTF8_Code_Point) return Boolean is
   begin
      return Category (Value) in Letter;
   end Is_Letter;

   function Is_Lower (Value : in UTF8_Code_Point) return Boolean is
   begin
      return Category (Value) = Ll;
   end Is_Lower;

   function Is_Digit (Value : in UTF8_Code_Point) return Boolean is
   begin
      return Category (Value) = Nd;
   end Is_Digit;

   function Is_Other_Format (Value : in UTF8_Code_Point)
      return Boolean is
   begin
      return Category (Value) = Cf;
   end Is_Other_Format;

   function Is_Space (Value : in UTF8_Code_Point) return Boolean is
   begin
      return Category (Value) = Zs;
   end Is_Space;

   function Is_Subscript_Digit (Value : in UTF8_Code_Point)
      return Boolean is
   begin
      return Value in 16#2080#..16#208A#;
   end Is_Subscript_Digit;

   function Is_Superscript_Digit (Value : in UTF8_Code_Point)
      return Boolean is
   begin
      case Value is
         when 16#B2#..16#B3# | 16#B9# | 16#2070#..16#2079# =>
            return True;
         when others =>
            return False;
      end case;
   end Is_Superscript_Digit;

   function Is_Title (Value : in UTF8_Code_Point) return Boolean is
   begin
      return Category (Value) = Lt;
   end Is_Title;

   function Is_Upper (Value : in UTF8_Code_Point) return Boolean is
   begin
      return Category (Value) = Lu;
   end Is_Upper;

end Strings_Edit.UTF8.Categorization;
