
//# -- Copyright (C) 2017  <fastrgv@gmail.com>
//# --
//# -- This program is free software: you can redistribute it and/or modify
//# -- it under the terms of the GNU General Public License as published by
//# -- the Free Software Foundation, either version 3 of the License, or
//# -- (at your option) any later version.
//# --
//# -- This program is distributed in the hope that it will be useful,
//# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
//# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//# -- GNU General Public License for more details.
//# --
//# -- You may read the full text of the GNU General Public License
//# -- at <http://www.gnu.org/licenses/>.


#include "snd4ada.hpp"

#include <SFML/Audio.hpp>
#include <SFML/System.hpp>
#include <cassert>

#include <string>
using std::string;


static sf::Music  *pKorlaM, *pKorlaT;

static sf::Sound * psound, *wsound;

// transient psounds here:
//                       6        7         8     9      10       11        12
static sf::SoundBuffer *pFanfare, *pStone, *pDn, *pdDie, *pUp, *pdEat, *pWater;

//                      4       5
static sf::SoundBuffer *pRoar, *pWon;


void termSnds(void)
{
	//(*psound).stop(); // might not be necessary
	stopSndLoop();
	stopMusicLoop();

	delete psound;
	delete wsound;

	delete pRoar;
	delete pWon;
	delete pFanfare;
	delete pStone;
	delete pDn;
	delete pdDie;
	delete pUp;
	delete pKorlaM;
	delete pKorlaT;
	delete pWater;
	delete pdEat;

}


//void initSnds(void)
int initSnds(void)
{

 const string sbr("data/roar.wav"); //4
 const string sbw("data/won.wav");  //5

 // 6, 7, 8, 9, 10, 11
 const string sbf("data/fanfare.wav");
 const string sbs("data/concrete.ogg");
 const string sbx("data/putdown.wav");
 const string sdd("data/dragondie.wav"); // 9=dragondie
 const string sqp("data/pickup.wav");
 const string sde("data/eaten.wav");  // 11=eaten
 const string wat("data/lake-water.ogg");


 // named loops:

//note: ffmpeg-produced-ogg format not supported...
//      use sox to convert to ogg format

 const string mkp("data/misrlu.ogg");
 const string tkp("data/turkish.ogg");

// end loops, begin transients:

psound    = new sf::Sound;
wsound    = new sf::Sound;

pRoar = new sf::SoundBuffer; //4
pWon  = new sf::SoundBuffer; //5

pFanfare  = new sf::SoundBuffer;
pStone  = new sf::SoundBuffer;
pDn  = new sf::SoundBuffer;
pdDie   = new sf::SoundBuffer;
pUp  = new sf::SoundBuffer;
pWater = new sf::SoundBuffer;
pdEat = new sf::SoundBuffer;


pKorlaM = new sf::Music;
pKorlaT = new sf::Music;



	if( !(*pRoar).loadFromFile(sbr) ) return 4;
	if( !(*pWon).loadFromFile(sbw) ) return 5;

	if( !(*pFanfare).loadFromFile(sbf) ) return 10;
	if( !(*pStone).loadFromFile(sbs) ) return 11;
	if( !(*pDn).loadFromFile(sbx) ) return 12;
	if( !(*pdDie).loadFromFile(sdd) ) return 13;
	if( !(*pUp).loadFromFile(sqp) ) return 14;
	if( !(*pdEat).loadFromFile(sde) ) return 15;
	if( !(*pWater).loadFromFile(wat) ) return 16;


	if( !(*pKorlaM).openFromFile(mkp) ) return 17;
	if( !(*pKorlaT).openFromFile(tkp) ) return 18;

	(*pKorlaM).setLoop(true);
	(*pKorlaM).setVolume(90);

	(*pKorlaT).setLoop(true);
	(*pKorlaT).setVolume(90);



	(*wsound).setLoop(true);
	(*wsound).setVolume(50);


	(*psound).setLoop(false);
	(*psound).setVolume(100);

	return 0;

} // end initSnds




void playWatr(void) {
	sf::Sound & wound(*wsound);

	wound.setBuffer(*pWater);
	wound.setVolume(50);
	wound.setLoop(true);
	wound.play();
}

void stopSndLoop(void) {
		(*wsound).stop();
}




void stopMusicLoop(void) {

	if( sf::Music::Playing == (*pKorlaM).getStatus() )  
		(*pKorlaM).stop();
	if( sf::Music::Playing == (*pKorlaT).getStatus() )  
		(*pKorlaT).stop();

}


void playMisr(void) {
	(*pKorlaM).play();
}

void playTurk(void) {
	(*pKorlaT).play();
}




// these next procs start, stop
// the music loops:

/*
void playMisr(void) {
	sf::Sound & sound(*psound);

	sound.setBuffer(*pKorlaM);
	sound.setVolume(90);
	sound.setLoop(true);
	sound.play();
}

void playTurk(void) {
	sf::Sound & sound(*psound);

	sound.setBuffer(*pKorlaT);
	sound.setVolume(90);
	sound.setLoop(true);
	sound.play();
}
*/












void playSnd( int nbuf ) {

	sf::Sound & sound(*psound);


	assert(nbuf>=4);
	assert(nbuf<=11);


	if( nbuf==4 )
	{
		sound.setBuffer(*pRoar);
		sound.setLoop(false);
		sound.setVolume(80);
		sound.play();
	}

	else if( nbuf==5 )
	{
		sound.setBuffer(*pWon);
		sound.setLoop(false);
		sound.setVolume(80);
		sound.play();
	}


	else if( nbuf==6 )
	{
		sound.setBuffer(*pFanfare);
		sound.setLoop(false);
		sound.setVolume(50);
		sound.play();
	}
	else if( nbuf==7 )
	{
		sound.setBuffer(*pStone);
		sound.setLoop(false);
		sound.setVolume(100);
		sound.play();
	}

	else if( nbuf==8 )
	{
		sound.setBuffer(*pDn);
		sound.setLoop(false);
		sound.setVolume(50);
		sound.play();

	}


	else if( nbuf==9 )
	{
		sound.setBuffer(*pdDie);
		sound.setLoop(false);
		sound.setVolume(100);
		sound.play();
	}


	else if( nbuf==10 )
	{
		sound.setBuffer(*pUp);
		sound.setLoop(false);
		sound.setVolume(50);
		sound.play();

	}

	else if( nbuf==11 )
	{
		sound.setBuffer(*pdEat);
		sound.setLoop(false);
		sound.setVolume(99);
		sound.play();
	}



} // end playSnd


