
--
-- Copyright (C) 2016  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with ada.numerics.generic_elementary_functions;
with matutils;  use matutils;




with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

-------------------------------------------------------------
with System;
with Interfaces.C;
use  type interfaces.c.unsigned;
use  type interfaces.c.c_float;
with Interfaces.C.Pointers;
with interfaces.c.strings;

use interfaces.c;
use interfaces.c.strings;

---------------------------------------------------------
with sdl;  use sdl;
---------------------------

with ada.unchecked_conversion;
with ada.text_io; use ada.text_io;
with Ada.Command_Line;
with Ada.Strings.Unbounded;
with Ada.Strings.Unbounded.Text_IO;

----------------------------------------------------------------


with shader;  use shader;

with cylobj;
with droomobj;
with rectobj;
with rectxobj;
with rectsurfobj;
with avatarobj;
with pictobj;
with twictobj;
with xtreeobj;
with ztubeobj;


with cubemapobj;
with itemobj;

with text_io;  use text_io;









package gametypes is



	use gl;
	use matutils;
	use type interfaces.c.c_float;




	type vec3 is array(1..3) of float;

	package fmath is new
			Ada.Numerics.generic_elementary_functions( float );



	onepi : constant float     := 3.14159_26535_89793;
	halfpi : constant float    := onepi/2.0;
	thirdpi : constant float   := onepi/3.0;
	fourthpi : constant float  := onepi/4.0;
	eighthpi : constant float  := onepi/8.0;
	twopi : constant float     := onepi*2.0;
	deg2rad : constant float   := onepi/180.0;
	rad2deg : constant float   := 180.0/onepi;



---------- begin game controller ----------------------------------------

cfgfile : string := "./settings.txt";

Lsens, Rsens, Jsens : float := 1.0; -- paddle sensitivities

gshtl,gshtr,gjmp,
jshtl,jshtr,jjmp,  -- read from cfg file
jbak,jfor : glint; -- button maps

gamepad, joystik : boolean; --flags presence of game controllers
jsa : access SDL_JoyStick;

axis_lx, axis_ly, axis_rx, axis_ry : sdl.Sint16;

btn_2, btn_3,
btn_4, btn_5, 
btn_6, btn_7, btn_8, btn_9,
btn_0, btn_1
	: sdl.Uint8;


---------- end game controller ----------------------------------------



	mousex,mousey : aliased interfaces.c.int;

	state, ileft, iright : integer;



	oldTimeKb : float := 0.0;
	mousestate : Uint32;
	deltaT : float;

	speed : constant float := 2.0;
	pauseatlevelchange : boolean := false;
	forwardok : boolean := true;


	vertbuff, uvbuff, elembuff, rgbbuff, vertexarrayid : gluint;






-- begin string pointers for getUniformLocation:

	phrad  : chars_ptr := new_string("hrad"&ascii.nul);
	phpos  : chars_ptr := new_string("hole"&ascii.nul);

	phang : chars_ptr := new_string("horiAng"&ascii.nul);

	psand : chars_ptr := new_string("sandLevel"&ascii.nul);
	ppid : chars_ptr := new_string("palmID"&ascii.nul);
	pmytime : chars_ptr := new_string("mytime"&ascii.nul);

	pmyfade : chars_ptr := new_string("fade"&ascii.nul);
	pmydir : chars_ptr := new_string("direction"&ascii.nul);

	pwPos : chars_ptr := new_string("wPos"&ascii.nul);
	pwRad : chars_ptr := new_string("wRad"&ascii.nul);

	pmv : chars_ptr := new_string("MV"&ascii.nul);
	pmvp : chars_ptr := new_string("MVP"&ascii.nul);
	pdark : chars_ptr := new_string("darkness"&ascii.nul);
	pmylev : chars_ptr := new_string("level"&ascii.nul);
	pmyclr : chars_ptr := new_string("colr"&ascii.nul);
	pmyts : chars_ptr := new_string("myTextureSampler"&ascii.nul);
	popac : chars_ptr := new_string("NormalOpacity"&ascii.nul);
	pcubemap : chars_ptr := new_string("CubeMap"&ascii.nul);

	ptime : chars_ptr := new_string("time"&ascii.nul);
	presol : chars_ptr := new_string("resolution"&ascii.nul);


	prad  : chars_ptr := new_string("rad"&ascii.nul);
	pangl : chars_ptr := new_string("angl"&ascii.nul);
	pwvel : chars_ptr := new_string("wvel"&ascii.nul);
	pwamp : chars_ptr := new_string("wamp"&ascii.nul);


-- end string pointers for getUniformLocation:







----- time variables ---------------------------------------------------
	currentTime,
	deltabtntime, lasttime,
	foldtime, boldtime, jumptime : float := -20.0;
----- time variables ---------------------------------------------------


	winwidth, winheight : interfaces.c.int := 500;







	--mv,mvp, pm, vm, mm, bmm,bmvp, imvp,mmvp,mmv, 
	pm,mv,imv,  mmvp, imvp :  mat44 := identity;



	nearpedestal: constant float := 0.8; --0.5;
	nearchalice: constant float := 1.0;

	rsword : constant float := 0.2;
	nearsword : constant float := 0.5; --0.8;

	htobj: constant float := 0.02;
	rkey : constant float := 0.1;
	nearkey : constant float := 0.5; --0.8;

	neargate : constant float := 1.0;



	schalice : integer := 4;

	sgkey,
	sbkey,
	ssword,
	swkey: integer := 1; -- scene #

	xgkey, ygkey, zgkey, -- green key to maze
	xbkey, ybkey, zbkey, -- black key to temple
	xsword,ysword,zsword,
	xwkey, ywkey, zwkey, -- white key to castle
	xme,yme,zme, 
	oxme,oyme,ozme: float := 0.0; -- virtual position


	fovrad : constant float := fourthpi;
	fovdeg : constant float := fourthpi*rad2deg;
	--mindot : constant float := fmath.cos(fourthpi);
	--mindot2: constant float := fmath.cos(60.0*deg2rad);


	margin     : constant float := 0.2; --0.20; 18sep16
	aheight    : constant float := 0.5;
	userexit : boolean := false;

repassage: constant float := 2.0; --seconds between door crossings

-- this must greater than margin
here: constant float := 0.25;
step: constant float := 0.28; --just beyond "here" threshold
--threshold distance from maze transitions

eps : constant float := 0.02; --dist maze gate from wall

	-- scene parms

	-- exterior dimensions
	xmax : constant float := 20.0;
	ymax : constant float := 20.0;
	zmax : constant float := 20.0;

	-- exterior User domain of (xme,zme), somewhat more limited
	-- so we don't encounter the edge of our flat world.
	xmaxu: constant float := 18.0;
	zmaxu: constant float := 18.0;

	ixmax : constant float :=10.0;
	iymax : constant float := 3.0;
	izmax : constant float :=10.0;

hmax: constant float := 0.0;
wlev: constant float := 0.0;
r1 : constant float := 10.0;
r2 : constant float := 20.0;
r3 : constant float := 30.0;



	skybox: cubemapobj.cubemap;



	hcup: constant glfloat := 0.2;
	wcup: constant glfloat := 0.1;

	xped,zped, yped,
	xchalice,ychalice,zchalice : glfloat;







	jumping : boolean := false;
	pyjump : float := -ymax+aheight;
	vyjump : float := 0.0;



	rox: rectxobj.rectx; --maze-ceiling uses fancy frag.shader

	mz: integer := 0; -- # maze walls defined
	
	mxbloks : constant integer := 25;  -- to build castle, maze
	mwall, wallblok : array(1..mxbloks) of rectobj.rectangle; --wall

avatar,
	zpwall,zmwall,xpwall,xmwall,
	mfloor,tfloor,floor, rceil,
	wallxp, wallxm, wallzp, wallzm : rectobj.rectangle;

	tree, chalice: xtreeobj.treeangle;

	ixmaze,iymaze,izmaze,
	ixtmpl,iytmpl,iztmpl,
	 xtmpl, ytmpl, ztmpl : float;

	ymaze: float;
	xmaze: constant float := 7.0; --5.0;
	zmaze: constant float := 5.0; --4.4; --5.0-0.61;

	dmaze: constant float := 0.7; -- nearness defining "at-maze"
	ddoor: constant float := 0.4; -- nearness "atdoor"
	dtmpl: constant float := 0.9; -- nearness "attemple"



	xlion, ylion, zlion,
	ixdoor, iydoor, izdoor,
	xdoor,ydoor,zdoor: float;

	-- scene #5
	doorc, doord, doore, doorf, doorg,
	doory, doorz, doorv, doorw, doorx,

	-- scene #6
	doora1,doora2, doorb1, doorb2,
	doorv6,doorw6,doorx6,doory6,doorz6,
	doorc6,doord6,doore6,doorf6,doorg6,

	-- scene #7
	al7,ar7,bl7,br7,cl7,cr7,dl7,dr7,el7,er7,fl7,fr7, g7, h7,
	lg7,lh7, ex7,

	-- scene #8
	g8,h8, eg8,eh8,

	imazedoor: pictobj.pictangle;

	beam12,
	dungdoor,
	--imazeexit,
	beam34,
	rsafe, rdoor,
	wallmoor,
	--korla,
	idung,
	omazedoor,
	bdragon,
	rdragon,

	minotaur,

	sword,
	pedestal,
	rug, ceil,
	porch, key1, key2, key3,
	--hallway, 
	gatem1,gatem2,
	gatexp, gatexm, gatezp, gatezm : pictobj.pictangle;

	korla: twictobj.twictangle;

	zpmural,
	ihallway, ohallway : pictobj.pictangle;



	xaxis : constant vec3 := (1.0,0.0,0.0);
	yaxis : constant vec3 := (0.0,1.0,0.0);
	zaxis : constant vec3 := (0.0,0.0,1.0);
	axis : vec3 := ( others => 0.0 );




	rotx,roty,rotz : float := 0.0;

	maxnko : constant integer := 900;
	nko, level, oldlevel : integer := 0;

	koscene: array(1..maxnko) of integer := (others=>1);

	koxlo, koxhi, koylo,koyhi, kozlo,kozhi : array(1..maxnko) of float;
	onledge : array(1..maxnko) of boolean;



------------------------ begin stuff from main -----------------------------

	mainWindow : access SDL_Window;
	mainGLContext : SDL_GLContext;




	contextFlags : sdl_windowflags;
	current : aliased SDL_DisplayMode;
	should_be_zero : glint;
	cursor : access SDL_Cursor;

	Fwid, Fhit : aliased interfaces.c.int;

	ret : interfaces.c.int;
	numkeys : aliased glint;

	error : interfaces.c.int;


	--subtype keyindex is interfaces.c.int range 0..511;
	--type keyarraytype is array(keyindex) of Uint8;
	key_map : access sdl.keyarraytype;






	use gl;
	use matutils;
	use type interfaces.c.c_float;



	iskylight,
	--xskylight,
	pillar5, pillar6, pillar7,
	pillar8, pillar9, pillar10,
	pillar3, pillar4,
	pillar1, pillar2 : cylobj.cylinder;


	tfile: text_io.file_type;

	intro: boolean := true;

	drawchalice, chalicegone: boolean := false;


	slime_texid, moss_texid, roots_texid,
	labWall_texid, labMaze_texid,

	korla_texid,
	exit_texid,
	lab_texid,

	avatar_texid,
	snake_texid,

	intview_texid,

	tree1_texid, tree2_texid, tree3_texid,
	tree4_texid, tree5_texid,
	spalm_texid, tpalm_texid,

	--doorwood_texid,
	mural_texid,
	greekey_texid,
	adobe_texid,
	lion_texid,
	greenrockwall_texid,
	stonedoor_texid,
	gmarble_texid,
	bmarble_texid,
	--pmarble_texid,
	--temple_texid,
	--templet_texid,
	moorwall_texid,
	--mazewall_texid, 
	mazeouter_texid,
	doort_texid,
	doortw_texid,
	door_texid, hedge_texid,
	deadbdragon_texid,
	deadrdragon_texid,
	deadminotaur_texid,
	bat1_texid, bat2_texid,
	chalice_texid, sword_texid,
	cherry_texid, room_texid, ceil_texid, floor_texid, rug_texid,
	wood_texid, hall_texid, key_texid, 
	gkey_texid, bkey_texid,	gate_texid,
	darkcubemap_texid, 
	sunnycubemap_texid,
	cloudycubemap_texid,
	mooncubemap_texid,
	grass1_texid, 

	grass_texid, stone_texid : gluint := 0;





	playSecs : float; --glfw.Seconds;

	package myint_io is new text_io.integer_io(integer);



	holeTexShadID,
	snakeTexShadID,

	treeTexShadID, 

	star2shadid,
	poolshadid,
	skyshadid,
	sky2shadid,
	cupTexShadID,
	pgmtexshadid,
	pidterra,
	pidskyb, pidskyw : gluint;


	star2timeid, star2resid, star2matid,

	--envmapid, 
	poolmvid, poolmatid,
	timeid, pcenid,pradid,wlevid,

	holemvid, holeMatrixID, holeuniftex, holeradid, holecenid,
	holeunifdark, holeuniflev, holeunifclr,
	snakemvid,
	snakeMatrixID,
	snakeuniftex,
	snakecenid,
	snakeunifrad,
	snakeunifangl,
	snakeunifwvel,
	snakeunifwamp,

	snakeunifdark,
	snakeuniflev,
	snakeunifclr,

	treeMatrixID, treeuniftex, treeunifdark,
	treeuniftime, treeunifid, treebaseunifid,
	treeradID, treecenID,

	cupunifang,
	cupuniflev,cupunifclr,cupmvid,
	skymatid,skyresid, skytimeid,
	sky2matid,sky2resid, sky2timeid,
	mvid, matrixid, uniftex, uniflev, unifclr,
	cupMatrixID, cupuniftex, cupunifdark, cupcenid, cupradid,
	sbmvpuid, sbmapuid, mmatrixid, muniftex, unifdark, munifdark: glint;




	j1,j2,j3,j4,j5,j6 : float; -- junk to ignore

	--xmaz1,zmaz1, xmaz2,zmaz2,
	xgxp,zgxp, xgxm,zgxm, xgzp,zgzp, xgzm,zgzm: float;

	gkeyheld,
	bkeyheld, lionnear,
	seen1already, batested7, bat7sent,
	batested1, batested5, bat1sent, bat5sent, batfly, 
	bathaswkey, bathasbkey, bathaschalice,
	bdragondead, bdragonsent,
	rdragondead, rdragonsent, rdragonfly, bdragonfly,
	minosent, minofly, minotaurdead,

	bkeyseen, wkeyseen, 
	--swordseen,
	pedestalnear,
	swordnear, chalicenear, swordheld, chaliceheld,
	interior, gatewait, 
	mazewait, lionwait, 
	gkeynear, bkeynear,wkeynear, wkeyheld: boolean := false;

	mazenear, gatenear : boolean := false;

	openlion, openmaze, opengate : boolean := false;

	gk1,gk2, -- exterior maze gates
	lko, -- lion gate
	gzpk,gzmk, gxpk,gxmk : integer;

	mazegoingup,
	liongoingup, lionopen, mazeopen,
	xpup,xmup, zpup,zmup : boolean := false;

	mazetime,
	liontime, lifttime : float ;
	liftduration : constant float := 8.3; --seconds


-- glint == interfaces.c.int
darkness : glint := 4; -- 0..4

tt, pltime, yg, elapsed: float := 0.0;
pickdwell : constant float := 0.3;



------------------------------ end stuff from main -----------------------------
cdo, mdo5, mdo6, mdo7, mdo8, tdo : droomobj.room; --castle, maze, temple



-- exterior(castle-grounds), interior(chalice-room), interior(maze)
numscenes: constant integer := 6;
savehang: array(1..numscenes) of float :=
	( onepi, onepi, fourthpi*5.0, onepi,
		onepi,onepi
	); 
	
-- exterior(castle-grounds), interiors (chalice-room) (maze) (temple)
savexme: array(1..numscenes) of float := 
	(-5.0,        -5.0,  -ixmax+0.9+margin,     0.0,
	  0.0,0.0
	);
savezme: array(1..numscenes) of float := 
	(-13.0, -9.0,  -izmax+0.9+margin, -izmax+margin,
		-9.0,-9.0
	);

restore_newmazes,
restore_temple,
restore_maze,
restore_castle,
restore_croom: boolean:= false;

	nuscene, scene: integer := 0;

dragonduration: constant float := 7.0; --seconds
batduration: constant float := 30.0; --seconds



bsdra, rsdra : integer; --scene# of dragon death

mxdra,mydra,mzdra,
bxdra,bydra,bzdra,
rxdra,rydra,rzdra,
dragonstart, batstart,xbat,ybat,zbat: float;

gkeyvisible : boolean := true;

-- this must exclude other nearby connections
samequad: constant float := 1.5; --threshold distance to neighbor maze

heralded, success : boolean := false;

----- begin new mazes -------------------------------------

	-- make consistent with interiors -10..10, -3..3, -10..10

	subtype scenerng is integer range 5..8; -- 5 multiply-connected parts
	mrows, mcols : constant integer := 10;
	mzwall : array(scenerng, -mrows..mrows, -mcols..mcols) of rectobj.rectangle;

	passthru,
	iswall : array(scenerng, -mrows..mrows, -mcols..mcols) of boolean
		:= (others=>(others=>(others=>false)));


	package longtube is new ztubeobj(25);
	snake : longtube.ztube;

	snake7rad, snake7angl, x7snake, z7snake,
	snake8rad, snake8angl, x8snake, z8snake,

	snake5angl, snake6angl, snake5rad, snake6rad,
	x6snake,z6snake, x5snake,z5snake : float;


	warning1, threshold,
	imdead_minotaur,
	imdead_dragon, imdead_snake: boolean := false;

	--package mycornice is new corniceobj(30);
	--nocorn : mycornice.cornice;

--------- family of moorish columns with cornices ---------------

	pwaterlevel : chars_ptr := new_string("waterlevel"&ascii.nul);
	--penvmap : chars_ptr := new_string("envMap"&ascii.nul);
	--peyepos : chars_ptr := new_string("eyePos"&ascii.nul);


	moorishpillar : array(0..4) of cylobj.cylinder;
	mpx,mpz : array(0..4) of float; -- pillar centers

	--nocorn,socorn,eacorn,wecorn : array(0..4) of rectobj.rectangle;

	slab, edgezm,edgezp,edgexp : rectobj.rectangle; 
	-- interior roof to pillars, pool
	-- and sides of pool

	rr: float; --hole radius




	--nox,noy,noz, sox,soy,soz, 
	--		eax,eay,eaz, wex,wey,wez: array(0..4) of float; --hole centers

	--package reflsurf is new rectsurfobj(180);
	--rfo : reflsurf.rectsurf;

	package newrectsurf is new rectsurfobj(40);
	rso : newrectsurf.rectsurf;


	nsortlimit: constant integer := 99;
	subtype nsortrng is integer range 0..nsortlimit;

	type sortarray is array(nsortrng) of integer;
	pfar2near, pnear2far, cf2n : sortarray;


	type limarray is array(nsortrng) of float;

	-- these describe locations of objects to be sorted:
	ox,oz : limarray := ( others => 0.0 );

	-- 1st subscript = no,so,ea,we
	-- 2nd subscript = pillar #
	hox, hoy, hoz : array(1..4,0..4) of float; --hole centers
	cornice : array(1..4,0..4) of rectobj.rectangle;

	--chapter: integer := 1; -- currently 1 or 2

	fanfare, stone, down, up, die, eat, roar, won,
	misr, turk, water : glint;

	resfile : string := "./data/resume_av.txt";

	major, minor, profile, flags, mtu :  glint;

-----------------------------------------------------------

	badhoriang : float:=0.0;
	horiang, vertang : float := 0.0; -- avatar actual
	choriang : float := 0.0; -- cam actual
	ahoriang : float := 0.0; -- cam looking @ avatar

	ixcam,iycam,izcam,        -- ideal cam.pos
	xcam, ycam, zcam: float;  -- actual cam.pos

	cxlook,cylook,czlook,       -- actual camera orientation
		xlook,ylook,zlook : float := 0.0; -- avatar orientation = ideal camera

	thirdPerson, showingGlyph: boolean := false;

	direction: integer;

	ava : avatarobj.avatar;

	avaTexShadID, 
	ava_texid: gluint;
	
	avaunifade, avauniftex, avaunifang,
	avaunifcen, avaunifmat, avauniftime, avaunifdir : glint;


end gametypes;

