
--
-- Copyright (C) 2018  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (avent)

procedure draw_maze5 is

	hwdoor : constant float := 0.8;
	fhdoor : constant float := 1.8;
	dt: float;

begin


	snake5rad := 7.0;

	snake5angl := 0.02*onepi*currenttime;

	-- given my coords, this defines a clockwise rotation:
	x5snake:= snake5rad*fmath.cos(snake5angl);
	z5snake:= snake5rad*fmath.sin(snake5angl);


		-- green mamba
		glUseProgram( snaketexshadid );
		gluniformmatrix4fv(snakemvid, 1, gl_false, imv(1,1)'address );
		gluniformmatrix4fv(snakeMatrixID, 1, gl_false, imvp(1,1)'address );
		gluniform1i(snakeuniftex,0);
		glUniform3f(snakecenID, 0.0, glfloat(-iymax+0.02 ), 0.0 );
		glUniform1f(snakeunifrad, glfloat(snake5rad) ); -- circle radius
		glUniform1f(snakeunifangl, glfloat(snake5angl) ); -- angle around orbit
		glUniform1f(snakeunifwvel, 1.0 ); --wiggle freq
		glUniform1f(snakeunifwamp, 4.0 ); --wiggle amplitude

		glUniform1i(snakeunifdark, darkness5);
		gluniform1i(snakeuniflev, foglev5 ); 
		gluniform1i(snakeunifclr, fogclr5 ); 

		glbindtexture(gl_texture_2d, snake_texid);
		longtube.draw( snake, vertbuff,uvbuff,elembuff );





		--for normal textured objects:
		glUseProgram( pgmtexshadid );
		gluniformmatrix4fv( mvid, 1, gl_false, imv(1,1)'address );
		gluniformmatrix4fv( matrixid, 1, gl_false, imvp(1,1)'address );
		gluniform1i(uniftex,0);
		glUniform1i(unifdark, darkness5);
		gluniform1i(uniflev, foglev5 ); 
		gluniform1i(unifclr, fogclr5 ); 




		glbindtexture(gl_texture_2d, mazeouter_texid);
		droomobj.draw(mdo5,vertbuff,uvbuff,elembuff); --textured room

		--floor
		glbindtexture(gl_texture_2d, grass_texid);
		rectobj.draw(mfloor, vertbuff,uvbuff,elembuff);



		--maze entry door
		glbindtexture(gl_texture_2d, doort_texid);
		pictobj.draw(imazedoor, vertbuff,uvbuff,elembuff);

		-- transition doors
		pictobj.draw(doorc, vertbuff,uvbuff,elembuff);
		pictobj.draw(doord, vertbuff,uvbuff,elembuff);
		pictobj.draw(doore, vertbuff,uvbuff,elembuff);
		pictobj.draw(doorf, vertbuff,uvbuff,elembuff);
		pictobj.draw(doorg, vertbuff,uvbuff,elembuff);
		pictobj.draw(doory, vertbuff,uvbuff,elembuff);
		pictobj.draw(doorz, vertbuff,uvbuff,elembuff);
		pictobj.draw(doorv, vertbuff,uvbuff,elembuff);
		pictobj.draw(doorw, vertbuff,uvbuff,elembuff);
		pictobj.draw(doorx, vertbuff,uvbuff,elembuff);





		--maze walls
		glbindtexture(gl_texture_2d, hedge_texid);
		for row in -mrows..mrows loop
		for col in -mcols..mcols loop
		if 
			iswall(5,row,col) and
			(kgate=0 or sgate/=5 or rgate/=row or cgate/=col) 
		then
				pictobj.draw(
					mzwall(5,row,col), 
						vertbuff,uvbuff,elembuff);
		end if;

		end loop;
		end loop;

		if kgate>0 and sgate=5 then
			glbindtexture(gl_texture_2d, frame_texid); --passthru
			pictobj.draw(
				mzwall(5,rgate,cgate), 
					vertbuff,uvbuff,elembuff);
		end if;





		if not gkeyheld and sgkey=5  then
			glbindtexture(gl_texture_2d, gkey_texid);
			pictobj.draw(key3, vertbuff,uvbuff,elembuff);
		end if;


		if not bkeyheld and sbkey=5 and not bathasbkey then
			glbindtexture(gl_texture_2d, bkey_texid);
			pictobj.draw(key2, vertbuff,uvbuff,elembuff);
		end if;

		if not wkeyheld and swkey=5 and not bathaswkey then
			glbindtexture(gl_texture_2d, key_texid);
			pictobj.draw(key1, vertbuff,uvbuff,elembuff);
		end if;

		if not swordheld and ssword=5 then
			glbindtexture(gl_texture_2d, sword_texid);
			pictobj.draw(sword, vertbuff,uvbuff,elembuff);
		end if;

		if not gateheld and sgate=5  and kgate=0 then
			glbindtexture(gl_texture_2d, frame_texid);
			pictobj.draw(gateway, vertbuff,uvbuff,elembuff);
		end if;


---------------------------------------------------------------

	if drawchalice and schalice=5 and not chaliceheld then
	-- use uniforms to set position
		glUseProgram(cupTexShadID);

		gluniform1i(cupFlag, 1 ); --no light effects
		glUniform1f(cupunifang, 0.0);
		gluniform3f(cupColr, 246.0/255.0, 216.0/255.0, 11.0/255.0 ); --gold
		--gluniform3f(cupColr, 123.0/255.0, 108.0/255.0, 6.0/255.0 ); --dgold
		--gluniform3f(cupColr, 61.0/255.0, 54.0/255.0, 3.0/255.0 ); --ddgold
		--gluniform3f(cupColr, 30.0/255.0, 27.0/255.0, 2.0/255.0 ); --dddgold
		gluniform3f(cupPos, xchalice,ychalice,zchalice );

		if thirdPerson then
			gluniform3f(cupeye, glfloat(xcam),glfloat(ycam),glfloat(zcam) );
		else
			gluniform3f(cupeye, glfloat(xme),glfloat(yme),glfloat(zme) );
		end if;



		glUniformMatrix4fv(cupMatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniform1i(cupuniftex, 0);
		glUniform1i(cupunifdark, 0); --darkness5);
		glUniform3f(cupcenid, xchalice,ychalice,zchalice );
		glUniform3f(cupradid, wcup, hcup, wcup );


		gluniform1i(cupuniflev, 0); --foglev5 ); 
		gluniform1i(cupunifclr, 0); --fogclr5 ); 

		glUniformMatrix4fv(cupmvid, 1, GL_FALSE, imv(1,1)'address);

		glbindtexture(gl_texture_2d, chalice_texid);
		xtreeobj.ldraw(chalice, vertbuff,uvbuff,normbuff,elembuff);
	end if;


if scene=5 then

			showingGlyph:=false;

		-- glyphs drawn @ screen center
		if gateheld then
			if insertable>0 then
				utex.print2d("%",0.5,0.5,50); -- "^" => gateway
			else
				utex.print2d("$",0.5,0.5,50); -- "^" => gateway
			end if;
			showingGlyph:=true;

		elsif gkeyheld then --draw key
			utex.print2d("^",0.5,0.5,50); -- "^" => green key
			showingGlyph:=true;

		elsif bkeyheld then --draw key
			utex.print2d("|",0.5,0.5,50); -- "|" => black key
			showingGlyph:=true;

		elsif wkeyheld then --draw key
			utex.print2d("~",0.5,0.5,50); -- "~" => white key
			showingGlyph:=true;

		elsif swordheld then --draw sword
			utex.print2d("=",0.5,0.5,120); -- "=" => sword
			showingGlyph:=true;

		elsif chaliceheld then --draw chalice
			utex.print2d(";",0.5,0.5,80); -- ";" => chalice
			showingGlyph:=true;
		end if;

		if 
			(pgatenear or gkeynear or bkeynear or wkeynear or swordnear or chalicenear)
			and not gatewait and not lionwait and not mazewait
		then
			utex.print2d("`",0.5,0.4,50); -- "`" = hand
			showingHand:=true;
		else
			showingHand:=false;
		end if;

end if;


		-- fancy fragshader draws cloud ceiling
		glUseProgram( skyshadid );
		gluniformmatrix4fv( skymatid, 1, gl_false, imvp(1,1)'address );
		gluniform1f(skytimeid, glfloat(currentTime) );
		gluniform2f(skyresid, glfloat(winwidth), glfloat(winheight) );
		rectxobj.draw(rox,vertbuff,elembuff);


---------------- begin bat insert ------------------

		if batfly and scene=5 then --draw flying bat as per gun-beam
			dt:=-0.5+1.0*(currenttime-batstart)/(0.5*batduration); -- -0.5..+0.5

			if dt>0.0 and not batested5 then
				batested5:=true;

				if not bathasbkey and not bkeyheld then 
					bathasbkey:=true;
					-- this flag being false indicates the bat
					-- succeeded in grabbing key from the ground!
					snd4ada_hpp.playSnd(up);
				end if;

			end if;

			if dt>=0.5 then
				batfly:=false;
				if not bkeyheld and bathasbkey then
					--bat drops key onto ground
					xbkey:=xbat;
					zbkey:=zbat;
					ybkey:=-iymax+htobj;

					pictobj.setrect( 
						key2, 
						xbkey,ybkey,zbkey, --xc,yc,zc
						0.1, 0.0, 0.1, --xr,yr,zr
						j1,j2,j3,j4,j5,j6);

					bathasbkey:=false;
					snd4ada_hpp.playSnd(down);
				end if;
			else --draw bat
				drawbat(dt);
			end if;
		end if; --batfly

---------------- end bat insert ------------------

end draw_maze5;


