# Linux
# "legacy" gnu compile script for adaventure 
# suitable for AdaCore 2016 or earlier
#
# using static libs wherever possible...
# exe.size=9.1Mb
#
# static:  SDL2-v2.0.3, SFML-v2.4.1, OpenAL-v1.17.3
# with libopenal.a [v1.17.3] built from src from 
# https://github.com/kcat/openal-soft
#
# This script probably produces the most
# portable linux executable...albeit much
# larger than lcmp.sh
#
# shared library presence in linux distros:
# 56/77	FLAC   => 73%
# 75/77	ogg
# 22/77	openal => most rare @ 28%
# 76/77	vorbis
#
# uses rpath to tell runtime linker to look also in
# ./libs/gnu/ for any needed *.so files 
# not found elsewhere, eg libogg.so.

#########################################################

# use this to ensure a complete recompilation:
if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi


# this is the typical path of gnat gpl...
# for AdaCore-2016 and earlier
export PATH=/usr/gnat16/bin:$PATH


#########################################################


# prepares snd4ada.o file prior to gnatmake...
# using g++ from GNAT:

g++ adabindings/sfmlAudio/snd4ada.cpp -c -Werror -std=c++11 -I./cppinclude

mv snd4ada.o ./obj/


#########################################################

gnatmake adaventure -o adaventure_gnu_d16 \
-O2 -gnat12 \
--subdirs=./obj \
-I./adabindings/gl \
-I./adabindings/sdlada \
-I./adabindings/AdaPngLib \
-I$PWD/adabindings/sfmlAudio \
-largs \
-lGL -lz -lstdc++ \
$PWD/obj/snd4ada.o \
-Xlinker -rpath='$ORIGIN/libs/gnu16' \
-L$PWD/libs/gnu16 \
-lSDL2 -lsfml-audio -lsfml-system \
-lopenal -lcrypto -logg -lvorbis -lvorbisenc -lvorbisfile -lFLAC

#NOTE:  final line above has libs that need not be explicitly
#       mentioned, yet are used and may be non-standard


mv ./obj/adaventure_gnu_d16 .



# -- Copyright (C) 2017  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

