
--
-- Copyright (C) 2018  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with matutils;  use matutils;
with gametypes;  use gametypes;

with sdl; use sdl;


with interfaces.c;
with interfaces.c.strings;
with glext;
with glext.pointers;
with glext.binding;
with gl;
with gl.binding;
with gl.pointers;





package gameutils is


	use interfaces.c;
	use interfaces.c.strings;
	use glext;
	use glext.pointers;
	use glext.binding;
	use gl;
	use gl.binding;
	use gl.pointers;



	procedure myassert( 
		condition : boolean;  
		flag: integer:=0;
		msg: string := "");


function odd( i: integer ) return boolean;

function sqr( x: float ) return float;
function min( x,y: float ) return float;
function mini( i,j: integer ) return integer;



function hordistance( x1,y1, x2,y2 : float ) return float;

procedure moveforward( currenttime: float );
procedure movebackward( currenttime: float );

procedure first_prep;

procedure InitSDL(  name: string );



procedure updategamestate;
procedure updateCamera(init: boolean := false);

procedure updateMVPs( wid,hit : float );

procedure slewToAvLook;
procedure slewToAv;




procedure handle_mouse_move( nowTime : float );

procedure handle_gc_left(gcx,gcy:sdl.sint16);
procedure handle_gc_right(nowTime:float; gcx,gcy:sdl.sint16);


function bitmatch( x,y : integer ) return boolean;


procedure zeroBtns;

procedure liftmaze;
procedure slidelab;
procedure liftlion;
procedure liftgate( n: integer );

function atdoor(currenttime: float) return boolean;
function atmaze(currenttime: float) return boolean;
function attemple(currenttime: float) return boolean;


function land_alt( x,z : float ) return float;

procedure sendBat;
procedure drawbat( et: float );
procedure drawRdragon( et: float );
procedure drawBdragon( et: float );
procedure drawMinotaur( et: float );
function angl( x1,y1,z1, x2,y2,z2 : float ) return float;

procedure initializeNewMazes;

function ata1(now: float) return boolean;
function atb1(now: float) return boolean;

function ata2(now: float) return boolean;
function atb2(now: float) return boolean;

function atc(now: float) return boolean;
function atd(now: float) return boolean;
function ate(now: float) return boolean;
function atf(now: float) return boolean;
function atg(now: float) return boolean;
function atv(now: float) return boolean;
function atw(now: float) return boolean;
function atx(now: float) return boolean;
function aty(now: float) return boolean;
function atz(now: float) return boolean;

function snakehiss return boolean;
function nearsnake return boolean;

procedure drawspider( et: float );


procedure sort( 
	f2n: in out sortarray;  -- output permutations
	ox,oz : limarray;       -- pos of each object
	lo, hi : integer;       -- bounds of sort
	eyex,eyez : float       -- xme, zme
	);


function at7f(now: float) return boolean;
function at7e(now: float) return boolean;
function at7d(now: float) return boolean;
function at7c(now: float) return boolean;
function at7b(now: float) return boolean;
function at7a(now: float) return boolean;


function at98g(now: float) return boolean;
function at78g(now: float) return boolean;
function at78h(now: float) return boolean;


procedure emptyGLerrorQueue;

function dumpGLerrorQueue(id: string) return integer;






function atla9(now: float) return boolean;
function atra9(now: float) return boolean;

function atlb9(now: float) return boolean;
function atrb9(now: float) return boolean;

function atlc9(now: float) return boolean;
function atrc9(now: float) return boolean;

function atlf9(now: float) return boolean;
function atrf9(now: float) return boolean;

function attd9(now: float) return boolean;
function atbd9(now: float) return boolean;

function atte9(now: float) return boolean;
function atbe9(now: float) return boolean;


end gameutils;
