
# this is the typical path of gnat gpl...
# for AdaCore-2017 
export PATH=/usr/gnat/bin:$PATH


#########################################################

# This step is not necessary if libsnd4ada.so is already present...
#
# prepares libsnd4ada.so file prior to gnatmake...
# using g++ from GNAT:

#g++ adabindings/sfmlAudio/snd4ada.cpp -c -Werror -fPIC -I./cppinclude

#g++ -shared -o ./libs/gnu/libsnd4ada.so snd4ada.o \
#-L$PWD/libs/gnu -lsfml-audio -lsfml-system


#########################################################

gnatmake adaventure -o adaventure_gnu \
-O2 -gnat12 \
--subdirs=./obj \
-I./adabindings/gl \
-I./adabindings/sdl207ada \
-I./adabindings/AdaPngLib \
-I$PWD/adabindings/sfmlAudio \
-largs \
-lGL -lz -lm -lpthread -lstdc++ \
-Xlinker -rpath='$ORIGIN/libs/gnu' \
-L$PWD/libs/gnu \
-lsnd4ada \
-lSDL2-207 -lsfml-audio -lsfml-system \
-lopenal -lcrypto -logg -lvorbis -lvorbisenc -lvorbisfile -lFLAC

#NOTE:  final line above has libs that need not be explicitly
#       mentioned, yet are used and may be non-standard


mv ./obj/adaventure_gnu .


