separate(gameutils)

procedure first_prep(HiRes: boolean:=false) is -- main program setup
	linestr: string(1..9);
	last,last2: natural;
begin

	oldstateexists:=false;
	if ada.directories.Exists(statefile) then
		oldstateexists:=true;
	end if;

	--First, Initialize all Sounds:

	snd4ada_hpp.initSnds;

------- addendum 15dec17 begin ---------------------------------------

	evilBugs := snd4ada_hpp.initLoop( --16nov19
		Interfaces.C.Strings.New_String("data/evilRoaches.wav"),6.00,90);

	wind1 := snd4ada_hpp.initLoop( --1dec18
		Interfaces.C.Strings.New_String("data/wind.wav"),30.00,20);

	ceph8 := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/ceph.wav"),60.01,50);

	dama8 := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/Dama-May.wav"),57.01,50);

	tmpl4 := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/westfold.wav"),50.02,60);

------- addendum 15dec17 end ---------------------------------------

	water := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/water.wav"),10.30,50);

	misr := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/misrlu.wav"),282.34 ,90);

	turk := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/turkish.wav"),239.43,90);

	hiss := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/hiss-beat.wav"),8.25,99);

------- now for transient sounds ==================================


	stone := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/concrete.wav"),99);

	down := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/putdown.wav"),50);

	up := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/pickup.wav"),50);

	die := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/dragondie.wav"),99);

	eat := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/eaten.wav"),99);

	roar := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/roar.wav"),80);

	won := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/won.wav"),80);

	medusascream := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/medusa.wav"),99);

	girlyscream := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/girly_scream.wav"),99);

	monsterscream := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/monster.wav"),99);

	womanscream := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/woman_scream.wav"),99);


	if 
		dama8<0 or ceph8<0 or tmpl4<0 or
		water<0 or misr<0 or turk<0 or hiss<0 or
		stone<0 or down<0 or up<0 or
		die<0 or eat<0 or roar<0 or won<0 or 
		medusascream<0 or girlyscream<0 or 
		monsterscream<0 or womanscream<0
	then
		put_line("snd4ada_hpp.initSnds ERROR");
		raise program_error;
	end if;



------- begin glfw prep ---------------------------------------------------------


	InitGlfwFs("AdaVenture");
	zoomwheel.enable(mainWindow);



	glgenvertexarrays(1, vertexarrayid'address );
	glbindvertexarray(vertexarrayid);

	-- from the literature it seems I might not have to
	-- call this explicitly because the first texture
	-- unit is the active texture unit, by default.
	-- And I have no multi-texturing needs yet,
	-- like a tarnish on top of an existing texture.
	glactivetexture(gl_texture0); -- moved here 5nov14 (outside main loop)

	glgenbuffers(1, vertbuff'address);
	glgenbuffers(1, normbuff'address);
	glgenbuffers(1, rgbbuff'address);
	glgenbuffers(1, uvbuff'address);
	glgenbuffers(1, elembuff'address);




	glenable(gl_depth_test);
	gldepthfunc( gl_lequal );
	glenable( gl_cull_face );



	-- reduces aliasing:
	glEnable(GL_MULTISAMPLE); -- default setting anyway


	--minimal error test
	if gl_no_error /= glGetError then
		put_line(" GLerror in gameutils.first_prep");
	end if;


	level:=0;



-- insert here attempt to read "settings.txt" file
	if ada.directories.Exists(setfile) then 
		put("settings file found...");

		declare
			xfspd, xmslu, xkslu, xgslu, xjslu: float;
		begin

			text_io.open(tfile, in_file, setfile);

			text_io.get_line(tfile,linestr,last);
			myfloat_io.get(linestr(1..last),xfspd,last2);

			text_io.get_line(tfile,linestr,last);
			myfloat_io.get(linestr(1..last),xmslu,last2);

			text_io.get_line(tfile,linestr,last);
			myfloat_io.get(linestr(1..last),xkslu,last2);

			text_io.get_line(tfile,linestr,last);
			myfloat_io.get(linestr(1..last),xgslu,last2);

			text_io.get_line(tfile,linestr,last);
			myfloat_io.get(linestr(1..last),xjslu,last2);

			text_io.close(tfile);

			fspd:=xfspd;
			mslu:=xmslu;
			kslu:=xkslu;
			gslu:=xgslu;
			jslu:=xjslu;
			put_line("and used.");

		 exception
			when others =>
				put_line("...problem reading settings file...using defaults.");
				text_io.close(tfile);

		end; --declare

	else
		put_line("No settings file found; using defaults.");
	end if;



end first_prep;





