--
-- Copyright (C) 2016  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with snd4ada_hpp;

with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

-------------------------------------------------------------
with System;
with Interfaces.C;
use  type interfaces.c.unsigned;
with Interfaces.C.Pointers;
with interfaces.c.strings;


----------------------------------------------------------------
with sdl;  use sdl;
----------------------------------------------------------------

with matutils;
with utex;

with ada.unchecked_conversion;
with Ada.Command_Line;
with Ada.Strings.Unbounded;
with Ada.Strings.Unbounded.Text_IO;
with ada.numerics.generic_elementary_functions;

----------------------------------------------------------------


with shader;  use shader;

with cubemapobj;
with mroomobj;
with rectobj;
with pictobj;

with texsurfobj;
with usboxobj;


with text_io;
with pngloader;
with gametypes;
with gameutils;
with matutils;

with ada.calendar;

with snd4ada_hpp;  use snd4ada_hpp;


procedure adaventure is

use text_io;
use pngloader;
use gametypes;
use gameutils;
use matutils;


	use gametypes.fmath;







	-- this assumes mm=ID, (xme,yme,zme)=virtual pos within skybox
	-- [ actual pos versus skybox is always (0,0,0) ]
	procedure updateMVPs( wid,hit : float) is
		xlk,ylk,zlk,
		xrt,yrt,zrt,
		xup,yup,zup : float;
	begin

		-- Look Vector
		xlk:=xme+xlook;
		ylk:=yme+ylook;
		zlk:=zme+zlook;

		-- Right unit-Direction
		xrt:= sin(horiang-halfpi);
		yrt:= 0.0;
		zrt:= cos(horiang-halfpi);

		-- calculate UP unit-Direction
		cross( xrt,yrt,zrt, xlook,ylook,zlook, xup,yup,zup );

		perspective(pm, 45.0, wid/hit,  0.1, 100.0);

		lookat(mviewMatrix, 0.0,0.0,0.0, xlook,ylook,zlook, xup,yup,zup );
		lookat(iviewMatrix, xme,yme,zme, xlk,ylk,zlk, xup,yup,zup );

		mmv:=mviewMatrix;
		mmvp:=mviewMatrix;
		imvp:=iviewMatrix;
		myMatMult(mmvp,pm);
		myMatMult(imvp,pm);

	end updateMVPs;










	use interfaces.c;
	use interfaces.c.strings;
	use glext;
	use glext.pointers;
	use glext.binding;
	use gl;
	use gl.binding;
	use gl.pointers;



procedure InitSDL( width, height : glint;  flags:Uint32;  name: string ) is

use system;

  ires, jerror, error, cver : interfaces.c.int;
  bresult : SDL_bool;

  compiled, linked : aliased SDL_version;

begin

	-- Careful!  Only initialize what we use (otherwise exe won't run):
	error := SDL_Init(
		SDL_INIT_TIMER or
		SDL_INIT_EVENTS or 
		SDL_INIT_VIDEO);
	myassert( error = 0, 1000 );

	jerror := SDL_Init(
		SDL_INIT_GAMECONTROLLER or
		SDL_INIT_JOYSTICK );

	joystik:=false;
	gamepad:=false;
	if  jerror = 0  and then SDL_NumJoysticks>=1  then
		jsa := SDL_JoystickOpen(0);
		gamepad := (sdl_joysticknumaxes(jsa) >= 4);
		joystik := not gamepad;
		put_line("#axes="& glint'image(sdl_joysticknumaxes(jsa)) );
		put_line("#btns="& glint'image(sdl_joysticknumbuttons(jsa)) );
		ires := SDL_JoystickEventState(SDL_QUERY); -- ignore ires (?might this stop spinning?)
		SDL_JoystickUpdate;
		axis_lx := SDL_JoystickGetAxis(jsa, 0);
		axis_ly := SDL_JoystickGetAxis(jsa, 1);
	end if;

	if gamepad then
		put_line("...#axes>=4 so I'm guessing controller is a gamepad...initialized");
	elsif joystik then
		put_line("...#axes<=3 so I'm guessing controller is a joystick...initialized");
	else
		put_line("...no game controller detected...");
	end if;

---------- begin 14feb15 insert ------------------------------------------------
	SDL_SOURCEVERSION( compiled'access );
	put_line("We compiled against SDL version "
		&Uint8'image(compiled.major)&"."
		&Uint8'image(compiled.minor)&"."
		&Uint8'image(compiled.patch) );
	cver := SDL_COMPILEDVERSION;  
	put_line("SDL_compiledversion="&glint'image(cver));
	SDL_GetVersion( linked'access );
	put_line("We linked against SDL version "
		&Uint8'image(linked.major)&"."
		&Uint8'image(linked.minor)&"."
		&Uint8'image(linked.patch) );
---------- end 14feb15 insert --------------------------------------------------

	bresult := SDL_SetHint( SDL_HINT_RENDER_VSYNC, "1" );
	myassert( bresult = SDL_TRUE, 1001 );
	bresult := SDL_SetHint( SDL_HINT_RENDER_SCALE_QUALITY, "1" );
	myassert( bresult = SDL_TRUE, 1002 );




	--// Turn on double buffering.
	error := SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
	myassert( error = 0, 1003 );
	error := SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 24);
	myassert( error = 0, 1004 );
	error := SDL_GL_SetAttribute(SDL_GL_ALPHA_SIZE, 8);
	myassert( error = 0, 1005 );





	error := SDL_GL_SetAttribute(SDL_GL_CONTEXT_MAJOR_VERSION, 3);
	myassert( error = 0, 1006 );
	error := SDL_GL_SetAttribute(SDL_GL_CONTEXT_MINOR_VERSION, 3);
	myassert( error = 0, 1007 );




	error := SDL_GL_SetAttribute( SDL_GL_CONTEXT_PROFILE_MASK, 
											SDL_GL_CONTEXT_PROFILE_CORE );
	myassert( error = 0, 1008 );

	-- Note that OSX currently requires the forward_compatible flag!
	error := SDL_GL_SetAttribute( SDL_GL_CONTEXT_FLAGS, 
											SDL_GL_CONTEXT_FORWARD_COMPATIBLE_FLAG );
	myassert( error = 0, 1009 );



	error := SDL_GL_SetAttribute(SDL_GL_MULTISAMPLESAMPLES, 4);
	myassert( error = 0, 1010 );



	mainWindow := SDL_CreateWindow( To_C(name,true) , 
			SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED, 
			width, height, flags);


	mainGLContext := SDL_GL_CreateContext(mainWindow);

	error := SDL_GL_MakeCurrent( mainWindow, mainGLContext );
	myassert( error = 0, 1011 );


end InitSDL;





package myfloat_io is new text_io.float_io(float);

package mygint_io is new text_io.integer_io(glint);


--we skip blank lines and comments beginning with "#":
function is_blank( line : string; len:integer ) return boolean is
begin

	if( len < 1 ) then return true; end if;

	if line( line'first )='#' then return true;
	elsif line( line'first ) = ' ' then	return true; end if;

	return false;

end is_blank;






procedure GetInt( Rcd:string;
						Bgn:in out natural;
						Int: in out glint ) is
begin
mygint_io.get( From => Rcd(Bgn..Rcd'last),
					Item => Int,
					Last => Bgn);
Bgn:=Bgn+1;
end GetInt;



procedure getNbInt(tfile:file_type; rcd: in out string; k: in out glint) is
	len,bgn: natural:=1;
begin
	while not end_of_file(tfile) loop
		get_line(tfile, rcd, len);
		if not is_blank(rcd,len) then exit; end if;
	end loop;
	bgn:=rcd'first;

	GetInt(rcd,bgn,k);

end getNbInt;


procedure GetFlt( Rcd:string;
					  Bgn:in out natural;
					  Flt: in out float ) is
nd: positive;
begin
myfloat_io.get( From => Rcd(Bgn..Rcd'last),
					 Item => Flt,
					 Last => nd);
Bgn := nd+1;
end GetFlt;


procedure getNbFlt(tfile:file_type; rcd: in out string; t: in out float) is
	len,bgn: natural:=1;
begin
	while not end_of_file(tfile) loop
		get_line(tfile, rcd, len);
		if not is_blank(rcd,len) then exit; end if;
	end loop;
	bgn:=rcd'first;
	GetFlt(rcd,bgn,t);
end getNbFlt;












procedure first_prep is -- main program setup
	rcd : string(1..80);
	ret : glint; --interfaces.c.int;
begin

	ret := snd4ada_hpp.initSnds;
	if ret>0 then
		put_line("snd4ada_hpp.initSnds ERROR-return = "&glint'image(ret) );
		raise program_error;
	end if;



------- begin SDL prep ---------------------------------------------------------

	ret := SDL_Init(SDL_INIT_VIDEO);
	should_be_zero := SDL_GetCurrentDisplayMode(0, current'access);
	myassert( should_be_zero = 0, 1015 );

	-- MacOSX:  HDPI is normally controlled in the "properties"
	-- box, but does not work for this app.  If there is jerkiness
	-- on your Retina display, use low dpi, which still looks 
	-- pretty good, albeit with some noticable aliasing.
	contextFlags := 
		SDL_WINDOW_SHOWN or SDL_WINDOW_OPENGL or 
		--SDL_WINDOW_FULLSCREEN_DESKTOP;
		SDL_WINDOW_FULLSCREEN_DESKTOP or SDL_WINDOW_ALLOW_HIGHDPI;

	InitSDL(current.w, current.h, contextFlags, "AdaGate");
	winwidth:=current.w;
	winheight:=current.h;



	-- this too runs fine...used for testing purposes...
	--contextFlags := SDL_WINDOW_SHOWN or SDL_WINDOW_OPENGL;
	--winwidth:=1000; --1400;
	--winheight:=600; --800;
	--InitSDL(winwidth,winheight, contextFlags, "AdaGate");


-- if joystik or gamepad, read settings here:
	if FileExists(cfgfile) then -- takes precedence over defaults
		put_line("game-controller settings file found");
		text_io.open(tfile, in_file, cfgfile);

		getNbInt(tfile,rcd,gshtl); 
		getNbInt(tfile,rcd,gshtr); 
		getNbInt(tfile,rcd,gjmp); 
		getNbFlt(tfile,rcd,Lsens); 
		getNbFlt(tfile,rcd,Rsens); 

------- end gamepad;  begin joystik --------------------

		getNbInt(tfile,rcd,jbak); 
		getNbInt(tfile,rcd,jfor); 
		getNbInt(tfile,rcd,jshtl); 
		getNbInt(tfile,rcd,jshtr); 
		getNbInt(tfile,rcd,jjmp); 
		getNbFlt(tfile,rcd,Jsens); 

		text_io.close(tfile);

	else
		put(cfgfile & " file not found...");
		put_line("Using default game controller settings");
		gshtl:=4; --shoot left
		gshtr:=5; --shoot right
		gjmp :=8; --jump

		jbak :=0; --moveback
		jfor :=1; --forward
		jshtl:=2; --shoot left
		jshtr:=3; --shoot right
		jjmp :=7; --jump
	end if;

	if joystik then --we actually use only Lsens or Rsens
		Lsens:=Jsens;
		Rsens:=Jsens; -- Jsens is not used
	end if;










	utex.inittext2d("data/rods3whk.png", integer(winwidth),integer(winheight));
	put_line( "Window: wid-X-hit :" 
		& interfaces.c.int'image(winwidth)&" X "
		& interfaces.c.int'image(winheight) );

	cursor := SDL_CreateSystemCursor(SDL_SYSTEM_CURSOR_CROSSHAIR);
	SDL_SetCursor(cursor);
	error := SDL_SetRelativeMouseMode(SDL_TRUE);
	myassert( error = 0, 1016 );

	SDL_GL_GetDrawableSize( mainWindow, Fwid'access, Fhit'access );
	glViewport(0,0,Fwid,Fhit);

	put_line( "Drawable: Fwid-X-Fhit : "
		&interfaces.c.int'image(Fwid)&" X "
		& interfaces.c.int'image(Fhit) );

	key_map := sdl_getkeyboardstate(numkeys'access);
	--put_line("...numkeys=" & interfaces.c.int'image(numkeys) ); -- 512
	--myassert( sdl.keyrange'last <= numkeys, 1017 );




	glgenvertexarrays(1, vertexarrayid'address );
	glbindvertexarray(vertexarrayid);

	glactivetexture(gl_texture0); -- moved here 5nov14 (outside main loop)

	glgenbuffers(1, vertbuff'address);
	glgenbuffers(1, rgbbuff'address);
	glgenbuffers(1, uvbuff'address);
	glgenbuffers(1, elembuff'address);




	glenable(gl_depth_test);
	gldepthfunc( gl_lequal );
	glenable( gl_cull_face );

	glShadeModel(gl_smooth);



	-- 6nov14  theoretically reduces aliasing (can't tell for sure):
	glEnable(GL_MULTISAMPLE);
	glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
	glHint(GL_POLYGON_SMOOTH_HINT, GL_NICEST);


	level:=0;


end first_prep;







function land_alt( x,z : float ) return float is
begin
	return 0.0;
end land_alt;




package terrain is new texsurfobj(20,20,land_alt); -- 12mar16
grounds : terrain.texsurf;



















procedure release_textures is -- prepare to close down
begin

	glext.binding.glDeleteBuffers(1, vertbuff'address);
	glext.binding.glDeleteBuffers(1, rgbbuff'address);
	glext.binding.glDeleteBuffers(1, uvbuff'address);
	glext.binding.glDeleteBuffers(1, elembuff'address);

	glext.binding.glDeleteProgram( mpidskyb );
	glext.binding.glDeleteProgram( mystpgmTexShadID );

	glext.binding.glDeleteVertexArrays(1, vertexarrayid'address);

	gldeletetextures(1, tropical_cubemap_texid'address);
	gldeletetextures(1, granite_texid'address);
	gldeletetextures(1, surface_texid'address);

end release_textures;



procedure setup_textures is  -- prepare dungeon textures
begin 

	-- lovely...Best daytime.
	tropical_cubemap_texid := loadCubePng(
	"data/skyBoxes/stormy/px.png",	"data/skyBoxes/stormy/nx.png",
	"data/skyBoxes/stormy/py.png",	"data/skyBoxes/stormy/ny.png",
	"data/skyBoxes/stormy/pz.png",	"data/skyBoxes/stormy/nz.png"	);

	--"data/skyBoxes/tropicalsun/slt.png",	"data/skyBoxes/tropicalsun/srt.png",
	--"data/skyBoxes/tropicalsun/sup.png",	"data/skyBoxes/tropicalsun/sdn.png",
	--"data/skyBoxes/tropicalsun/sfr.png",	"data/skyBoxes/tropicalsun/sbk.png"	);

	mpidSkyB := LoadShaders( "./data/osky.vs", "./data/osky.fs" );
	sbmvpUID := glGetUniformLocation( mpidSkyB, pmvp );     
	sbmapUID := glGetUniformLocation( mpidSkyB, pcubemap );     



	mystpgmTexShadID := 
		LoadShaders( "./data/yislandobj.vs", "./data/islandobj.fs" );
	mMatrixID := glGetUniformLocation( mystpgmTexShadID, pmvp );     
	muniftex := glGetUniformLocation( mystpgmTexShadID, pmyts );     
	munifdark := glGetUniformLocation( mystpgmTexShadID, pdark );     



	terrain.setrect(grounds, 0.0,0.0, xmax, zmax );
	surface_texid := loadPng(pngloader.mirror,"data/grasss.png");
	-- note that loadPng uses mirrored_repeat texture wrapping


	cubemapobj.setrect( skybox, 0.0,0.0,0.0, 20.0,20.0,20.0 );

	--granite_texid  := loadPng(mirror,"data/granitergb.png");
	granite_texid  := loadPng(mirror,"data/stonewall.png");

	gate_texid  := loadPng(mirror,"data/pbayGate.png");

	--key_texid  := loadPng(mirror,"data/secret_key.png");
	key_texid  := loadPng(mirror,"data/wkey.png");

	--door_texid  := loadPng(mirror,"data/door.png");
	door_texid  := loadPng(mirror,"data/hallgray.png");

	porch_texid  := loadPng(mirror,"data/woodenceiling.png");

end setup_textures; ------------------------------------------------------------




procedure setup_castles is
begin --setup_castles

	-- central block
	nko:=nko+1;
	rectobj.setrect( 
		wallblok(5), 
		0.0, 1.5, 0.0, --xc,yc,zc
		1.5, 0.5, 1.5, --xr,yr,zr
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );

	-- now the 4 corner legs...

	nko:=nko+1;
	rectobj.setrect( 
		wallblok(1), 
		-1.0, 0.5, -1.0, --xc,yc,zc
		0.5, 0.5, 0.5, --xr,yr,zr
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );

	nko:=nko+1;
	rectobj.setrect( 
		wallblok(2), 
		-1.0, 0.5, +1.0, --xc,yc,zc
		0.5, 0.5, 0.5, --xr,yr,zr
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );

	nko:=nko+1;
	rectobj.setrect( 
		wallblok(3), 
		+1.0, 0.5, +1.0, --xc,yc,zc
		0.5, 0.5, 0.5, --xr,yr,zr
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );

	nko:=nko+1;
	rectobj.setrect( 
		wallblok(4), 
		+1.0, 0.5, -1.0, --xc,yc,zc
		0.5, 0.5, 0.5, --xr,yr,zr
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );



	-- now the 4 corner towers...

	nko:=nko+1;
	rectobj.setrect( 
		wallblok(6), 
		-1.4, 2.3,-1.4, --xc,yc,zc
		 0.4, 0.7, 0.4, --xr,yr,zr
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );

	nko:=nko+1;
	rectobj.setrect( 
		wallblok(7), 
		-1.4, 2.3,+1.4, --xc,yc,zc
		 0.4, 0.7, 0.4, --xr,yr,zr
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );

	nko:=nko+1;
	rectobj.setrect( 
		wallblok(8), 
		+1.4, 2.3,+1.4, --xc,yc,zc
		 0.4, 0.7, 0.4, --xr,yr,zr
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );

	nko:=nko+1;
	rectobj.setrect( 
		wallblok(9), 
		+1.4, 2.3,-1.4, --xc,yc,zc
		 0.4, 0.7, 0.4, --xr,yr,zr
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );








	-- now the 4 edge walls between the towers:

	nko:=nko+1;
	rectobj.setrect( 
		wallblok(10), 
		-0.0, 2.2,-1.5, --xc,yc,zc
		 0.8, 0.2, 0.1, --xr,yr,zr
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );

	nko:=nko+1;
	rectobj.setrect( 
		wallblok(11), 
		-1.5, 2.2,+0.0, --xc,yc,zc
		 0.1, 0.2, 0.8, --xr,yr,zr
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );

	nko:=nko+1;
	rectobj.setrect( 
		wallblok(12), 
		+1.5, 2.2,+0.0, --xc,yc,zc
		 0.1, 0.2, 0.8, --xr,yr,zr
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );

	nko:=nko+1;
	rectobj.setrect( 
		wallblok(13), 
		+0.0, 2.2,+1.5, --xc,yc,zc
		 0.8, 0.2, 0.1, --xr,yr,zr
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );





-- initialize 4 gates and related KeepOuts

	xgxp:=+1.4;  zgxp:=0.0;
	nko:=nko+1;
	gxpk:=nko;
	pictobj.setrect( 
		gatexp, 
		xgxp, 0.4, zgxp, --xc,yc,zc
		0.0, 0.4, 0.4, --xr,yr,zr
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );

	xgxm:=-1.4;  zgxm:=0.0;
	nko:=nko+1;
	gxmk:=nko;
	pictobj.setrect( 
		gatexm, 
		xgxm, 0.4, zgxm, --xc,yc,zc
		0.0, 0.4, 0.4, --xr,yr,zr
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );



	xgzp:=0.0;  zgzp:=+1.4;
	nko:=nko+1;
	gzpk:=nko;
	pictobj.setrect( 
		gatezp, 
		xgzp, 0.4,zgzp, --xc,yc,zc
		0.4, 0.4, 0.0, --xr,yr,zr
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );

	xgzm:=0.0;  zgzm:=-1.4;
	nko:=nko+1;
	gzmk:=nko;
	pictobj.setrect( 
		gatezm, 
		xgzm, 0.4,zgzm, --xc,yc,zc
		0.4, 0.4, 0.0, --xr,yr,zr
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );


-- initialize Key

	xkey:=2.0;
	ykey:=0.01;
	zkey:=2.0;

	pictobj.setrect( 
		key1, 
		xkey,ykey,zkey, --xc,yc,zc
		rkey, 0.0, 0.5*rkey, --xr,yr,zr
		j1,j2,j3,j4,j5,j6);


	--castle interior view
	nko:=nko+1;
	pictobj.setrect( 
		door, 
		0.0, 0.5, 0.0,
		0.5, 0.7, 0.5,
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );


	--porch
	pictobj.setrect( 
		porch, 
		0.0, 0.005, 0.0, --xc,yc,zc
		1.5, 0.0, 1.5, --xr,yr,zr
		j1,j2,j3,j4,j5,j6);


-- outer perimeter wall

	--nko:=nko+1;
	--rectobj.setrect( 
	--	wallxp, 
	--	10.0, 0.25,  0.0,
	--	 1.0, 0.25, 18.0,
	--	koxlo(nko),koxhi(nko), koylo(nko),
	--	koyhi(nko), kozlo(nko),kozhi(nko) );

	--nko:=nko+1;
	--rectobj.setrect( 
	--	wallxm, 
	--	-10.0, 0.25,  0.0,
	--	  1.0, 0.25, 18.0,
	--	koxlo(nko),koxhi(nko), koylo(nko),
	--	koyhi(nko), kozlo(nko),kozhi(nko) );

	--nko:=nko+1;
	--rectobj.setrect( 
	--	wallzp, 
	--	 0.0, 0.25, 10.0,
	--	18.0, 0.25,  1.0,
	--	koxlo(nko),koxhi(nko), koylo(nko),
	--	koyhi(nko), kozlo(nko),kozhi(nko) );

	--nko:=nko+1;
	--rectobj.setrect( 
	--	wallzm, 
	--	 0.0, 0.25,-10.0,
	--	18.0, 0.25,  1.0,
	--	koxlo(nko),koxhi(nko), koylo(nko),
	--	koyhi(nko), kozlo(nko),kozhi(nko) );


end setup_castles;













-- decide if object is picked
procedure pickLeft is
	x0,y0,z0, x1,y1,z1, tt : float := 0.0;
	dx,dz,xtgt,ztgt : float;
	yplane : constant float := ykey; -- Y-coord of key
begin

	x0:=xme;
	y0:=yme;
	z0:=zme;
	x1:=x0;
	y1:=y0;
	z1:=z0;

	while (y1>yplane) loop
		tt:=tt+1.0;
		x1 := x0 + tt*xlook;
		y1 := y0 + tt*ylook;
		z1 := z0 + tt*zlook;
	end loop;
	tt := (yplane-y0)/(y1-y0);
	xtgt := x0 + tt*(x1-x0);
	ztgt := z0 + tt*(z1-z0);

	dx := xtgt-xkey;
	dz := ztgt-zkey;

	if (abs(dx)<nearkey) and (abs(dz)<nearkey)  then
		keyheld:=true;
		playSnd(10);
	else
		keyheld:=false;
		playSnd(8);
	end if;


end pickLeft;










-- glint == interfaces.c.int
darkness : glint := 4; -- 0..4

tt, pltime, yg, elapsed: float := 0.0;
pickdwell : constant float := 0.3;

------------------------------ main program begin ==========================
begin --adaventure

	new_line;
	new_line;
	put_line("Please be patient...Adaventure is slow to load...");
	new_line;
	new_line;

	xme:=  0.0;
	yme:=  aheight; -- seems a reasonable height
	zme:=-8.0; -- initial look dir = (0,0,1)


	first_prep;  -- main program setup

	SDL_PumpEvents; -- this precludes a Gnome "app-not-responding" dialog

	setup_textures; -- prep various textures

	setup_castles; --position & build castles

	SDL_PumpEvents; -- this precludes a Gnome "app-not-responding" dialog

	updateMVPs( float(winwidth), float(winheight) );





	-- main event loop begin: -----------------------------------------------
   while not userexit loop


	-- if multiple levels, prep each one here


	-- main event loop middle: -----------------------------------------------

------- begin response to user inputs ////////////////////////////////////

		currentTime := float(sdl_getticks)/1000.0;


		SDL_PumpEvents;


		if( key_map( SDL_SCANCODE_ESCAPE ) /= 0 ) then userexit:=true; end if;
		if( key_map( SDL_SCANCODE_Q ) /= 0 ) then userexit:=true; end if;



		if(      key_map( SDL_SCANCODE_UP     )  /= 0 ) then 
			moveForward(currentTime);
		elsif( key_map( SDL_SCANCODE_DOWN   )  /= 0 ) then 
			moveBackward(currentTime);
		end if;
		

		if( key_map( SDL_SCANCODE_SPACE )  /= 0 ) then
					jumpTime := currentTime;
					pyjump:= yme;
					vyjump:=2.0;
					jumping:=true;
		end if;

-----	///////////////////// begin response to mouse buttons


if abs(currentTime-pltime)>pickdwell then

		MouseState:=SDL_GetMouseState(mousex'access,mousey'access);
		state := integer( MouseState );
		ileft := integer( SDL_BUTTON(1) );

		if    bitmatch(state, ileft)   then 

			pltime:=currentTime;

			if keynear and not keyheld then
				pickLeft;

			elsif keyheld then
				keyheld:=false;
				playSnd(8);

				xkey:=xme;
				ykey:=0.01;
				zkey:=zme;

				pictobj.setrect( 
					key1, 
					xkey,ykey,zkey, --xc,yc,zc
					0.1, 0.0, 0.1, --xr,yr,zr
					j1,j2,j3,j4,j5,j6);

			end if;

		end if;

end if; -- dt>pickdwell




		--MouseState:=SDL_GetMouseState(mousex'access,mousey'access);
		--state := integer( MouseState );
		--ileft := integer( SDL_BUTTON(1) );
		--iright:= integer( SDL_BUTTON(3) );
		--if    bitmatch(state, ileft)   then 
		--	null;
		--elsif bitmatch(state, iright)  then 
		--	null;
		--end if;






		deltaT := currentTime - oldTimeKb;

		if( key_map( SDL_SCANCODE_LEFT )  /= 0 ) then
			roty := +0.5*deltaT;
			horiang := horiang + roty;
			roty:=0.0;
			xlook := fmath.cos(vertang)*fmath.sin(horiang);
			ylook := fmath.sin(vertang);
			zlook := fmath.cos(vertang)*fmath.cos(horiang);

		elsif( key_map( SDL_SCANCODE_RIGHT )  /= 0 ) then
			roty := -0.5*deltaT;
			horiang := horiang + roty;
			roty:=0.0;
			xlook := fmath.cos(vertang)*fmath.sin(horiang);
			ylook := fmath.sin(vertang);
			zlook := fmath.cos(vertang)*fmath.cos(horiang);

		end if;


------ begin mouse drag -------------------------------------------
		handle_mouse_drag(currentTime);
------ end mouse drag -------------------------------------------


----------- begin game controller ---------------------------------
		if joystik or gamepad then
			null;
		end if; --joystik or gamepad
----------- end game controller ---------------------------------

----////////////// end response to user inputs //////////////////////////




		updateMVPs( float(winwidth), float(winheight) );



		foldtime:=currenttime;
		boldtime:=currenttime;
		oldTimeKb := currentTime; --prepare for next time




--------- begin drawing =================================================

		glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);




		-- begin draw common textured objects---------------------------




	-- draw terrain:
		glUseProgram(mystpgmTexShadID);
		glUniformMatrix4fv(mMatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniform1i(muniftex, 0);
		glUniform1i(munifdark, darkness);
		glBindTexture(GL_TEXTURE_2D, surface_texid);
		terrain.Draw(grounds,vertbuff,uvbuff,elembuff);


		--interior
		glbindtexture(gl_texture_2d, door_texid);
		pictobj.draw(door, vertbuff,uvbuff,elembuff);

		--wood entry
		glbindtexture(gl_texture_2d, porch_texid);
		pictobj.draw(porch, vertbuff,uvbuff,elembuff);



		--castle walls
		glbindtexture(gl_texture_2d, granite_texid);
		for i in 1..13 loop
			rectobj.draw(wallblok(i), vertbuff,uvbuff,elembuff);
		end loop;

		-- perimeter walls
		--rectobj.draw(wallxp, vertbuff,uvbuff,elembuff);
		--rectobj.draw(wallxm, vertbuff,uvbuff,elembuff);
		--rectobj.draw(wallzp, vertbuff,uvbuff,elembuff);
		--rectobj.draw(wallzm, vertbuff,uvbuff,elembuff);


		-- castle entry gates
		if xpup then -- X+ gate is rising

			elapsed := currenttime-lifttime;
			tt := elapsed/liftduration;
			if tt>1.0 then gatewait:=false; xpup:=false; tt:=1.0; end if;
			yg := 1.1*tt + 0.4*(1.0-tt);
			pictobj.setrect( 
				gatexp, 
				xgxp, yg, zgxp, --xc,yc,zc
				0.0, 0.4, 0.4, --xr,yr,zr
				koxlo(gxpk),koxhi(gxpk),koylo(gxpk),
				koyhi(gxpk),kozlo(gxpk),kozhi(gxpk) );

		elsif xmup then -- X- gate rising

			elapsed := currenttime-lifttime;
			tt := elapsed/liftduration;
			if tt>1.0 then gatewait:=false; xmup:=false; tt:=1.0; end if;
			yg := 1.1*tt + 0.4*(1.0-tt);
			pictobj.setrect( 
				gatexm, 
				xgxm, yg, zgxm, --xc,yc,zc
				0.0, 0.4, 0.4, --xr,yr,zr
				koxlo(gxmk),koxhi(gxmk),koylo(gxmk),
				koyhi(gxmk),kozlo(gxmk),kozhi(gxmk) );

		elsif zpup then -- Z+ gate rising

			elapsed := currenttime-lifttime;
			tt := elapsed/liftduration;
			if tt>1.0 then gatewait:=false; zpup:=false; tt:=1.0; end if;
			yg := 1.1*tt + 0.4*(1.0-tt);
			pictobj.setrect( 
				gatezp, 
				xgzp, yg, zgzp, --xc,yc,zc
				0.4, 0.4, 0.0, --xr,yr,zr
				koxlo(gzpk),koxhi(gzpk),koylo(gzpk),
				koyhi(gzpk),kozlo(gzpk),kozhi(gzpk) );

		elsif zmup then -- Z- gate rising

			elapsed := currenttime-lifttime;
			tt := elapsed/liftduration;
			if tt>1.0 then gatewait:=false; zmup:=false; tt:=1.0; end if;
			yg := 1.1*tt + 0.4*(1.0-tt);
			pictobj.setrect( 
				gatezm, 
				xgzm, yg, zgzm, --xc,yc,zc
				0.4, 0.4, 0.0, --xr,yr,zr
				koxlo(gzmk),koxhi(gzmk),koylo(gzmk),
				koyhi(gzmk),kozlo(gzmk),kozhi(gzmk) );

		end if;

		glbindtexture(gl_texture_2d, gate_texid);
			pictobj.draw(gatexp, vertbuff,uvbuff,elembuff); 
			pictobj.draw(gatexm, vertbuff,uvbuff,elembuff);
			pictobj.draw(gatezp, vertbuff,uvbuff,elembuff);
			pictobj.draw(gatezm, vertbuff,uvbuff,elembuff);


		if not keyheld then
			glbindtexture(gl_texture_2d, key_texid);
			pictobj.draw(key1, vertbuff,uvbuff,elembuff);
		end if;



--////////////// draw cube-mapped skybox //////////////////////////////////
		glUseProgram(mpidSkyB);
		glUniform1i(sbmapUID, 0);
		glUniformMatrix4fv(sbmvpUID, 1, GL_FALSE, mmvp(1,1)'address);
		glEnable(GL_TEXTURE_CUBE_MAP);
		glBindTexture(GL_TEXTURE_CUBE_MAP, tropical_cubemap_texid);
		cubemapobj.Draw(skybox, vertbuff,elembuff);




		-- glyphs drawn @ screen center
		if keyheld then --draw key
			utex.print2d("~",0.5,0.5,50); -- "~" = key
		elsif keynear then --draw hand
			utex.print2d("`",0.5,0.5,50); -- "`" = hand
		end if;






---------- end draw common textured objects----------------------------


		sdl_gl_swapwindow( mainWindow );


---------------------------------------------------------------------------
   end loop; ---------------------- main event loop end -------------------
---------------------------------------------------------------------------





	snd4ada_hpp.termSnds; -- stops any loops;  then deallocates

	release_textures;

	utex.cleanuptext;

	if joystik or gamepad then
		SDL_JoystickClose(jsa);
	end if;

	SDL_GL_DeleteContext(mainGLContext);
	SDL_DestroyWindow(mainWindow);

	SDL_Quit;


end adaventure;

