
--
-- Copyright (C) 2016  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with ada.numerics.generic_elementary_functions;
with matutils;  use matutils;




with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

-------------------------------------------------------------
with System;
with Interfaces.C;
use  type interfaces.c.unsigned;
use  type interfaces.c.c_float;
with Interfaces.C.Pointers;
with interfaces.c.strings;

use interfaces.c;
use interfaces.c.strings;

---------------------------------------------------------
with sdl;  use sdl;
---------------------------

with ada.unchecked_conversion;
with ada.text_io; use ada.text_io;
with Ada.Command_Line;
with Ada.Strings.Unbounded;
with Ada.Strings.Unbounded.Text_IO;

----------------------------------------------------------------


with shader;  use shader;

with mroomobj;
with rectobj;
with pictobj;
with treeobj;
with zfishobj;
with ztubeobj;


with cubemapobj;
with itemobj;
with usboxobj;

with text_io;  use text_io;









package gametypes is



	use gl;
	use matutils;
	use type interfaces.c.c_float;




	type vec3 is array(1..3) of float;

	package fmath is new
			Ada.Numerics.generic_elementary_functions( float );
	use fmath;



	onepi : constant float     := 3.14159_26535_89793;
	halfpi : constant float    := onepi/2.0;
	fourthpi : constant float  := onepi/4.0;
	eighthpi : constant float  := onepi/8.0;
	twopi : constant float     := onepi*2.0;
	deg2rad : constant float   := onepi/180.0;
	rad2deg : constant float   := 180.0/onepi;




---------- begin game controller ----------------------------------------

cfgfile : string := "./settings.txt";

Lsens, Rsens, Jsens : float := 1.0; -- paddle sensitivities
gshtl,gshtr,gjmp,
jshtl,jshtr,jbak,jfor,jjmp : glint; -- button maps

gamepad, joystik : boolean; --flags presence of game controllers
jsa : access SDL_JoyStick;

axis_lx, axis_ly, axis_rx, axis_ry : sdl.Sint16;

btn_0, btn_1, btn_2, btn_3,
btn_4, btn_5, btn_6, btn_7, btn_8, btn_9: sdl.Uint8;


---------- end game controller ----------------------------------------



	mousex,mousey : aliased interfaces.c.int;

	state, ileft, iright : integer;



	oldTimeKb : float := 0.0;
	mousestate : Uint32;
	deltaT : float;

	speed : constant float := 3.0;
	pauseatlevelchange : boolean := false;
	forwardok : boolean := true;


	vertbuff, uvbuff, elembuff, rgbbuff, vertexarrayid : gluint;






-- begin string pointers for getUniformLocation:

	pmv : chars_ptr := new_string("MV"&ascii.nul);
	pmvp : chars_ptr := new_string("MVP"&ascii.nul);
	pdark : chars_ptr := new_string("darkness"&ascii.nul);
	pmylev : chars_ptr := new_string("level"&ascii.nul);
	pmyts : chars_ptr := new_string("myTextureSampler"&ascii.nul);
	popac : chars_ptr := new_string("NormalOpacity"&ascii.nul);
	pcubemap : chars_ptr := new_string("CubeMap"&ascii.nul);

-- end string pointers for getUniformLocation:







----- time variables ---------------------------------------------------
	currentTime,
	deltabtntime, lasttime,
	foldtime, boldtime, jumptime : float := -20.0;
----- time variables ---------------------------------------------------


	winwidth, winheight : interfaces.c.int := 500;







	mv,mvp, pm, vm, mm, bmm,bmvp, imvp,mmvp,mmv, 
		mviewMatrix, iviewMatrix :  mat44 := identity;

	badhoriang : float:=0.0;
	horiang : float := 0.0; --halfpi; set per p1n,p2n when @ portal
	vertang : float := 0.0; -- NO code changes this yet


	rkey : constant float := 0.1;
	nearkey : constant float := 0.5;
	neargate : constant float := 1.0; -- 0.5

	xkey, ykey, zkey,
	xme,yme,zme, 
	oxme,oyme,ozme, -- virtual position
		xlook,ylook,zlook : float := 0.0;


	fovrad : constant float := fourthpi;
	fovdeg : constant float := fourthpi*rad2deg;
	mindot : constant float := cos(fourthpi);
	mindot2: constant float := cos(60.0*deg2rad);


	margin     : constant float := 0.20;
	aheight    : constant float := 0.5;
	keyheld, userexit : boolean := false;


	-- scene parms
	xmax : constant float := 20.0;
	ymax : constant float := 20.0;
	zmax : constant float := 20.0;

hmax: constant float := 0.0;
wlev: constant float := 0.0;
r1 : constant float := 10.0;
r2 : constant float := 20.0;
r3 : constant float := 30.0;



	skybox: cubemapobj.cubemap;











	jumping : boolean := false;
	pyjump : float := -ymax+aheight;
	vyjump : float := 0.0;






	mxbloks : constant integer := 25;  -- to build castle
	wallblok : array(1..mxbloks) of rectobj.rectangle; --wall

	wallxp, wallxm, wallzp, wallzm : rectobj.rectangle;

	porch,
	key1, door,
	gatexp, gatexm, gatezp, gatezm : pictobj.pictangle;




	xaxis : constant vec3 := (1.0,0.0,0.0);
	yaxis : constant vec3 := (0.0,1.0,0.0);
	zaxis : constant vec3 := (0.0,0.0,1.0);
	axis : vec3 := ( others => 0.0 );




	rotx,roty,rotz : float := 0.0;

	maxnko : constant integer := 110;
	nko, level, oldlevel : integer := 0;

	koxlo, koxhi, koylo,koyhi, kozlo,kozhi : array(1..maxnko) of float;
	onledge : array(1..maxnko) of boolean;



------------------------ begin stuff from main -----------------------------

	mainWindow : access SDL_Window;
	mainGLContext : SDL_GLContext;




	contextFlags : sdl_windowflags;
	current : aliased SDL_DisplayMode;
	should_be_zero : glint;
	cursor : access SDL_Cursor;

	Fwid, Fhit : aliased interfaces.c.int;

	ret : interfaces.c.int;
	numkeys : aliased glint;

	error : interfaces.c.int;


	--subtype keyindex is interfaces.c.int range 0..511;
	--type keyarraytype is array(keyindex) of Uint8;
	key_map : access sdl.keyarraytype;






	use gl;
	use matutils;
	use type interfaces.c.c_float;






	tfile: text_io.file_type;
	--resfile : string := "./data/resume_ag.txt";


	porch_texid,
	door_texid,
	key_texid,
	gate_texid,
	tropical_cubemap_texid,
	surface_texid, granite_texid : gluint := 0;





	playSecs : float; --glfw.Seconds;

	package myint_io is new text_io.integer_io(integer);

	major, minor, profile, flags :  glint;


	mystpgmTexShadID,
	mpidskyb,
	pidskyb, pidskyw : gluint;


	sbmvpuid, sbmapuid, mmatrixid, muniftex, munifdark: glint;




	j1,j2,j3,j4,j5,j6 : float; -- junk to ignore

	xgxp,zgxp, xgxm,zgxm, xgzp,zgzp, xgzm,zgzm: float;

	gatewait, keynear: boolean := false;

	gatenearxp, gatenearxm, gatenearzp, gatenearzm : boolean := false;

	opengatexp, opengatexm, opengatezp, opengatezm : boolean := false;

	gzpk,gzmk, gxpk,gxmk : integer;

	xpup,xmup, zpup,zmup : boolean := false;
	lifttime : float ;
	liftduration : constant float := 8.3; --seconds



------------------------------ end stuff from main -----------------------------








end gametypes;

