
--
-- Copyright (C) 2016  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


----------------------------------------------------------------
with interfaces;
with interfaces.c;


with matutils;  use matutils;
with gametypes;  use gametypes;
with snd4ada_hpp;

with ada.numerics.generic_elementary_functions;
with text_io; use text_io;
with utex;

with gl;  use gl;

with sdl;  use sdl;


with cubemapobj;
with rectobj;
with pictobj;
with treeobj;
with zfishobj;

with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

with Interfaces.C;
use  type interfaces.c.unsigned;
with Interfaces.C.Pointers;
with interfaces.c.strings;

with pngloader;
with shader;

with snd4ada_hpp; use snd4ada_hpp;



package body gameutils is

	use pngloader;
	use shader;

	package fmath is new
			Ada.Numerics.generic_elementary_functions( float );
	use fmath;






function odd( i: integer ) return boolean is
begin
	return ( i mod 2 = 1 );
end odd;



function min( x,y: float ) return float is
begin
	if x<y then return x;
	else return y; end if;
end min;

	function mini(i,j: integer) return integer is
	begin
		if i<j then return i;
		else return j; end if;
	end mini;


	procedure myassert( 
		condition : boolean;  
		flag: integer:=0;
		msg: string := ""
		) is
	begin
	  if condition=false then
			put("ASSERTION Failed!  ");
			if flag /= 0 then
				put( "@ " & integer'image(flag) &" : " );
			end if;
			put_line(msg);
			new_line;
			raise program_error;
	  end if;
	end myassert;




function max( x,y : float ) return float is
begin
	if y>x then return y;
	else return x; end if;
end;

function sqr( x:float ) return float is
begin
	return x*x;
end;

function dotprod( x,y,z, a,b,c : float ) return float is
begin
	return x*a + y*b + z*c;
end;




function intersectsko( x0,y0,z0, x1,y1,z1 : float;  k : in out integer ) return boolean is
	result: boolean := false;
	tx,ty,tz,tt,xx,yy,zz : float;
begin
	k:=-1;
	-- traverse from p0 to p1 and select obstacle closest to p1
	for j in 0..1000 loop 
		tt:=float(j)/1000.0;
		xx:=x0+tt*(x1-x0);
		yy:=y0+tt*(y1-y0);
		zz:=z0+tt*(z1-z0);

		for i in 1..nko loop
		  tx:=(xx-koxlo(i))*(koxhi(i)-xx);
		  ty:=(yy-koylo(i))*(koyhi(i)-yy);
		  tz:=(zz-kozlo(i))*(kozhi(i)-zz);
		  if (tx>0.0) and (ty>0.0) and (tz>0.0) then
		  	result:=true;
			k:=i;
		  end if;
		end loop; --for i

	end loop; --for j
	return result;
end intersectsko;





















-- jump physics here
function ypos( nowtime, yp0, yvinit, deltaSecs : float ) return float is
	epsilon : constant float := 0.1;
	gravity : constant float :=-3.0;

	-- pos = p0 + v*t + 0.5*a*t*t :
	yp : float := yp0 + yvinit*deltasecs + 0.5*gravity*sqr(deltasecs);

	yfloor : float;
begin

	if (yp>ymax) then --bumped into ceiling
		yp:=ymax;  pyjump:=yp;  vyjump:=0.0;  jumptime:=nowtime;
	end if;

	yfloor := -ymax+aheight;
	for i in 1..nko loop
	if onledge(i) then yfloor:=max(yfloor, koyhi(i)+aheight); end if;
	end loop;

	if (yp<yfloor) then --hit floor
		yp:=yfloor;
		jumping:=false;
		vyjump:=0.0;
	end if;

	return yp;

end ypos;



function hordistance( x1,y1, x2,y2 : float ) return float is
begin
	return fmath.sqrt( sqr(x2-x1) + sqr(y2-y1) );
end hordistance;

function signum( x : float ) return float is
begin
	if x>0.0 then
		return +1.0;
	elsif x<0.0 then
		return -1.0;
	else
		return 0.0;
	end if;
end signum;












procedure updategamestate is
begin

		gatenearxp :=
			(abs(xme-xgxp)<neargate) and (abs(zme-zgxp)<neargate);

		gatenearxm :=
			(abs(xme-xgxm)<neargate) and (abs(zme-zgxm)<neargate);


		gatenearzp :=
			(abs(xme-xgzp)<neargate) and (abs(zme-zgzp)<neargate);

		gatenearzm :=
			(abs(xme-xgzm)<neargate) and (abs(zme-zgzm)<neargate);

		if keyheld and gatenearxp and not opengatexp then liftgate(gxpk); end if;
		if keyheld and gatenearxm and not opengatexm then liftgate(gxmk); end if;
		if keyheld and gatenearzp and not opengatezp then liftgate(gzpk); end if;
		if keyheld and gatenearzm and not opengatezm then liftgate(gzmk); end if;


		opengatexp := opengatexp or (keyheld and gatenearxp);
		opengatexm := opengatexm or (keyheld and gatenearxm);
		opengatezp := opengatezp or (keyheld and gatenearzp);
		opengatezm := opengatezm or (keyheld and gatenearzm);


		-- must be looking down at 30 degrees or more below horizontal
		keynear := 
		( (abs(xme-xkey)<nearkey) and (abs(zme-zkey)<nearkey) and (ylook<-0.5) );


end updategamestate;




procedure liftgate( n: integer ) is
  -- n is to be removed from sequential list
  -- so we simply make it non-effectual
  -- then redefine gate, KO
begin
	myassert( n <= nko );
	myassert( (n=gxpk) or (n=gxmk) or (n=gzpk) or (n=gzmk) );

	koxlo(n):=0.0;
	koxhi(n):=0.0;
	koylo(n):=0.0;
	koyhi(n):=0.0;
	kozlo(n):=0.0;
	kozhi(n):=0.0;

	lifttime := float(sdl_getticks)/1000.0;

	gatewait:=true;
	playSnd(7);

	if n=gxpk then
		xpup:=true;
	elsif n=gxmk then
		xmup:=true;
	elsif n=gzpk then
		zpup:=true;
	elsif n=gzmk then
		zmup:=true;
	end if;

end liftgate;















--NOTICE:  typically, dt<<0.1 second  (between iterations of main loop)
--         but when it is that big, it's probably because foldtime is stale
procedure moveforward( currenttime: float ) is
	dt : float := currenttime-foldtime;
	lagfac : constant float := 1.0;
	anyrolling : boolean := false;

	dx,dy,dz,
	kxl,kxh,kyl,kyh,kzl,kzh,
	okxl,okxh, okzl, okzh: float;
begin

if not gatewait then

	dx:=dt*speed*xlook;
	dy:=0.0;  -- only move horizontally
	dz:=dt*speed*zlook;

	foldtime:=currenttime;
	oxme:=xme;
	oyme:=yme;
	ozme:=zme;

	xme:=xme+dx;
	yme:=yme+dy;
	zme:=zme+dz;


	-- limit pos to be within walls:
	if (xme>+xmax*0.9-margin) then xme:=+xmax*0.9-margin; end if;
	if (xme<-xmax*0.9+margin) then xme:=-xmax*0.9+margin; end if;
	if (zme>+zmax*0.9-margin) then zme:=+zmax*0.9-margin; end if;
	if (zme<-zmax*0.9+margin) then zme:=-zmax*0.9+margin; end if;


	-- further, limit pos to avoid ko zones:
	for i in 1..nko loop

		kxl:=xme-koxlo(i)+margin;
		kxh:=koxhi(i)+margin-xme;

		kyl:=yme-aheight/2.0-koylo(i);
		kyh:=koyhi(i)-yme+aheight/2.0;

		kzl:=zme-kozlo(i)+margin;
		kzh:=kozhi(i)+margin-zme;


		if (kxl*kxh>0.0) and (kyl*kyh>0.0) and (kzl*kzh>0.0) then 
		--intrusion into ko

			okxl:=oxme-koxlo(i)+margin;
			okxh:=koxhi(i)+margin-oxme;
			okzl:=ozme-kozlo(i)+margin;
			okzh:=kozhi(i)+margin-ozme;

			if      ( (okxl*okxh>0.0) and (okzl*okzh<=0.0) ) then
				zme:=ozme;
				null;
			elsif ( (okzl*okzh>0.0) and (okxl*okxh<=0.0) ) then
				xme:=oxme;
				null;
			end if;

		end if; --intrusion into ko


	end loop; --for i

	updategamestate;

end if;

end moveforward;




-- not yet able to back thru a stargate
procedure movebackward( currenttime: float ) is
	dt : float := currenttime-boldtime;
	--lagfac : constant float := 1.0;
	kxl,kxh,kyl,kyh,kzl,kzh,
	okxl,okxh, okzl, okzh: float;
begin

if not gatewait then

	-- 1.0 seconds per main loop
	--if (dt>2.0) then dt:=0.0; end if;


	boldtime:=currenttime;

	forwardok:=true;

	oxme:=xme;
	oyme:=yme;
	ozme:=zme;


	xme := xme - dt*speed*xlook;
	yme := yme;
	zme := zme - dt*speed*zlook;


	-- limit pos to be within walls:
	if (xme>+xmax*0.9-margin) then xme:=+xmax*0.9-margin; end if;
	if (xme<-xmax*0.9+margin) then xme:=-xmax*0.9+margin; end if;
	if (zme>+zmax*0.9-margin) then zme:=+zmax*0.9-margin; end if;
	if (zme<-zmax*0.9+margin) then zme:=-zmax*0.9+margin; end if;


	-- further, limit pos to avoid ko zones:
	for i in 1..nko loop

		kxl:=xme-koxlo(i)+margin;
		kxh:=koxhi(i)+margin-xme;

		kyl:=yme-aheight/2.0-koylo(i);
		kyh:=koyhi(i)-yme+aheight/2.0;

		kzl:=zme-kozlo(i)+margin;
		kzh:=kozhi(i)+margin-zme;


		if (kxl*kxh>0.0) and (kyl*kyh>0.0) and (kzl*kzh>0.0) then 
		--intrusion into ko

			okxl:=oxme-koxlo(i)+margin;
			okxh:=koxhi(i)+margin-oxme;
			okzl:=ozme-kozlo(i)+margin;
			okzh:=kozhi(i)+margin-ozme;

			if      ( (okxl*okxh>=0.0) and (okzl*okzh<0.0) ) then
				zme:=ozme;
			elsif ( (okzl*okzh>=0.0) and (okxl*okxh<0.0) ) then
				xme:=oxme;
			end if;

		end if; -- KO intrusion

	end loop; --for i

	updategamestate;

end if;

end movebackward;













procedure handle_gc_left( gcx,gcy:sdl.sint16 ) is
-- to update look direction using left game controller stick
	ux : float := float(gcx)/float(32768);
	uy : float := float(gcy)/float(32768);
begin


if abs(ux)<0.15 then 
	ux:=0.0;
else
	ux:=ux-0.15*signum(ux);
end if;

if abs(uy)<0.15 then 
	uy:=0.0; 
else
	uy:=uy-0.15*signum(uy);
end if;


	horiAng := horiAng - 0.04 * ux * Lsens;
	vertAng := vertAng + 0.02 * uy * Lsens;

	xlook := fmath.cos(vertAng)*fmath.sin(horiAng);
	ylook := fmath.sin(vertAng);
	zlook := fmath.cos(vertAng)*fmath.cos(horiAng);


	if
	( 
	not forwardOk 
	and (abs(badHoriAng-horiAng)>fourthpi) 
	and not pauseAtLevelChange 
	)  then
		forwardOk:=true;
		badHoriAng:=-10.0*twopi;
	end if;

end handle_gc_left;

procedure handle_gc_right( nowtime: float; gcx,gcy:sdl.sint16 ) is
-- to update move direction using right game controller stick
	ux : float := Rsens*float(gcx)/float(32768);
	uy : float := Rsens*float(gcy)/float(32768);
begin

	if    uy < -0.05 then
		moveforward(nowTime);

	elsif uy > +0.05 then
		movebackward(nowTime);

	end if;

	handle_gc_left(gcx,0); -- turns left/right

end handle_gc_right;










































   function FileExists (File : String) return Boolean is
      FileId : text_io.File_Type;
   begin -- TextFileExists
      -----------------------------------------------------
      -- Open and close the file to see if the file exists.
      -----------------------------------------------------
      text_io.Open
         (File => FileId,
          Mode => text_io.In_File,
          Name => File);

      text_io.Close
         (File => FileId);
      -------------------------------------------------
      -- If no exception occurred, the file must exist.
      -------------------------------------------------
      return True;
   exception
      when text_io.Name_Error =>
         return False;
		when others => return false;
   end FileExists;







oldTime : float := 0.0;

procedure handle_mouse_drag( nowTime : float ) is

-- to update look direction
-- also handles touch pad...

	mousedx, mousedy : aliased interfaces.c.int;
	error : Uint32;
	dt : float := nowTime-oldTime;

begin

	error := SDL_GetRelativeMouseState(mousedx'access, mousedy'access);

	oldTime:=nowTime;

	if( dt<0.1 ) then
		horiAng := horiAng - 0.002 * float(mousedx);
		vertAng := vertAng - 0.002 * float(mousedy);
	end if;

	xlook := fmath.cos(vertAng)*fmath.sin(horiAng);
	ylook := fmath.sin(vertAng);
	zlook := fmath.cos(vertAng)*fmath.cos(horiAng);


	if
	( 
	not forwardOk 
	and (abs(badHoriAng-horiAng)>fourthpi) 
	and not pauseAtLevelChange 
	)  then
		forwardOk:=true;
		badHoriAng:=-10.0*twopi;
	end if;

end handle_mouse_drag;














------------------ end game specific code -----------------------------


function bitmatch( x, y : integer ) return boolean is
	result : boolean := false;
	a : integer := x;
	b : integer := y;
begin
	for i in 1..32 loop
		if ( odd(a) and odd(b) ) then result:=true; end if;
		a:=a/2;
		b:=b/2;
	end loop;
	return result;
end;



procedure output( a : mat44 ) is
begin
	for row in 1..4 loop
	for col in 1..4 loop
		put( float'image( a(row,col) ) &" ");
	end loop;
	new_line;
	end loop;
	new_line;
end;



-------------- 9dec14 begin additions ------------------------------------



-- Warning:  this logic is not fully generalized...
--           Sokoban input files must be screened carefully.
--
--           On the other hand, Ada length function omits
--           confusing control characters at EOL, so we 
--           don't need to distinguish DOS from Unix files.
--
function is_blank( line : string; len:integer ) return boolean is
begin

	if( len < 1 ) then return true; end if;

	for i in 1..len loop
	  if( line(i) = '#' ) then return false; end if;
	end loop;
	return true;
end is_blank;




-------------- 9dec14 end additions ------------------------------------


------- begin addendum 5jan15 -------------------------------------------------

-------------- begin myst setup ---------------------------------------





procedure zeroBtns is
begin
	btn_0:=0;
	btn_1:=0;
	btn_2:=0;
	btn_3:=0;
	btn_4:=0;
	btn_5:=0;
	btn_6:=0;
	btn_7:=0;
	btn_8:=0;
end zeroBtns;










end gameutils;



