
//# -- Copyright (C) 2016  <fastrgv@gmail.com>
//# --
//# -- This program is free software: you can redistribute it and/or modify
//# -- it under the terms of the GNU General Public License as published by
//# -- the Free Software Foundation, either version 3 of the License, or
//# -- (at your option) any later version.
//# --
//# -- This program is distributed in the hope that it will be useful,
//# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
//# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//# -- GNU General Public License for more details.
//# --
//# -- You may read the full text of the GNU General Public License
//# -- at <http://www.gnu.org/licenses/>.


#include "snd4ada.hpp"

#include <SFML/Audio.hpp>
#include <SFML/System.hpp>
#include <cassert>

#include <string>
using std::string;


static int bkmus(-1);

static sf::Sound * psound;

// persistent psound loops here:
static sf::Music *pmusic[6]; // 0..5
static sf::Music *pwater, *plava, *phum;

// transient psounds here:
//                       6        7        8pdn     9      10pup       11        12
static sf::SoundBuffer *pLaser, *pStone, *pXport, *pKick, *pQport, *pShriek, *pSplash;



void termSnds(void)
{
	(*psound).stop(); // might not be necessary
	stopSnd();

	for(int i=0; i<6; i++) { delete pmusic[i]; }
	delete pwater;
	delete plava;
	delete phum;

	delete psound;

	delete pLaser;
	delete pStone;
	delete pXport;
	delete pKick;
	delete pQport;
	delete pSplash;
	delete pShriek;

}


//void initSnds(void)
int initSnds(void)
{
 // loops 0..5:
 const string st0("data/beach00.ogg");
 const string st1("data/falls.ogg");
 const string st2("data/dark-metal-electronic-loop.ogg");
 const string st3("data/gothic-dutch-trance.ogg");
 const string st4("data/portals-to-neptune_loop.ogg");
 const string st5("data/briefChurchChoir.ogg");

 // 6, 7, 8, 9, 10, 11, 12
 const string sbl("data/laser-gun.wav");
 const string sbs("data/concrete.ogg");
 const string sbx("data/putdown.wav");
 const string sbk("data/soccer-kick.wav");
 const string sqp("data/pickup.wav");
 const string sts("data/splash.wav");
 const string shk("data/medusa.ogg");

 // named loops:
 const string stw("data/lake-waves-01.ogg");
 const string stl("data/nulava.ogg");
 const string sth("data/hum.ogg");

 pmusic[0] = new sf::Music;
 pmusic[1] = new sf::Music;
 pmusic[2] = new sf::Music;
 pmusic[3] = new sf::Music;
 pmusic[4] = new sf::Music;
 pmusic[5] = new sf::Music;
 pwater    = new sf::Music;
 phum      = new sf::Music;
 plava     = new sf::Music;


	if( !(*pmusic[0]).openFromFile(st0) ) return 1;
	if( !(*pmusic[1]).openFromFile(st1) ) return 2;
	if( !(*pmusic[2]).openFromFile(st2) ) return 3;
	if( !(*pmusic[3]).openFromFile(st3) ) return 4;
	if( !(*pmusic[4]).openFromFile(st4) ) return 5;
	if( !(*pmusic[5]).openFromFile(st5) ) return 6;
	if( !(*pwater).openFromFile(stw) ) return 7;
	if( !(*plava).openFromFile(stl) ) return 8;
	if( !(*phum).openFromFile(sth) ) return 9;

	for(int i=0; i<6; i++) {
		(*pmusic[i]).setLoop(true);
		if( i==0 ) 
			(*pmusic[i]).setVolume(100);
		else
			(*pmusic[i]).setVolume(50);
	}
	(*pmusic[3]).setVolume(40); //gothicDutch

	(*pwater).setLoop(true);
	(*pwater).setVolume(60); // 16nov14 down from 100
	
	(*plava).setLoop(true);
	(*plava).setVolume(100);

	(*phum).setLoop(true);
	(*phum).setVolume(100);



// end loops, begin transients:

psound    = new sf::Sound;
pLaser  = new sf::SoundBuffer;
pStone  = new sf::SoundBuffer;
pXport  = new sf::SoundBuffer;
pKick   = new sf::SoundBuffer;
pQport  = new sf::SoundBuffer;
pSplash = new sf::SoundBuffer;
pShriek = new sf::SoundBuffer;

	if( !(*pLaser).loadFromFile(sbl) ) return 10;
	if( !(*pStone).loadFromFile(sbs) ) return 11;
	if( !(*pXport).loadFromFile(sbx) ) return 12;
	if( !(*pKick).loadFromFile(sbk) ) return 13;
	if( !(*pQport).loadFromFile(sqp) ) return 14;
	if( !(*pSplash).loadFromFile(sts) ) return 15;
	if( !(*pShriek).loadFromFile(shk) ) return 16;


	(*psound).setLoop(false);
	(*psound).setVolume(100);

	return 0;

} // end initSnds





void stopSnd(void) {  // stops current music loop AND named bkgd loop

	if( ( bkmus >= 0 ) && ( bkmus<=5 ) )
	{
		(*pmusic[bkmus]).stop();
		bkmus=-1;
	}

	if( sf::Music::Playing == (*phum).getStatus() )       (*phum).stop();
	if( sf::Music::Playing == (*plava).getStatus() )     (*plava).stop();
	if( sf::Music::Playing == (*pwater).getStatus() )   (*pwater).stop();

} // end stopSnd






void stopMusik(void) {  // stops current music loop only

	if( ( bkmus >= 0 ) && ( bkmus<=5 ) )
	{
		(*pmusic[bkmus]).stop();
		bkmus=-1;
	}

} // end stopMusik




void playHum(void) {
	(*phum).play();
}

void stopHum(void) {
	if( sf::Music::Playing == (*phum).getStatus() )     (*phum).stop();
}




void playLava(void) {
	(*plava).play();
}

void stopLava(void) {
	if( sf::Music::Playing == (*plava).getStatus() )   (*plava).stop();
}





void playWater(void) {
	(*pwater).play();
}

void stopWater(void) {
	if( sf::Music::Playing == (*pwater).getStatus() ) (*pwater).stop();
}



// these next two procs start, stop
// the prolog [transient] splash-loop
void playSplash(void) {
	sf::Sound & sound(*psound);

	sound.setBuffer(*pSplash);
	sound.setVolume(20);
	sound.setLoop(true);
	sound.play();
}
void stopSplash(void) {
		(*psound).stop();
}







void playSnd( int nbuf ) {

	sf::Sound & sound(*psound);


	assert(nbuf>=0);
	assert(nbuf<=11);


	if( nbuf<6 ) 
	{
		if( bkmus>=0 ) stopSnd();
		bkmus=nbuf;
		(*pmusic[bkmus]).play();
	}


	else if( nbuf==6 )
	{
		sound.setBuffer(*pLaser);
		sound.setLoop(false);
		sound.setVolume(50);
		sound.play();
	}
	else if( nbuf==7 )
	{
		sound.setBuffer(*pStone);
		sound.setLoop(false);
		sound.setVolume(100);
		sound.play();
	}

	else if( nbuf==8 )
	{
		sound.setBuffer(*pXport);
		sound.setLoop(false);
		sound.setVolume(50);
		sound.play();
	}


	else if( nbuf==9 )
	{
		sound.setBuffer(*pKick);
		sound.setLoop(false);
		sound.setVolume(100);
		sound.play();
	}


	else if( nbuf==10 )
	{
		sound.setBuffer(*pQport);
		sound.setLoop(false);
		sound.setVolume(50);
		sound.play();
	}

	else if( nbuf==11 )
	{
		sound.setBuffer(*pShriek);
		sound.setLoop(false);
		sound.setVolume(99);
		sound.play();
	}



} // end playSnd


