
--
-- Copyright (C) 2016  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (adaventure)

procedure draw_castle is
begin


		
		glUseProgram( pgmtexshadid );

		gluniformmatrix4fv( mvid, 1, gl_false, imv(1,1)'address );
		gluniformmatrix4fv( matrixid, 1, gl_false, imvp(1,1)'address );

		gluniform1i(uniftex,0);
		glUniform1i(unifdark, darkness);

		gluniform1i(uniflev, interfaces.c.int(1) ); 
		-- 1=>normal, 2=>dense, 3=>extreme fog

		gluniform1i(unifclr, interfaces.c.int(1) ); 
		-- 1=>gray, 2=>brown, 3=>purple fog

		glbindtexture(gl_texture_2d, room_texid);
		mroomobj.draw(rmo,vertbuff,uvbuff,elembuff); --textured room


		--ceiling
		glbindtexture(gl_texture_2d, ceil_texid);
		pictobj.draw(ceil, vertbuff,uvbuff,elembuff);

		--ceiling
		glbindtexture(gl_texture_2d, moorwall_texid);
		pictobj.draw(wallmoor, vertbuff,uvbuff,elembuff);


		--floor
		glbindtexture(gl_texture_2d, floor_texid);
		rectobj.draw(floor, vertbuff,uvbuff,elembuff);

		--pedestal
		glbindtexture(gl_texture_2d, cherry_texid);
		pictobj.draw(pedestal, vertbuff,uvbuff,elembuff);

		--tapestry
		glbindtexture(gl_texture_2d, rug_texid);
		pictobj.draw(rug, vertbuff,uvbuff,elembuff);

		--hallway door
		--glbindtexture(gl_texture_2d, hall_texid);
		glbindtexture(gl_texture_2d, doorwood_texid);
		pictobj.draw(ihallway, vertbuff,uvbuff,elembuff);

		if not gkeyheld and sgkey=2 and gkeyvisible then
			glbindtexture(gl_texture_2d, gkey_texid);
			pictobj.draw(key3, vertbuff,uvbuff,elembuff);
		end if;

		if not bkeyheld and sbkey=2 and bkeyvisible then
			glbindtexture(gl_texture_2d, bkey_texid);
			pictobj.draw(key2, vertbuff,uvbuff,elembuff);
		end if;

		if not wkeyheld and swkey=2 and wkeyvisible then
			glbindtexture(gl_texture_2d, key_texid);
			pictobj.draw(key1, vertbuff,uvbuff,elembuff);
		end if;

		if not swordheld and ssword=2 then
			glbindtexture(gl_texture_2d, sword_texid);
			pictobj.draw(sword, vertbuff,uvbuff,elembuff);
		end if;



	if drawchalice and schalice=2 and not chaliceheld then
	-- use uniforms to set position
		glUseProgram(cupTexShadID);
		glUniformMatrix4fv(cupMatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniform1i(cupuniftex, 0);
		glUniform1i(cupunifdark, darkness);
		glUniform3f(cupcenid, xchalice,ychalice,zchalice );
		glUniform3f(cupradid, 0.1, 0.2, 0.1 );

		gluniform1i(cupuniflev, interfaces.c.int(1) ); 
		-- 1=>normal, 2=>dense, 3=>extreme fog

		gluniform1i(cupunifclr, interfaces.c.int(1) ); 
		-- 1=>gray, 2=>brown, 3=>purple fog

		glUniformMatrix4fv(cupmvid, 1, GL_FALSE, imv(1,1)'address);

		glbindtexture(gl_texture_2d, chalice_texid);
		xtreeobj.draw(chalice, vertbuff,uvbuff,elembuff);
	end if;


		-- glyphs drawn @ screen center

		if gkeyheld then --draw key
			utex.print2d("^",0.5,0.5,50); -- "^" = key

		elsif wkeyheld then --draw key
			utex.print2d("~",0.5,0.5,50); -- "~" = key

		elsif bkeyheld then --draw key
			utex.print2d("|",0.5,0.5,50); -- "|" = key

		elsif swordheld then --draw sword
			utex.print2d("(--",0.5,0.5,40);

		elsif chaliceheld then --draw chalice
			utex.print2d("V",0.5,0.5,30);

		elsif gkeynear or bkeynear or wkeynear or swordnear or chalicenear then --draw hand
			utex.print2d("`",0.5,0.5,50); -- "`" = hand
		end if;



end draw_castle;


