
--
-- Copyright (C) 2016  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (adaventure)

procedure draw_maze is

	wdoor : constant float := 0.8;
	hdoor : constant float := 1.0;

begin


		--for normal textured objects:
		glUseProgram( pgmtexshadid );

		gluniformmatrix4fv( mvid, 1, gl_false, imv(1,1)'address );
		gluniformmatrix4fv( matrixid, 1, gl_false, imvp(1,1)'address );

		gluniform1i(uniftex,0);
		glUniform1i(unifdark, darkness);

		gluniform1i(uniflev, interfaces.c.int(3) ); 
		-- 1=>normal, 2=>heavy, 3=>extreme fog
		gluniform1i(unifclr, interfaces.c.int(1) ); 
		-- 1=>gray, 2=>brown, 3=>purple fog

		glbindtexture(gl_texture_2d, mazeouter_texid);
		mroomobj.draw(rmo,vertbuff,uvbuff,elembuff); --textured room



		--floor
		glbindtexture(gl_texture_2d, grass_texid);
		rectobj.draw(floor, vertbuff,uvbuff,elembuff);



		--maze entry door
		glbindtexture(gl_texture_2d, doort_texid);
		twictobj.draw(imazedoor, vertbuff,uvbuff,elembuff);


		if liongoingup then

			elapsed := currenttime-liontime;
			tt := elapsed/liftduration;
			if tt>1.0 then 
				lionwait:=false; 
				lionopen:=true;
				liongoingup:=false;
				tt:=1.0; 
			end if;

			ylion:=ymaze+1.98*tt*hdoor;
			twictobj.setrect( 
				dungdoor,
				xlion, ylion, zlion,
				1.2*wdoor, hdoor, 1.2*wdoor,
				j1,j2,j3,j4,j5,j6);

			--disable KO #lko
			koxlo(lko):=0.0;
			koxhi(lko):=0.0;
			koylo(lko):=0.0;
			koyhi(lko):=0.0;
			kozlo(lko):=0.0;
			kozhi(lko):=0.0;

		end if;

		--maze exit door
		glbindtexture(gl_texture_2d, hall_texid);
		twictobj.draw(imazeexit, vertbuff,uvbuff,elembuff);

		-- lion lift door
		glbindtexture(gl_texture_2d, lion_texid);
		twictobj.draw(dungdoor, vertbuff,uvbuff,elembuff);









		--pillars
		glbindtexture(gl_texture_2d, gmarble_texid);
		cylobj.draw(pillar1, vertbuff,uvbuff,elembuff);
		cylobj.draw(pillar2, vertbuff,uvbuff,elembuff);
		twictobj.draw(beam12, vertbuff,uvbuff,elembuff);


		--maze walls
		glbindtexture(gl_texture_2d, hedge_texid);
		for i in 1..mz loop
			rectobj.draw(mwall(i), vertbuff,uvbuff,elembuff);
		end loop;


--------- temporary fixed ceiling -----------------------------
		--glbindtexture(gl_texture_2d, ceil_texid);
		--pictobj.draw(ceil, vertbuff,uvbuff,elembuff);

---------------------------------------------------------------

		if not gkeyheld and sgkey=3 and gkeyvisible then
			glbindtexture(gl_texture_2d, gkey_texid);
			pictobj.draw(key3, vertbuff,uvbuff,elembuff);
		end if;


		if not bkeyheld and sbkey=3 and bkeyvisible then
			glbindtexture(gl_texture_2d, bkey_texid);
			pictobj.draw(key2, vertbuff,uvbuff,elembuff);
		end if;

		if not wkeyheld and swkey=3 and wkeyvisible then
			glbindtexture(gl_texture_2d, key_texid);
			pictobj.draw(key1, vertbuff,uvbuff,elembuff);
		end if;

		if not swordheld and ssword=3 then
			glbindtexture(gl_texture_2d, sword_texid);
			pictobj.draw(sword, vertbuff,uvbuff,elembuff);
		end if;



	if drawchalice and schalice=3 and not chaliceheld then
	-- use uniforms to set position
		glUseProgram(cupTexShadID);
		glUniformMatrix4fv(cupMatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniform1i(cupuniftex, 0);
		glUniform1i(cupunifdark, darkness);
		glUniform3f(cupcenid, xchalice,ychalice,zchalice );
		glUniform3f(cupradid, 0.1, 0.2, 0.1 );


		gluniform1i(cupuniflev, interfaces.c.int(3) ); 
		-- 1=>normal, 2=>dense, 3=>extreme fog

		gluniform1i(cupunifclr, interfaces.c.int(1) ); 
		-- 1=>gray, 2=>brown, 3=>purple fog

		glUniformMatrix4fv(cupmvid, 1, GL_FALSE, imv(1,1)'address);



		glbindtexture(gl_texture_2d, chalice_texid);
		xtreeobj.draw(chalice, vertbuff,uvbuff,elembuff);
	end if;




		-- glyphs drawn @ screen center
		if gkeyheld then --draw key
			utex.print2d("^",0.5,0.5,50); -- "^" = key

		elsif bkeyheld then --draw key
			utex.print2d("|",0.5,0.5,50); -- "|" = key

		elsif wkeyheld then --draw key
			utex.print2d("~",0.5,0.5,50); -- "~" = key

		elsif swordheld then --draw sword
			utex.print2d("(--",0.5,0.5,40);

		elsif chaliceheld then --draw chalice
			utex.print2d("V",0.5,0.5,30);

		elsif gkeynear or bkeynear or wkeynear or swordnear or chalicenear then --draw hand
			utex.print2d("`",0.5,0.5,50); -- "`" = hand
		end if;






		-- fancy fragshader draws cloud ceiling
		glUseProgram( skyshadid );
		gluniformmatrix4fv( skymatid, 1, gl_false, imvp(1,1)'address );
		gluniform1f(skytimeid, glfloat(currentTime) );
		gluniform2f(skyresid, glfloat(winwidth), glfloat(winheight) );
		rectxobj.draw(rox,vertbuff,elembuff);




end draw_maze;


