
--
-- Copyright (C) 2016  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (adaventure)


procedure setup_dungeon is -- scene=4

	wdoor : constant float := 0.8;
	hdoor : constant float := 1.0;
	tdoor : constant float := 0.1;

begin

if not restore_dungeon then --first time

-- aheight=0.5 so lets try to live with that...
-- default room size is [x,y,z] in [-10..10, -3..3, -10..10]

	--walls
	mroomobj.setrect( dro, 
		0.0, 0.0, 0.0,
		--ixmax,iymax,izmax,
		ixmax/3.0,iymax,izmax,
		ixmax/6.0,iymax/2.0,izmax/4.0); --scaled for 16 mirrored copies each wall

	--mural
	pictobj.setrect(zpmural, 
		0.0,-1.0, izmax-0.02, 
		ixmax/5.0,1.0,0.02, 
		j1,j2,j3,j4,j5,j6);

	-- walls
	rectobj.setrect(zpwall, 
		0.0, 2.0, izmax-0.02, 
		ixmax/3.0,1.0,0.02, 
		j1,j2,j3,j4,j5,j6);
	rectobj.setrect(zmwall, 
		0.0, 2.0, -izmax+0.02, 
		ixmax/3.0,1.0,0.02, 
		j1,j2,j3,j4,j5,j6);
	rectobj.setrect(xpwall, 
		ixmax/3.0-0.02, 2.0, 0.0, 
		0.02, 1.0, izmax,
		j1,j2,j3,j4,j5,j6);
	rectobj.setrect(xmwall, 
		-ixmax/3.0+0.02, 2.0, 0.0, 
		0.02, 1.0, izmax,
		j1,j2,j3,j4,j5,j6);


	--ceiling
	rectobj.setrect(rceil, 
		0.0,iymax-0.01,0.0, 
		ixmax,0.0,izmax, 
		j1,j2,j3,j4,j5,j6);

	rectobj.setrect(floor, 
		0.0,-iymax+0.01,0.0, 
		ixmax,0.0,izmax, 
		j1,j2,j3,j4,j5,j6);

-- define dungeon door:
	xdung:=0.0;
	ydung:=-iymax+hdoor;
	zdung:=-izmax;
	tdung:=0.9;
	nko:=nko+1;
	koscene(nko):=4;
	pictobj.setrect( 
		idung,
		xdung, ydung, zdung,
		wdoor, hdoor, tdoor,
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );


	pictobj.setrect( 
		beam34,
		xdung,ydung+hdoor,zdung,
		wdoor+0.4, 0.3, 0.3,
		j1,j2,j3,j4,j5,j6);

	nko:=nko+1;
	koscene(nko):=4;
	cylobj.setcyl(
		pillar3,
		xdung-wdoor,ydung,zdung,
		hdoor, 0.3,
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );

	nko:=nko+1;
	koscene(nko):=4;
	cylobj.setcyl(
		pillar4,
		xdung+wdoor,ydung,zdung,
		hdoor, 0.3,
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );

--------- begin 6 tall marble pillars

	nko:=nko+1;
	koscene(nko):=4;
	cylobj.setcyl(
		pillar5,
		-ixmax/3.0+0.5, 0.0, -izmax+0.5,
		iymax, 0.5,
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );

	nko:=nko+1;
	koscene(nko):=4;
	cylobj.setcyl(
		pillar6,
		-ixmax/3.0+0.5, 0.0, +izmax-0.5,
		iymax, 0.5,
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );

	nko:=nko+1;
	koscene(nko):=4;
	cylobj.setcyl(
		pillar7,
		-ixmax/3.0+0.5, 0.0, 0.0,
		iymax, 0.5,
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );




	nko:=nko+1;
	koscene(nko):=4;
	cylobj.setcyl(
		pillar8,
		+ixmax/3.0-0.5, 0.0, -izmax+0.5,
		iymax, 0.5,
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );

	nko:=nko+1;
	koscene(nko):=4;
	cylobj.setcyl(
		pillar9,
		+ixmax/3.0-0.5, 0.0, +izmax-0.5,
		iymax, 0.5,
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );

	nko:=nko+1;
	koscene(nko):=4;
	cylobj.setcyl(
		pillar10,
		+ixmax/3.0-0.5, 0.0, 0.0,
		iymax, 0.5,
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );
















--define rocksafe
	nko:=nko+1;
	koscene(nko):=4;
	pictobj.setrect( 
		rsafe,
		--ixmax/3.0-0.5,-iymax+0.5, izmax-0.5,
		0.0,-iymax+0.3, izmax-0.3,
		0.3, 0.3, 0.3,
		koxlo(nko),koxhi(nko), koylo(nko),
		koyhi(nko), kozlo(nko),kozhi(nko) );

--initialize chalice to be near front of rocksafe
--xchalice:=glfloat(ixmax/3.0-0.5);
--ychalice:=glfloat(-iymax+0.3);
--zchalice:=glfloat(izmax-1.0);

xchalice:=glfloat(0.0);
ychalice:=glfloat(-iymax+0.6);
zchalice:=glfloat(izmax-0.3);
schalice:=4;
drawchalice:=true;

-- door to rocksafe
	--nko:=nko+1;
	--koscene(nko):=4;
	--pictobj.setrect( 
	--	rdoor,
	--	ixmax/3.0-0.5,-iymax+0.3, izmax-1.0-0.001,
	--	0.3, 0.3, 0.001,
	--	koxlo(nko),koxhi(nko), koylo(nko),
	--	koyhi(nko), kozlo(nko),kozhi(nko) );



--------------------------------------------------------


end if; -- restore

	interior:=true;


	xdung:=0.0;
	ydung:=-iymax+hdoor;
	zdung:=-izmax;
	tdung:=0.9;



restore_dungeon:=true; --flag indicates already prepped

end setup_dungeon;



