--
-- Copyright (C) 2016  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with snd4ada_hpp;

with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

-------------------------------------------------------------
with System;
with Interfaces.C;
use  type interfaces.c.unsigned;
with Interfaces.C.Pointers;
with interfaces.c.strings;


----------------------------------------------------------------
with sdl;  use sdl;
----------------------------------------------------------------

with matutils;
with utex;

with ada.unchecked_conversion;
with Ada.Command_Line;
with Ada.Strings.Unbounded;
with Ada.Strings.Unbounded.Text_IO;
with ada.numerics.generic_elementary_functions;

----------------------------------------------------------------


with shader;  use shader;

with cubemapobj;
with mroomobj;
with xtreeobj;
with rectobj;
with rectxobj;
with pictobj;
with twictobj;
with cylobj;

with texsurfobj;
with usboxobj;


with text_io;
with pngloader;
with gametypes;
with gameutils;
with matutils;

with ada.calendar;

with snd4ada_hpp;  use snd4ada_hpp;


procedure adaventure is

	use text_io;
	use pngloader;
	use gametypes;
	use gameutils;
	use matutils;
	--use gametypes.fmath;
	use interfaces.c;
	use interfaces.c.strings;
	use glext;
	use glext.pointers;
	use glext.binding;
	use gl;
	use gl.binding;
	use gl.pointers;





package terrain is new texsurfobj(20,20,land_alt); -- 12mar16
grounds : terrain.texsurf;







procedure release_textures is -- prepare to close down
begin

	glext.binding.glDeleteBuffers(1, vertbuff'address);
	glext.binding.glDeleteBuffers(1, rgbbuff'address);
	glext.binding.glDeleteBuffers(1, uvbuff'address);
	glext.binding.glDeleteBuffers(1, elembuff'address);
	glext.binding.glDeleteVertexArrays(1, vertexarrayid'address);

	gldeletetextures(1, gkey_texid'address);
	gldeletetextures(1, bkey_texid'address);
	gldeletetextures(1, key_texid'address);
	gldeletetextures(1, sword_texid'address);

	gldeletetextures(1, bat1_texid'address);
	gldeletetextures(1, bat2_texid'address);

	gldeletetextures(1, deadwdragon_texid'address);
	gldeletetextures(1, doorwood_texid'address);

--------- castle begin --------------------------------------------

	glext.binding.glDeleteProgram( pidskyb );
	glext.binding.glDeleteProgram( pidterra );

	gldeletetextures(1, cubemap_texid'address);
	gldeletetextures(1, stone_texid'address);
	gldeletetextures(1, grass_texid'address);
	gldeletetextures(1, grass1_texid'address);
	gldeletetextures(1, stone_texid'address);
	gldeletetextures(1, gate_texid'address);
	gldeletetextures(1, hall_texid'address);
	gldeletetextures(1, wood_texid'address);
	gldeletetextures(1, room_texid'address);
	gldeletetextures(1, mazewall_texid'address);
	gldeletetextures(1, moorwall_texid'address);
	gldeletetextures(1, gmarble_texid'address);

	gldeletetextures(1, stonedoor_texid'address);
	gldeletetextures(1, greenrockwall_texid'address);
	gldeletetextures(1, lion_texid'address);

	gldeletetextures(1, spalm_texid'address);
	gldeletetextures(1, tpalm_texid'address);

	gldeletetextures(1, tree1_texid'address);
	gldeletetextures(1, tree2_texid'address);
	gldeletetextures(1, tree3_texid'address);
	gldeletetextures(1, tree4_texid'address);
	gldeletetextures(1, tree5_texid'address);

	gldeletetextures(1, intview_texid'address);

---------- chalice room begin -------------------------------------

end release_textures;



procedure setup_textures is  -- prepare dungeon textures
begin 

--------- castle begin --------------------------------------------

	cubemap_texid := loadCubePng(
	"data/skyBoxes/stormy/px.png",	"data/skyBoxes/stormy/nx.png",
	"data/skyBoxes/stormy/py.png",	"data/skyBoxes/stormy/ny.png",
	"data/skyBoxes/stormy/pz.png",	"data/skyBoxes/stormy/nz.png"	);

	--cubemap_texid := loadCubePng(
	--"data/skyBoxes/clouds/bluft.png",	"data/skyBoxes/clouds/blubk.png",
	--"data/skyBoxes/clouds/bluup.png",	"data/skyBoxes/clouds/bludn.png",
	--"data/skyBoxes/clouds/blurt.png",	"data/skyBoxes/clouds/blulf.png"	);

	pidSkyB := LoadShaders( "./data/osky.vs", "./data/osky.fs" );
	sbmvpUID := glGetUniformLocation( pidSkyB, pmvp );     
	sbmapUID := glGetUniformLocation( pidSkyB, pcubemap );     

	pidterra := 
		LoadShaders( "./data/yislandobj.vs", "./data/islandobj.fs" );
	mMatrixID := glGetUniformLocation( pidterra, pmvp );     
	muniftex := glGetUniformLocation( pidterra, pmyts );     
	munifdark := glGetUniformLocation( pidterra, pdark );     

	terrain.setrect(grounds, 0.0,0.0, xmax, zmax );

	grass1_texid := loadPng(pngloader.mirror,"data/grass1.png");

	grass_texid := loadPng(pngloader.mirror,"data/grasss.png");
	-- note that loadPng uses mirrored_repeat texture wrapping


	cubemapobj.setrect( skybox, 0.0,0.0,0.0, 20.0,20.0,20.0 );
	stone_texid  := loadPng(mirror,"data/stonewall.png");
	gate_texid  := loadPng(mirror,"data/pbayGate.png");
	gkey_texid  := loadPng(mirror,"data/gkey.png");
	bkey_texid  := loadPng(mirror,"data/bkey.png");
	key_texid  := loadPng(mirror,"data/wkey.png");
	sword_texid  := loadPng(mirror,"data/swordw.png");
	hall_texid  := loadPng(mirror,"data/hallgray2.png");
	wood_texid  := loadPng(mirror,"data/wood.png");

	greenrockwall_texid  := loadPng(mirror,"data/rockwall1.png");
	stonedoor_texid  := loadPng(mirror,"data/stonedoor.png");
	stonedoorc_texid  := loadPng(mirror,"data/stonedoorC.png");

	moorwall_texid  := loadPng(mirror,"data/moorishWall.png");
	gmarble_texid  := loadPng(mirror,"data/marblegray.png");

	deadwdragon_texid  := loadPng(mirror,"data/dbd.png");


	doorwood_texid  := loadPng(mirror,"data/doorwood.png");
	door_texid  := loadPng(mirror,"data/door.png");
	doort_texid  := loadPng(mirror,"data/doort.png");
	hedge_texid  := loadPng(mirror,"data/hedge2Pbay.png");


	lion_texid  := loadPng(mirror,"data/lion.png");

	intview_texid  := loadPng(mirror,"data/intview3.png");

------------ chalice room begin -----------------------------------


	pgmtexshadid := loadshaders("./data/texobjFog.vs", "./data/texobjFog.fs");
	mvid := glgetuniformlocation(pgmtexshadid, pmv); --MV
	matrixid := glgetuniformlocation(pgmtexshadid, pmvp); --MVP
	uniftex  := glgetuniformlocation(pgmtexshadid, pmyts); --myTextureSampler
	unifdark := glGetUniformLocation(pgmtexshadid, pdark );--darkness
	uniflev  := glgetuniformlocation(pgmtexshadid, pmylev);--level
	unifclr  := glgetuniformlocation(pgmtexshadid, pmyclr);--color

	mural_texid := loadPng(mirror,"data/mural.png");
	greekey_texid := loadPng(mirror,"data/greek.png");
	adobe_texid := loadPng(mirror,"data/darkadobe.png");
	cherry_texid := loadPng(mirror,"data/wood2_texture.png"); --cherry wood
	room_texid := loadPng(mirror,"data/darkstonewall.png"); 

	mazewall_texid := loadPng(mirror,"data/roof2.png"); 
	mazeouter_texid  := loadPng(mirror,"data/hedge3Pbay.png");

	ceil_texid := loadPng(mirror,"data/mosqueceilSQ.png"); 
	floor_texid  := loadPng(mirror,"data/bricksE.png");
	dungeon_texid  := loadPng(mirror,"data/bricksC.png");
	dungeont_texid  := loadPng(mirror,"data/bricksCt.png");
	rug_texid  := loadPng(mirror,"data/persiancarpetdark.png");
	chalice_texid  := loadPng(mirror,"data/chaliceT.png");

	--grunge_texid  := loadPng(mirror,"data/grungeRGBA.png");

	bat1_texid := loadPng(mirror,"data/bat0b.png");
	bat2_texid := loadPng(mirror,"data/bat1b.png");

	cupTexShadID:=LoadShaders("./data/newtexobj.vs","./data/texobjFog.fs");
	cupMatrixID := glGetUniformLocation( cupTexShadID, pmvp );     
	cupuniftex := glGetUniformLocation( cupTexShadID, pmyts );     
	cupunifdark := glGetUniformLocation( cupTexShadID, pdark );     
	cupradID := glGetUniformLocation(cupTexShadID, pwrad); --// vec3
	cupcenid := glGetUniformLocation(cupTexShadID, pwpos); --// vec3

	cupuniflev  := glgetuniformlocation(cuptexshadid, pmylev);--level
	cupunifclr  := glgetuniformlocation(cuptexshadid, pmyclr);--color
	cupmvid := glgetuniformlocation(cuptexshadid, pmv); --MV


--------- trees begin ---------------------------------------------

	spalm_texid := loadPng(mirror,"data/palm1.png");
	tpalm_texid := loadPng(mirror,"data/tallpalm1.png");

	tree1_texid := loadPng(mirror,"data/tree1.png");
	tree2_texid := loadPng(mirror,"data/tree2.png");
	tree3_texid := loadPng(mirror,"data/tree3.png");
	tree4_texid := loadPng(mirror,"data/tree4.png");
	tree5_texid := loadPng(mirror,"data/tree5.png");


	treeTexShadID:=LoadShaders("./data/windtexobj.vs","./data/otexobj.fs");
	treeMatrixID := glGetUniformLocation( treeTexShadID, pmvp );
	treeuniftex := glGetUniformLocation( treeTexShadID, pmyts );
	treeunifdark := glGetUniformLocation( treeTexShadID, pdark );
	treeuniftime := glGetUniformLocation( treeTexShadID, pmytime );
	treeunifid := glGetUniformLocation( treeTexShadID, ppid );
	treebaseunifid := glGetUniformLocation( treeTexShadID, psand );

	treeradID := glGetUniformLocation(treeTexShadID, pwrad); --// vec3
	treecenid := glGetUniformLocation(treeTexShadID, pwpos); --// vec3





--------------- maze room begin -----------------------------------

	skyshadid := loadshaders("./data/skyX.vs", "./data/tunnelstars.fs");
	-- ok, pretty awesome night sky...twinkling stars with liminous colors

	--skyshadid := loadshaders("./data/skyX.vs", "./data/starfield3.fs");
	-- nice as is liminous green designs in night sky

	--skyshadid := loadshaders("./data/skyX.vs", "./data/clouds.fs");
	-- fine B&W night clouds


	skymatid := glgetuniformlocation(skyshadid, pmvp);
	skyresid := glgetuniformlocation(skyshadid, presol);
	skytimeid := glgetuniformlocation(skyshadid, ptime);



end setup_textures; ------------------------------------------------------------




procedure setup_exterior is separate;
procedure draw_exterior is separate;

procedure setup_castle is separate;
procedure draw_castle is separate;


procedure setup_maze is separate;
procedure draw_maze is separate;


procedure setup_dungeon is separate;
procedure draw_dungeon is separate;





type itemtype is (gkee, bkee, wkee, srd, cup);

procedure dropitem( item: itemtype ) is
begin



	if item=gkee then

		xgkey:=xme;
		zgkey:=zme;
		sgkey:=scene;
		if interior then
			ygkey:=-iymax+0.02;
		else
			ygkey:=0.03+land_alt(xme,zme);
		end if;

		pictobj.setrect( 
			key3, 
			xgkey,ygkey,zgkey, --xc,yc,zc
			0.1, 0.0, 0.1, --xr,yr,zr
			j1,j2,j3,j4,j5,j6);


	elsif item=bkee then

		xbkey:=xme;
		zbkey:=zme;
		sbkey:=scene;
		if interior then
			ybkey:=-iymax+0.02;
		else
			ybkey:=0.03+land_alt(xme,zme);
		end if;

		pictobj.setrect( 
			key2, 
			xbkey,ybkey,zbkey, --xc,yc,zc
			0.1, 0.0, 0.1, --xr,yr,zr
			j1,j2,j3,j4,j5,j6);

	elsif item=wkee then

		xwkey:=xme;
		zwkey:=zme;
		swkey:=scene;
		if interior then
			ywkey:=-iymax+0.02;
		else
			ywkey:=0.03+land_alt(xme,zme);
		end if;

		pictobj.setrect( 
			key1, 
			xwkey,ywkey,zwkey, --xc,yc,zc
			0.1, 0.0, 0.1, --xr,yr,zr
			j1,j2,j3,j4,j5,j6);

	elsif item=srd then

		xsword:=xme;
		if interior then
			ysword:=-iymax+0.02;
		else
			ysword:=0.03+land_alt(xme,zme);
		end if;
		zsword:=zme;
		ssword:=scene;
		pictobj.setrect( 
			sword, 
			xsword,ysword,zsword,
			0.1, 0.0, 0.1,
			j1,j2,j3,j4,j5,j6);



	elsif item=cup then

		xchalice:=glfloat(xme);
		if interior then
			ychalice:=glfloat(-iymax+0.02);
		else
			ychalice:=glfloat(0.02+land_alt(xme,zme));
		end if;
		zchalice:=glfloat(zme);
		schalice:=scene;
		-- uses [dynamic] uniform-positioning @ draw-time

	end if;

end dropitem;



-- decide if object is picked
procedure pickLeft( item: itemtype ) is
	--xtgt,ztgt, x0,y0,z0, x1,y1,z1, tt : float := 0.0;
	dx,dy,dz, xobj,yobj,zobj, objang : float;
begin

	if item=gkee then
		yobj:=ygkey;
		xobj:=xgkey;
		zobj:=zgkey;
	elsif item=bkee then
		yobj:=ybkey;
		xobj:=xbkey;
		zobj:=zbkey;
	elsif item=wkee then 
		yobj:=ywkey;
		xobj:=xwkey;
		zobj:=zwkey;
	elsif item=srd then 
		yobj:=ysword;
		xobj:=xsword;
		zobj:=zsword;
	elsif item=cup then 
		yobj:=float(ychalice);
		xobj:=float(xchalice);
		zobj:=float(zchalice);
	end if;

----------------------- begin delete ----------------
	--x0:=xme;
	--y0:=yme;
	--z0:=zme;
	--x1:=x0;
	--y1:=y0;
	--z1:=z0;
	--while (y1>yobj) loop
	--	tt:=tt+1.0;
	--	x1 := x0 + tt*xlook;
	--	y1 := y0 + tt*ylook;
	--	z1 := z0 + tt*zlook;
	--end loop;
	--tt := (yobj-y0)/(y1-y0);
	--xtgt := x0 + tt*(x1-x0);
	--ztgt := z0 + tt*(z1-z0);
	--dx := xtgt-xobj;
	--dz := ztgt-zobj;
------------------------ end delete -------------------------

	dx := xobj-xme;
	dy := yobj-yme;
	dz := zobj-zme;
	objang := angl(xlook,ylook,zlook, dx,dy,dz);

if objang<fourthpi then

if item=gkee then

	if (abs(dx)<nearkey) and (abs(dz)<nearkey) and gkeyvisible  then

		if swordheld then dropitem(srd);
		elsif wkeyheld then dropitem(wkee);
		elsif bkeyheld then dropitem(bkee);
		elsif chaliceheld then dropitem(cup);
		end if;

		gkeyheld:=true; 
		swordheld:=false; 
		chaliceheld:=false; 
		bkeyheld:=false;
		wkeyheld:=false;
		playSnd(10); --pickup
	else
		gkeyheld:=false;
		playSnd(8); --putdown
	end if;




elsif item=wkee then

	if (abs(dx)<nearkey) and (abs(dz)<nearkey) and wkeyvisible  then

		if swordheld then dropitem(srd);
		elsif gkeyheld then dropitem(gkee);
		elsif bkeyheld then dropitem(bkee);
		elsif chaliceheld then dropitem(cup);
		end if;

		wkeyheld:=true; swordheld:=false; chaliceheld:=false; 
		bkeyheld:=false;
		gkeyheld:=false;
		playSnd(10); --pickup
	else
		wkeyheld:=false;
		playSnd(8); --putdown
	end if;



elsif item=bkee then

	if (abs(dx)<nearkey) and (abs(dz)<nearkey) and bkeyvisible  then

		if swordheld then dropitem(srd);
		elsif wkeyheld then dropitem(wkee);
		elsif gkeyheld then dropitem(gkee);
		elsif chaliceheld then dropitem(cup);
		end if;

		bkeyheld:=true; swordheld:=false; chaliceheld:=false; wkeyheld:=false;
		gkeyheld:=false;
		playSnd(10); --pickup
	else
		bkeyheld:=false;
		playSnd(8); --putdown
	end if;


elsif item=srd then

	if (abs(dx)<nearsword) and (abs(dz)<nearsword)  then

		if wkeyheld then dropitem(wkee);
		elsif bkeyheld then dropitem(bkee);
		elsif gkeyheld then dropitem(gkee);
		elsif chaliceheld then dropitem(cup);
		end if;

		swordheld:=true; wkeyheld:=false; chaliceheld:=false; bkeyheld:=false;
		gkeyheld:=false;
		playSnd(10);
	else
		swordheld:=false;
		playSnd(8);
	end if;

elsif item=cup then

	if (abs(dx)<nearchalice) and (abs(dz)<nearchalice)  then

		if swordheld then dropitem(srd);
		elsif bkeyheld then dropitem(bkee);
		elsif gkeyheld then dropitem(gkee);
		elsif wkeyheld then dropitem(wkee);
		end if;

		chaliceheld:=true; swordheld:=false; wkeyheld:=false; bkeyheld:=false;
		gkeyheld:=false;
		chalicegone:=true; --do NOT show inside rocksafe
		drawchalice:=true; --...but DO draw it as soon as dropped
		playSnd(10); --pickup
	else
		chaliceheld:=false;
		playSnd(8); --putdown
	end if;

end if;

end if; -- objang<pi/4

end pickLeft;




sz: integer;
dt: float;
imdead: boolean := false;

keydwell: constant float := 2.0; --seconds
keytime : float := 0.0;

------------------------------ main program begin ==========================
begin --adaventure

	new_line;
	new_line;
	put_line("Please be patient...Adaventure is slow to load...");
	new_line;
	new_line;


	first_prep;  -- main program setup

	SDL_PumpEvents; -- this precludes a Gnome "app-not-responding" dialog

	setup_textures; -- prep various textures

	SDL_PumpEvents; -- this precludes a Gnome "app-not-responding" dialog

	updateMVPs( float(winwidth), float(winheight) );

	xtreeobj.setrect(chalice);

	nuscene:=1; -- later, this will control prep/display


	-- main event loop begin: -----------------------------------------------
   while not userexit loop


	-- prep each new scene here

		if nuscene /= scene then

			if nuscene=1 then interior:=false;
			elsif nuscene=2 then interior:=true;
			elsif nuscene=3 then interior:=true;
			elsif nuscene=4 then interior:=true;
			end if;

			if scene>0 then
				savehang(scene) := horiang;
				savexme(scene):=xme;
				savezme(scene):=zme;
			end if;

			xme:=savexme(nuscene);
			zme:=savezme(nuscene);

			if interior then
				yme := -iymax+aheight;
			else
				yme := aheight + land_alt(xme,zme);
			end if;

			horiang := onepi+savehang(nuscene);
			vertang:=0.0;

			xlook := fmath.cos(vertAng)*fmath.sin(horiAng);
			ylook := fmath.sin(vertAng);
			zlook := fmath.cos(vertAng)*fmath.cos(horiAng);



			--if nuscene /= 2 then stopCelebrate; end if;

			if nuscene=1 then

				setup_exterior; -- position, build castle
				if scene=2 and dejavu and not dragonsent then
					sendDragon; -- just once per scene
					dragonsent:=true;
				end if;
				dejavu:=true; 

			elsif nuscene=2 then
				setup_castle;
			elsif nuscene=3 then
				setup_maze;
			elsif nuscene=4 then
				setup_dungeon;
			end if;


			if not dejavu then 
				batsent:=false;
				batested:=false;
			end if;

			scene:=nuscene;

		end if; -- nuscene /= scene


	-- main event loop middle: -----------------------------------------------

------- begin response to user inputs ////////////////////////////////////

		currentTime := float(sdl_getticks)/1000.0;


		SDL_PumpEvents;


		if( key_map( SDL_SCANCODE_ESCAPE ) /= 0 ) then userexit:=true; end if;
		if( key_map( SDL_SCANCODE_Q ) /= 0 ) then userexit:=true; end if;

		if
			( key_map( SDL_SCANCODE_I ) /= 0 )
			and (currentTime-keytime>keydwell)
		then 
			intro:=not intro; 
			keytime:=currentTime;
		end if;


		if(      key_map( SDL_SCANCODE_UP     )  /= 0 ) then 
			moveForward(currentTime);
		elsif( key_map( SDL_SCANCODE_DOWN   )  /= 0 ) then 
			moveBackward(currentTime);
		end if;
		

		if( key_map( SDL_SCANCODE_SPACE )  /= 0 ) then
					jumpTime := currentTime;
					pyjump:= yme;
					vyjump:=2.0;
					jumping:=true;
		end if;

-----	///////////////////// begin response to mouse buttons


if abs(currentTime-pltime)>pickdwell then

		MouseState:=SDL_GetMouseState(mousex'access,mousey'access);
		state := integer( MouseState );
		ileft := integer( SDL_BUTTON(1) );

		if    bitmatch(state, ileft)   then 

			pltime:=currentTime;


			-- key logic:
			if gkeynear and not gkeyheld then
				pickLeft(gkee);

			elsif bkeynear and not bkeyheld then
				pickLeft(bkee);

			elsif wkeynear and not wkeyheld then
				pickLeft(wkee);

			-- sword logic:
			elsif swordnear and not swordheld then
				pickLeft(srd);

			-- chalice logic:
			elsif chalicenear and not chaliceheld then
				pickLeft(cup);


			elsif wkeyheld and not gatewait then
				wkeyheld:=false;
				dropitem(wkee);
				playSnd(8); --putdown


			elsif gkeyheld and not mazewait then
				gkeyheld:=false;
				dropitem(gkee);
				playSnd(8); --putdown

			elsif bkeyheld and not lionwait then
				bkeyheld:=false;
				dropitem(bkee);
				playSnd(8); --putdown


			elsif swordheld then
				swordheld:=false;
				dropitem(srd);
				playSnd(8); --putdown


			elsif chaliceheld then
				chaliceheld:=false;
				dropitem(cup);
				playSnd(8); --putdown

				if interior and scene=2 and pedestalnear then
					xchalice:=xped;
					ychalice:=yped;
					zchalice:=zped;
					snd4ada_hpp.playCelebrate;
					success:=true;
					--snd4ada_hpp.playSnd(6); --fanfare
				end if;

			end if;


		end if;

end if; -- dt>pickdwell




		--MouseState:=SDL_GetMouseState(mousex'access,mousey'access);
		--state := integer( MouseState );
		--ileft := integer( SDL_BUTTON(1) );
		--iright:= integer( SDL_BUTTON(3) );
		--if    bitmatch(state, ileft)   then 
		--	null;
		--elsif bitmatch(state, iright)  then 
		--	null;
		--end if;






		deltaT := currentTime - oldTimeKb;

		if( key_map( SDL_SCANCODE_LEFT )  /= 0 ) then
			roty := +0.5*deltaT;
			horiang := horiang + roty;
			roty:=0.0;
			xlook := fmath.cos(vertang)*fmath.sin(horiang);
			ylook := fmath.sin(vertang);
			zlook := fmath.cos(vertang)*fmath.cos(horiang);

			updategamestate; --automatic in moveforward

		elsif( key_map( SDL_SCANCODE_RIGHT )  /= 0 ) then
			roty := -0.5*deltaT;
			horiang := horiang + roty;
			roty:=0.0;
			xlook := fmath.cos(vertang)*fmath.sin(horiang);
			ylook := fmath.sin(vertang);
			zlook := fmath.cos(vertang)*fmath.cos(horiang);

			updategamestate; --automatic in moveforward

		end if;


------ begin mouse drag -------------------------------------------
		handle_mouse_drag(currentTime);
------ end mouse drag -------------------------------------------


----------- begin game controller ---------------------------------
	if joystik or gamepad then

		-- axis values in [-32768...+32767]

		-- JS: 2nd Axis parm:  0..2
		-- GC: 2nd Axis parm:  0..3

		-- unresolved question:  how do I prevent spinning @ startup?

		axis_lx := SDL_JoystickGetAxis(jsa, 0);
		axis_ly := SDL_JoystickGetAxis(jsa, 1);
		handle_gc_left(axis_lx,axis_ly);

		if gamepad then -- these handle move forward/backward
			axis_rx := SDL_JoystickGetAxis(jsa, 2);
			axis_ry := SDL_JoystickGetAxis(jsa, 3);
			handle_gc_right(currentTime,axis_rx,axis_ry);
		end if;

		-- now for the buttons:

		-- 1 => pressed,  0 => not pressed
		-- JS: 2nd Btn parm:  0..7
		-- GC: 2nd Btn parm:  0..11

		zeroBtns; -- set btns 0..8 to zero
		if gamepad then
			--btn_4 := SDL_JoystickGetButton(jsa,gshtl); -- shootLeft(LtShoulder)
			--btn_5 := SDL_JoystickGetButton(jsa,gshtr); -- shootRight(RtShoulder)
			--btn_8 := SDL_JoystickGetButton(jsa,gjmp); -- jump
			null;
		elsif joystik then
			btn_0 := SDL_JoystickGetButton(jsa,jbak); -- moveBackward(trigger)
			btn_1 := SDL_JoystickGetButton(jsa,jfor); -- moveForward(thumb)
			--btn_2 := SDL_JoystickGetButton(jsa,jshtl); -- shootLeft(thumb)
			--btn_3 := SDL_JoystickGetButton(jsa,jshtr); -- shootRight(thumb)
			--btn_7 := SDL_JoystickGetButton(jsa,jjmp); -- jump
		end if;

		--if btn_7>0 or btn_8>0 then
		--	jumpTime := currentTime;
		--	pyjump:= yme;
		--	vyjump:=2.0;
		--	jumping:=true;
		--end if;

		--if btn_4>0 or btn_2>0 then 
		--	shootLeft(currentTime); 
		--end if;

		--if btn_5>0 or btn_3>0 then 
		--	shootRight(currentTime); 
		--end if;

		if joystik then
			if    btn_0>0 then -- JS.trigger
				moveBackward(currentTime);
			elsif btn_1>0 then -- JS.thumb
				moveForward(currentTime);
			end if;
		end if;


	end if; --joystik or gamepad
----------- end game controller ---------------------------------

----////////////// end response to user inputs //////////////////////////


		updateMVPs( float(winwidth), float(winheight) );


		if (scene=1 or scene=2) and atdoor(currenttime) then
			if scene=1 then nuscene:=2;
			elsif scene=2 then nuscene:=1;
			end if;
		end if;


		if 
			(scene=1 or scene=3) 
			and atmaze(currenttime) 
			and mazeopen
			and not mazewait
		then
			if scene=1 then nuscene:=3;
			elsif scene=3 then nuscene:=1;
			end if;
		end if;



		if 
			(scene=3 or scene=4) 
			and atdungeon(currenttime)
			-- note:  these next 2 conditions adequately substitute
			-- for the KO failure using twictobj
			and lionopen
			and not lionwait
		then
			if scene=4 then nuscene:=3;
			elsif scene=3 then nuscene:=4;
			end if;
		end if;


		foldtime:=currenttime;
		boldtime:=currenttime;
		oldTimeKb := currentTime; --prepare for next time



		if wkeyseen and not batsent then
			sendBat; -- just once per scene
			batsent:=true;
		end if;

--------- begin drawing =================================================

		glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);

		if scene=1 then
			draw_exterior;
		elsif scene=2 then
			draw_castle;
		elsif scene=3 then
			draw_maze;
		elsif scene=4 then
			draw_dungeon;
		end if;


		if batfly then --draw flying bat as per gun-beam
			dt:=-0.5+1.5*(currenttime-batstart)/batduration; -- -0.5..+1.0

			if dt>0.0 and not batested then
				batested:=true;

				if wkeyvisible and not wkeyheld then 
					wkeyvisible:=false;
					-- this flag being false indicates the bat
					-- succeeded in grabbing key from the ground!
				end if;

			end if;

			if dt>=1.0 then
				batfly:=false;
				if not wkeyheld and not wkeyvisible then
					--bat drops key onto ground
					xwkey:=xbat;
					zwkey:=zbat;
					if interior then
						ywkey:=-iymax+0.02;
					else
						ywkey:=0.03+land_alt(xwkey,zwkey);
					end if;
					pictobj.setrect( 
						key1, 
						xwkey,ywkey,zwkey, --xc,yc,zc
						0.1, 0.0, 0.1, --xr,yr,zr
						j1,j2,j3,j4,j5,j6);
				end if;
				wkeyvisible:=true;
			else --draw bat
				drawbat(dt);
			end if;
		end if; --batfly




		if dragonfly then --draw dragon
			dt:=(currenttime-dragonstart)/dragonduration; -- 0..1
			if dt>=1.0 then
				dragonfly:=false;
					xdra:=xme;
					zdra:=zme;
					if interior then
						ydra:=-iymax+0.02;
					else
						ydra:=0.03+land_alt(xdra,zdra);
					end if;
					pictobj.setrect( 
						wdragon1, 
						xdra,ydra,zdra,
						0.3, 0.0, 0.3, --xr,yr,zr
						j1,j2,j3,j4,j5,j6);
				if swordheld then 
					dragondead:=true;
					playSnd(9); -- dragondie.wav
					delay 0.5;
				else
					--utex.print2d("You Are Dead !", 0.5, 0.5, 90);
					playSnd(11); -- eaten.wav
					delay 4.0;
					userexit:=true;
					imdead:=true;
				end if;
				
			else --draw bat
				drawdragon(dt);
			end if;
		end if; --dragonfly

		if dragondead and not interior then
			glUseProgram(pidterra);
			glUniformMatrix4fv(mMatrixID, 1, GL_FALSE, imvp(1,1)'address);
			glUniform1i(muniftex, 0);
			glUniform1i(munifdark, darkness);

			glbindtexture(gl_texture_2d, deadwdragon_texid);
			pictobj.draw(wdragon1, vertbuff,uvbuff,elembuff);
		end if;


		if intro then
			sz:=25;
			utex.print2d("AdaVenture is a point & click quest set",0.02,0.90,sz);
			utex.print2d("in ancient Persia.  The golden chalice",0.02,0.85,sz);
			utex.print2d("of Xerxes has been stolen by Greeks.",0.02,0.80,sz);
			utex.print2d("Find & return the golden chalice",0.02,0.75,sz);
			utex.print2d("to its pedestal within the castle.",0.02,0.70,sz);
			utex.print2d("Use the sword to kill any dragons;",0.02,0.65,sz);
			utex.print2d("click to grab/drop objects as needed.",0.02,0.60,sz);
			utex.print2d("The (i)-key toggles this Introduction",0.02,0.55,sz);
		end if; --intro

		if success then

			sz:=25;
			utex.print2d("You have restored the Golden Chalice",0.02,0.90,sz);
			utex.print2d("of Xerxes!  Praise be upon you!",0.02,0.80,sz);
			utex.print2d("Now, we shall dance all the evening...",0.02,0.70,sz);
			utex.print2d("...or until you hit the (esc)-key.",0.02,0.60,sz);

		end if;

-- test new flying characters here:
--utex.print2d(":",0.5,0.5,50);
--
-- bat1="{" 
-- bat2="}"
--     Dragon=">"
-- killDragon="<"
-- hand = "`"
-- whiteKey="~"
-- blackKey="|"
-- greenKey="^"
-- spider=":"


		sdl_gl_swapwindow( mainWindow );


		if imdead then
			utex.print2d("The Dragon Ate You !", 0.3, 0.5, 70);
			sdl_gl_swapwindow( mainWindow );
			delay 3.0;
		end if;

---------------------------------------------------------------------------
   end loop; ---------------------- main event loop end -------------------
---------------------------------------------------------------------------





	snd4ada_hpp.termSnds; -- stops any loops;  then deallocates

	release_textures;

	utex.cleanuptext;

	if joystik or gamepad then
		SDL_JoystickClose(jsa);
	end if;

	SDL_GL_DeleteContext(mainGLContext);
	SDL_DestroyWindow(mainWindow);

	SDL_Quit;


end adaventure;

