
--
-- Copyright (C) 2016  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


----------------------------------------------------------------
with interfaces;
with interfaces.c;


with matutils;  use matutils;
with gametypes;  use gametypes;
with snd4ada_hpp;

with ada.numerics.generic_elementary_functions;
with text_io; use text_io;
with utex;

with gl;  use gl;

with sdl;  use sdl;


with cubemapobj;
with rectobj;
with pictobj;

with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

with system;
with Interfaces.C;
use  type interfaces.c.unsigned;
with Interfaces.C.Pointers;
with interfaces.c.strings;

with pngloader;
with shader;

with snd4ada_hpp; use snd4ada_hpp;



package body gameutils is

	use pngloader;
	use shader;

	--use gametypes.fmath;







function odd( i: integer ) return boolean is
begin
	return ( i mod 2 = 1 );
end odd;



function min( x,y: float ) return float is
begin
	if x<y then return x;
	else return y; end if;
end min;

	function mini(i,j: integer) return integer is
	begin
		if i<j then return i;
		else return j; end if;
	end mini;


	procedure myassert( 
		condition : boolean;  
		flag: integer:=0;
		msg: string := ""
		) is
	begin
	  if condition=false then
			put("ASSERTION Failed!  ");
			if flag /= 0 then
				put( "@ " & integer'image(flag) &" : " );
			end if;
			put_line(msg);
			new_line;
			raise program_error;
	  end if;
	end myassert;




function max( x,y : float ) return float is
begin
	if y>x then return y;
	else return x; end if;
end;

function sqr( x:float ) return float is
begin
	return x*x;
end;

function dotprod( x,y,z, a,b,c : float ) return float is
begin
	return x*a + y*b + z*c;
end;




function intersectsko( x0,y0,z0, x1,y1,z1 : float;  k : in out integer ) return boolean is
	result: boolean := false;
	tx,ty,tz,tt,xx,yy,zz : float;
begin
	k:=-1;
	-- traverse from p0 to p1 and select obstacle closest to p1
	for j in 0..1000 loop 
		tt:=float(j)/1000.0;
		xx:=x0+tt*(x1-x0);
		yy:=y0+tt*(y1-y0);
		zz:=z0+tt*(z1-z0);

		for i in 1..nko loop
		  tx:=(xx-koxlo(i))*(koxhi(i)-xx);
		  ty:=(yy-koylo(i))*(koyhi(i)-yy);
		  tz:=(zz-kozlo(i))*(kozhi(i)-zz);
		  if (tx>0.0) and (ty>0.0) and (tz>0.0) then
		  	result:=true;
			k:=i;
		  end if;
		end loop; --for i

	end loop; --for j
	return result;
end intersectsko;





















-- jump physics here
function ypos( nowtime, yp0, yvinit, deltaSecs : float ) return float is
	epsilon : constant float := 0.1;
	gravity : constant float :=-3.0;

	-- pos = p0 + v*t + 0.5*a*t*t :
	yp : float := yp0 + yvinit*deltasecs + 0.5*gravity*sqr(deltasecs);

	yfloor : float;
begin

	if (yp>ymax) then --bumped into ceiling
		yp:=ymax;  pyjump:=yp;  vyjump:=0.0;  jumptime:=nowtime;
	end if;

	yfloor := -ymax+aheight;
	for i in 1..nko loop
	if onledge(i) then yfloor:=max(yfloor, koyhi(i)+aheight); end if;
	end loop;

	if (yp<yfloor) then --hit floor
		yp:=yfloor;
		jumping:=false;
		vyjump:=0.0;
	end if;

	return yp;

end ypos;



function hordistance( x1,y1, x2,y2 : float ) return float is
begin
	return fmath.sqrt( sqr(x2-x1) + sqr(y2-y1) );
end hordistance;

function signum( x : float ) return float is
begin
	if x>0.0 then
		return +1.0;
	elsif x<0.0 then
		return -1.0;
	else
		return 0.0;
	end if;
end signum;






	use interfaces.c;
	use interfaces.c.strings;
	use glext;
	use glext.pointers;
	use glext.binding;
	use gl;
	use gl.binding;
	use gl.pointers;




procedure InitSDL( width, height : glint;  flags:Uint32;  name: string ) is

use system;

  ires, jerror, error, cver : interfaces.c.int;
  bresult : SDL_bool;

  compiled, linked : aliased SDL_version;

begin

	-- Careful!  Only initialize what we use (otherwise exe won't run):
	error := SDL_Init(
		SDL_INIT_TIMER or
		SDL_INIT_EVENTS or 
		SDL_INIT_VIDEO);
	myassert( error = 0, 1000 );

	jerror := SDL_Init(
		SDL_INIT_GAMECONTROLLER or
		SDL_INIT_JOYSTICK );

	joystik:=false;
	gamepad:=false;
	if  jerror = 0  and then SDL_NumJoysticks>=1  then
		jsa := SDL_JoystickOpen(0);
		gamepad := (sdl_joysticknumaxes(jsa) >= 4);
		joystik := not gamepad;
		put_line("#axes="& glint'image(sdl_joysticknumaxes(jsa)) );
		put_line("#btns="& glint'image(sdl_joysticknumbuttons(jsa)) );
		ires := SDL_JoystickEventState(SDL_QUERY); -- ignore ires (?might this stop spinning?)
		SDL_JoystickUpdate;
		axis_lx := SDL_JoystickGetAxis(jsa, 0);
		axis_ly := SDL_JoystickGetAxis(jsa, 1);
	end if;

	if gamepad then
		put_line("...#axes>=4 so I'm guessing controller is a gamepad...initialized");
	elsif joystik then
		put_line("...#axes<=3 so I'm guessing controller is a joystick...initialized");
	else
		put_line("...no game controller detected...");
	end if;

---------- begin 14feb15 insert ------------------------------------------------
	SDL_SOURCEVERSION( compiled'access );
	put_line("We compiled against SDL version "
		&Uint8'image(compiled.major)&"."
		&Uint8'image(compiled.minor)&"."
		&Uint8'image(compiled.patch) );
	cver := SDL_COMPILEDVERSION;  
	put_line("SDL_compiledversion="&glint'image(cver));
	SDL_GetVersion( linked'access );
	put_line("We linked against SDL version "
		&Uint8'image(linked.major)&"."
		&Uint8'image(linked.minor)&"."
		&Uint8'image(linked.patch) );
---------- end 14feb15 insert --------------------------------------------------

	bresult := SDL_SetHint( SDL_HINT_RENDER_VSYNC, "1" );
	myassert( bresult = SDL_TRUE, 1001 );
	bresult := SDL_SetHint( SDL_HINT_RENDER_SCALE_QUALITY, "1" );
	myassert( bresult = SDL_TRUE, 1002 );




	--// Turn on double buffering.
	error := SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
	myassert( error = 0, 1003 );
	error := SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 24);
	myassert( error = 0, 1004 );
	error := SDL_GL_SetAttribute(SDL_GL_ALPHA_SIZE, 8);
	myassert( error = 0, 1005 );





	error := SDL_GL_SetAttribute(SDL_GL_CONTEXT_MAJOR_VERSION, 3);
	myassert( error = 0, 1006 );
	error := SDL_GL_SetAttribute(SDL_GL_CONTEXT_MINOR_VERSION, 3);
	myassert( error = 0, 1007 );




	error := SDL_GL_SetAttribute( SDL_GL_CONTEXT_PROFILE_MASK, 
											SDL_GL_CONTEXT_PROFILE_CORE );
	myassert( error = 0, 1008 );

	-- Note that OSX currently requires the forward_compatible flag!
	error := SDL_GL_SetAttribute( SDL_GL_CONTEXT_FLAGS, 
											SDL_GL_CONTEXT_FORWARD_COMPATIBLE_FLAG );
	myassert( error = 0, 1009 );



	error := SDL_GL_SetAttribute(SDL_GL_MULTISAMPLESAMPLES, 4);
	myassert( error = 0, 1010 );



	mainWindow := SDL_CreateWindow( To_C(name,true) , 
			SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED, 
			width, height, flags);


	mainGLContext := SDL_GL_CreateContext(mainWindow);

	error := SDL_GL_MakeCurrent( mainWindow, mainGLContext );
	myassert( error = 0, 1011 );


end InitSDL;













package myfloat_io is new text_io.float_io(float);

package mygint_io is new text_io.integer_io(glint);


--we skip blank lines and comments beginning with "#":
function is_blank2( line : string; len:integer ) return boolean is
begin

	if( len < 1 ) then return true; end if;

	if line( line'first )='#' then return true;
	elsif line( line'first ) = ' ' then	return true; end if;

	return false;

end is_blank2;






procedure GetInt( Rcd:string;
						Bgn:in out natural;
						Int: in out glint ) is
begin
mygint_io.get( From => Rcd(Bgn..Rcd'last),
					Item => Int,
					Last => Bgn);
Bgn:=Bgn+1;
end GetInt;



procedure getNbInt(tfile:file_type; rcd: in out string; k: in out glint) is
	len,bgn: natural:=1;
begin
	while not end_of_file(tfile) loop
		get_line(tfile, rcd, len);
		if not is_blank2(rcd,len) then exit; end if;
	end loop;
	bgn:=rcd'first;

	GetInt(rcd,bgn,k);

end getNbInt;


procedure GetFlt( Rcd:string;
					  Bgn:in out natural;
					  Flt: in out float ) is
nd: positive;
begin
myfloat_io.get( From => Rcd(Bgn..Rcd'last),
					 Item => Flt,
					 Last => nd);
Bgn := nd+1;
end GetFlt;


procedure getNbFlt(tfile:file_type; rcd: in out string; t: in out float) is
	len,bgn: natural:=1;
begin
	while not end_of_file(tfile) loop
		get_line(tfile, rcd, len);
		if not is_blank2(rcd,len) then exit; end if;
	end loop;
	bgn:=rcd'first;
	GetFlt(rcd,bgn,t);
end getNbFlt;












procedure first_prep is -- main program setup
	rcd : string(1..80);
	ret : glint; --interfaces.c.int;
begin

	ret := snd4ada_hpp.initSnds;
	if ret>0 then
		put_line("snd4ada_hpp.initSnds ERROR-return = "&glint'image(ret) );
		raise program_error;
	end if;



------- begin SDL prep ---------------------------------------------------------

	ret := SDL_Init(SDL_INIT_VIDEO);
	should_be_zero := SDL_GetCurrentDisplayMode(0, current'access);
	myassert( should_be_zero = 0, 1015 );

	-- MacOSX:  HDPI is normally controlled in the "properties"
	-- box, but does not work for this app.  If there is jerkiness
	-- on your Retina display, use low dpi, which still looks 
	-- pretty good, albeit with some noticable aliasing.
	contextFlags := 
		SDL_WINDOW_SHOWN or SDL_WINDOW_OPENGL or 
		--SDL_WINDOW_FULLSCREEN_DESKTOP;
		SDL_WINDOW_FULLSCREEN_DESKTOP or SDL_WINDOW_ALLOW_HIGHDPI;

	InitSDL(current.w, current.h, contextFlags, "AdaGate");
	winwidth:=current.w;
	winheight:=current.h;



	-- this too runs fine...used for testing purposes...
	--contextFlags := SDL_WINDOW_SHOWN or SDL_WINDOW_OPENGL;
	--winwidth:=1000; --1400;
	--winheight:=600; --800;
	--InitSDL(winwidth,winheight, contextFlags, "AdaGate");


-- if joystik or gamepad, read settings here:
	if FileExists(cfgfile) then -- takes precedence over defaults
		put_line("game-controller settings file found");
		text_io.open(tfile, in_file, cfgfile);

			getNbInt(tfile,rcd,gshtl); 
			getNbInt(tfile,rcd,gshtr); 
			getNbInt(tfile,rcd,gjmp); 
		getNbFlt(tfile,rcd,Lsens); 
		getNbFlt(tfile,rcd,Rsens); 

------- end gamepad;  begin joystik --------------------

		getNbInt(tfile,rcd,jbak); 
		getNbInt(tfile,rcd,jfor); 
			getNbInt(tfile,rcd,jshtl); 
			getNbInt(tfile,rcd,jshtr); 
			getNbInt(tfile,rcd,jjmp); 
		getNbFlt(tfile,rcd,Jsens); 

		text_io.close(tfile);

	else
		put(cfgfile & " file not found...");
		put_line("Using default game controller settings");
		--gshtl:=4; --shoot left
		--gshtr:=5; --shoot right
		--gjmp :=8; --jump

		jbak :=0; --moveback
		jfor :=1; --forward
		--jshtl:=2; --shoot left
		--jshtr:=3; --shoot right
		--jjmp :=7; --jump
	end if;

	if joystik then --we actually use only Lsens or Rsens
		Lsens:=Jsens;
		Rsens:=Jsens; -- Jsens is not used
	end if;










	utex.inittext2d("data/rods3whk.png", integer(winwidth),integer(winheight));
	put_line( "Window: wid-X-hit :" 
		& interfaces.c.int'image(winwidth)&" X "
		& interfaces.c.int'image(winheight) );

	cursor := SDL_CreateSystemCursor(SDL_SYSTEM_CURSOR_CROSSHAIR);
	SDL_SetCursor(cursor);
	error := SDL_SetRelativeMouseMode(SDL_TRUE);
	myassert( error = 0, 1016 );

	SDL_GL_GetDrawableSize( mainWindow, Fwid'access, Fhit'access );
	glViewport(0,0,Fwid,Fhit);

	put_line( "Drawable: Fwid-X-Fhit : "
		&interfaces.c.int'image(Fwid)&" X "
		& interfaces.c.int'image(Fhit) );

	key_map := sdl_getkeyboardstate(numkeys'access);
	--put_line("...numkeys=" & interfaces.c.int'image(numkeys) ); -- 512
	--myassert( sdl.keyrange'last <= numkeys, 1017 );




	glgenvertexarrays(1, vertexarrayid'address );
	glbindvertexarray(vertexarrayid);

	glactivetexture(gl_texture0); -- moved here 5nov14 (outside main loop)

	glgenbuffers(1, vertbuff'address);
	glgenbuffers(1, rgbbuff'address);
	glgenbuffers(1, uvbuff'address);
	glgenbuffers(1, elembuff'address);




	glenable(gl_depth_test);
	gldepthfunc( gl_lequal );
	glenable( gl_cull_face );

	glShadeModel(gl_smooth);



	-- 6nov14  theoretically reduces aliasing (can't tell for sure):
	glEnable(GL_MULTISAMPLE);
	glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
	glHint(GL_POLYGON_SMOOTH_HINT, GL_NICEST);


	level:=0;


end first_prep;









--calculate the radian measure of the solid angle between two vectors
function angl( x1,y1,z1, x2,y2,z2 : float ) return float is
	len1 : constant float := fmath.sqrt(x1*x1+y1*y1+z1*z1);
	len2 : constant float := fmath.sqrt(x2*x2+y2*y2+z2*z2);
	dot12, cosang : float;
begin
myassert(len1>0.0, 191, "angl: len1=0");
myassert(len2>0.0, 192, "angl: len2=0");
-- note:  if these ever fail, simply define offending length to be 0.01

	dot12:=x1*x2+y1*y2+z1*z2;
	cosang := dot12/len1/len2;
	return fmath.arccos(cosang);
end angl;








	-- this assumes mm=ID, (xme,yme,zme)=virtual pos within skybox
	-- [ actual pos versus skybox is always (0,0,0) ]
	procedure updateMVPs( wid,hit : float) is
		xlk,ylk,zlk,
		xrt,yrt,zrt,
		xup,yup,zup : float;
	begin

		-- Look Vector
		xlk:=xme+xlook;
		ylk:=yme+ylook;
		zlk:=zme+zlook;

		-- Right unit-Direction
		xrt:= fmath.sin(horiang-halfpi);
		yrt:= 0.0;
		zrt:= fmath.cos(horiang-halfpi);

		-- calculate UP unit-Direction
		cross( xrt,yrt,zrt, xlook,ylook,zlook, xup,yup,zup );

		perspective(pm, 45.0, wid/hit,  0.1, 100.0);

		lookat(mv, 0.0,0.0,0.0, xlook,ylook,zlook, xup,yup,zup );
		lookat(imv, xme,yme,zme, xlk,ylk,zlk, xup,yup,zup );

		mmv:=mv;
		mmvp:=mv;
		imvp:=imv;
		myMatMult(mmvp,pm);
		myMatMult(imvp,pm);

	end updateMVPs;












procedure updategamestate is
	cupang, swordang, wkeyang,bkeyang,gkeyang: float := 1.0;
begin

	if scene=1 then

		gatenearxp :=
			(abs(xme-xgxp)<neargate) and (abs(zme-zgxp)<neargate);

		gatenearxm :=
			(abs(xme-xgxm)<neargate) and (abs(zme-zgxm)<neargate);


		gatenearzp :=
			(abs(xme-xgzp)<neargate) and (abs(zme-zgzp)<neargate);

		gatenearzm :=
			(abs(xme-xgzm)<neargate) and (abs(zme-zgzm)<neargate);

		if wkeyheld and gatenearxp and not opengatexp then liftgate(gxpk); end if;
		if wkeyheld and gatenearxm and not opengatexm then liftgate(gxmk); end if;
		if wkeyheld and gatenearzp and not opengatezp then liftgate(gzpk); end if;
		if wkeyheld and gatenearzm and not opengatezm then liftgate(gzmk); end if;


		opengatexp := opengatexp or (wkeyheld and gatenearxp);
		opengatexm := opengatexm or (wkeyheld and gatenearxm);
		opengatezp := opengatezp or (wkeyheld and gatenearzp);
		opengatezm := opengatezm or (wkeyheld and gatenearzm);


------- now deal with opening maze

		mazenear :=
			(abs(xme-xmaze)<neargate*1.8) and (abs(zme-zmaze)<neargate*1.8);
			--(abs(xme-xmaze)<neargate*1.5) and (abs(zme-zmaze)<neargate*1.5);
		if gkeyheld and mazenear and not openmaze then liftmaze; end if;
		openmaze := openmaze or (gkeyheld and mazenear);



	elsif scene=3 then

		lionnear :=
			(abs(xme-xlion)<neargate*1.5) and (abs(zme-zlion)<neargate*1.5);

		if bkeyheld and lionnear and not openlion then liftlion; end if;

		openlion := openlion or (bkeyheld and lionnear);

	end if;





if not chaliceheld then
	cupang := angl(xlook,ylook,zlook, 
		float(xchalice)-xme,
		float(ychalice)-yme,
		float(zchalice)-zme);
end if;

if not wkeyheld then
	wkeyang := angl(xlook,ylook,zlook, xwkey-xme,  ywkey-yme, zwkey-zme);
end if;

if not bkeyheld then
	bkeyang := angl(xlook,ylook,zlook, xbkey-xme,  ybkey-yme, zbkey-zme);
end if;

if not gkeyheld then
	gkeyang := angl(xlook,ylook,zlook, xgkey-xme,  ygkey-yme, zgkey-zme);
end if;

if not swordheld then
	swordang :=angl(xlook,ylook,zlook, xsword-xme,ysword-yme,zsword-zme);
end if;

	wkeyseen := (
		not wkeyheld
		and (abs(xme-xwkey)<nearkey*4.0)
		and (abs(zme-zwkey)<nearkey*4.0) 
		and (wkeyang<fourthpi) );

	swordseen := (
		not swordheld
		and (abs(xme-xsword)<nearsword*4.0)
		and (abs(zme-zsword)<nearsword*4.0) 
		and (swordang<fourthpi) );



	gkeynear := (
		not gkeyheld
		and (abs(xme-xgkey)<nearkey)
		and (abs(zme-zgkey)<nearkey) 
		and (gkeyang<fourthpi) );

	bkeynear := (
		not bkeyheld
		and (abs(xme-xbkey)<nearkey)
		and (abs(zme-zbkey)<nearkey) 
		and (bkeyang<fourthpi) );

	wkeynear := (
		not wkeyheld
		and (abs(xme-xwkey)<nearkey)
		and (abs(zme-zwkey)<nearkey) 
		and (wkeyang<fourthpi) );

	swordnear := (
		not swordheld
		and (abs(xme-xsword)<nearsword)
		and (abs(zme-zsword)<nearsword) 
		and (swordang<fourthpi) );

	chalicenear := (
		not chaliceheld
		and (abs(xme-float(xchalice))<nearchalice)
		and (abs(zme-float(zchalice))<nearchalice) 
		and (cupang<fourthpi) );

	pedestalnear := -- pedestal is @ (x,z)=(0,0)
		( (abs(xme-float(xped))<nearpedestal) 
		and (abs(zme-float(zped))<nearpedestal) 
		and (abs(ylook)<0.5) ); -- looking near horizontal



end updategamestate;




procedure liftgate( n: integer ) is
  -- n is to be removed from sequential list
  -- so we simply make it non-effectual
  -- then redefine gate, KO
begin
	myassert( n <= nko );
	myassert( (n=gxpk) or (n=gxmk) or (n=gzpk) or (n=gzmk) );

	koxlo(n):=0.0;
	koxhi(n):=0.0;
	koylo(n):=0.0;
	koyhi(n):=0.0;
	kozlo(n):=0.0;
	kozhi(n):=0.0;

	lifttime := float(sdl_getticks)/1000.0;

	gatewait:=true;
	playSnd(7); --concrete

	if n=gxpk then
		xpup:=true;
	elsif n=gxmk then
		xmup:=true;
	elsif n=gzpk then
		zpup:=true;
	elsif n=gzmk then
		zmup:=true;
	end if;

end liftgate;










procedure liftlion is
begin

	liontime := float(sdl_getticks)/1000.0;

	lionwait:=true;
	playSnd(7); --concrete

	liongoingup:=true;

end liftlion;






procedure liftmaze is
begin

	mazetime := float(sdl_getticks)/1000.0;

	mazewait:=true;
	playSnd(7); --concrete

	mazegoingup:=true;

end liftmaze;




















--NOTICE:  typically, dt<<0.1 second  (between iterations of main loop)
--         but when it is that big, it's probably because foldtime is stale
procedure moveforward( currenttime: float ) is
	dt : float := currenttime-foldtime;
	lagfac : constant float := 1.0;
	anyrolling : boolean := false;

	yyme, yhalf,
	kxl,kxh,kyl,kyh,kzl,kzh,
	okxl,okxh, okzl, okzh: float;
	ixmx: float;
begin

if scene=4 then
	ixmx:=ixmax/3.0;
else
	ixmx:=ixmax;
end if;

if 
	not gatewait
	and not lionwait
	and not mazewait
	--and not batwait
then

	foldtime:=currenttime;
	oxme:=xme;
	oyme:=yme;
	ozme:=zme;

	xme:=xme+dt*speed*xlook;
	zme:=zme+dt*speed*zlook;

	if not interior then
		yme := aheight + land_alt(xme,zme);
	end if;





if interior then

	-- limit pos to be within walls:
	if (xme>+ixmx-margin) then xme:=+ixmx-margin; end if;
	if (xme<-ixmx+margin) then xme:=-ixmx+margin; end if;
	if (zme>+izmax-margin) then zme:=+izmax-margin; end if;
	if (zme<-izmax+margin) then zme:=-izmax+margin; end if;

else --exterior scene
	-- limit pos to be within bounds:
	if (xme>+xmax*0.9-margin) then xme:=+xmax*0.9-margin; end if;
	if (xme<-xmax*0.9+margin) then xme:=-xmax*0.9+margin; end if;
	if (zme>+zmax*0.9-margin) then zme:=+zmax*0.9-margin; end if;
	if (zme<-zmax*0.9+margin) then zme:=-zmax*0.9+margin; end if;
end if;

	if scene=1 then
		yyme:=aheight;
		yhalf:=yyme-aheight/2.0;
	else
		yyme:=-iymax+aheight;
		yhalf:=yyme-aheight/2.0;
	end if;

	-- further, limit pos to avoid ko zones:
	for i in 1..nko loop
	if scene=koscene(i) then --this KO applies here


		kxl:=xme-koxlo(i)+margin;
		kxh:=koxhi(i)+margin-xme;

		kyl:=yhalf-koylo(i);
		kyh:=koyhi(i)-yhalf;

		kzl:=zme-kozlo(i)+margin;
		kzh:=kozhi(i)+margin-zme;





		if (kxl*kxh>0.0) and (kyl*kyh>0.0) and (kzl*kzh>0.0) then 
		--intrusion into ko

			okxl:=oxme-koxlo(i)+margin;
			okxh:=koxhi(i)+margin-oxme;
			okzl:=ozme-kozlo(i)+margin;
			okzh:=kozhi(i)+margin-ozme;

			if      ( (okxl*okxh>0.0) and (okzl*okzh<=0.0) ) then
				zme:=ozme;
				null;
			elsif ( (okzl*okzh>0.0) and (okxl*okxh<=0.0) ) then
				xme:=oxme;
				null;
			end if;

		end if; --intrusion into ko

	end if;
	end loop; --for i

	updategamestate;

end if;

end moveforward;




-- not yet able to back thru a stargate
procedure movebackward( currenttime: float ) is
	dt : float := currenttime-boldtime;
	--lagfac : constant float := 1.0;
	yyme, yhalf, kxl,kxh,kyl,kyh,kzl,kzh,
	ixmx, okxl,okxh, okzl, okzh: float;
begin

if scene=4 then
	ixmx:=ixmax/3.0;
else
	ixmx:=ixmax;
end if;

if 
	not gatewait
	and not lionwait
	and not mazewait
	--and not batwait
then


	boldtime:=currenttime;

	forwardok:=true;

	oxme:=xme;
	oyme:=yme;
	ozme:=zme;


	xme:=xme-dt*speed*xlook;
	zme:=zme-dt*speed*zlook;

	if not interior then
		yme := aheight + land_alt(xme,zme);
	end if;



if interior then

	-- limit pos to be within walls:
	if (xme>+ixmx-margin) then xme:=+ixmx-margin; end if;
	if (xme<-ixmx+margin) then xme:=-ixmx+margin; end if;
	if (zme>+izmax-margin) then zme:=+izmax-margin; end if;
	if (zme<-izmax+margin) then zme:=-izmax+margin; end if;

else --exterior scene
	-- limit pos to be within bounds:
	if (xme>+xmax*0.9-margin) then xme:=+xmax*0.9-margin; end if;
	if (xme<-xmax*0.9+margin) then xme:=-xmax*0.9+margin; end if;
	if (zme>+zmax*0.9-margin) then zme:=+zmax*0.9-margin; end if;
	if (zme<-zmax*0.9+margin) then zme:=-zmax*0.9+margin; end if;
end if;


	if scene=1 then
		yyme:=aheight;
		yhalf:=yyme-aheight/2.0;
	else
		yyme:=-iymax+aheight;
		yhalf:=yyme-aheight/2.0;
	end if;


	-- further, limit pos to avoid ko zones:
	for i in 1..nko loop
	if scene=koscene(i) then -- this KO applies here


		kxl:=xme-koxlo(i)+margin;
		kxh:=koxhi(i)+margin-xme;

		kyl:=yhalf-koylo(i);
		kyh:=koyhi(i)-yhalf;

		kzl:=zme-kozlo(i)+margin;
		kzh:=kozhi(i)+margin-zme;


		if (kxl*kxh>0.0) and (kyl*kyh>0.0) and (kzl*kzh>0.0) then 
		--intrusion into ko

			okxl:=oxme-koxlo(i)+margin;
			okxh:=koxhi(i)+margin-oxme;
			okzl:=ozme-kozlo(i)+margin;
			okzh:=kozhi(i)+margin-ozme;

			if      ( (okxl*okxh>=0.0) and (okzl*okzh<0.0) ) then
				zme:=ozme;
			elsif ( (okzl*okzh>=0.0) and (okxl*okxh<0.0) ) then
				xme:=oxme;
			end if;

		end if; -- KO intrusion
	end if;
	end loop; --for i

	updategamestate;

end if;

end movebackward;



doortime: float := 0.0;
-- ensure look direction is facing door
-- otherwise we are trapped in door-hell:
function atdoor(currenttime: float) return boolean is -- scene 1,2
	dx,dz,hrad : float;
	ok: boolean := false;
	dt: float := currenttime - doortime;
begin

if dt>repassage then -- second minimum repassage time

	dx :=  xdoor - xme;
	dz :=  zdoor - zme;
	hrad := fmath.sqrt( dx*dx + dz*dz );

	if abs(dx)>abs(dz) then
		if dx*xlook>0.0 then ok:=true; end if;
	else
		if dz*zlook>0.0 then ok:=true; end if;
	end if;

	--hlk := fmath.arctan(dx,dz);
	--ok := (abs(fmath.sin(horiang-hlk)) < 0.5);

	if (hrad<tdoor+margin+margin) 
	--and ok
	then 
		doortime:=currenttime;
		return true;
	else 
		return false;
	end if;

else
	return false;
end if;

end atdoor;












mazepassagetime: float := 0.0;
-- ensure look direction is facing maze
function atmaze(currenttime: float) return boolean is --scene 1,3
	dx,dz,hrad : float;
	ok: boolean := false;
	dt: float := currenttime - mazepassagetime;
begin

if dt>repassage then -- second minimum repassage time

	dx :=  xmaze - xme;
	dz :=  zmaze - zme;
	hrad := fmath.sqrt( dx*dx + dz*dz );

	if abs(dx)>abs(dz) then
		if dx*xlook>0.0 then ok:=true; end if;
	else
		if dz*zlook>0.0 then ok:=true; end if;
	end if;


	if (hrad<tmaze+margin+margin) 
	--and ok
	then 
		mazepassagetime:=currenttime;
		return true;
	else 
		return false;
	end if;

else
	return false;
end if;

end atmaze;












dungtime: float := 0.0;
-- ensure look direction is facing dungeon
function atdungeon(currenttime: float) return boolean is --scene 3,4
	dx,dz,hrad : float;
	ok: boolean := false;
	dt: float := currenttime - dungtime;
begin

if dt>repassage then -- second minimum repassage time

	dx :=  xdung - xme;
	dz :=  zdung - zme;
	hrad := fmath.sqrt( dx*dx + dz*dz );

	if abs(dx)>abs(dz) then
		if dx*xlook>0.0 then ok:=true; end if;
	else
		if dz*zlook>0.0 then ok:=true; end if;
	end if;


	if (hrad<tdung+margin+margin) 
	--and ok
	then 
		dungtime:=currenttime;
		return true;
	else 
		return false;
	end if;

else
	return false;
end if;

end atdungeon;





















procedure handle_gc_left( gcx,gcy:sdl.sint16 ) is
-- to update look direction using left game controller stick
	ux : float := float(gcx)/float(32768);
	uy : float := float(gcy)/float(32768);
begin


if abs(ux)<0.15 then 
	ux:=0.0;
else
	ux:=ux-0.15*signum(ux);
end if;

if abs(uy)<0.15 then 
	uy:=0.0; 
else
	uy:=uy-0.15*signum(uy);
end if;


	horiAng := horiAng - 0.04 * ux * Lsens;
	vertAng := vertAng + 0.02 * uy * Lsens;

	xlook := fmath.cos(vertAng)*fmath.sin(horiAng);
	ylook := fmath.sin(vertAng);
	zlook := fmath.cos(vertAng)*fmath.cos(horiAng);


	if
	( 
	not forwardOk 
	and (abs(badHoriAng-horiAng)>fourthpi) 
	and not pauseAtLevelChange 
	)  then
		forwardOk:=true;
		badHoriAng:=-10.0*twopi;
	end if;

	updategamestate;

end handle_gc_left;

procedure handle_gc_right( nowtime: float; gcx,gcy:sdl.sint16 ) is
-- to update move direction using right game controller stick
	ux : float := Rsens*float(gcx)/float(32768);
	uy : float := Rsens*float(gcy)/float(32768);
begin

	if    uy < -0.05 then
		moveforward(nowTime);

	elsif uy > +0.05 then
		movebackward(nowTime);

	end if;

	handle_gc_left(gcx,0); -- turns left/right

end handle_gc_right;










































   function FileExists (File : String) return Boolean is
      FileId : text_io.File_Type;
   begin -- TextFileExists
      -----------------------------------------------------
      -- Open and close the file to see if the file exists.
      -----------------------------------------------------
      text_io.Open
         (File => FileId,
          Mode => text_io.In_File,
          Name => File);

      text_io.Close
         (File => FileId);
      -------------------------------------------------
      -- If no exception occurred, the file must exist.
      -------------------------------------------------
      return True;
   exception
      when text_io.Name_Error =>
         return False;
		when others => return false;
   end FileExists;







oldTime : float := 0.0;

procedure handle_mouse_drag( nowTime : float ) is

-- to update look direction
-- also handles touch pad...

	mousedx, mousedy : aliased interfaces.c.int;
	error : Uint32;
	dt : float := nowTime-oldTime;

begin

	error := SDL_GetRelativeMouseState(mousedx'access, mousedy'access);

	oldTime:=nowTime;

	if( dt<0.1 ) then
		horiAng := horiAng - 0.002 * float(mousedx);
		vertAng := vertAng - 0.002 * float(mousedy);
	end if;

	xlook := fmath.cos(vertAng)*fmath.sin(horiAng);
	ylook := fmath.sin(vertAng);
	zlook := fmath.cos(vertAng)*fmath.cos(horiAng);


	if
	( 
	not forwardOk 
	and (abs(badHoriAng-horiAng)>fourthpi) 
	and not pauseAtLevelChange 
	)  then
		forwardOk:=true;
		badHoriAng:=-10.0*twopi;
	end if;

	updategamestate;

end handle_mouse_drag;














------------------ end game specific code -----------------------------


function bitmatch( x, y : integer ) return boolean is
	result : boolean := false;
	a : integer := x;
	b : integer := y;
begin
	for i in 1..32 loop
		if ( odd(a) and odd(b) ) then result:=true; end if;
		a:=a/2;
		b:=b/2;
	end loop;
	return result;
end;



procedure output( a : mat44 ) is
begin
	for row in 1..4 loop
	for col in 1..4 loop
		put( float'image( a(row,col) ) &" ");
	end loop;
	new_line;
	end loop;
	new_line;
end;



-------------- 9dec14 begin additions ------------------------------------



-- Warning:  this logic is not fully generalized...
--           Sokoban input files must be screened carefully.
--
--           On the other hand, Ada length function omits
--           confusing control characters at EOL, so we 
--           don't need to distinguish DOS from Unix files.
--
function is_blank( line : string; len:integer ) return boolean is
begin

	if( len < 1 ) then return true; end if;

	for i in 1..len loop
	  if( line(i) = '#' ) then return false; end if;
	end loop;
	return true;
end is_blank;




-------------- 9dec14 end additions ------------------------------------


------- begin addendum 5jan15 -------------------------------------------------

-------------- begin myst setup ---------------------------------------





procedure zeroBtns is
begin
	btn_0:=0;
	btn_1:=0;
	--btn_2:=0;
	--btn_3:=0;
	--btn_4:=0;
	--btn_5:=0;
	--btn_6:=0;
	--btn_7:=0;
	--btn_8:=0;
end zeroBtns;






-- note that xmax,ymax,zmax = (20,20,20):
function land_alt( x,z : float ) return float is
	cycx: constant float := x*twopi/xmax;
	cycz: constant float := z*twopi/zmax;
	amp : constant float := ymax/50.0; --0.4
begin
	--return 0.0;
	return -0.1 + amp*( fmath.sin(cycx)+fmath.sin(cycz) )/2.0;
end land_alt;


procedure sendBat is
begin
	batfly:=true;
	batstart:=float(sdl_getticks)/1000.0;
	-- ensure margin<1.0:
	if interior then
		xbat:=ixmax-1.0; ybat:=iymax-1.0; zbat:=izmax-1.0;
	else
		xbat:=-xmax*0.9+1.0; ybat:=ymax-1.0; zbat:=-zmax*0.9+1.0;
	end if;
end sendBat;

-- fly bat in a linear trajectory starting and ending
-- at a randomly chosen, but pickable (x,z) location
-- make the key-pickup sound, then disappear...
-- but only if lying on ground, not if being held.
procedure drawbat( et: float ) is
	v4, vcc : vec4;
	xt,yt,zt, rtgt,dot : float;
	mindot : constant float := fmath.cos(fourthpi);
	s1: string := "{"; --bat1
	s2: string := "}"; --bat2
	s : string(1..1);
	nx: constant float := 2.0; -- #transitions per second
	i: integer;
begin
	myassert( et>=-1.01 );
	myassert( et<=+1.01 );
	-- et in (-1..1)

	i := integer( batduration * et * nx );
	if odd(i) then
		s:=s1;
	else
		s:=s2;
	end if;

	xt:=xwkey+abs(et)*(xbat-xwkey);
	yt:=ywkey+abs(et)*(ybat-ywkey);
	zt:=zwkey+abs(et)*(zbat-zwkey);


	rtgt := fmath.sqrt( sqr(xt-xme) + sqr(yt-yme) + sqr(zt-zme) );
	dot := (xt-xme)*xlook + (yt-yme)*ylook + (zt-zme)*zlook;
	v4 := (xt,yt,zt,1.0);
	mymatvec( imvp, v4, vcc );

	if (dot/rtgt > mindot) then
		utex.print3d(s,
			vcc(1),vcc(2),
			vcc(3),vcc(4), 500, rtgt);
	end if;

end drawbat;

















procedure sendDragon is
	rr,r2, xmx,ymx,zmx, x,y,z: float;
begin
	dragonfly:=true;
	dragonstart:=float(sdl_getticks)/1000.0;


	if interior then
		xmx:=ixmax; ymx:=iymax; zmx:=izmax;
	else
		xmx:=xmax; ymx:=ymax; zmx:=zmax;
	end if;
	r2:=xmx*xmx+ymx*ymx+zmx*zmx;
	rr := 2.0*fmath.sqrt(r2);

	x:=xlook; y:=ylook+0.2; z:=zlook;
	normalize(x,y,z);

	loop
		xdra:=rr*x; ydra:=rr*y; zdra:=rr*z;
		exit when abs(xdra)<xmx and abs(ydra)<ymx and abs(zdra)<zmx;
		rr:=rr-1.0;
	end loop;

--put_line("me: "&float'image(xme)&","&float'image(yme)&","&float'image(zme));
--put_line("look: "&float'image(xlook)&","&float'image(ylook)&","&float'image(zlook));
--put_line("dragon: "&float'image(xdra)&","&float'image(ydra)&","&float'image(zdra));

end sendDragon;


-- 7sep16 revision:  Once the dragon is seen,
-- you cannot turn away...he approaces from
-- whatever your look direction may be !!!
procedure drawDragon( et: float ) is
	v4, vcc : vec4;
	xt,yt,zt : float;
	--rtgt,dot : float;
	mindot : constant float := fmath.cos(fourthpi);
	d2: string := "<"; --kill
	d1: string := ">"; --chase
	s : string(1..1) := d1;
	rng : float := (1.0-et)
		*fmath.sqrt(sqr(xdra-xme)+sqr(ydra-yme)+sqr(zdra-zme));
begin
	myassert( et>=-0.01 );
	myassert( et<=+1.01 );
	-- et in (0..1)

	if et>0.9 then s:=d2; end if;

	--xt:=xdra+et*(xme-xdra);
	--yt:=ydra+et*(yme-ydra);
	--zt:=zdra+et*(zme-zdra);
	--rtgt := fmath.sqrt( sqr(xt-xme) + sqr(yt-yme) + sqr(zt-zme) );
	--dot := (xt-xme)*xlook + (yt-yme)*ylook + (zt-zme)*zlook;

	xt:=xme+rng*xlook;
	yt:=yme+rng*ylook;
	zt:=zme+rng*zlook;

	v4 := (xt,yt,zt,1.0);
	mymatvec( imvp, v4, vcc );

	--if (dot/rtgt > mindot) then
		utex.print3d(s,
			vcc(1),vcc(2),
			vcc(3),vcc(4), 400, rng);
			--vcc(3),vcc(4), 400, rtgt);
	--end if;

end drawDragon;

















end gameutils;



