
--
-- Copyright (C) 2016  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with matutils;  use matutils;
with gametypes;  use gametypes;

with sdl; use sdl;


with interfaces.c;
with interfaces.c.strings;
with glext;
with glext.pointers;
with glext.binding;
with gl;
with gl.binding;
with gl.pointers;





package gameutils is


	use interfaces.c;
	use interfaces.c.strings;
	use glext;
	use glext.pointers;
	use glext.binding;
	use gl;
	use gl.binding;
	use gl.pointers;



	procedure myassert( 
		condition : boolean;  
		flag: integer:=0;
		msg: string := "");


function odd( i: integer ) return boolean;

function sqr( x: float ) return float;
function min( x,y: float ) return float;
function mini( i,j: integer ) return integer;


function intersectsko( x0,y0,z0, x1,y1,z1 : float;  k : in out integer ) return boolean;




function ypos( nowtime, yp0, yvinit, deltaSecs : float ) return float;

function hordistance( x1,y1, x2,y2 : float ) return float;

procedure moveforward( currenttime: float );
procedure movebackward( currenttime: float );

procedure first_prep;

procedure InitSDL( width, height : glint;  flags:Uint32;  name: string );



procedure updategamestate;
	procedure updateMVPs( wid,hit : float);



function FileExists (File : String) return Boolean;


procedure handle_mouse_drag( nowTime : float );

procedure handle_gc_left(gcx,gcy:sdl.sint16);
procedure handle_gc_right(nowTime:float; gcx,gcy:sdl.sint16);


function bitmatch( x,y : integer ) return boolean;


procedure zeroBtns;

procedure liftmaze;
procedure liftlion;
procedure liftgate( n: integer );

function atdoor(currenttime: float) return boolean;
function atmaze(currenttime: float) return boolean;
function atdungeon(currenttime: float) return boolean;


function land_alt( x,z : float ) return float;

procedure sendBat;
procedure sendDragon;
procedure drawbat( et: float );
procedure drawdragon( et: float );
function angl( x1,y1,z1, x2,y2,z2 : float ) return float;


end gameutils;
