
--
-- Copyright (C) 2016  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--

with system;
with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

with interfaces.c;
use type interfaces.c.unsigned_short;


with ada.finalization;
with unchecked_deallocation;

	with text_io;



package body mroomobj is -- for rectangular textured interiors

-- this variation maps multiple copies of texture to walls



procedure initialize( rm: in out room ) is
begin
	rm.vert := new varray;
	rm.txuv := new tarray;
	rm.elem := new earray;
end initialize;

procedure vfree is new unchecked_deallocation(varray,vap);
procedure tfree is new unchecked_deallocation(tarray,tap);
procedure efree is new unchecked_deallocation(earray,eap);

procedure finalize( rm: in out room ) is
begin
	vfree( rm.vert );
	tfree( rm.txuv );
	efree( rm.elem );
	--text_io.put_line("room Free");
end finalize;













procedure setroomwithfloorgap( 
	rm: room; 
	dx,dy,dz, z1,z2, xc,yc,zc, xr,yr,zr : float ) is

xm,xp,ym,yp,zm1,zp1, zm2,zp2 : float;

	j,k : integer := 0;
	jj : glushort;

	-- dungeon dimensions 10x3x20
	--dx : constant float := 0.125;
	--dy : constant float := 0.25;
	--dz : constant float := 0.125;

begin

	xm  := xc-xr;
	xp  := xc+xr;
	ym  := yc-yr;
	yp  := yc+yr;

	zm1 := zc-zr;
	zp1 := z1;
	zm2 := z2;
	zp2 := zc+zr;

	if    z1>=z2 then
		text_io.put_line("mroomobj: Z1 > Z2");
		raise program_error; 
	end if;
	if zc-zr>=z1 then 
		text_io.put_line("mroomobj: ZC-ZR >= Z1");
		raise program_error; 
	end if;
	if z2>=zc+zr then 
		text_io.put_line("mroomobj: Z2 >= ZC+ZR");
		raise program_error; 
	end if;

	gap:=true;

	-- front
	rm.vert(k+ 1):=xm;  rm.vert(k+ 2):=ym;  rm.vert(k+ 3):=zp2;
	rm.vert(k+ 4):=xm;  rm.vert(k+ 5):=yp;  rm.vert(k+ 6):=zp2;
	rm.vert(k+ 7):=xp;  rm.vert(k+ 8):=yp;  rm.vert(k+ 9):=zp2;
	rm.vert(k+10):=xp;  rm.vert(k+11):=ym;  rm.vert(k+12):=zp2;
	k:=k+12;

	j:=0;
	rm.txuv(j+2):=xm*dx;  rm.txuv(j+1):=ym*dy;
	rm.txuv(j+4):=xm*dx;  rm.txuv(j+3):=yp*dy;
	rm.txuv(j+6):=xp*dx;  rm.txuv(j+5):=yp*dy;
	rm.txuv(j+8):=xp*dx;  rm.txuv(j+7):=ym*dy;


	-- top
	rm.vert(k+ 1):=xm;  rm.vert(k+ 2):=yp;  rm.vert(k+ 3):=zp2;
	rm.vert(k+ 4):=xm;  rm.vert(k+ 5):=yp;  rm.vert(k+ 6):=zm1;
	rm.vert(k+ 7):=xp;  rm.vert(k+ 8):=yp;  rm.vert(k+ 9):=zm1;
	rm.vert(k+10):=xp;  rm.vert(k+11):=yp;  rm.vert(k+12):=zp2;
	k:=k+12;

	j:=8;
	rm.txuv(j+1):=xm*dx;  rm.txuv(j+2):=zp2*dz;
	rm.txuv(j+3):=xm*dx;  rm.txuv(j+4):=zm1*dz;
	rm.txuv(j+5):=xp*dx;  rm.txuv(j+6):=zm1*dz;
	rm.txuv(j+7):=xp*dx;  rm.txuv(j+8):=zp2*dz;



	-- back
	rm.vert(k+ 1):=xp;  rm.vert(k+ 2):=ym;  rm.vert(k+ 3):=zm1;
	rm.vert(k+ 4):=xp;  rm.vert(k+ 5):=yp;  rm.vert(k+ 6):=zm1;
	rm.vert(k+ 7):=xm;  rm.vert(k+ 8):=yp;  rm.vert(k+ 9):=zm1;
	rm.vert(k+10):=xm;  rm.vert(k+11):=ym;  rm.vert(k+12):=zm1;
	k:=k+12;

	j:=16;
	rm.txuv(j+2):=xp*dx;  rm.txuv(j+1):=ym*dy;
	rm.txuv(j+4):=xp*dx;  rm.txuv(j+3):=yp*dy;
	rm.txuv(j+6):=xm*dx;  rm.txuv(j+5):=yp*dy;
	rm.txuv(j+8):=xm*dx;  rm.txuv(j+7):=ym*dy;


	-- bottom A
	rm.vert(k+ 1):=xm;  rm.vert(k+ 2):=ym;  rm.vert(k+ 3):=zm1;
	rm.vert(k+ 4):=xm;  rm.vert(k+ 5):=ym;  rm.vert(k+ 6):=zp1;
	rm.vert(k+ 7):=xp;  rm.vert(k+ 8):=ym;  rm.vert(k+ 9):=zp1;
	rm.vert(k+10):=xp;  rm.vert(k+11):=ym;  rm.vert(k+12):=zm1;
	k:=k+12;

	j:=24;
	rm.txuv(j+1):=xm*dx;  rm.txuv(j+2):=zm1*dz;
	rm.txuv(j+3):=xm*dx;  rm.txuv(j+4):=zp1*dz;
	rm.txuv(j+5):=xp*dx;  rm.txuv(j+6):=zp1*dz;
	rm.txuv(j+7):=xp*dx;  rm.txuv(j+8):=zm1*dz;



	-- right
	rm.vert(k+ 1):=xm;  rm.vert(k+ 2):=ym;  rm.vert(k+ 3):=zm1;
	rm.vert(k+ 4):=xm;  rm.vert(k+ 5):=yp;  rm.vert(k+ 6):=zm1;
	rm.vert(k+ 7):=xm;  rm.vert(k+ 8):=yp;  rm.vert(k+ 9):=zp2;
	rm.vert(k+10):=xm;  rm.vert(k+11):=ym;  rm.vert(k+12):=zp2;
	k:=k+12;

	j:=32;
	rm.txuv(j+1):=ym*dy;  rm.txuv(j+2):=zm1*dz;
	rm.txuv(j+3):=yp*dy;  rm.txuv(j+4):=zm1*dz;
	rm.txuv(j+5):=yp*dy;  rm.txuv(j+6):=zp2*dz;
	rm.txuv(j+7):=ym*dy;  rm.txuv(j+8):=zp2*dz;


	-- left
	rm.vert(k+ 1):=xp;  rm.vert(k+ 2):=ym;  rm.vert(k+ 3):=zp2;
	rm.vert(k+ 4):=xp;  rm.vert(k+ 5):=yp;  rm.vert(k+ 6):=zp2;
	rm.vert(k+ 7):=xp;  rm.vert(k+ 8):=yp;  rm.vert(k+ 9):=zm1;
	rm.vert(k+10):=xp;  rm.vert(k+11):=ym;  rm.vert(k+12):=zm1;
	k:=k+12;

	j:=40;
	rm.txuv(j+1):=ym*dy;  rm.txuv(j+2):=zp2*dz;
	rm.txuv(j+3):=yp*dy;  rm.txuv(j+4):=zp2*dz;
	rm.txuv(j+5):=yp*dy;  rm.txuv(j+6):=zm1*dz;
	rm.txuv(j+7):=ym*dy;  rm.txuv(j+8):=zm1*dz;


	-- bottom B
	rm.vert(k+ 1):=xm;  rm.vert(k+ 2):=ym;  rm.vert(k+ 3):=zm2;
	rm.vert(k+ 4):=xm;  rm.vert(k+ 5):=ym;  rm.vert(k+ 6):=zp2;
	rm.vert(k+ 7):=xp;  rm.vert(k+ 8):=ym;  rm.vert(k+ 9):=zp2;
	rm.vert(k+10):=xp;  rm.vert(k+11):=ym;  rm.vert(k+12):=zm2;

	j:=48;
	rm.txuv(j+1):=xm*dx;  rm.txuv(j+2):=zm2*dz;
	rm.txuv(j+3):=xm*dx;  rm.txuv(j+4):=zp2*dz;
	rm.txuv(j+5):=xp*dx;  rm.txuv(j+6):=zp2*dz;
	rm.txuv(j+7):=xp*dx;  rm.txuv(j+8):=zm2*dz;



	-- element indices:
	for i in 0..6 loop
		jj:=glushort(i*4);
		j := i*6;
		rm.elem(j+1):=jj+0;
		rm.elem(j+2):=jj+1;
		rm.elem(j+3):=jj+2;
		rm.elem(j+4):=jj+2;
		rm.elem(j+5):=jj+3;
		rm.elem(j+6):=jj+0;
	end loop;


end setroomwithfloorgap;















procedure setrect( rm: room;  xc,yc,zc, xr,yr,zr, sx,sy,sz : float ) is

xm,xp,ym,yp,zm,zp : float;

	k, j : integer := 0;
	jj : glushort;

begin
	--sanity check on scale factor...
	-- s=10 => reduce texture coords by factor of 10 => fewer images per wall
   --myassert( s>=1.0 );
	--myassert( s<=10.0 );

	xm  := xc-xr;
	xp  := xc+xr;
	ym  := yc-yr;
	yp  := yc+yr;
	zm  := zc-zr;
	zp  := zc+zr;


	gap:=false;

	-- front
	rm.vert(k+ 1):=xm;  rm.vert(k+ 2):=ym;  rm.vert(k+ 3):=zp;
	rm.vert(k+ 4):=xm;  rm.vert(k+ 5):=yp;  rm.vert(k+ 6):=zp;
	rm.vert(k+ 7):=xp;  rm.vert(k+ 8):=yp;  rm.vert(k+ 9):=zp;
	rm.vert(k+10):=xp;  rm.vert(k+11):=ym;  rm.vert(k+12):=zp;
	k:=k+12;

	j:=0;
	rm.txuv(j+1):=ym/sy;  rm.txuv(j+2):=xm/sx;
	rm.txuv(j+3):=yp/sy;  rm.txuv(j+4):=xm/sx;
	rm.txuv(j+5):=yp/sy;  rm.txuv(j+6):=xp/sx;
	rm.txuv(j+7):=ym/sy;  rm.txuv(j+8):=xp/sx;




	-- top
	rm.vert(k+ 1):=xm;  rm.vert(k+ 2):=yp;  rm.vert(k+ 3):=zp;
	rm.vert(k+ 4):=xm;  rm.vert(k+ 5):=yp;  rm.vert(k+ 6):=zm;
	rm.vert(k+ 7):=xp;  rm.vert(k+ 8):=yp;  rm.vert(k+ 9):=zm;
	rm.vert(k+10):=xp;  rm.vert(k+11):=yp;  rm.vert(k+12):=zp;
	k:=k+12;

	j:=8;
	rm.txuv(j+1):=xm/sx;  rm.txuv(j+2):=zm/sz;
	rm.txuv(j+3):=xp/sx;  rm.txuv(j+4):=zm/sz;
	rm.txuv(j+5):=xp/sx;  rm.txuv(j+6):=zp/sz;
	rm.txuv(j+7):=xm/sx;  rm.txuv(j+8):=zp/sz;





	-- back
	rm.vert(k+ 1):=xp;  rm.vert(k+ 2):=ym;  rm.vert(k+ 3):=zm;
	rm.vert(k+ 4):=xp;  rm.vert(k+ 5):=yp;  rm.vert(k+ 6):=zm;
	rm.vert(k+ 7):=xm;  rm.vert(k+ 8):=yp;  rm.vert(k+ 9):=zm;
	rm.vert(k+10):=xm;  rm.vert(k+11):=ym;  rm.vert(k+12):=zm;
	k:=k+12;

	j:=16;
	rm.txuv(j+1):=ym/sy;  rm.txuv(j+2):=xm/sx;
	rm.txuv(j+3):=yp/sy;  rm.txuv(j+4):=xm/sx;
	rm.txuv(j+5):=yp/sy;  rm.txuv(j+6):=xp/sx;
	rm.txuv(j+7):=ym/sy;  rm.txuv(j+8):=xp/sx;




	-- bottom
	rm.vert(k+ 1):=xm;  rm.vert(k+ 2):=ym;  rm.vert(k+ 3):=zm;
	rm.vert(k+ 4):=xm;  rm.vert(k+ 5):=ym;  rm.vert(k+ 6):=zp;
	rm.vert(k+ 7):=xp;  rm.vert(k+ 8):=ym;  rm.vert(k+ 9):=zp;
	rm.vert(k+10):=xp;  rm.vert(k+11):=ym;  rm.vert(k+12):=zm;
	k:=k+12;

	j:=24;
	rm.txuv(j+1):=xm/sx;  rm.txuv(j+2):=zm/sz;
	rm.txuv(j+3):=xp/sx;  rm.txuv(j+4):=zm/sz;
	rm.txuv(j+5):=xp/sx;  rm.txuv(j+6):=zp/sz;
	rm.txuv(j+7):=xm/sx;  rm.txuv(j+8):=zp/sz;





	-- right
	rm.vert(k+ 1):=xm;  rm.vert(k+ 2):=ym;  rm.vert(k+ 3):=zm;
	rm.vert(k+ 4):=xm;  rm.vert(k+ 5):=yp;  rm.vert(k+ 6):=zm;
	rm.vert(k+ 7):=xm;  rm.vert(k+ 8):=yp;  rm.vert(k+ 9):=zp;
	rm.vert(k+10):=xm;  rm.vert(k+11):=ym;  rm.vert(k+12):=zp;
	k:=k+12;

	j:=32;
	rm.txuv(j+1):=ym/sy;  rm.txuv(j+2):=zm/sz;
	rm.txuv(j+3):=yp/sy;  rm.txuv(j+4):=zm/sz;
	rm.txuv(j+5):=yp/sy;  rm.txuv(j+6):=zp/sz;
	rm.txuv(j+7):=ym/sy;  rm.txuv(j+8):=zp/sz;




	-- left
	rm.vert(k+ 1):=xp;  rm.vert(k+ 2):=ym;  rm.vert(k+ 3):=zp;
	rm.vert(k+ 4):=xp;  rm.vert(k+ 5):=yp;  rm.vert(k+ 6):=zp;
	rm.vert(k+ 7):=xp;  rm.vert(k+ 8):=yp;  rm.vert(k+ 9):=zm;
	rm.vert(k+10):=xp;  rm.vert(k+11):=ym;  rm.vert(k+12):=zm;

	j:=40;
	rm.txuv(j+1):=ym/sy;  rm.txuv(j+2):=zm/sz;
	rm.txuv(j+3):=yp/sy;  rm.txuv(j+4):=zm/sz;
	rm.txuv(j+5):=yp/sy;  rm.txuv(j+6):=zp/sz;
	rm.txuv(j+7):=ym/sy;  rm.txuv(j+8):=zp/sz;






	-- element indices:
	for i in 0..5 loop
		jj:=glushort(i*4);
		j := i*6;
		rm.elem(j+1):=jj+0;
		rm.elem(j+2):=jj+1;
		rm.elem(j+3):=jj+2;
		rm.elem(j+4):=jj+2;
		rm.elem(j+5):=jj+3;
		rm.elem(j+6):=jj+0;
	end loop;


end setrect;



--
-- note:  the shaders for these objects must have two 
-- input "layouts", as well as whatever uniforms are needed:
--
-- layout(location=0) in vec3 vertPosName
-- layout(location=1) in vec3 vertRgbName
--
-- ...where their actual names can be whatever is convenient
--
use gl;
use glext;
use glext.binding;
use gl.binding;

procedure draw( rm: room;  vertbuff, uvbuff, elembuff : gluint ) is
	nv, nt, ne : integer; -- no gap => (72,48,36);  gap=>(84,56,42)
begin

	if gap then
		nv:=nvert;
		nt:=nuv;
		ne:=nelm;
	else
		nv:=72;
		nt:=48;
		ne:=36;
	end if;

	-- 0th attribute:  vertices
	glBindBuffer(gl_array_buffer, vertbuff);
	glBufferData(gl_array_buffer, glsizeiptr(4*nv), rm.vert(1)'address, gl_static_draw);
	glEnableVertexAttribArray(0);
	glVertexAttribPointer(0,3,gl_float,gl_false,0, system.null_address);

	-- 1st attribute:  texture UV
	glBindBuffer(gl_array_buffer, uvbuff);
	glBufferData(gl_array_buffer, glsizeiptr(4*nt), rm.txuv(1)'address, gl_static_draw);
	glEnableVertexAttribArray(1);
	glVertexAttribPointer(1,2,gl_float,gl_false,0, system.null_address);

	-- element indices:
	glBindBuffer(gl_element_array_buffer, elembuff);
	glBufferData(gl_element_array_buffer, glsizeiptr(2*ne), rm.elem(1)'address, gl_static_draw);

	glEnable(gl_blend);
	glBlendFunc(gl_src_alpha, gl_one_minus_src_alpha);

	glDrawElements( gl_triangles, glint(nv), gl_unsigned_short, system.null_address );

	glDisableVertexAttribArray(0);
	glDisableVertexAttribArray(1);

end draw;



end mroomobj;

