
//# -- Copyright (C) 2016  <fastrgv@gmail.com>
//# --
//# -- This program is free software: you can redistribute it and/or modify
//# -- it under the terms of the GNU General Public License as published by
//# -- the Free Software Foundation, either version 3 of the License, or
//# -- (at your option) any later version.
//# --
//# -- This program is distributed in the hope that it will be useful,
//# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
//# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//# -- GNU General Public License for more details.
//# --
//# -- You may read the full text of the GNU General Public License
//# -- at <http://www.gnu.org/licenses/>.


#include "snd4ada.hpp"

#include <SFML/Audio.hpp>
#include <SFML/System.hpp>
#include <cassert>

#include <string>
using std::string;



static sf::Sound * psound;

// transient psounds here:
//                       6        7         8     9      10       11        12
static sf::SoundBuffer *pFanfare, *pStone, *pDn, *pdDie, *pUp, *pdEat, *pCelebrate;



void termSnds(void)
{
	(*psound).stop(); // might not be necessary

	delete psound;

	delete pFanfare;
	delete pStone;
	delete pDn;
	delete pdDie;
	delete pUp;
	delete pCelebrate;
	delete pdEat;

}


//void initSnds(void)
int initSnds(void)
{
 
 // 6, 7, 8, 9, 10, 11
 const string sbf("data/fanfare.wav");
 const string sbs("data/concrete.ogg");
 const string sbx("data/putdown.wav");
 const string sdd("data/dragondie.wav"); // 9=dragondie
 const string sqp("data/pickup.wav");
 const string sde("data/eaten.wav");  // 11=eaten


 // named loops:
 const string sts("data/mide.wav");
// end loops, begin transients:

psound    = new sf::Sound;
pFanfare  = new sf::SoundBuffer;
pStone  = new sf::SoundBuffer;
pDn  = new sf::SoundBuffer;
pdDie   = new sf::SoundBuffer;
pUp  = new sf::SoundBuffer;
pCelebrate = new sf::SoundBuffer;
pdEat = new sf::SoundBuffer;

	if( !(*pFanfare).loadFromFile(sbf) ) return 10;
	if( !(*pStone).loadFromFile(sbs) ) return 11;
	if( !(*pDn).loadFromFile(sbx) ) return 12;
	if( !(*pdDie).loadFromFile(sdd) ) return 13;
	if( !(*pUp).loadFromFile(sqp) ) return 14;
	if( !(*pCelebrate).loadFromFile(sts) ) return 15;
	if( !(*pdEat).loadFromFile(sde) ) return 16;


	(*psound).setLoop(false);
	(*psound).setVolume(100);

	return 0;

} // end initSnds







// these next two procs start, stop
// the prolog [transient] splash-loop
void playCelebrate(void) {
	sf::Sound & sound(*psound);

	sound.setBuffer(*pCelebrate);
	sound.setVolume(90);
	sound.setLoop(true);
	sound.play();
}

void stopCelebrate(void) {
		(*psound).stop();
}







void playSnd( int nbuf ) {

	sf::Sound & sound(*psound);


	assert(nbuf>=6);
	assert(nbuf<=11);



	if( nbuf==6 )
	{
		sound.setBuffer(*pFanfare);
		sound.setLoop(false);
		sound.setVolume(50);
		sound.play();
	}
	else if( nbuf==7 )
	{
		sound.setBuffer(*pStone);
		sound.setLoop(false);
		sound.setVolume(100);
		sound.play();
	}

	else if( nbuf==8 )
	{
		sound.setBuffer(*pDn);
		sound.setLoop(false);
		sound.setVolume(50);
		sound.play();

	}


	else if( nbuf==9 )
	{
		sound.setBuffer(*pdDie);
		sound.setLoop(false);
		sound.setVolume(100);
		sound.play();
	}


	else if( nbuf==10 )
	{
		sound.setBuffer(*pUp);
		sound.setLoop(false);
		sound.setVolume(50);
		sound.play();

	}

	else if( nbuf==11 )
	{
		sound.setBuffer(*pdEat);
		sound.setLoop(false);
		sound.setVolume(99);
		sound.play();
	}



} // end playSnd


