# Completions for the `pamac` command

set -l all_subcmds search info install reinstall remove build checkupdates upgrade update list clone clean
set -l pkg_subcmds install info search
set -l installed_pkg_subcmds remove reinstall
set -l handle_file_pkg_subcmds install

function __fish_pamac_subcommand -V all_subcmds
    set -l subcommand $argv[1]
    set -e argv[1]
    complete -f -c pamac -n "not __fish_seen_subcommand_from $all_subcmds" -a $subcommand $argv
end


complete -c pamac -f

complete -k -c pamac -n "__fish_seen_subcommand_from $pkg_subcmds" -a '(pamac search -q "(?:\\b|_)"(commandline -ct | string escape --style=regex) | sort)'
complete -c pamac -n "__fish_seen_subcommand_from $installed_pkg_subcmds" -a '(pamac search -q -i "(?:\\b|_)"(commandline -ct | string escape --style=regex))'
complete -k -c pamac -n "__fish_seen_subcommand_from $handle_file_pkg_subcmds" -a '(__fish_complete_suffix .pkg.tar.zstd)'

# Support flags
complete -f -c pamac -s h -l help -d 'Display help'
complete -f -c pamac -l version -d 'Display version and exit'

__fish_pamac_subcommand search -r -d 'Search for packages or files, multiple search terms can be specified'

__fish_pamac_subcommand info -x -d 'Display package details, multiple packages can be specified'

__fish_pamac_subcommand install -r -d 'Install packages from repositories, path or url'
__fish_pamac_subcommand reinstall -x -d 'Reinstall packages'

__fish_pamac_subcommand remove -x -d 'Remove packages'

__fish_pamac_subcommand build -r -d 'Build packages from AUR and install them with their dependencies'

__fish_pamac_subcommand checkupdates -d 'Safely check for updates without modifiying the databases'

__fish_pamac_subcommand upgrade -d 'Upgrade packages'

__fish_pamac_subcommand update -d 'Update your system'

__fish_pamac_subcommand list -r -d 'List packages, groups, repositories or files'

__fish_pamac_subcommand clone -r -d 'Clone or sync packages build files from AUR'

__fish_pamac_subcommand clean -d 'Clean packages cache or build files'


functions -e __fish_pamac_subcommand
