/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.map;

import org.basex.data.Data;
import org.basex.gui.view.ViewData;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;

final class MapList
extends IntList {
    double[] weight;

    MapList() {
    }

    MapList(int[] v) {
        super(v);
    }

    @Override
    public MapList sort() {
        this.sort(this.weight, false);
        return this;
    }

    void initWeights(int[] textLen, int nchildren, Data data, int w) {
        this.weight = new double[this.size];
        if (w == 0) {
            int i = 0;
            while (i < this.size) {
                this.weight[i] = (double)ViewData.size(data, this.list[i]) / (double)nchildren;
                ++i;
            }
            return;
        }
        double sizeP = (double)w / 100.0;
        long sum = 0L;
        int i = 0;
        while (i < this.size) {
            sum = (long)((double)sum + this.weight(textLen, data, i));
            ++i;
        }
        if (sizeP < 1.0) {
            i = 0;
            while (i < this.size) {
                this.weight[i] = sizeP * this.weight(textLen, data, i) / (double)sum + (1.0 - sizeP) * (double)ViewData.size(data, this.list[i]) / (double)nchildren;
                ++i;
            }
        } else {
            i = 0;
            while (i < this.size) {
                this.weight[i] = this.weight(textLen, data, i) / (double)sum;
                ++i;
            }
        }
    }

    private double weight(int[] textLen, Data data, int i) {
        byte[] val;
        double d = textLen != null ? (double)textLen[this.list[i]] : (double)((val = data.attValue(ViewData.sizeID(data), this.list[i])) != null ? Token.toLong(val) : 0L);
        return d > 1.0 ? d : 1.0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(String.valueOf(Util.className(this)) + '[');
        int i = 0;
        while (i < this.size) {
            sb.append(i == 0 ? "" : ", ").append(this.list[i]);
            if (this.weight != null) {
                sb.append('/').append(this.weight[i]);
            }
            ++i;
        }
        return sb.append(']').toString();
    }
}

