/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.Comparator;
import org.basex.util.Array;

public final class MinHeap<K, V> {
    private Object[] vals;
    private final Comparator<K> comp;
    private int size;

    public MinHeap(Comparator<K> cmp) {
        this(8, cmp);
    }

    public MinHeap(int cap, Comparator<K> cmp) {
        this.vals = new Object[2 * cap];
        this.comp = cmp;
    }

    public void insert(K key, V value) {
        int s = this.size << 1;
        if (s == this.vals.length) {
            this.vals = Array.copy(this.vals, new Object[s << 1]);
        }
        this.vals[s] = key;
        this.vals[s + 1] = value;
        int curr = this.size++;
        int par = (curr - 1) / 2;
        while (curr > 0 && this.compare(curr, par) < 0) {
            this.swap(curr, par);
            curr = par;
            par = (curr - 1) / 2;
        }
    }

    public V removeMin() {
        V val = this.minValue();
        this.swap(0, --this.size);
        int pos = 0;
        while (pos < this.size / 2) {
            int sm = 2 * pos + 1;
            if (sm < this.size - 1 && this.compare(sm + 1, sm) < 0) {
                ++sm;
            }
            if (this.compare(pos, sm) <= 0) break;
            this.swap(pos, sm);
            pos = sm;
        }
        return val;
    }

    private V minValue() {
        return (V)this.vals[1];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private int compare(int i, int j) {
        Object a = this.vals[2 * i];
        Object b = this.vals[2 * j];
        return this.comp == null ? ((Comparable)a).compareTo(b) : this.comp.compare(a, b);
    }

    private void swap(int a, int b) {
        if (a == b) {
            return;
        }
        int k1 = 2 * a;
        int v1 = k1 + 1;
        int k2 = 2 * b;
        int v2 = k2 + 1;
        Object k = this.vals[k1];
        Object v = this.vals[v1];
        this.vals[k1] = this.vals[k2];
        this.vals[v1] = this.vals[v2];
        this.vals[k2] = k;
        this.vals[v2] = v;
    }

    void verify() {
        this.verify(0);
    }

    private void verify(int i) {
        if (2 * i + 1 < this.size) {
            int left = 2 * i + 1;
            int right = 2 * (i + 1);
            if (this.compare(i, left) > 0 || right < this.size && this.compare(i, right) > 0) {
                throw new IllegalStateException("Heap invariant doesn'T hold at node " + i + '.');
            }
            this.verify(left);
            this.verify(right);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Heap[");
        int i = 0;
        while (i < this.size) {
            sb.append('(').append(this.vals[2 * i]).append(", ").append(this.vals[2 * i + 1]).append(')');
            if (i < this.size - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.append(']').toString();
    }
}

