/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.Arrays;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.Util;

public final class TokenBuilder {
    public static final byte NLINE = 10;
    public static final int PRIVATE_START = 57344;
    public static final int PRIVATE_END = 63743;
    public static final int HLINE = 63743;
    public static final int BOLD = 63742;
    public static final int NORM = 63741;
    public static final int MARK = 63740;
    public static final int ULINE = 63739;
    private byte[] chars;
    private int size;

    public TokenBuilder() {
        this(8);
    }

    public TokenBuilder(int capacity) {
        this.chars = new byte[capacity];
    }

    public TokenBuilder(String string) {
        this(Token.token(string));
    }

    public TokenBuilder(byte[] token) {
        this(token.length + 8);
        this.size = token.length;
        System.arraycopy(token, 0, this.chars, 0, this.size);
    }

    public TokenBuilder(int[] cps) {
        this(cps.length);
        this.add(cps);
    }

    public int size() {
        return this.size;
    }

    public void size(int sz) {
        this.size = sz;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public TokenBuilder reset() {
        this.size = 0;
        return this;
    }

    public TokenBuilder bold() {
        return this.add(63742);
    }

    public TokenBuilder uline() {
        return this.add(63739);
    }

    public TokenBuilder norm() {
        return this.add(63741);
    }

    public TokenBuilder hline() {
        return this.add(63743);
    }

    public TokenBuilder nline() {
        return this.add(10);
    }

    public TokenBuilder add(int[] cps) {
        int[] nArray = cps;
        int n = cps.length;
        int n2 = 0;
        while (n2 < n) {
            int cp = nArray[n2];
            this.add(cp);
            ++n2;
        }
        return this;
    }

    public TokenBuilder add(int cp) {
        if (cp <= 127) {
            this.addByte((byte)cp);
        } else if (cp <= 2047) {
            this.addByte((byte)(cp >> 6 & 0x1F | 0xC0));
            this.addByte((byte)(cp & 0x3F | 0x80));
        } else if (cp <= 65535) {
            this.addByte((byte)(cp >> 12 & 0xF | 0xE0));
            this.addByte((byte)(cp >> 6 & 0x3F | 0x80));
            this.addByte((byte)(cp & 0x3F | 0x80));
        } else {
            this.addByte((byte)(cp >> 18 & 7 | 0xF0));
            this.addByte((byte)(cp >> 12 & 0x3F | 0x80));
            this.addByte((byte)(cp >> 6 & 0x3F | 0x80));
            this.addByte((byte)(cp & 0x3F | 0x80));
        }
        return this;
    }

    public int cp(int pos) {
        return Token.cp(this.chars, pos);
    }

    public int cl(int pos) {
        return Token.cl(this.chars, pos);
    }

    public byte get(int pos) {
        return this.chars[pos];
    }

    public void set(int pos, byte value) {
        this.chars[pos] = value;
    }

    public void delete(int pos, int length) {
        Array.move(this.chars, pos + length, -length, this.size - pos - length);
        this.size -= length;
    }

    public TokenBuilder addByte(byte value) {
        int s = this.size;
        byte[] chrs = this.chars;
        if (s == chrs.length) {
            chrs = Arrays.copyOf(chrs, Array.newSize(s));
        }
        chrs[s] = value;
        this.chars = chrs;
        this.size = s + 1;
        return this;
    }

    public TokenBuilder addInt(int value) {
        return this.add(Token.token(value));
    }

    public TokenBuilder addLong(long value) {
        return this.add(Token.token(value));
    }

    public TokenBuilder add(byte[] token) {
        return this.add(token, 0, token.length);
    }

    public TokenBuilder add(byte[] token, int start, int end) {
        int l = end - start;
        if (l > 0) {
            int s = this.size;
            int ns = s + l;
            byte[] chrs = this.chars;
            int cl = chrs.length;
            if (ns > cl) {
                chrs = Arrays.copyOf(chrs, Array.newSize(ns));
            }
            System.arraycopy(token, start, chrs, s, l);
            this.chars = chrs;
            this.size = ns;
        }
        return this;
    }

    public TokenBuilder add(String string) {
        return this.add(Token.token(string));
    }

    public TokenBuilder addSep(Object[] objects, String sep) {
        int ol = objects.length;
        int o = 0;
        while (o < ol) {
            if (o != 0) {
                this.add(sep);
            }
            this.addExt(objects[o], new Object[0]);
            ++o;
        }
        return this;
    }

    public TokenBuilder addExt(Object object, Object ... ext) {
        byte[] t = TokenBuilder.token(object);
        int tl = t.length;
        int el = ext.length;
        int i = 0;
        int e = 0;
        while (i < tl) {
            if (t[i] != 37 || e == el) {
                this.addByte(t[i]);
            } else {
                boolean d;
                byte c = i + 1 < tl ? t[i + 1] : (byte)0;
                boolean bl = d = c >= 49 && c <= 57;
                if (d) {
                    ++i;
                }
                int n = d ? c - 49 : e++;
                Object o = n < el ? ext[n] : null;
                this.addExt(o, new Object[0]);
            }
            ++i;
        }
        return this;
    }

    public static byte[] token(Object object) {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        String s = object == null ? "null" : (object instanceof Throwable ? Util.message((Throwable)object) : (object instanceof Class ? Util.className((Class)object) : object.toString()));
        return Token.token(s);
    }

    public TokenBuilder trim() {
        byte[] chrs = this.chars;
        int s = this.size;
        while (s > 0 && Token.ws(chrs[s - 1])) {
            --s;
        }
        int c = -1;
        while (++c < s && Token.ws(chrs[c])) {
        }
        if (c != 0 && c != s) {
            Array.move(chrs, c, -c, s - c);
        }
        this.size = s - c;
        return this;
    }

    public TokenBuilder normalize() {
        byte[] chrs = this.chars;
        int s = this.size;
        int n = 0;
        int c = 0;
        while (c < s) {
            int ch = chrs[c];
            if (ch == 13) {
                ch = 10;
                if (c + 1 < s && chrs[c + 1] == 10) {
                    ++c;
                }
            }
            chrs[n++] = ch;
            ++c;
        }
        this.size = n;
        return this;
    }

    public byte[] toArray() {
        int s = this.size;
        return s == 0 ? Token.EMPTY : Arrays.copyOf(this.chars, s);
    }

    public byte[] next() {
        int s = this.size;
        if (s == 0) {
            return Token.EMPTY;
        }
        this.size = 0;
        return Arrays.copyOf(this.chars, s);
    }

    public byte[] finish() {
        byte[] chrs = this.chars;
        this.chars = null;
        int s = this.size;
        return s == 0 ? Token.EMPTY : (s == chrs.length ? chrs : Arrays.copyOf(chrs, s));
    }

    public String toString() {
        return this.chars == null ? "" : Token.string(this.chars, 0, this.size);
    }
}

