/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.http11.auth;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.AuthenticationHandler;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthHandler
implements AuthenticationHandler {
    private static final Logger log = LoggerFactory.getLogger(BasicAuthHandler.class);

    @Override
    public boolean supports(Resource r, Request request) {
        Auth auth = request.getAuthorization();
        if (auth == null) {
            return false;
        }
        log.trace("supports: {}", (Object)auth.getScheme());
        return auth.getScheme().equals((Object)Auth.Scheme.BASIC);
    }

    @Override
    public Object authenticate(Resource resource, Request request) {
        log.trace("authenticate");
        Auth auth = request.getAuthorization();
        Object o = resource.authenticate(auth.getUser(), auth.getPassword());
        log.trace("result: {}", o);
        return o;
    }

    @Override
    public String getChallenge(Resource resource, Request request) {
        if (resource == null) {
            throw new RuntimeException("Can't generate challenge because resource is null, so can't get realm");
        }
        return "Basic realm=\"" + resource.getRealm() + "\"";
    }

    @Override
    public boolean isCompatible(Resource resource) {
        return true;
    }
}

