/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.ft;

import org.basex.index.ft.FTIndexTree;

final class FTIndexTrees {
    private final FTIndexTree[] trees;
    private int ctree;

    FTIndexTrees(int size) {
        this.trees = new FTIndexTree[size + 1];
    }

    void index(byte[] token, int pre, int pos, int index) {
        int tl = token.length;
        if (this.trees[tl] == null) {
            this.trees[tl] = new FTIndexTree();
        }
        this.trees[tl].add(token, pre, pos, index);
    }

    void initFT() {
        FTIndexTree[] fTIndexTreeArray = this.trees;
        int n = this.trees.length;
        int n2 = 0;
        while (n2 < n) {
            FTIndexTree tree = fTIndexTreeArray[n2];
            if (tree != null) {
                tree.initFT();
            }
            ++n2;
        }
    }

    void init() {
        FTIndexTree[] fTIndexTreeArray = this.trees;
        int n = this.trees.length;
        int n2 = 0;
        while (n2 < n) {
            FTIndexTree tree = fTIndexTreeArray[n2];
            if (tree != null) {
                tree.init();
            }
            ++n2;
        }
        this.ctree = -1;
    }

    boolean more(int index) {
        if (this.ctree != -1 && this.trees[this.ctree].more(index)) {
            return true;
        }
        int tl = this.trees.length;
        while (++this.ctree < tl) {
            if (this.trees[this.ctree] == null) continue;
            return this.more(index);
        }
        return false;
    }

    FTIndexTree nextTree() {
        return this.trees[this.ctree];
    }
}

