/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Stack;
import org.basex.build.csv.CsvOptions;
import org.basex.build.json.JsonOptions;
import org.basex.build.json.JsonSerialOptions;
import org.basex.data.Data;
import org.basex.data.DataText;
import org.basex.io.serial.AdaptiveSerializer;
import org.basex.io.serial.BaseXSerializer;
import org.basex.io.serial.HTMLSerializer;
import org.basex.io.serial.SerializerMode;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.TextSerializer;
import org.basex.io.serial.XHTMLSerializer;
import org.basex.io.serial.XMLSerializer;
import org.basex.io.serial.csv.CsvDirectSerializer;
import org.basex.io.serial.csv.CsvXQuerySerializer;
import org.basex.io.serial.json.JsonBasicSerializer;
import org.basex.io.serial.json.JsonMLSerializer;
import org.basex.io.serial.json.JsonNodeSerializer;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.util.ft.FTPos;
import org.basex.query.util.ft.FTPosData;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FNode;
import org.basex.query.value.node.FTPosNode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.BoolList;
import org.basex.util.list.IntList;

public abstract class Serializer
implements Closeable {
    protected final Stack<QNm> elems = new Stack();
    protected int level;
    protected QNm elem;
    protected boolean indent;
    private final Atts nspaces = new Atts(Token.XML, QueryText.XML_URI).add(Token.EMPTY, Token.EMPTY);
    private final IntList nstack = new IntList();
    protected StaticContext sc;
    protected boolean more;
    private boolean opening;

    public static Serializer get(OutputStream os) throws IOException {
        return Serializer.get(os, null);
    }

    public static Serializer get(OutputStream os, SerializerOptions sopts) throws IOException {
        SerializerOptions so = sopts == null ? SerializerMode.DEFAULT.get() : sopts;
        switch (so.get(SerializerOptions.METHOD)) {
            case XHTML: {
                return new XHTMLSerializer(os, so);
            }
            case HTML: {
                return new HTMLSerializer(os, so);
            }
            case TEXT: {
                return new TextSerializer(os, so);
            }
            case CSV: {
                CsvOptions copts = so.get(SerializerOptions.CSV);
                return copts.get(CsvOptions.FORMAT) == CsvOptions.CsvFormat.XQUERY ? new CsvXQuerySerializer(os, so) : new CsvDirectSerializer(os, so);
            }
            case JSON: {
                JsonSerialOptions jopts = so.get(SerializerOptions.JSON);
                JsonOptions.JsonFormat jformat = jopts.get(JsonOptions.FORMAT);
                return jformat == JsonOptions.JsonFormat.JSONML ? new JsonMLSerializer(os, so) : (jformat == JsonOptions.JsonFormat.BASIC ? new JsonBasicSerializer(os, so) : new JsonNodeSerializer(os, so));
            }
            case XML: {
                return new XMLSerializer(os, so);
            }
            case ADAPTIVE: {
                return new AdaptiveSerializer(os, so);
            }
        }
        return new BaseXSerializer(os, so);
    }

    public void serialize(Item item) throws IOException {
        if (item instanceof ANode) {
            this.node((ANode)item);
        } else if (item instanceof FItem) {
            this.function((FItem)item);
        } else {
            this.atomic(item);
        }
        this.more = true;
    }

    @Override
    public void close() throws IOException {
    }

    public boolean finished() {
        return false;
    }

    public void reset() {
    }

    public Serializer sc(StaticContext sctx) {
        this.sc = sctx;
        return this;
    }

    protected void node(ANode node) throws IOException {
        if (this.ignore(node)) {
            return;
        }
        if (node instanceof DBNode) {
            this.node((DBNode)node);
        } else {
            this.node((FNode)node);
        }
    }

    protected final void openElement(QNm name) throws IOException {
        this.prepare();
        this.opening = true;
        this.elem = name;
        this.startOpen(name);
        this.nstack.push(this.nspaces.size());
    }

    protected final void closeElement() throws IOException {
        this.nspaces.size(this.nstack.pop());
        if (this.opening) {
            this.finishEmpty();
            this.opening = false;
        } else {
            this.elem = this.elems.peek();
            --this.level;
            this.finishClose();
            this.elems.pop();
        }
    }

    protected void openDoc(byte[] name) throws IOException {
    }

    protected void closeDoc() throws IOException {
    }

    protected void namespace(byte[] prefix, byte[] uri, boolean standalone) throws IOException {
        byte[] ancUri = this.nsUri(prefix);
        if (ancUri == null || !Token.eq(ancUri, uri)) {
            this.attribute(prefix.length == 0 ? Token.XMLNS : Token.concat(Token.XMLNSC, prefix), uri, standalone);
            this.nspaces.add(prefix, uri);
        }
    }

    protected final byte[] nsUri(byte[] prefix) {
        int n = this.nspaces.size() - 1;
        while (n >= 0) {
            if (Token.eq(this.nspaces.name(n), prefix)) {
                return this.nspaces.value(n);
            }
            --n;
        }
        return null;
    }

    protected boolean ignore(ANode node) {
        return false;
    }

    protected void attribute(byte[] name, byte[] value, boolean standalone) throws IOException {
    }

    protected void startOpen(QNm name) throws IOException {
    }

    protected void finishOpen() throws IOException {
    }

    protected void finishEmpty() throws IOException {
    }

    protected void finishClose() throws IOException {
    }

    protected void text(byte[] value, FTPos ftp) throws IOException {
    }

    protected void comment(byte[] value) throws IOException {
    }

    protected void pi(byte[] name, byte[] value) throws IOException {
    }

    protected void atomic(Item item) throws IOException {
    }

    protected void function(FItem item) throws IOException {
    }

    protected final void node(DBNode node) throws IOException {
        FTPosData ft = node instanceof FTPosNode ? ((FTPosNode)node).ftpos : null;
        Data data = node.data();
        int pre = node.pre();
        int kind = data.kind(pre);
        int size = pre + data.size(pre, kind);
        if (kind == 0) {
            this.openDoc(data.text(pre++, true));
            while (pre < size && !this.finished()) {
                this.node((ANode)new DBNode(data, pre));
                pre += data.size(pre, data.kind(pre));
            }
            this.closeDoc();
            return;
        }
        boolean nsExist = !data.nspaces.isEmpty();
        TokenSet nsSet = nsExist ? new TokenSet() : null;
        IntList parentStack = new IntList();
        BoolList indentStack = new BoolList();
        while (pre < size && !this.finished()) {
            kind = data.kind(pre);
            int par = data.parent(pre, kind);
            while (!parentStack.isEmpty() && parentStack.peek() >= par) {
                this.closeElement();
                this.indent = indentStack.pop();
                parentStack.pop();
            }
            if (kind == 2) {
                this.prepareText(data.text(pre, true), ft != null ? ft.get(data, pre) : null);
                ++pre;
                continue;
            }
            if (kind == 4) {
                this.prepareComment(data.text(pre++, true));
                continue;
            }
            if (kind == 5) {
                this.preparePi(data.name(pre, 5), data.atom(pre++));
                continue;
            }
            byte[] name = data.name(pre, kind);
            byte[] nsPrefix = Token.EMPTY;
            byte[] nsUri = null;
            if (nsExist) {
                nsPrefix = Token.prefix(name);
                nsUri = data.nspaces.uri(data.uriId(pre, kind));
            }
            this.openElement(new QNm(name, nsUri));
            if (nsUri == null) {
                nsUri = Token.EMPTY;
            }
            this.namespace(nsPrefix, nsUri, false);
            if (nsExist) {
                nsSet.add(nsUri);
                int p = pre;
                do {
                    Atts ns = data.namespaces(p);
                    int nl = ns.size();
                    int n = 0;
                    while (n < nl) {
                        nsPrefix = ns.name(n);
                        if (nsSet.add(nsPrefix)) {
                            this.namespace(nsPrefix, ns.value(n), false);
                        }
                        ++n;
                    }
                } while (this.level == 0 && (p = data.parent(p, data.kind(p))) >= 0 && data.kind(p) == 1);
                nsSet.clear();
            }
            indentStack.push(this.indent);
            int as = pre + data.attSize(pre, kind);
            while (++pre != as) {
                byte[] n = data.name(pre, 3);
                byte[] v = data.text(pre, false);
                this.attribute(n, v, false);
                if (!Token.eq(n, DataText.XML_SPACE) || !this.indent) continue;
                boolean bl = this.indent = !Token.eq(v, DataText.PRESERVE);
            }
            parentStack.push(par);
        }
        while (!parentStack.isEmpty()) {
            this.closeElement();
            this.indent = indentStack.pop();
            parentStack.pop();
        }
    }

    protected final void node(FNode node) throws IOException {
        Type type = node.type;
        if (type == NodeType.COM) {
            this.prepareComment(node.string());
        } else if (type == NodeType.TXT) {
            this.prepareText(node.string(), null);
        } else if (type == NodeType.PI) {
            this.preparePi(node.name(), node.string());
        } else if (type == NodeType.ATT) {
            this.attribute(node.name(), node.string(), true);
        } else if (type == NodeType.NSP) {
            this.namespace(node.name(), node.string(), true);
        } else if (type == NodeType.DOC) {
            this.openDoc(node.baseURI());
            for (ANode n : node.children()) {
                this.node(n);
            }
            this.closeDoc();
        } else {
            ANode n;
            ANode nd;
            QNm name = node.qname();
            this.openElement(name);
            Atts nsp = node.namespaces();
            int p = nsp.size() - 1;
            while (p >= 0) {
                this.namespace(nsp.name(p), nsp.value(p), false);
                --p;
            }
            this.namespace(name.prefix(), name.uri(), false);
            boolean i = this.indent;
            BasicNodeIter iter = node.attributes();
            while ((nd = iter.next()) != null) {
                byte[] n2 = nd.name();
                byte[] v = nd.string();
                this.attribute(n2, v, false);
                if (!Token.eq(n2, DataText.XML_SPACE) || !this.indent) continue;
                boolean bl = this.indent = !Token.eq(v, DataText.PRESERVE);
            }
            iter = node.children();
            while ((n = iter.next()) != null) {
                this.node(n);
            }
            this.closeElement();
            this.indent = i;
        }
    }

    private void prepareComment(byte[] value) throws IOException {
        this.prepare();
        this.comment(value);
    }

    private void prepareText(byte[] value, FTPos ftp) throws IOException {
        this.prepare();
        this.text(value, ftp);
    }

    private void preparePi(byte[] name, byte[] value) throws IOException {
        this.prepare();
        this.pi(name, value);
    }

    private void prepare() throws IOException {
        if (!this.opening) {
            return;
        }
        this.opening = false;
        this.finishOpen();
        this.elems.push(this.elem);
        ++this.level;
    }
}

