/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.basex.build.DirParser;
import org.basex.core.Context;
import org.basex.core.Datas;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Open;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.io.IO;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryInput;
import org.basex.query.QueryResource;
import org.basex.query.StaticContext;
import org.basex.query.util.list.ItemList;
import org.basex.query.util.pkg.ModuleLoader;
import org.basex.query.value.Value;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.DBNodeSeq;
import org.basex.query.value.seq.DBNodes;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public final class QueryResources {
    private final QueryContext qc;
    private ModuleLoader modules;
    private final ArrayList<Value> colls = new ArrayList(1);
    private final ArrayList<String> collNames = new ArrayList(1);
    private boolean globalData;
    private Map<String, String[]> texts;
    private Map<String, IO> stop;
    private Map<String, IO> thes;
    private final ArrayList<Data> datas = new ArrayList(1);
    private Map<Class<? extends QueryResource>, QueryResource> external;

    QueryResources(QueryContext qc) {
        this.qc = qc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Value compile(DBNodes nodes) {
        Data data = nodes.data();
        this.addData(data);
        Datas datas = this.qc.context.datas;
        synchronized (datas) {
            this.qc.context.datas.pin(data);
        }
        this.globalData = true;
        boolean all = nodes.all();
        Value value = DBNodeSeq.get(new IntList(nodes.pres()), data, all, all);
        Value coll = all ? value : DBNodeSeq.get(data.resources.docs(), data, true, true);
        this.addCollection(coll, data.meta.name);
        return value;
    }

    void close() {
        for (Data data : this.datas) {
            Close.close(data, this.qc.context);
        }
        this.datas.clear();
        if (this.modules != null) {
            this.modules.close();
        }
        if (this.external != null) {
            for (QueryResource c : this.external.values()) {
                c.close();
            }
        }
    }

    Data globalData() {
        return this.globalData ? this.datas.get(0) : null;
    }

    public synchronized <R extends QueryResource> R index(Class<? extends R> resource) {
        QueryResource value;
        if (this.external == null) {
            this.external = new HashMap<Class<? extends QueryResource>, QueryResource>();
        }
        if ((value = this.external.get(resource)) == null) {
            try {
                value = (QueryResource)resource.newInstance();
                this.external.put(resource, value);
            }
            catch (Throwable ex) {
                throw Util.notExpected(ex, new Object[0]);
            }
        }
        return (R)value;
    }

    public synchronized Data database(String name, InputInfo info) throws QueryException {
        Context ctx = this.qc.context;
        boolean mainmem = ctx.options.get(MainOptions.MAINMEM);
        for (Data data : this.datas) {
            if (data.inMemory() && !mainmem) continue;
            String n = data.meta.name;
            if (!(Prop.CASE ? n.equals(name) : n.equalsIgnoreCase(name))) continue;
            return data;
        }
        if (!ctx.perm(Perm.READ, name)) {
            throw QueryError.BASEX_PERMISSION_X_X.get(info, new Object[]{Perm.READ, name});
        }
        try {
            return this.addData(Open.open(name, ctx, ctx.options));
        }
        catch (IOException ex) {
            throw QueryError.DB_OPEN2_X.get(info, ex);
        }
    }

    public synchronized DBNode doc(QueryInput qi, InputInfo info) throws QueryException {
        int pre;
        Data data = this.globalData();
        if (data != null && this.qc.context.options.get(MainOptions.DEFAULTDB).booleanValue() && (pre = data.resources.doc(qi.original)) != -1) {
            return new DBNode(data, pre, 0);
        }
        data = this.data(qi, info, true);
        IntList docs = data.resources.docs(qi.dbPath);
        if (docs.size() == 1) {
            return new DBNode(data, docs.get(0), 0);
        }
        throw (docs.isEmpty() ? QueryError.BASEX_DBPATH1_X : QueryError.BASEX_DBPATH2_X).get(info, qi.original);
    }

    public synchronized Value collection(QueryInput qi, InputInfo info) throws QueryException {
        if (qi == null) {
            if (this.colls.isEmpty()) {
                throw QueryError.NODEFCOLL.get(info, new Object[0]);
            }
            return this.colls.get(0);
        }
        Data data = this.globalData();
        if (data != null && this.qc.context.options.get(MainOptions.DEFAULTDB).booleanValue()) {
            IntList pres = data.resources.docs(qi.original);
            return DBNodeSeq.get(pres, data, true, qi.original.isEmpty());
        }
        int cs = this.colls.size();
        int c = 0;
        while (c < cs) {
            String name = this.collNames.get(c);
            String path = qi.io.path();
            if (Prop.CASE ? name.equals(path) : name.equalsIgnoreCase(path)) {
                return this.colls.get(c);
            }
            ++c;
        }
        data = this.data(qi, info, false);
        IntList docs = data.resources.docs(qi.dbPath);
        return DBNodeSeq.get(docs, data, true, qi.dbPath.isEmpty());
    }

    public ModuleLoader modules() {
        if (this.modules == null) {
            this.modules = new ModuleLoader(this.qc.context);
        }
        return this.modules;
    }

    public void remove(String name) {
        int ds = this.datas.size();
        int d = this.globalData ? 1 : 0;
        while (d < ds) {
            Data data = this.datas.get(d);
            if (data.meta.name.equals(name)) {
                Close.close(data, this.qc.context);
                this.datas.remove(d);
                break;
            }
            ++d;
        }
    }

    public String[] text(String uri) {
        return this.texts == null ? null : this.texts.get(uri);
    }

    public IO stopWords(String path, StaticContext sc) {
        return this.stop != null ? this.stop.get(path) : sc.resolve(path, null);
    }

    public IO thesaurus(String path, StaticContext sc) {
        return this.thes != null ? this.thes.get(path) : sc.resolve(path, null);
    }

    public void addDoc(String name, String path, StaticContext sc) throws QueryException {
        QueryInput qi = new QueryInput(path, sc);
        Data data = this.create(qi, true, null);
        if (name != null) {
            data.meta.original = name;
        }
    }

    public void addResource(String uri, String ... strings) {
        if (this.texts == null) {
            this.texts = new HashMap<String, String[]>();
        }
        this.texts.put(uri, strings);
    }

    public void addCollection(String name, String[] paths, StaticContext sc) throws QueryException {
        ItemList items = new ItemList(paths.length);
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            QueryInput qi = new QueryInput(path, sc);
            items.add(new DBNode(this.create(qi, true, null), 0, 0));
            ++n2;
        }
        this.addCollection(items.value(NodeType.DOC), name);
    }

    public void ftmaps(HashMap<String, IO> sw, HashMap<String, IO> th) {
        this.stop = sw;
        this.thes = th;
    }

    private Data data(QueryInput qi, InputInfo info, boolean single) throws QueryException {
        for (Data data : this.datas) {
            String orig = data.meta.original;
            if (!orig.isEmpty() && IO.get(orig).eq(qi.io)) {
                qi.dbPath = "";
                return data;
            }
            String name = data.meta.name;
            String dbName = qi.dbName;
            if (!(Prop.CASE ? name.equals(dbName) : name.equalsIgnoreCase(dbName))) continue;
            return data;
        }
        String name = qi.dbName;
        if (name != null) {
            try {
                Context ctx = this.qc.context;
                return this.addData(Open.open(name, ctx, ctx.options));
            }
            catch (IOException ex) {
                Util.debug(ex);
            }
        }
        Data data = this.create(qi, single, info);
        qi.dbPath = "";
        return data;
    }

    private Data create(QueryInput input, boolean single, InputInfo info) throws QueryException {
        Data data;
        Context context = this.qc.context;
        if (!context.user().has(Perm.READ)) {
            throw QueryError.XQUERY_PERMISSION1_X.get(info, Util.info(Text.PERM_REQUIRED_X, new Object[]{Perm.READ}));
        }
        IO io = input.io;
        if (!io.exists()) {
            throw QueryError.WHICHRES_X.get(info, io);
        }
        if (single && io.isDir()) {
            throw QueryError.RESDIR_X.get(info, io);
        }
        boolean mem = context.options.get(MainOptions.FORCECREATE) == false;
        MainOptions opts = new MainOptions(context.options, true);
        DirParser parser = new DirParser(io, opts);
        try {
            data = CreateDB.create(io.dbName(), parser, context, opts, mem);
        }
        catch (IOException ex) {
            throw QueryError.IOERR_X.get(info, ex);
        }
        return this.addData(data);
    }

    private Data addData(Data data) {
        this.datas.add(data);
        return data;
    }

    private void addCollection(Value coll, String name) {
        this.colls.add(coll);
        this.collNames.add(name);
    }
}

