/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.ft.FTFilter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.ft.FTMatch;
import org.basex.query.util.ft.FTStringMatch;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTUnit;
import org.basex.util.hash.IntObjMap;

public final class FTWindow
extends FTFilter {
    private Expr win;

    public FTWindow(InputInfo info, FTExpr expr, Expr win, FTUnit unit) {
        super(info, expr, unit);
        this.win = win;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.win);
        super.checkUp();
    }

    @Override
    public FTExpr compile(CompileContext cc) throws QueryException {
        this.win = this.win.compile(cc);
        return super.compile(cc);
    }

    @Override
    protected boolean filter(QueryContext qc, FTMatch match, FTLexer lexer) throws QueryException {
        int n = (int)this.toLong(this.win, qc) - 1;
        match.sort();
        FTStringMatch first = null;
        for (FTStringMatch sm : match) {
            if (sm.exclude) continue;
            if (first == null) {
                first = sm;
            }
            first.gaps = first.gaps | sm.end - first.end > 1;
            first.end = sm.end;
            if (this.pos(first.end, lexer) - this.pos(first.start, lexer) <= n) continue;
            return false;
        }
        if (first == null) {
            return false;
        }
        int w = n - this.pos(first.end, lexer) + this.pos(first.start, lexer);
        int s = this.pos(first.start, lexer) - w;
        while (s <= this.pos(first.start, lexer)) {
            boolean h = false;
            for (FTStringMatch sm : match) {
                boolean bl = h = sm.exclude && this.pos(sm.start, lexer) >= s && this.pos(sm.end, lexer) <= s + w;
                if (h) break;
            }
            if (!h) {
                match.reset();
                match.add(first);
                return true;
            }
            ++s;
        }
        return false;
    }

    @Override
    public boolean has(Flag ... flags) {
        return this.win.has(flags) || super.has(flags);
    }

    @Override
    public boolean removable(Var var) {
        return this.win.removable(var) && super.removable(var);
    }

    @Override
    public VarUsage count(Var var) {
        return this.win.count(var).plus(super.count(var));
    }

    @Override
    public FTExpr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        boolean e = FTWindow.inlineAll(this.exprs, var, ex, cc);
        Expr w = this.win.inline(var, ex, cc);
        if (w != null) {
            this.win = w;
        }
        return e || w != null ? this.optimize(cc) : null;
    }

    @Override
    public FTExpr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new FTWindow(this.info, (FTExpr)this.exprs[0].copy(cc, (IntObjMap)vm), this.win.copy(cc, vm), this.unit);
    }

    @Override
    public void plan(FElem plan) {
        FTWindow.addPlan(plan, this.planElem(new Object[]{"window", this.unit}), new Object[]{this.win, this.exprs});
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return super.accept(visitor) && this.win.accept(visitor);
    }

    @Override
    public int exprSize() {
        int size = 1;
        FTExpr[] fTExprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            FTExpr expr = fTExprArray[n2];
            size += expr.exprSize();
            ++n2;
        }
        return size + this.win.exprSize();
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "window" + ' ' + this.win + ' ' + (Object)((Object)this.unit);
    }
}

