/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.hof;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryRTException;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.util.MinHeap;

public final class HofTopKBy
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        FItem getKey = this.checkArity(this.exprs[1], 1, qc);
        long k = Math.min(this.toLong(this.exprs[2], qc), Integer.MAX_VALUE);
        if (k < 1L) {
            return Empty.SEQ;
        }
        Iter iter = this.exprs[0].iter(qc);
        MinHeap<Item, Item> heap = new MinHeap<Item, Item>((item1, item2) -> {
            try {
                return CmpV.OpV.LT.eval((Item)item1, (Item)item2, this.sc.collation, this.sc, this.info) ? -1 : 1;
            }
            catch (QueryException qe) {
                throw new QueryRTException(qe);
            }
        });
        try {
            Item item;
            while ((item = qc.next(iter)) != null) {
                heap.insert(this.checkNoEmpty(getKey.invokeItem(qc, this.info, item)), item);
                if ((long)heap.size() <= k) continue;
                heap.removeMin();
            }
        }
        catch (QueryRTException ex) {
            throw ex.getCause();
        }
        ValueBuilder vb = new ValueBuilder(qc);
        while (!heap.isEmpty()) {
            vb.addFront((Item)heap.removeMin());
        }
        return vb.value();
    }

    @Override
    protected Expr opt(CompileContext cc) {
        Expr expr = this.exprs[0];
        return expr.seqType().zero() ? expr : this.adoptType(expr);
    }
}

