/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import java.util.ArrayList;
import java.util.List;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.node.DeleteNode;
import org.basex.query.up.primitives.node.InsertInto;
import org.basex.query.up.primitives.node.NodeUpdate;
import org.basex.query.up.primitives.node.ReplaceContent;
import org.basex.query.up.primitives.node.ReplaceValue;

final class NodeUpdates {
    List<NodeUpdate> updates = new ArrayList<NodeUpdate>(1);

    NodeUpdates() {
    }

    void add(NodeUpdate update) throws QueryException {
        int index = this.indexOf(update.type);
        if (index == -1) {
            this.updates.add(update);
        } else {
            NodeUpdate oldUpdate = this.updates.get(index);
            if (oldUpdate instanceof InsertInto && update instanceof ReplaceContent) {
                this.updates.set(index, update);
            } else {
                oldUpdate.merge(update);
            }
        }
    }

    private NodeUpdate find(UpdateType type) {
        for (NodeUpdate update : this.updates) {
            if (update.type != type) continue;
            return update;
        }
        return null;
    }

    private int indexOf(UpdateType type) {
        int us = this.updates.size();
        int u = 0;
        while (u < us) {
            if (this.updates.get((int)u).type == type) {
                return u;
            }
            ++u;
        }
        return -1;
    }

    List<NodeUpdate> finish() {
        List<NodeUpdate> primnew = new ArrayList<NodeUpdate>();
        DeleteNode del = (DeleteNode)this.find(UpdateType.DELETENODE);
        if (del != null && del.rec) {
            primnew.add(del);
            this.updates = null;
            return primnew;
        }
        NodeUpdate replace = this.find(UpdateType.REPLACENODE);
        if (replace != null) {
            for (NodeUpdate update : this.updates) {
                if (update.type != UpdateType.REPLACENODE && update.type != UpdateType.INSERTBEFORE && update.type != UpdateType.INSERTAFTER) continue;
                primnew.add(update);
            }
            this.updates = null;
            return primnew;
        }
        ReplaceValue rec = (ReplaceValue)this.find(UpdateType.REPLACEVALUE);
        if (rec != null && rec.rec) {
            for (NodeUpdate update : this.updates) {
                if ((update.type == UpdateType.INSERTINTOFIRST || update.type == UpdateType.INSERTINTO || update.type == UpdateType.INSERTINTOLAST) && (update.type != UpdateType.INSERTINTO || !(update instanceof ReplaceContent))) continue;
                primnew.add(update);
            }
            this.updates = null;
            return primnew;
        }
        primnew = this.updates;
        this.updates = null;
        return primnew;
    }
}

