/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class Dec
extends ANum {
    public static final Dec ZERO = new Dec(BigDecimal.ZERO);
    public static final Dec ONE = new Dec(BigDecimal.ONE);
    private final BigDecimal value;

    private Dec(BigDecimal value) {
        super(AtomType.DEC);
        this.value = value;
    }

    public static Dec get(BigDecimal value) {
        return value.signum() == 0 ? ZERO : new Dec(value);
    }

    public static Dec get(double value) {
        return Dec.get(new BigDecimal(value));
    }

    @Override
    public byte[] string() {
        return Token.chopNumber(Token.token(this.value.toPlainString()));
    }

    @Override
    public boolean bool(InputInfo info) {
        return this.value.signum() != 0;
    }

    @Override
    public long itr() {
        return this.value.longValue();
    }

    @Override
    public float flt() {
        return this.value.floatValue();
    }

    @Override
    public double dbl() {
        return this.value.doubleValue();
    }

    @Override
    public BigDecimal dec(InputInfo info) {
        return this.value;
    }

    @Override
    public Dec abs() {
        return this.value.signum() == -1 ? Dec.get(this.value.negate()) : this;
    }

    @Override
    public Dec ceiling() {
        return Dec.get(this.value.setScale(0, RoundingMode.CEILING));
    }

    @Override
    public Dec floor() {
        return Dec.get(this.value.setScale(0, RoundingMode.FLOOR));
    }

    @Override
    public Dec round(int scale, boolean even) {
        int s = this.value.signum();
        return s == 0 ? this : Dec.get(this.value.setScale(scale, even ? RoundingMode.HALF_EVEN : (s == 1 ? RoundingMode.HALF_UP : RoundingMode.HALF_DOWN)));
    }

    @Override
    public boolean eq(Item item, Collation coll, StaticContext sc, InputInfo info) throws QueryException {
        return item.type == AtomType.DBL || item.type == AtomType.FLT ? item.eq(this, coll, sc, info) : this.value.compareTo(item.dec(info)) == 0;
    }

    @Override
    public int diff(Item item, Collation coll, InputInfo info) throws QueryException {
        double d = item.dbl(info);
        return d == Double.NEGATIVE_INFINITY ? -1 : (d == Double.POSITIVE_INFINITY ? 1 : (Double.isNaN(d) ? Integer.MIN_VALUE : this.value.compareTo(item.dec(info))));
    }

    @Override
    public Object toJava() {
        return this.value;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Dec && this.value.compareTo(((Dec)obj).value) == 0;
    }

    public static BigDecimal parse(Item item, InputInfo info) throws QueryException {
        byte[] value = item.string(info);
        try {
            if (!Token.contains(value, 101) && !Token.contains(value, 69)) {
                return new BigDecimal(Token.string(value).trim());
            }
        }
        catch (NumberFormatException ignored) {
            Util.debug(ignored);
        }
        throw AtomType.DEC.castError(item, info);
    }
}

